#!/bin/perl

# Script to convert maple polynomial to LattE Integrale input
# David Haws 
# 11/09/11
# www.davidhaws.net
# dchaws@gmail.com

# This reads (from standard input) a polynomial in maple format 
# and writes (to standard output) input suitable for Latte Integrale.
# The user must specify, on the command line, how many variables to expect.
# See Page 11 of "manual_v1.5.pdf" of LattE Integrale.

# Example ./maple2integrale 3 < test1.txt 
# Example ./maple2integrale 3 < test2.txt 
# Example ./maple2integrale 3 < test2.txt | less
# Example ./maple2integrale 3 < test2.txt > test2_latte.txt

my $numArgs = $#ARGV + 1;
#print ("$numArgs\n"); # DEBUG

if ($numArgs < 1)
{
    print("Usage: maple2integrale [number variables] < [maple file]\n");
    print("or   : maple2integrale [number variables] < [maple file] > [output file name]\n");
    exit(0);
}

my $numVars = $ARGV[0];

#print ("Number of variables $numVars\n"); # DEBUG

print ("[");
my $input;
while ($input = <STDIN> )
{

    # Parse each line into tokens separated by {+,-}
    # The (?=.....) part keeps the delimiter. So tricky.
    my @monomials = split(/(?=[+-])/, $input);

    my $firstRun = 1;
    foreach $monomial (@monomials)
    {
        if ($firstRun == 0)
        {
            print (", ");
        }
        $firstRun = 0;

        # Zero out our vector to store the exponents of the monomial.
        for (my $i=0;$i<$numVars;$i++)
        {
            $expvec[$i] = 0;
        }
#        print ("Monomial \"$monomial\"\n"); # DEBUG
        my @elements = split(/\*/,$monomial);
        foreach $element (@elements)
        {
#            print ("    Element \"$element\"\n"); # DEBUG
            if ($element =~ m/^x/)
            {
                if ($element =~ /x(\d*)\D(\d*)/)
                {
#                    print("        Index: $1    Power: $2\n"); # DEBUG
                    $expvec[$1 - 1] = $2;
                }
                if ($element =~ /x(\d*)$/)
                {
#                    print("        Index: $1    Power: 0 (hard code)\n"); # DEBUG
                    $expvec[$1 - 1] = 0;
                }
            }
        }
        # Print exp vector in Latte Integrale form
        my $coeff = $elements[0]; 
        if ($coeff =~ m/^\+/)
        {
            $coeff =~ s/^\+(\d+)/\1/;
        }
        print ("[$coeff,[");
        for (my $i=0;$i<$numVars - 1;$i++)
        {
            print ("$expvec[$i],")
        }
        print ("$expvec[$numVars - 1]]]")
    }
}
print("]\n");
