;#This is the program integral via "duality".
with(combinat):with(linalg):with(LinearAlgebra):with(numapprox,laurent):
# INPUT: listlinear=[l1..lk] a list of lists: nops(lj)=nops(Sj), S=[S1,..,Sd]  a list of lists, m =[m1..mk] a list, t =[t1..tk] a list. 
# OUTPUT: a polynomial od degree at most D=m1+..mk
# MATH: The list  listlinear represent s linear form and  we are expanding 1/(product(i=1..d+1) (1-t1l1(Si)-  -tklk(Si) as in the formula of the corollary

integrand:=proc(listlinear,S,t) local i,f,Q,D;
f:=1;
D:=add(m[i],i=1..nops(m));

    for i from 1 to nops(S) do
    Q:=add(add(t[j]*listlinear[j][k]*S[i][k],k=1..nops(S[i])),j=1..nops(listlinear));
       if Q=0 then 
       f:=f;
 else 
       f:=f*1/(1-Q):
       fi;
    od;
f;
end:
# INPUT: listlinear=[l1..lk] a list of lists: nops(lj)=nops(Sj), S=[S1,..,S{d+1}] ,d a number, 
#   m =[m1..mk] a list, t =[t1..tk] a list. 
# OUTPUT: a number
# MATH: the integral of the  l1^(m1)*l2^(m2)*ldots* ld^(md) over the simplex S.
integral_via_duality_product_linear:=proc(S,d,m,listlinear) local D,P,volum,f,i,out:
D:=add(m[i],i=1..nops(m));#print("D",D);
P:=product((m[t])!,t=1..nops(m));#print("P",P);
volum:=abs(Determinant(Matrix([seq(S[j]-S[1],j=2..d+1)]))); #print("volum",volum);
f:=integrand(listlinear,S,t);
     for i from 1 to nops(m) do
     f:=convert(laurent(f,t[i],m[i]+1),polynom);
f:=coeff(f,t[i],m[i]);
     od;
    #print("fend",f);
out:=(P*volum)/(D+d)!*f;
end:
# Integral of a monomial over a simplex,  
# by means of duality  formula
standard_basis:=proc(d) local i,v;
for i from 1 to d do
v[i]:=[seq(0,j=1..i-1),1,seq(0,j=i+1..d)]
od;[seq(v[j],j=1..d)];
end:
# The input is a simplex S,  d an integer, and m:[m1,m2,...,m_d] a list of d integers.
# The output is \int_S x_1^(m1)*...*x_d^(m_d).
monome_integral_via_duality:=proc(S,d,m) local listlinear,ll,newm,i;
ll:=[]:
newm:=[];
for i from 1 to nops(m) do
if m[i]=0 then newm:=newm; ll:=ll;
else newm:=[op(newm),m[i]]; 
ll:=[op(ll),standard_basis(d)[i]];
fi;
od;
integral_via_duality_product_linear(S,d,newm,ll);
end:
 
cleaned_set:=proc(L) local newL,subL,X,i;
newL:=[]; 
for i from 1 to nops(L) do 
if L[i][1]<>0 then
newL:=[op(newL),L[i]];
fi;
od;
subL:={seq(newL[s][2],s=1..nops(newL))};
X:=add(newL[s][1]*x[newL[s][2]],s=1..nops(newL));
{seq([coeff(X,x[subL[i]],1),subL[i]],i=1..nops(subL))};
end:
integral_via_duality:=proc(S,d,sparse_poly)local n,i,output,new_sparse_poly;output:=0;
new_sparse_poly:=cleaned_set(sparse_poly);
n:=nops(new_sparse_poly);
for i from 1 to n do 
output:=output+monome_integral_via_duality(S,d,new_sparse_poly[i][2])*new_sparse_poly[i][1];
   od;
end:
