# Datas for examples.

with(combinat):

random_linear_form:=proc(d) local R,U;
  R := rand(10):
  U := proc()  R()  end proc:
  [ seq( U(), i=1..d) ];
  end:

## This produces near-centered monomials
# random_monomial:=proc(d,K) local R,U;
#   R := rand(K..K+1):
#   U := proc()  R()  end proc:
#   [ seq( U(), i=1..d) ];
#   end:

lattice_random_simplex:=proc(d,N) local R,U;
  R := rand(N):
  U:=proc()[seq(R(),i=1..d)] end proc:
  [ seq(U(), i=1..d+1) ];
  end:
  standard_basis:=proc(d) local i,v;
  for i from 1 to d do
  v[i]:=[seq(0,j=1..i-1),1,seq(0,j=i+1..d)]
  od;[seq(v[j],j=1..d)];
  end:
  standard_simplex:=proc(d) local a, output;
  a:=[seq(0,i=1..d)];
  output:=[a,op(standard_basis(d))];
  end:


## Computing a uniformly random monomial
## of prescribed degree.

## The number of compositions of M into n non-negative integers can be
## computed by the Maple function numcomp(M+n, n).
## There is the recursion numbcomp(M+n, n) = sum(numbcomp(M+n-1-i, n-1), i
## = 0...M), obtained by running the first number (m_1) from 0 to M.
## 
## So you can choose the first number m_1 between 0 and M with
## probabilities given by how many random choices there are. Then recurse
## to choose the remaining numbers.

### This is very very slow. --Matthias

## partial_sums := proc(degree, dimension)
##   #option remember;
##   counts := [ seq(numbcomp(degree+dimension-1-i, dimension-1),
##                     i = 0..degree) ];
##     #print(["counts", counts]);
##     total_count := add(c, c in counts);
##     #print(["total_count", total_count]);
##     pos := rand(total_count)();
##     #print(["pos", pos]);
##     partial := 0;
##     partials := [];
##     choice := -1;
##     for i from 0 to degree do
##       #print(i);
##       partial := partial + counts[i+1];
##       partials := [ op(partials), partial ];
##       #print(partial);
##     od;
##   partials;
## end:

## random_monomial_of_given_degree := proc(dimension, degree)
##   local x;
##   #print("random_monomial_of_given_degree", dimension, degree);
##   if dimension = 1 then
##     [degree]
##   elif dimension = 2 then
##     x := rand(degree + 1)();
##     [x, degree - x]
##   else
##     partials := partial_sums(degree, dimension);
##     total_count := partials[degree+1];
##     #print(["total_count", total_count]);
##     pos := rand(total_count)();
##     #print(["pos", pos]);
##     choice := -1;
##     for i from 0 to degree do
##       #print(i);
##       partial := partials[i+1];
##       #print(partial);
##       if pos < partial then
##         choice := i;
##         break;
##       end if;
##     od;
##     assert(choice >= 0);
##     [ choice, 
##       op(random_monomial_of_given_degree(dimension - 1, degree - choice)) ]
##   end if
## end:


## Converting from Maple polynomials to our sparse format

polynomial_to_sparsepoly := proc(p, dimension)
  local variables,coefficients, monomials, exponents; 
  variables := [ seq(x[i], i=1..dimension) ];     
  #print (variables);     
  coefficients := coeffs(p, variables, 'monomials');
  #print (coefficients);
  #print (monomials);
  exponents := map( monomial -> map( variable -> degree(monomial, variable),
                            variables),
                     [monomials]);
  #print(exponents);
  zip((c,m) -> [c,m],
      [coefficients], 
      exponents);
end:

#polynomial_to_sparsepoly(x[1]*x[2]^2+2*x[2]-3*x[1], 2);

# We rather use a built-in procedure of Maple,
# and convert the result to our format.

##
## Creating random polynomials in sparse format
##

# N - use coefficients up to this number
# d - dimension
# M - degree
# r - number of monomials
## random_sparse_homogeneous_polynomial_with_degree:=proc(N,d,M,r) 
##   local MM, out,R,U,A,m,coe,k,mono;out:=[];
##   out:=[];
##   R := rand(N):
##   U:=proc()[seq(R(),i=1..r)] end proc:
##   A:= U();#print(U);
##   for k from 1 to r do
##   mono := random_monomial_of_given_degree(d,M);
##   out:=[op(out),[A[k],mono]];
##   od;
##   out;
## end:

random_sparse_homogeneous_polynomial_with_degree:=proc(N,d,M,r) 
  local p, R;
  ## Give up if too large polynomials requested
  if (r > 500000) then
    error "Too large a polynomial requested"
  fi;
  R := rand(N);
  p := randpoly([ seq(x[i], i=1..d) ], 
                homogeneous, degree = M, terms = r, coeffs = proc() R() + 1; end);
  polynomial_to_sparsepoly(p, d);
end:

##random_sparse_homogeneous_polynomial_with_degree(100000, 50, 1000, 1);


# One monomial
random_sparse_homogeneous_polynomial_with_degree_1:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree(100, d, M, 1);
end:

# Very sparse
random_sparse_homogeneous_polynomial_with_degree_2:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree(100, d, M, d+M);
end:


random_sparse_homogeneous_polynomial_with_degree_3:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree(100, d, M, 
    floor(evalf(root(binomial(M+d-1, d-1), 4))));
end:

random_sparse_homogeneous_polynomial_with_degree_4:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree(100, d, M, 
    floor(evalf(root(binomial(M+d-1, d-1), 2))));
end:

random_sparse_homogeneous_polynomial_with_degree_5:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree(100, d, M, 
    floor(evalf(root(binomial(M+d-1, d-1), 1))));
end:



random_sparse_homogeneous_polynomial_with_degree_and_eff_num_vars:=
proc(N,d,eff_num_vars,M,r) 
  local p, R;
  ## Give up if too large polynomials requested
  if (r > 500000) then
    error "Too large a polynomial requested"
  fi;
  R := rand(N);
  p := randpoly([ seq(x[i], i=1..eff_num_vars) ], 
                homogeneous, degree = M, terms = r, coeffs = proc() R() + 1; end);
  polynomial_to_sparsepoly(p, d);
end:

# One monomial, constant (2/4/6) number of effective variables!
random_sparse_homogeneous_polynomial_with_degree_6:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree_and_eff_num_vars(100, d, 
                                                        min(2, d),
                                                   M, 1);
end:

random_sparse_homogeneous_polynomial_with_degree_7:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree_and_eff_num_vars(100, d, 
                                                        min(4, d),
                                                   M, 1);
end:

random_sparse_homogeneous_polynomial_with_degree_8:=proc(d,M)
  random_sparse_homogeneous_polynomial_with_degree_and_eff_num_vars(100, d, 
                                                        min(6, d),
                                                   M, 1);
end:
