## Create a LaTeX table from Maple.

latex_toprule := proc()
  printf("\\toprule\n");
end:

latex_midrule := proc()
  printf("\\midrule\n");
end:

latex_bottomrule := proc()
  printf("\\bottomrule\n");
end:

latex_cmidrule := proc(a, b)
  printf("\\cmidrule{%d-%d}\n", a, b);
end:

latex_tab := proc()
  printf(" & ");
end:

latex_newline := proc()
  printf("\\\\\n");
end:

latex_tablehead := proc(columns_description, columns, rows_description)
  local M;
  printf("\\begin{tabular}{r*{%d}r}\n", nops(columns));
  latex_toprule();
  latex_tab();
  printf("\\multicolumn{%d}{c}{%s}", nops(columns), columns_description);
  latex_newline();
  latex_cmidrule(2, 1+nops(columns));
  printf("%s", rows_description);
  for M in columns do
    latex_tab();
    printf("%d", M);
  od;
  latex_newline();
  latex_midrule();
end:

latex_tablefoot := proc()
  printf("\\bottomrule\n");
  printf("\\end{tabular}\n");
end:

dimension_degree_table := proc(dimensions, degrees, entry_proc, time_limit)
  local n, M, R, poly;
  R := rand(1..100);
  latex_tablehead("Degree", degrees, "Dimension");
  for n in dimensions do
    printf("%d", n);
    for M in degrees do
      latex_tab();
      try 
        if time_limit = -1 then
          entry_proc(n, M);
	else
	  timelimit(time_limit, 
            proc()
	      entry_proc(n, M);
            end ())
        fi
       catch "time expired":
         printf("%% Time expired\n");
	 break;
       end;
    od;
    latex_newline();
  od;
  latex_tablefoot();
end:

print_seconds := proc(s)
  if evalb(s <= 0.05) then
    printf("%7.0f", 0)
  elif evalb(s <= 9.95) then
    printf("%7.1f", s)
  else
    printf("%7.0f", s);
  fi:
end:
# Test the format:
# print_seconds(0);
# print_seconds(0.04);
# print_seconds(0.06);
# print_seconds(1.3);
# print_seconds(9.9);
# print_seconds(9.96);
# print_seconds(17.3);
# print_seconds(117.3);
# print_seconds(1117.3);
# printf("\n");

dimension_degree_avg_table := proc(dimensions, degrees, compute_proc, 
				           num_samples, time_limit)
  dimension_degree_table(dimensions, degrees, 
    proc(n, M)
      local min_time, max_time, sum_time, time_diff, i,
      	    avg_time, dev_time;
      min_time := 1e8;
      max_time := 0;
      sum_time := 0;
      for i from 1 to num_samples do
        time_diff := timelimit(time_limit, 
          proc()
	    compute_proc(n, M);
          end ());
	min_time := min(min_time, time_diff);
	max_time := max(max_time, time_diff);
	sum_time := sum_time + time_diff
      od;
      avg_time := sum_time / num_samples;
      dev_time := max(max_time - avg_time, avg_time - min_time);
      #printf("%7.2g \\pm %7.2g", avg_time, dev_time);
      printf("\\minavgmax{");
      print_seconds(min_time);
      printf("}{");
      print_seconds(avg_time);
      printf("}{");
      print_seconds(max_time);
      printf("}\n");
    end,
    -1):
end:


dimension_degree_avg_runtime_table := proc(dimensions, degrees, compute_proc, 
				           num_samples, time_limit)
  dimension_degree_avg_table(dimensions, degrees, 
     proc(n, M)
        local time_after, time_before;
        time_before := time();
        compute_proc(n, M);
	time_after := time();
        time_after - time_before;
     end, 
     num_samples, time_limit);
end:
    

