with(linalg):with(LinearAlgebra):
with(numapprox,laurent):
# Integral of a  power of a linear form over a simplex.
# Our Notations;

# 
# 

# The  integer d is the dimension;
# A vector in Q^d is a list of d rational numbers.
# A vertex is a vector in Q^d;
# The simplex  S is the convex hull of its vertices s_i. 
# Thus S is encoded as a list of vectors
# in Q^d.
# If the simplex is of full dimension, we have (d+1) vertices.  

#  A linear forms is called alpha, it is  represented by  a vector in Q^d.
# A monomial m is a list of d integers
#  A polynomial represented  in a sparse way;
#  Exemple x*y^2+2*x^2 with be given as a list of lists [[1,[1,2]],[2,[2,0]]. Each list represents a monomial with his coefficients. 
# Thus a sparse polynomial is represented as a list of lists.
# 
# .
# 
# Simplex and multiplicities.
# 
# INPUT: d an integer, S  list of d+1 lists of lenght d, alpha: list of lenght d . 
# OUTPUT: set of lists {[a_S], [m_S]} 
# MATH: S a simplex of dimension d+1, alpha a linear form, m_S is the list of the number of vertices S where <\alpha,S> = a_S.
# 
#    
multiplicity_alpha_simplex:=proc(S,d,alpha) local i,n,VS,m,Mult,j,c;
n:=nops(S);
VS:={seq(add(alpha[s]*S[i][s],s=1..d),i=1..nops(S))};
Mult:={};
for i from 1 to nops(VS) do 
m:=0; 
for j from 1 to nops(S) do 
c[j]:=add(alpha[s]*S[j][s],s=1..d);
if c[j]=VS[i] then m:=m+1;
else m:=m;
fi;
od;
Mult:={op(Mult),[VS[i],m]};
od;
Mult:
end:
# Computation of a coefficient
# 
# 
# 
# 
# M an integer, d an integer,  starting is a list of two elements  [v1,order1], where v1 is a rational number and order1 is an integer ;
#      L is a sequence of elements [ai,mi] where mi are integers and ai are numbers.  The output is 
# coeff((epsilon+v1)^(M+d)*1
# /(epsilon+a1)^m1*1/(epsilon+a2)^m2*...*1/(epsilon +aK)^mK; epsilon,order1-1)
prototype_residue:=proc(M,d,starting,L) local f,m,LL;
f:=(epsilon+starting[1])^(M+d); #print(f);
for m from 1 to nops(L) do
f:=f*1/(L[m][1])^(L[m][2])*1/(1+epsilon/L[m][1])^(L[m][2]);
od; 
f;
LL:=convert(laurent(f,epsilon,starting[2]),polynom);
coeff(LL,epsilon,starting[2]-1);
end:
# INPUT: S a simplex, alpha a linear form, d an integer, M an integer 
# OUTPUT: a number int_S alpha^M
# MATH:;
# See the manual for the formula.  
# 
integral_power_linear_form:=proc(S,d,M,alpha) local int,Mult,output,v,i,L,B,R,m,starting;
v:=abs(Determinant(Matrix([seq(S[j]-S[1],j=2..d+1)])));
if v=0 then int:=0;
else 
 Mult:=multiplicity_alpha_simplex(S,d,alpha); 
int:=0;
for  i from 1 to nops(Mult) do 
starting:=Mult[i];
 L:=
[seq([Mult[i][1]-Mult[j][1],Mult[j][2]],j=1..(i-1)),
seq([Mult[i][1]-Mult[j][1],Mult[j][2]],j=(i+1)..nops(Mult))];
R:=prototype_residue(M,d,starting,L);
int:=int+R;   
od;
fi;
M!/(M+d)!*int*v:
end:

# Decomposing  a monomial in powers of linear forms.
# INPUT:L list of integers, m a list of integers,M an integer
# OUTPUT: a nonnegative number
# MATH: The list $m$ represents the monomial x^m=x_1^{m[1]}x_2^{m[2]}\cdots x_d^{m[d], 
# the list L represents the linear form L=L[1]x[1]+..L[d]x_d. 
# The output is the coefficient of L^M,  M=M:=add(m[i],i=1..nops(m)), in the expansion of x^m in linear form using the formula in userguide. 
# CAUTION: The algorithm works only if we take "primitive" linear form as in the formula. 
coeff_linear_form_expansion:=proc(L,m) local p,j,c,s,M,out;
p:=[];
M:=add(m[i],i=1..nops(m));
    if igcd(seq(L[i],i=1..nops(L)))<>1 then print(trouble); 
    else
        for j from 1 to nops(L) do #print("j",j);
           if L[j]<>0 then
           p:=[op(p),iquo(m[j],L[j])];
           else p:=p;
           fi;
         od;

    c:=min(seq(p[i],i=1..nops(p)));
    s:=add(L[i],i=1..nops(L));#print("s,m,c",s,m,c);
    out:=1/M!*add((-1)^(M-k*s)*product(binomial(m[i],k*L[i]),i=1..nops(L))*k^M,k=1..c);
    fi;
out;
end:
# The input is a monomial.
# The output is the list of  elements [p1,....,pn] where$pi<=mi$ and mutually prime.
list_for_simplex_integral:=proc(m) local j,F,L,i,f,newL;newL:=[];
i:=1; 
if m[1]=0 then L:=[[0]]; else
L:=[seq([j],j=0..m[1])];fi;

     for i from 2 to nops(m) do #print(i,nops(L));
     L:=[seq(seq([op(L[s]),j],j=0..m[i]),s=1..nops(L))];
     od;
#print(L);
     for j from 1 to nops(L) 
     do F:=L[j];

       if
       igcd(seq(F[i],i=1..nops(F)))<>1
       then newL:=newL; 
       else newL:=[op(newL),F];
       fi;
     newL:
     od;
newL;
end:
# INPUT: m a list of integers, coe a number
# OUTPUT: a list of lists of lenght nops(m)
# MATH:  The list $m$ represents the monomial x^m=x_1^{m[1]}x_2^{m[2]}\cdots x_d^{m[d].
# The output is a list of lists. Each element in the list represents a linear form ([1,2]=x+2y). The output exausts all the linear form with exponents M=m[1]+..+m[d] which appear when  expressing   x^m as  linear combinations of linear form with exponent M. The first element is the coefficient multiplied by coe;
list_and_coeff_for_monome:=proc(m,coe) local M,L,out:
M:=add(m[i],i=1..nops(m));
L:=list_for_simplex_integral(m);#print(L);
out:=[ seq([coe*coeff_linear_form_expansion(L[j],m),[M,L[j]]],j=1..nops(L))];
end:
#  The input: S is  a simplex, d a number, m a monomial. The output is  a number, the integral of x^m over S.
integral_monome_via_waring:=proc(S,d,m) local out,M,L,i;
out:=0;
M:=add(m[i],i=1..nops(m));
L:=list_and_coeff_for_monome(m,1);
for i from 1 to nops(L) do
   out:=out
+L[i][1]*integral_power_linear_form(S,d,M,L[i][2][2]);
   od;
out;
end:
##integral_monome_via_waring([[0,0],[0,1],[1,0]],2,[9,2]);
# Integral of a polynomial via Waring.
# We give a polynomial in a sparse way; Exemple x*y^2+2*x^2 with be given as a list of lists [[1,[1,2]],[2,[2,0]]. Each list represents a monomial with his coefficients. 
#  We start by cleaning the sets for example we replace [[1,[1,2]],[1,[1,2]] by [2,[1,2]];
# Input  L; a list of lists [[a,alpha],[b,beta],...]. here a is a number, alpha is a list. The ouptput is
# a set of lists.
# If alpha=beta, we replace by [a+b,alpha]; if a=0 we skip;
# The input is a list  L of lists [a,\alpha] where a is a number. The output is of the same kind.
cleaned_set:=proc(L) local newL,subL,X,i;
newL:=[]; 
for i from 1 to nops(L) do 
if L[i][1]<>0 then
newL:=[op(newL),L[i]];
fi;
od;
subL:={seq(newL[s][2],s=1..nops(newL))};
X:=add(newL[s][1]*x[newL[s][2]],s=1..nops(newL));
{seq([coeff(X,x[subL[i]],1),subL[i]],i=1..nops(subL))};
end:
# The input is  a sparse polynomial represented as a lists [c,m] of monomials with coefficients. The output is a list of lists [coe,[M,L]], coe a number, M an integer, L a linear form. It represents coe*L^M. 
list_integral_via_waring:=proc(sparse_poly) 
local Y, new_sparse_poly,n,i,Z;
new_sparse_poly:=cleaned_set(sparse_poly);
n:=nops(new_sparse_poly);
Y:=list_and_coeff_for_monome(new_sparse_poly[1][2],new_sparse_poly[1][1]); 
 for i from 2 to n do 
Z:=list_and_coeff_for_monome(new_sparse_poly[i][2],new_sparse_poly[i][1]); 
Y:=cleaned_set([op(Y),op(Z)]);
od; 
Y;
end:
# The input is a simplex S, d the dimension, sparse_poly a sparse polynomial. 
# The ouput is a number; the integral over S of the polynomial.
integral_via_waring:=proc(S,d,sparse_poly) local output,i, L ;output:=0;
L:=list_integral_via_waring(sparse_poly);
for i from 1 to nops(L) do 
output:=output+L[i][1]*
integral_power_linear_form(S,d,L[i][2][1],L[i][2][2]);
   od;
end:

# 
