(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    355908,       7745]*)
(*NotebookOutlinePosition[    356785,       7775]*)
(*  CellTagsIndexPosition[    356741,       7771]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
PolytopeSkeleton.m
Visualizing Convex Polytope Skeletons (with cddmathlink)\
\>", "Title",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[StyleBox["Komei Fukuda, fukuda@ifor.math.ethz.ch\nSwiss Federal \
Institute of Technology, Lausanne and Zurich\nDecember 17, 2002",
  FontSize->17,
  FontSlant->"Italic"]], "Subtitle",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Preparation (reading Packages)", "Section",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Off[General::spell1]; Off[General::spell]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["$Path = Append[$Path,\"~/Math\"]; ", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "We use an extra graphics package available from ",
  StyleBox["MathSource",
    FontSlant->"Italic"],
  ".    It is called View3D which is a part of ExtendGraphics  package wrtten \
by  Tom Wickham-Jones .  The package is available at ",
  StyleBox["http://www.mathsource.com/",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ".  If you install it in a directory which in not in the $Path, you need to \
append the directory to $Path."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["$Path", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({"/Users/fukuda/Library/Mathematica/4.1/Kernel", 
      "/Users/fukuda/Library/Mathematica/4.1/AddOns/Autoload", 
      "/Users/fukuda/Library/Mathematica/4.1/AddOns/Applications", 
      "/Library/Mathematica/Kernel/", "/Library/Mathematica/Autoload/", 
      "/Library/Mathematica/Applications/", "/Library/Mathematica/", ".", 
      "/Users/fukuda", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/StandardPackages", 
      "/Applications/LocalApps/Mathematica \
4.1.app/AddOns/StandardPackages/StartUp", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/Autoload", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/Applications", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/ExtraPackages", 
      "/Applications/LocalApps/Mathematica \
4.1.app/SystemFiles/Graphics/Packages", 
      "/Applications/LocalApps/Mathematica 4.1.app/Configuration/Kernel", 
      "~/Math", "~/Math"}\)], "Output"]
}, Open  ]],

Cell["Needs[\"ExtendGraphics`View3D`\"];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "cddmathlink is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  version of libcdd for doing the vertex enumeration and the facet \
enumeration of a convex polyhedron.  cddlib-080.tar.gz is available from \
Fukuda's Homepage:   http:///www.ifor.math.ethz.ch/staff/fukuda/fukuda.html  \
.   Look for \"cdd Homepage\"."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["cddml=Install[\"~/Math/cddmathlink2gmp\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(LinkObject["/Users/fukuda/Math/cddmathlink2gmp", 4, 2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The following packages come with libcdd package and should be installed in \
your favorite directory.  Here I assume it is in \"~/Math\" directory.   They \
are separately available from Fukuda's Homepage: \
http:///www.ifor.math.ethz.ch/staff/fukuda/fukuda.html  .  Look for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Projects."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<< PolytopeSkeleton.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<< IOPolyhedra.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<< UnfoldPolytope.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute theVertices of a Polytope by using cddmathlink", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["FileNames[\"*\",\"~/Math/ine_3d\"]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({"~/Math/ine_3d/cube3a.ine", "~/Math/ine_3d/cube3b.ine", 
      "~/Math/ine_3d/cube3.ine", "~/Math/ine_3d/cubocta.ine", 
      "~/Math/ine_3d/cuboctaT.ine", "~/Math/ine_3d/denault1.ine", 
      "~/Math/ine_3d/dodeca.ine", "~/Math/ine_3d/dodecaT.ine", 
      "~/Math/ine_3d/glopt1.ine", "~/Math/ine_3d/grcubocta.ine", 
      "~/Math/ine_3d/grcuboctaT.ine", "~/Math/ine_3d/hexocta.ine", 
      "~/Math/ine_3d/hexoctaT.ine", "~/Math/ine_3d/icododeca.ine", 
      "~/Math/ine_3d/icododecaT.ine", "~/Math/ine_3d/icosaT.ine", 
      "~/Math/ine_3d/rcubocta.ine", "~/Math/ine_3d/rcuboctaT.ine", 
      "~/Math/ine_3d/rhomtria.ine", "~/Math/ine_3d/rhomtriaT.ine", 
      "~/Math/ine_3d/scube3.ine", "~/Math/ine_3d/zono3_10.ine"}\)], "Output"]
}, Open  ]],

Cell["\<\
The file test.ine is the main output file of cdd+, which gives the \
inequality (facet) representation of the polytope.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[inedata=
\tReadPolyhedraData[\"~/Math/ine_3d/glopt1.ine\"]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]17\[InvisibleSpace]",   n="\
\[InvisibleSpace]4\[InvisibleSpace]" type="\[InvisibleSpace]"rational"\),
      SequenceForm[ "m=", 17, ",   n=", 4, " type=", "rational"],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
amat=-Transpose[Drop[Transpose[inedata],1]];
bvec=Transpose[inedata][[1]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["{m,d}=Dimensions[inedata]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({17, 4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(amat\)], "Input"],

Cell[BoxData[
    \({{12, 0, 5}, {0, 15\/2, 9\/2}, {0, 9\/5, 52\/25}, {23\/3, 10\/3, 
        0}, {35\/3, 5\/3, 0}, {5\/2, 0, 7\/2}, {25\/3, 5\/3, 28\/3}, {223\/3, 
        5\/3, 94\/3}, {16, 0, 8}, {0, 15\/4, 7\/4}, {0, 5\/3, 0}, {1, 3, 
        16\/15}, {1, 3, 0}, {35\/6, 25\/6, 0}, {\(-1\), 0, 0}, {0, \(-1\), 
        0}, {0, 0, \(-1\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
{{extlist,linearity},ecdlist,eadlist,icdlist,iadlist}=
\tAllVerticesWithAdjacency[m,d,ToString[inedata,InputForm]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["vlist0 = Map[Drop[#, 1]&, ToExpression[extlist]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{149\/16, 0, 105\/4}, {73\/8, 0, 213\/8}, {0, 2164\/75, 109\/5}, {0, 
        1714\/75, 159\/5}, {81\/4, 0, 0}, {56\/5, 173\/5, 26\/5}, {56\/5, 
        173\/5, 0}, {26\/5, 183\/5, 0}, {0, 183\/5, 0}, {0, 0, 0}, {0, 0, 
        232\/7}, {0, 183\/5, 26\/5}, {26\/5, 183\/5, 26\/5}, {211\/15, 
        2294\/75, 0}, {99\/5, 87\/5, 0}, {0, 19, 232\/7}, {0, 219\/10, 
        261\/8}, {11\/15, 1714\/75, 159\/5}, {99\/5, 87\/5, 9\/10}, {149\/16, 
        137\/16, 105\/4}, {161\/15, 2164\/75, 109\/5}, {81\/4, 57\/4, 
        0}, {211\/15, 2294\/75, 69\/5}, {73\/8, 79\/8, 213\/8}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vlist = N[vlist0]\)], "Input"],

Cell[BoxData[
    \({{9.3125`, 0.`, 26.25`}, {9.125`, 0.`, 26.625`}, {0.`, 
        28.85333333333333`, 21.8`}, {0.`, 22.85333333333333`, 
        31.8`}, {20.25`, 0.`, 0.`}, {11.2`, 34.6`, 5.2`}, {11.2`, 34.6`, 
        0.`}, {5.2`, 36.6`, 0.`}, {0.`, 36.6`, 0.`}, {0.`, 0.`, 0.`}, {0.`, 
        0.`, 33.142857142857146`}, {0.`, 36.6`, 5.2`}, {5.2`, 36.6`, 
        5.2`}, {14.066666666666666`, 30.586666666666666`, 0.`}, {19.8`, 
        17.4`, 0.`}, {0.`, 19.`, 33.142857142857146`}, {0.`, 21.9`, 
        32.625`}, {0.7333333333333333`, 22.85333333333333`, 31.8`}, {19.8`, 
        17.4`, 0.9`}, {9.3125`, 8.5625`, 26.25`}, {10.733333333333333`, 
        28.85333333333333`, 21.8`}, {20.25`, 14.25`, 
        0.`}, {14.066666666666666`, 30.586666666666666`, 13.8`}, {9.125`, 
        9.875`, 26.625`}}\)], "Output"]
}, Open  ]],

Cell["\<\
invertpos[l_List, j_]:=
\tModule[{i,pos={}},
\t\tDo[
\t\t\tIf[Position[l[[i]],j]!={},AppendTo[pos,i]],
\t\t\t{i,1,Length[l]}
\t\t];
\t\tpos
\t];
dualizeIndices[ecd_List, ineLen_Integer]:=
\tMap[invertpos[ecd,#]&, Range[ineLen]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["icdlist=dualizeIndices[ecdlist, Length[inedata]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{1, 5, 20, 22}, {3, 4, 18, 21}, {4, 17, 18}, {14, 15, 19, 23}, {15, 
        19, 22}, {2, 11, 16, 24}, {16, 17, 18, 21, 24}, {19, 20, 21, 22, 23, 
        24}, {1, 2, 20, 24}, {3, 12, 13, 21}, {8, 9, 12, 13}, {6, 13, 21, 
        23}, {6, 7, 8, 13}, {6, 7, 14, 23}, {3, 4, 9, 10, 11, 12, 16, 
        17}, {1, 2, 5, 10, 11}, {5, 7, 8, 9, 10, 14, 15, 22}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing the Skeleton of a Polytope", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Defining 3D objects.  ", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
skel3D[vp_]:= 
\tGraphics3D[
\t\tVisibleSkeleton[vlist, ecdlist, eadlist, 
     \t{amat, bvec}, vp]
     ]; 
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
facets=Map[(Part[vlist,#]) &, icdlist];
facets1=OrderFacets[facets];
solid3D:= Graphics3D[Polygon /@ facets1]; 
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Draw a Polytope  by Built-In Graphics", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Do[ uvp=circle[a,50,20];
\tShow[solid3D, 
\t\tBoxed->False, 
 \t\tViewPoint -> getMmaViewPoint[uvp,skel3D[uvp]],
 \t\tSphericalRegion->True
 \t],
 \t{a,Pi/11,Pi,Pi/18}
 ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.483333]
}, Open  ]],

Cell[CellGroupData[{

Cell["Draw a  Polytope  by a New VisibleSkeleton Graphics", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Do[ uvp=circle[a,50,20];
\tShow[skel3D[uvp], 
\t\tBoxed->False, 
 \t\tViewPoint -> getMmaViewPoint[uvp,skel3D[uvp]],
 \t\tSphericalRegion->True
 \t],
 \t{a,Pi/11,Pi,Pi/18}
 ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->1.33333,
  AnimationCycleOffset->0.0625,
  AnimationCycleRepetitions->Infinity]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unfolding the Polytope", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["UnfoldPolytope[facets1] ;", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  AnimationCycleOffset->0.0625,
  AnimationCycleRepetitions->Infinity],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Solve :: \"svars\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.3406 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.168744 1.41719 -1.11022e-16 1.41719 [
[ 0 0 0 0 ]
[ 1 1.3406 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.3406 L
0 1.3406 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.53601 .68794 m .10645 .21595 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.63102 .65725 m .53601 .68794 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.53601 .68794 m .53594 .77534 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.10645 .21595 m .53601 .68794 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.53601 .68794 m .53594 .77534 L .63286 .74517 L p .573 .367 .563 r
F P
0 g
s
.63286 .74517 m .63102 .65725 L .53601 .68794 L p .573 .367 .563 r
F P
0 g
s
.72535 .59786 m .63102 .65725 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.72535 .59786 m .63102 .65725 L .63286 .74517 L p .451 .272 .546 r
F P
0 g
s
.53594 .77534 m .44972 1.00044 L .37086 1.14777 L p .951 .687 .499 r
F P
0 g
s
.53594 .77534 m .44972 1.00044 L .67312 .937 L p .454 .121 .31 r
F P
0 g
s
.67312 .937 m .63286 .74517 L .53594 .77534 L p .454 .121 .31 r
F P
0 g
s
.63286 .74517 m .72921 .68676 L .72535 .59786 L p .451 .272 .546 r
F P
0 g
s
.67312 .937 m .63286 .74517 L .72921 .68676 L p .303 .031 .324 r
F P
0 g
s
.74366 .53161 m .72535 .59786 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.72535 .59786 m .74366 .53161 L .75563 .779 L p 0 0 .324 r
F P
0 g
s
.75563 .779 m .72921 .68676 L .72535 .59786 L p 0 0 .324 r
F P
0 g
s
.72921 .68676 m .75563 .779 L .67312 .937 L p .303 .031 .324 r
F P
0 g
s
.7084 .26578 m .73162 .31552 L .74366 .53161 L p .671 .73 .894 r
F P
0 g
s
.74366 .53161 m .73162 .31552 L .73238 .33127 L p .716 .555 0 r
F P
0 g
s
.73238 .33127 m .75563 .779 L .74366 .53161 L p .716 .555 0 r
F P
0 g
s
.75563 .779 m .67312 .937 L p .7084 .26578 L .932 .78 .669 r
F P
0 g
s
.7084 .26578 m .73238 .33127 L .75563 .779 L p .932 .78 .669 r
F P
0 g
s
.44972 1.00044 m .37086 1.14777 L .3867 1.14354 L p .399 .023 .204 r
F P
0 g
s
.3867 1.14354 m .67312 .937 L .44972 1.00044 L p .399 .023 .204 r
F P
0 g
s
.73238 .33127 m .7084 .26578 L .73162 .31552 L closepath p .975 .696 .295 r
F P
0 g
s
.67312 .937 m .40709 .81749 L p .7084 .26578 L .932 .78 .669 r
F P
0 g
s
.40709 .81749 m .67312 .937 L .3867 1.14354 L p .873 .849 .816 r
F P
0 g
s
.10645 .21595 m .54474 .03568 L .7084 .26578 L p .671 .73 .894 r
F P
0 g
s
.40709 .81749 m .39363 .78987 L .7084 .26578 L p .932 .78 .669 r
F P
0 g
s
.54474 .03568 m .7084 .26578 L .39363 .78987 L p .928 .772 .667 r
F P
0 g
s
.10645 .21595 m .54474 .03568 L .26821 .66611 L p .5 .261 .485 r
F P
0 g
s
.03007 .90264 m .10645 .21595 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.03007 .90264 m .10645 .21595 L p .26821 .66611 L .5 .261 .485 r
F P
0 g
s
.31871 1.13647 m .03007 .90264 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.37086 1.14777 m .35781 1.1561 L .31871 1.13647 L p .951 .687 .499 r
F P
0 g
s
.3867 1.14354 m .35781 1.1561 L .37086 1.14777 L closepath p .08 0 0 r
F P
0 g
s
.31871 1.13647 m .40709 .81749 L p .3867 1.14354 L .873 .849 .816 r
F P
0 g
s
.3867 1.14354 m .35781 1.1561 L .31871 1.13647 L p .873 .849 .816 r
F P
0 g
s
.03007 .90264 m .31871 1.13647 L .40709 .81749 L p .83 .801 .824 r
F P
0 g
s
.39363 .78987 m .26821 .66611 L .54474 .03568 L p .928 .772 .667 r
F P
0 g
s
.39363 .78987 m .40709 .81749 L .26309 .6763 L p .918 .779 .692 r
F P
0 g
s
.40709 .81749 m .26309 .6763 L .03007 .90264 L p .83 .801 .824 r
F P
0 g
s
.26309 .6763 m .26821 .66611 L .39363 .78987 L p .918 .779 .692 r
F P
0 g
s
.26821 .66611 m .26309 .6763 L .03007 .90264 L p .5 .261 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F00017b000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool007?ooooo0_l0001Qooooo`00
L?ooool3o`00000307m2O?l0003ooooo063ooooo001^ooooo`;o00000`1o@W`00ol00000kLFZo`00
001Pooooo`00K?ooool2o`0000D0Od9l00Co00000>g5ZP3]aJ[o0000Goooool006Wooooo0ol00006
07m2O005o`00003]aJX0kLFZ0>g5Z_l00000Goooool006Oooooo0_l0000907m2O003o`00003]aJX0
kLFZ0080kLFZ00?o0000ooooooooool0G?ooool006Cooooo0ol0000;07m2O003o`00003]aJX0kLFZ
00<0kLFZ00?o0000ooooooooool0Foooool006;ooooo0_l0000=07m2O003o`00003]aJX0kLFZ00D0
kLFZ00?o0000ooooooooool0F_ooool0063ooooo0_l0000?07m2O003o`00003]aJX0kLFZ00D0kLFZ
00?o0000ooooooooool0F_ooool005gooooo0ol0000@07m2O003o`00003]aJX0kLFZ00L0kLFZ00?o
0000ooooooooool0FOooool005_ooooo0_l0000C07m2O003o`00003]aJX0kLFZ00P0kLFZ00?o0000
ooooooooool0F?ooool005Sooooo0ol0000D07m2O003o`00003]aJX0kLFZ00T0kLFZ00?o0000oooo
ooooool0F?ooool005Kooooo0_l0000G07m2O003o`00003]aJX0kLFZ00X0kLFZ00?o0000oooooooo
ool0Eoooool005?ooooo0ol0000I07m2O003o`00003]aJX0kLFZ00/0kLFZ00?o0000ooooooooool0
E_ooool0057ooooo0_l0000K07m2O003o`00003]aJX0kLFZ00`0kLFZ00?o0000ooooooooool0E_oo
ool004oooooo0_l0000M07m2O003o`00003]aJX0kLFZ00d0kLFZ00?o0000ooooooooool0EOooool0
04cooooo0ol0000N07m2O003o`00003]aJX0kLFZ00l0kLFZ00?o0000ooooooooool0E?ooool004[o
oooo0_l0000Q07m2O003o`00003]aJX0kLFZ0100kLFZ00?o0000ooooooooool0Doooool004Oooooo
0ol0000R07m2O003o`00003]aJX0kLFZ0140kLFZ00?o0000ooooooooool0Doooool004Gooooo0_l0
000U07m2O003o`00003]aJX0kLFZ0180kLFZ00?o0000ooooooooool0D_ooool004?ooooo0_l0000V
07m2O003o`00003]aJX0kLFZ01@0kLFZ00?o0000ooooooooool0DOooool0043ooooo0ol0000X07m2
O003o`00003]aJX0kLFZ01@0kLFZ00?o0000ooooooooool0DOooool003kooooo0_l0000[07m2O003
o`00003]aJX0kLFZ01D0kLFZ00?o0000ooooooooool0D?ooool003_ooooo0ol0000/07m2O003o`00
003]aJX0kLFZ01L0kLFZ00?o0000ooooooooool0Coooool003Wooooo0_l0000_07m2O003o`00003]
aJX0kLFZ01L0kLFZ00?o0000ooooooooool0Coooool003Oooooo0_l0000`07m2O003o`00003]aJX0
kLFZ01T0kLFZ00?o0000ooooooooool0C_ooool003Cooooo0ol0000b07m2O003o`00003]aJX0kLFZ
01X0kLFZ00?o0000ooooooooool0COooool003;ooooo0_l0000d07m2O003o`00003]aJX0kLFZ01`0
kLFZ00?o0000ooooooooool0C?ooool002oooooo0ol0000f07m2O003o`00003]aJX0kLFZ01`0kLFZ
00?o0000ooooooooool0C?ooool002gooooo0_l0000i07m2O003o`00003]aJX0kLFZ01d0kLFZ00?o
0000ooooooooool0Boooool002[ooooo0ol0000j07m2O003o`00003]aJX0kLFZ01l0kLFZ00?o0000
ooooooooool0B_ooool002Sooooo0_l0000m07m2O003o`00003]aJX0kLFZ01l0kLFZ00?o0000oooo
ooooool0B_ooool002Kooooo0_l0000n07m2O003o`00003]aJX0kLFZ0240kLFZ00?o0000oooooooo
ool0BOooool002?ooooo0ol0001007m2O003o`00003]aJX0kLFZ0280kLFZ00?o0000ooooooooool0
B?ooool0027ooooo0_l0001207m2O003o`00003]aJX0kLFZ02<0kLFZ00?o0000ooooooooool0B?oo
ool001kooooo0ol0001407m2O003o`00003]aJX0kLFZ02@0kLFZ00?o0000ooooooooool0Aoooool0
01cooooo0_l0001607m2O003o`00003]aJX0kLFZ02H0kLFZ00?o0000ooooooooool0A_ooool001[o
oooo0_l0001807m2O003o`00003]aJX0kLFZ02L0kLFZ00?o0000ooooooooool0AOooool001Oooooo
0ol0001:07m2O003o`00003]aJX0kLFZ02L0kLFZ00?o0000ooooooooool0AOooool001Kooooo00?o
000007m2O01o@W`0BP1o@W`00ol00000kLFZ0>g5ZP0Y0>g5ZP03o`000?oooooooooo04Cooooo000F
ooooo`03o`00001o@W`0Od9l04X0Od9l00?o00000>g5ZP3]aJX0:P3]aJX00ol0003oooooooooo`13
ooooo`005_ooool00ol00000Od9l07m2O01907m2O003o`00003]aJX0kLFZ02/0kLFZ00?o0000oooo
ooooool0@oooool001Kooooo00?o000007m2O01o@W`0B@1o@W`00ol00000kLFZ0>g5ZP0/0>g5ZP03
o`000?oooooooooo04;ooooo000Fooooo`03o`00001o@W`0Od9l04P0Od9l00?o00000>g5ZP3]aJX0
;P3]aJX00ol0003oooooooooo`11ooooo`005_ooool00ol00000Od9l07m2O01807m2O003o`00003]
aJX0kLFZ02h0kLFZ00?o0000ooooooooool0@Oooool001Gooooo00?o000007m2O01o@W`0B@1o@W`0
0ol00000kLFZ0>g5ZP0_0>g5ZP03o`000?oooooooooo043ooooo000Eooooo`03o`00001o@W`0Od9l
04P0Od9l00?o00000>g5ZP3]aJX0<@3]aJX00ol0003oooooooooo`0oooooo`005Oooool00ol00000
Od9l07m2O01807m2O003o`00003]aJX0kLFZ0380kLFZ00?o0000ooooooooool0?_ooool001Gooooo
00?o000007m2O01o@W`0A`1o@W`00ol00000kLFZ0>g5ZP0c0>g5ZP03o`000?oooooooooo03kooooo
000Eooooo`03o`00001o@W`0Od9l04L0Od9l00?o00000>g5ZP3]aJX0=03]aJX00ol0003ooooooooo
o`0mooooo`005Oooool00ol00000Od9l07m2O01607m2O003o`00003]aJX0kLFZ03H0kLFZ00?o0000
ooooooooool0??ooool001Gooooo00?o000007m2O01o@W`0AP1o@W`00ol00000kLFZ0>g5ZP0f0>g5
ZP03o`000?oooooooooo03cooooo000Eooooo`03o`00001o@W`0Od9l04D0Od9l00?o00000>g5ZP3]
aJX0=P3]aJX00ol00000k/N[o`00000mooooo`005Oooool00ol00000Od9l07m2O01507m2O003o`00
003]aJX0kLFZ03H0kLFZ00?o00000>k7Zol00000?Oooool001Cooooo00?o000007m2O01o@W`0AP1o
@W`00ol00000kLFZ0>g5ZP0e0>g5ZP03o`00003^aj/0k/N[00;o0000??ooool001Cooooo00?o0000
07m2O01o@W`0A@1o@W`00ol00000kLFZ0>g5ZP0e0>g5ZP03o`00003^aj/0k/N[0080k/N[00?o0000
ooooooooool0>_ooool001Cooooo00?o000007m2O01o@W`0A@1o@W`00ol00000kLFZ0>g5ZP0e0>g5
ZP03o`00003^aj/0k/N[0080k/N[0_l0000kooooo`005?ooool00ol00000Od9l07m2O01407m2O003
o`00003]aJX0kLFZ03D0kLFZ00?o00000>k7Z`3^aj/00`3^aj/2o`0003_ooooo000Dooooo`03o`00
001o@W`0Od9l04@0Od9l00?o00000>g5ZP3]aJX0=@3]aJX00ol00000k/N[0>k7Z`040>k7Z`;o0000
>_ooool001Cooooo00?o000007m2O01o@W`0@`1o@W`00ol00000kLFZ0>g5ZP0e0>g5ZP03o`00003^
aj/0k/N[00D0k/N[0_l0000jooooo`005?ooool00ol00000Od9l07m2O01307m2O003o`00003]aJX0
kLFZ03@0kLFZ00?o00000>k7Z`3^aj/01P3^aj/00ol00000nK9;o`00000iooooo`005?ooool00ol0
0000Od9l07m2O01307m2O003o`00003]aJX0kLFZ03@0kLFZ00?o00000>k7Z`3^aj/01`3^aj/2o`00
03Wooooo000Dooooo`03o`00001o@W`0Od9l0480Od9l00?o00000>g5ZP3]aJX0=03]aJX00ol00000
k/N[0>k7Z`080>k7Z`;o0000>Oooool001?ooooo00?o000007m2O01o@W`0@`1o@W`00ol00000kLFZ
0>g5ZP0d0>g5ZP03o`00003^aj/0k/N[00P0k/N[0_l0000iooooo`004oooool00ol00000Od9l07m2
O01207m2O003o`00003]aJX0kLFZ03@0kLFZ00?o00000>k7Z`3^aj/02P3^aj/00ol0003ooooooooo
o`0gooooo`004oooool00ol00000Od9l07m2O01207m2O003o`00003]aJX0kLFZ03<0kLFZ00?o0000
0>k7Z`3^aj/02`3^aj/00ol0003oooooooooo`0gooooo`004oooool00ol00000Od9l07m2O01107m2
O003o`00003]aJX0kLFZ03@0kLFZ00?o00000>k7Z`3^aj/02`3^aj/00ol0003oooooooooo`0goooo
o`004oooool00ol00000Od9l07m2O01107m2O003o`00003]aJX0kLFZ03<0kLFZ00?o00000>k7Z`3^
aj/0303^aj/00ol0003oooooooooo`0gooooo`004oooool00ol00000Od9l07m2O01007m2O003o`00
003]aJX0kLFZ03@0kLFZ00?o00000>k7Z`3^aj/0303^aj/00ol0003oooooooooo`0gooooo`004ooo
ool00ol00000Od9l07m2O01007m2O003o`00003]aJX0kLFZ03<0kLFZ00?o00000>k7Z`3^aj/03@3^
aj/2o`0003Sooooo000Cooooo`03o`00001o@W`0Od9l0400Od9l00?o00000>g5ZP3]aJX0<P3]aJX0
0ol00000k/N[0>k7Z`0>0>k7Z`;o0000>?ooool001?ooooo00?o000007m2O01o@W`0?`1o@W`00ol0
0000kLFZ0>g5ZP0c0>g5ZP03o`00003^aj/0k/N[00h0k/N[0_l0000hooooo`004_ooool00ol00000
Od9l07m2O01007m2O003o`00003]aJX0kLFZ0380kLFZ00?o00000>k7Z`3^aj/03`3^aj/2o`0003So
oooo000Booooo`03o`00001o@W`0Od9l03l0Od9l00?o00000>g5ZP3]aJX0<`3]aJX00ol00000k/N[
0>k7Z`0?0>k7Z`;o0000>?ooool001;ooooo00?o000007m2O01o@W`0?`1o@W`00ol00000kLFZ0>g5
ZP0b0>g5ZP03o`00003^aj/0k/N[0140k/N[00?o0000ooooooooool0=_ooool001;ooooo00?o0000
07m2O01o@W`0?P1o@W`00ol00000kLFZ0>g5ZP0b0>g5ZP03o`00003^aj/0k/N[0180k/N[00?o0000
ooooooooool0=_ooool001;ooooo00?o000007m2O01o@W`0?P1o@W`00ol00000kLFZ0>g5ZP0b0>g5
ZP03o`00003^aj/0k/N[0180k/N[00?o0000ooooooooool0=_ooool001;ooooo00?o000007m2O01o
@W`0?P1o@W`00ol00000kLFZ0>g5ZP0a0>g5ZP03o`00003^aj/0k/N[01<0k/N[00?o0000oooooooo
ool0=_ooool001;ooooo00?o000007m2O01o@W`0?@1o@W`00ol00000kLFZ0>g5ZP0b0>g5ZP03o`00
003^aj/0k/N[01<0k/N[00?o0000ooooooooool0=_ooool001;ooooo00?o000007m2O01o@W`0?@1o
@W`00ol00000kLFZ0>g5ZP0a0>g5ZP03o`00003^aj/0k/N[01@0k/N[00?o0000ooooooooool0=_oo
ool001;ooooo00?o000007m2O01o@W`0?01o@W`00ol00000kLFZ0>g5ZP0a0>g5ZP03o`00003^aj/0
k/N[01D0k/N[00?o0000ooooooooool0=_ooool0017ooooo00?o000007m2O01o@W`0?@1o@W`00ol0
0000kLFZ0>g5ZP0a0>g5ZP03o`00003^aj/0k/N[01D0k/N[00?o0000ooooooooool0=_ooool0017o
oooo00?o000007m2O01o@W`0?01o@W`00ol00000kLFZ0>g5ZP0a0>g5ZP03o`00003^aj/0k/N[01H0
k/N[00?o0000ooooooooool0=_ooool0017ooooo00?o000007m2O01o@W`0?01o@W`00ol00000kLFZ
0>g5ZP0a0>g5ZP03o`00003^aj/0k/N[01H0k/N[00?o0000ooooooooool0=_ooool0017ooooo00?o
000007m2O01o@W`0?01o@W`00ol00000kLFZ0>g5ZP0`0>g5ZP03o`00003^aj/0k/N[01L0k/N[0_l0
000gooooo`004Oooool00ol00000Od9l07m2O00k07m2O003o`00003]aJX0kLFZ0300kLFZ00?o0000
0>k7Z`3^aj/0603^aj/2o`0003Oooooo000Aooooo`03o`00001o@W`0Od9l03/0Od9l00?o00000>g5
ZP3]aJX0<03]aJX00ol00000k/N[0>k7Z`0H0>k7Z`;o0000=oooool0017ooooo00?o000007m2O01o
@W`0>P1o@W`00ol00000kLFZ0>g5ZP0`0>g5ZP03o`00003^aj/0k/N[01T0k/N[0_l0000gooooo`00
4Oooool00ol00000Od9l07m2O00j07m2O003o`00003]aJX0kLFZ0300kLFZ00?o00000>k7Z`3^aj/0
6@3^aj/2o`0003Oooooo000Aooooo`03o`00001o@W`0Od9l03T0Od9l00?o00000>g5ZP3]aJX0<03]
aJX00ol00000k/N[0>k7Z`0J0>k7Z`;o0000=oooool0017ooooo00?o000007m2O01o@W`0>@1o@W`0
0ol00000kLFZ0>g5ZP0_0>g5ZP03o`00003^aj/0k/N[01/0k/N[0_l0000gooooo`004?ooool00ol0
0000Od9l07m2O00i07m2O003o`00003]aJX0kLFZ0300kLFZ00?o00000>k7Z`3^aj/06`3^aj/2o`00
03Oooooo000@ooooo`03o`00001o@W`0Od9l03T0Od9l00?o00000>g5ZP3]aJX0;`3]aJX00ol00000
k/N[0>k7Z`0L0>k7Z`;o0000=oooool0013ooooo00?o000007m2O01o@W`0>@1o@W`00ol00000kLFZ
0>g5ZP0_0>g5ZP03o`00003^aj/0k/N[01d0k/N[00?o0000ooooooooool0=Oooool0013ooooo00?o
000007m2O01o@W`0>01o@W`00ol00000kLFZ0>g5ZP0_0>g5ZP03o`00003^aj/0k/N[01h0k/N[00?o
0000ooooooooool0=Oooool0013ooooo00?o000007m2O01o@W`0>01o@W`00ol00000kLFZ0>g5ZP0^
0>g5ZP03o`00003^aj/0k/N[01l0k/N[00?o0000ooooooooool0=Oooool0013ooooo00?o000007m2
O01o@W`0=`1o@W`00ol00000kLFZ0>g5ZP0_0>g5ZP03o`00003^aj/0k/N[01l0k/N[00?o0000oooo
ooooool0=Oooool0013ooooo00?o000007m2O01o@W`0=`1o@W`00ol00000kLFZ0>g5ZP0^0>g5ZP03
o`00003^aj/0k/N[0200k/N[00?o0000ooooooooool0=Oooool0013ooooo00?o000007m2O01o@W`0
=P1o@W`00ol00000kLFZ0>g5ZP0_0>g5ZP03o`00003^aj/0k/N[0200k/N[00?o0000ooooooooool0
=Oooool0013ooooo00?o000007m2O01o@W`0=P1o@W`00ol00000kLFZ0>g5ZP0^0>g5ZP03o`00003^
aj/0k/N[0240k/N[0_l0000fooooo`003oooool00ol00000Od9l07m2O00g07m2O003o`00003]aJX0
kLFZ02d0kLFZ00?o00000>k7Z`3^aj/08P3^aj/2o`0003Kooooo000?ooooo`03o`00001o@W`0Od9l
03H0Od9l00?o00000>g5ZP3]aJX0;P3]aJX00ol00000k/N[0>k7Z`0R0>k7Z`;o0000=_ooool000oo
oooo00?o000007m2O01o@W`0=P1o@W`00ol00000kLFZ0>g5ZP0]0>g5ZP03o`00003^aj/0k/N[02<0
k/N[0_l0000fooooo`003oooool00ol00000Od9l07m2O00e07m2O003o`00003]aJX0kLFZ02h0kLFZ
00?o00000>k7Z`3^aj/08`3^aj/2o`0003Kooooo000?ooooo`03o`00001o@W`0Od9l03D0Od9l00?o
00000>g5ZP3]aJX0;@3]aJX00ol00000k/N[0>k7Z`0T0>k7Z`;o0000=_ooool000oooooo00?o0000
07m2O01o@W`0=01o@W`00ol00000kLFZ0>g5ZP0]0>g5ZP03o`00003^aj/0k/N[02D0k/N[0_l0000f
ooooo`003oooool00ol00000Od9l07m2O00d07m2O003o`00003]aJX0kLFZ02d0kLFZ00?o00000>k7
Z`3^aj/09@3^aj/2o`0003Kooooo000?ooooo`03o`00001o@W`0Od9l03<0Od9l00?o00000>g5ZP3]
aJX0;@3]aJX00ol00000k/N[0>k7Z`0V0>k7Z`;o0000=_ooool000oooooo00?o000007m2O01o@W`0
<`1o@W`00ol00000kLFZ0>g5ZP0]0>g5ZP03o`00003^aj/0k/N[02H0k/N[0_l0000fooooo`003_oo
ool00ol00000Od9l07m2O00d07m2O003o`00003]aJX0kLFZ02`0kLFZ00?o00000>k7Z`3^aj/09`3^
aj/2o`0003Kooooo000>ooooo`03o`00001o@W`0Od9l03<0Od9l00?o00000>g5ZP3]aJX0;03]aJX0
0ol00000k/N[0>k7Z`0X0>k7Z`;o0000=_ooool000kooooo00?o000007m2O01o@W`0<`1o@W`00ol0
0000kLFZ0>g5ZP0/0>g5ZP03o`00003^aj/0k/N[02P0k/N[0_l0000fooooo`003_ooool00ol00000
Od9l07m2O00b07m2O003o`00003]aJX0kLFZ02`0kLFZ00?o00000>k7Z`3^aj/0:P3^aj/00ol0003o
ooooooooo`0dooooo`003_ooool00ol00000Od9l07m2O00b07m2O003o`00003]aJX0kLFZ02`0kLFZ
00?o00000>k7Z`3^aj/0:P3^aj/00ol0003oooooooooo`0dooooo`003_ooool00ol00000Od9l07m2
O00a07m2O003o`00003]aJX0kLFZ02`0kLFZ00?o00000>k7Z`3^aj/0:`3^aj/00ol0003ooooooooo
o`0dooooo`003_ooool00ol00000Od9l07m2O00a07m2O003o`00003]aJX0kLFZ02/0kLFZ00?o0000
0>k7Z`3^aj/0;03^aj/00ol0003oooooooooo`0dooooo`003_ooool00ol00000Od9l07m2O00a07m2
O003o`00003]aJX0kLFZ02/0kLFZ00?o00000>k7Z`3^aj/0;03^aj/00ol0003oooooooooo`0doooo
o`003_ooool00ol00000Od9l07m2O00`07m2O003o`00003]aJX0kLFZ02/0kLFZ00?o00000>k7Z`3^
aj/0;@3^aj/00ol0003oooooooooo`0dooooo`003Oooool00ol00000Od9l07m2O00a07m2O003o`00
003]aJX0kLFZ02/0kLFZ00?o00000>k7Z`3^aj/0;@3^aj/00ol0003oooooooooo`0dooooo`003Ooo
ool00ol00000Od9l07m2O00`07m2O003o`00003]aJX0kLFZ02/0kLFZ00?o00000>k7Z`3^aj/0;P3^
aj/00ol0003oooooooooo`0dooooo`003Oooool00ol00000Od9l07m2O00`07m2O003o`00003]aJX0
kLFZ02X0kLFZ00?o00000>k7Z`3^aj/0;`3^aj/2o`0003Gooooo000=ooooo`03o`00001o@W`0Od9l
02l0Od9l00?o00000>g5ZP3]aJX0:`3]aJX00ol00000k/N[0>k7Z`0_0>k7Z`;o0000=Oooool000go
oooo00?o000007m2O01o@W`0;`1o@W`00ol00000kLFZ0>g5ZP0Z0>g5ZP03o`00003^aj/0k/N[0300
k/N[0_l0000eooooo`003Oooool00ol00000Od9l07m2O00^07m2O003o`00003]aJX0kLFZ02/0kLFZ
00?o00000>k7Z`3^aj/0<03^aj/2o`0003Gooooo000=ooooo`03o`00001o@W`0Od9l02h0Od9l00?o
00000>g5ZP3]aJX0:P3]aJX00ol00000k/N[0>k7Z`0a0>k7Z`;o0000=Oooool000gooooo00?o0000
07m2O01o@W`0;P1o@W`00ol00000kLFZ0>g5ZP0Y0>g5ZP03o`00003^aj/0k/N[0380k/N[0_l0000e
ooooo`003Oooool00ol00000Od9l07m2O00]07m2O003o`00003]aJX0kLFZ02X0kLFZ00?o00000>k7
Z`3^aj/0<P3^aj/2o`0003Gooooo000<ooooo`03o`00001o@W`0Od9l02h0Od9l00?o00000>g5ZP3]
aJX0:@3]aJX00ol00000k/N[0>k7Z`0c0>k7Z`;o0000=Oooool000cooooo00?o000007m2O01o@W`0
;@1o@W`00ol00000kLFZ0>g5ZP0Z0>g5ZP03o`00003^aj/0k/N[03<0k/N[0_l0000eooooo`003?oo
ool00ol00000Od9l07m2O00]07m2O003o`00003]aJX0kLFZ02T0kLFZ00?o00000>k7Z`3^aj/0=03^
aj/2o`0003Gooooo000<ooooo`03o`00001o@W`0Od9l02`0Od9l00?o00000>g5ZP3]aJX0:@3]aJX0
0ol00000k/N[0>k7Z`0e0>k7Z`;o0000=Oooool000cooooo00?o000007m2O01o@W`0;01o@W`00ol0
0000kLFZ0>g5ZP0Y0>g5ZP03o`00003^aj/0k/N[03H0k/N[00?o0000ooooooooool0<oooool000co
oooo00?o000007m2O01o@W`0;01o@W`00ol00000kLFZ0>g5ZP0X0>g5ZP03o`00003^aj/0k/N[03L0
k/N[00?o0000ooooooooool0<oooool000cooooo00?o000007m2O01o@W`0:`1o@W`00ol00000kLFZ
0>g5ZP0Y0>g5ZP03o`00003^aj/0k/N[03L0k/N[00?o0000ooooooooool0<oooool000cooooo00?o
000007m2O01o@W`0:`1o@W`00ol00000kLFZ0>g5ZP0X0>g5ZP03o`00003^aj/0k/N[03P0k/N[00?o
0000ooooooooool0<oooool000cooooo00?o000007m2O01o@W`0:P1o@W`00ol00000kLFZ0>g5ZP0X
0>g5ZP03o`00003^aj/0k/N[03T0k/N[00?o0000ooooooooool0<oooool000_ooooo00?o000007m2
O01o@W`0:`1o@W`2o`0002T0kLFZ00?o00000>k7Z`3^aj/0>@3^aj/00ol0003oooooooooo`0coooo
o`002oooool00ol00000Od9l07m2O00Y07m2O0;o00000P3[ak400ol00000kLFZ0>g5ZP0U0>g5ZP03
o`00003^aj/0k/N[03X0k/N[00?o0000ooooooooool0<oooool000_ooooo00?o000007m2O01o@W`0
:01o@W`01?l00000e<gB0=C=d_l000020>_7/@03o`00003]aJX0kLFZ02@0kLFZ00?o00000>k7Z`3^
aj/0>P3^aj/00ol0003oooooooooo`0cooooo`002oooool00ol00000Od9l07m2O00W07m2O003o`00
003DcM80e<gB0080e<gB00Co00000>_7/@3[ak7o0000903]aJX00ol00000k/N[0>k7Z`0k0>k7Z`03
o`000?oooooooooo03?ooooo000;ooooo`03o`00001o@W`0Od9l02H0Od9l00?o00000=C=dP3DcM80
103DcM801?l00000jlNa0>_7/Ol0000R0>g5ZP03o`00003^aj/0k/N[03`0k/N[00?o0000oooooooo
ool0<oooool000_ooooo00?o000007m2O01o@W`09@1o@W`00ol00000e<gB0=C=dP060=C=dP04o`00
003[ak40jlNao`000240kLFZ00?o00000>k7Z`3^aj/0?03^aj/00ol0003oooooooooo`0cooooo`00
2oooool00ol00000Od9l07m2O00T07m2O003o`00003DcM80e<gB00P0e<gB00Co00000>_7/@3[ak7o
00007`3]aJX00ol00000k/N[0>k7Z`0m0>k7Z`03o`000?oooooooooo03?ooooo000;ooooo`03o`00
001o@W`0Od9l02<0Od9l00?o00000=C=dP3DcM802P3DcM801?l00000jlNa0>_7/Ol0000N0>g5ZP03
o`00003^aj/0k/N[03d0k/N[00?o0000ooooooooool0<oooool000_ooooo00?o000007m2O01o@W`0
8P1o@W`00ol00000e<gB0=C=dP0<0=C=dP04o`00003[ak40jlNao`0001`0kLFZ00?o00000>k7Z`3^
aj/0?P3^aj/00ol0003oooooooooo`0cooooo`002oooool00ol00000Od9l07m2O00Q07m2O003o`00
003DcM80e<gB00h0e<gB00Co00000>_7/@3[ak7o00006P3]aJX00ol00000k/N[0>k7Z`0o0>k7Z`03
o`000?oooooooooo03?ooooo000:ooooo`03o`00001o@W`0Od9l0240Od9l00?o00000=C=dP3DcM80
403DcM801?l00000jlNa0>_7/Ol0000I0>g5ZP03o`00003^aj/0k/N[03l0k/N[00?o0000oooooooo
ool0<oooool000[ooooo00?o000007m2O01o@W`0801o@W`00ol00000e<gB0=C=dP0B0=C=dP04o`00
003[ak40jlNao`0001L0kLFZ00?o00000>k7Z`3^aj/0@03^aj/2o`0003Cooooo000:ooooo`03o`00
001o@W`0Od9l01l0Od9l00?o00000=C=dP3DcM80503DcM801?l00000jlNa0>_7/Ol0000F0>g5ZP03
o`00003^aj/0k/N[0400k/N[0_l0000dooooo`002_ooool00ol00000Od9l07m2O00N07m2O003o`00
003DcM80e<gB01H0e<gB00Co00000>_7/@3[ak7o0000503]aJX00ol00000k/N[0>k7Z`110>k7Z`;o
0000=?ooool000[ooooo00?o000007m2O01o@W`07@1o@W`00ol00000e<gB0=C=dP0H0=C=dP04o`00
003[ak40jlNao`000180kLFZ00?o00000>k7Z`3^aj/0@`3^aj/00ol0003oooooooooo`0booooo`00
2_ooool00ol00000Od9l07m2O00L07m2O003o`00003DcM80e<gB01X0e<gB00Co00000>_7/@3[ak7o
00004@3]aJX00ol00000k/N[0>k7Z`130>k7Z`03o`000?oooooooooo03;ooooo000:ooooo`03o`00
001o@W`0Od9l01/0Od9l00?o00000=C=dP3DcM80703DcM801?l00000jlNa0>_7/Ol0000?0>g5ZP03
o`00003^aj/0k/N[04@0k/N[00?o0000ooooooooool0<_ooool000[ooooo00?o000007m2O01o@W`0
6P1o@W`00ol00000e<gB0=C=dP0N0=C=dP04o`00003[ak40jlNao`0000h0kLFZ00?o00000>k7Z`3^
aj/0A03^aj/00ol0003oooooooooo`0booooo`002_ooool00ol00000Od9l07m2O00I07m2O003o`00
003DcM80e<gB0200e<gB00Co00000>_7/@3[ak7o0000303]aJX00ol00000k/N[0>k7Z`150>k7Z`03
o`000?oooooooooo03;ooooo0009ooooo`03o`00001o@W`0Od9l01T0Od9l00?o00000=C=dP3DcM80
8P3DcM801?l00000jlNa0>_7/Ol0000:0>g5ZP03o`00003^aj/0k/N[04H0k/N[00?o0000oooooooo
ool0<_ooool000Wooooo00?o000007m2O01o@W`0601o@W`00ol00000e<gB0=C=dP0T0=C=dP04o`00
003[ak40jlNao`0000T0kLFZ00?o00000>k7Z`3^aj/0AP3^aj/00ol0003oooooooooo`0booooo`00
2Oooool00ol00000Od9l07m2O00G07m2O003o`00003DcM80e<gB02H0e<gB00Co00000>_7/@3[ak7o
00001`3]aJX00ol00000k/N[0>k7Z`170>k7Z`03o`000?oooooooooo03;ooooo0009ooooo`03o`00
001o@W`0Od9l01H0Od9l00?o00000=C=dP3DcM80:03DcM801?l00000jlNa0>_7/Ol000060>g5ZP03
o`00003^aj/0k/N[04L0k/N[00?o0000ooooooooool0<_ooool000Wooooo00?o000007m2O01o@W`0
5@1o@W`00ol00000e<gB0=C=dP0Z0=C=dP04o`00003[ak40jlNao`0000@0kLFZ00?o00000>k7Z`3^
aj/0B03^aj/00ol0003oooooooooo`0booooo`002Oooool00ol00000Od9l07m2O00D07m2O003o`00
003DcM80e<gB02`0e<gB00Co00000>_7/@3[ak7o00000P3]aJX00ol00000k/N[0>k7Z`190>k7Z`03
o`000?oooooooooo03;ooooo0009ooooo`03o`00001o@W`0Od9l01<0Od9l00?o00000=C=dP3DcM80
;P3DcM801_l00000jlNa0>_7/Ol00000kLFZo`0004X0k/N[00?o0000ooooooooool0<oooool000Wo
oooo00?o000007m2O01o@W`04P1o@W`00ol00000e<gB0=C=dP0`0=C=dP04o`00003[ak40jlNao`00
04/0k/N[00?o0000ooooooooool0<oooool000Wooooo00?o000007m2O01o@W`04@1o@W`00ol00000
e<gB0=C=dP0b0=C=dP03o`00003[ak7o000004X0k/N[00?o0000ooooooooool0=?ooool000Sooooo
00?o000007m2O01o@W`04@1o@W`00ol00000e<gB0=C=dP0d0=C=dP03o`00003[ak7o000004T0k/N[
00?o0000ooooooooool0=?ooool000Sooooo00?o000007m2O01o@W`0401o@W`00ol00000e<gB0=C=
dP0f0=C=dP;o0000B03^aj/00ol0003oooooooooo`0eooooo`002?ooool00ol00000Od9l07m2O00?
07m2O003o`00003DcM80e<gB03P0e<gB0_l000170>k7Z`03o`000?oooooooooo03Gooooo0008oooo
o`03o`00001o@W`0Od9l00h0Od9l00?o00000=C=dP3DcM80>P3DcM800ol00000k/N[0>k7Z`140>k7
Z`03o`000?oooooooooo03Kooooo0008ooooo`03o`00001o@W`0Od9l00d0Od9l00?o00000=C=dP3D
cM80?03DcM82o`0004<0k/N[00?o0000ooooooooool0=oooool000Sooooo00?o000007m2O01o@W`0
301o@W`00ol00000e<gB0=C=dP0m0=C=dP04o`00003OfM3o0000o`000440k/N[00?o0000oooooooo
ool0=oooool000Sooooo00?o000007m2O01o@W`02`1o@W`00ol00000e<gB0=C=dP0n0=C=dP04o`00
003OfM00gmW@0=oId0?o0000?@3^aj/00ol0003oooooooooo`0hooooo`002?ooool00ol00000Od9l
07m2O00:07m2O003o`00003DcM80e<gB03h0e<gB00?o00000=oId03OfM001@3OfM02o`0003/0k/N[
00?o0000ooooooooool0>?ooool000Sooooo00?o000007m2O01o@W`02@1o@W`00ol00000e<gB0=C=
dP0o0=C=dP03o`00003OfM00gmW@00L0gmW@0_l0000h0>k7Z`03o`000?oooooooooo03Wooooo0007
ooooo`03o`00001o@W`0Od9l00T0Od9l00?o00000=C=dP3DcM80@03DcM800ol00000gmW@0=oId009
0=oId0;o0000=P3^aj/00ol0003oooooooooo`0iooooo`001oooool00ol00000Od9l07m2O00807m2
O003o`00003DcM80e<gB0400e<gB00?o00000=oId03OfM00303OfM03o`000380k/N[00?o0000oooo
ooooool0>_ooool000Oooooo00?o000007m2O01o@W`01`1o@W`00ol00000e<gB0=C=dP110=C=dP03
o`00003OfM00gmW@00l0gmW@0_l0000`0>k7Z`03o`000?oooooooooo03[ooooo0007ooooo`03o`00
001o@W`0Od9l00H0Od9l00?o00000=C=dP3DcM80@P3DcM800ol00000gmW@0=oId00A0=oId0;o0000
;@3^aj/00ol0003oooooooooo`0kooooo`001oooool00ol00000Od9l07m2O00507m2O003o`00003D
cM80e<gB04<0e<gB00?o00000=oId03OfM004`3OfM02o`0002/0k/N[00?o0000ooooooooool0>ooo
ool000Oooooo00?o000007m2O01o@W`0101o@W`00ol00000e<gB0=C=dP130=C=dP03o`00003OfM00
gmW@01H0gmW@0ol0000W0>k7Z`03o`000?oooooooooo03cooooo0007ooooo`03o`00001o@W`0Od9l
00<0Od9l00?o00000=C=dP3DcM80A03DcM800ol00000gmW@0=oId00I0=oId0;o00009@3^aj/00ol0
003oooooooooo`0looooo`001oooool00ol00000Od9l07m2O00207m2O003o`00003DcM80e<gB04D0
e<gB00?o00000=oId03OfM006`3OfM02o`000280k/N[00?o0000ooooooooool0?Oooool000Oooooo
00Go000007m2O01o@W`0Od9lo`0000180=C=dP03o`00003OfM00gmW@01d0gmW@0_l0000P0>k7Z`03
o`000?oooooooooo03gooooo0006ooooo`05o`00001o@W`0Od9l07m2O?l00000B03DcM800ol00000
gmW@0=oId00P0=oId0;o00007@3^aj/00ol0003oooooooooo`0nooooo`001_ooool01?l00000Od9l
07m2O?l000190=C=dP03o`00003OfM00gmW@0280gmW@0ol0000J0>k7Z`03o`000?oooooooooo03ko
oooo0006ooooo`03o`00001o@Wco000004X0e<gB00?o00000=oId03OfM009@3OfM02o`0001L0k/N[
00?o0000ooooooooool0?oooool000Kooooo0_l0001:0=C=dP03o`00003OfM00gmW@02P0gmW@0_l0
000D0>k7Z`03o`000?oooooooooo043ooooo0006ooooo`03o`00003DcM80e<gB04T0e<gB00?o0000
0=oId03OfM00:P3OfM02o`000180k/N[00?o0000ooooooooool0@?ooool000Sooooo00?o00000=C=
dP3DcM80A`3DcM800ol00000gmW@0=oId00/0=oId0?o00003P3^aj/00ol0003oooooooooo`11oooo
o`002Oooool00ol00000e<gB0=C=dP160=C=dP03o`00003OfM00gmW@02l0gmW@0_l0000<0>k7Z`03
o`000?oooooooooo047ooooo000:ooooo`03o`00003DcM80e<gB04@0e<gB00?o00000=oId03OfM00
<P3OfM02o`0000T0k/N[00?o0000ooooooooool0@_ooool000_ooooo0_l000140=C=dP03o`00003O
fM00gmW@03@0gmW@0_l000070>k7Z`03o`000?oooooooooo04;ooooo000=ooooo`03o`00003DcM80
e<gB0440e<gB00?o00000=oId03OfM00=P3OfM03o`0000<0k/N[00?o0000ooooooooool0@oooool0
00kooooo00?o00000=C=dP3DcM80?`3DcM800ol00000gmW@0=oId00j0=oId0;o000000<0k/N[o`00
0?ooool0A?ooool000oooooo00?o00000=C=dP3DcM80?P3DcM800ol00000gmW@0=oId00k0=oId0;o
0000A_ooool0013ooooo0_l0000n0=C=dP03o`00003OfM00gmW@03X0gmW@00?o0000ooooooooool0
A_ooool001;ooooo00?o00000=C=dP3DcM80>`3DcM800ol00000gmW@0=oId00i0=oId003o`000?oo
oooooooo04Oooooo000Cooooo`03o`00003DcM80e<gB03T0e<gB00?o00000=oId03OfM00>03OfM02
o`0004[ooooo000Dooooo`03o`00003DcM80e<gB03P0e<gB00?o00000=oId03OfM00=`3OfM000ol0
003oooooooooo`1:ooooo`005Oooool2o`0003P0e<gB00?o00000=oId03OfM00=@3OfM02o`0004go
oooo000Gooooo`03o`00003DcM80e<gB03@0e<gB00?o00000=oId03OfM00=@3OfM000ol0003ooooo
ooooo`1=ooooo`006?ooool00ol00000e<gB0=C=dP0c0=C=dP03o`00003OfM00gmW@03@0gmW@00?o
0000ooooooooool0C_ooool001Wooooo00?o00000=C=dP3DcM80<P3DcM800ol00000gmW@0=oId00b
0=oId0;o0000DOooool001[ooooo00?o00000=C=dP3DcM80<@3DcM800ol00000gmW@0=oId00a0=oI
d003o`000?oooooooooo057ooooo000Kooooo`;o0000<03DcM800ol00000gmW@0=oId00`0=oId0;o
0000E?ooool001gooooo00?o00000=C=dP3DcM80;@3DcM800ol00000gmW@0=oId00_0=oId003o`00
0?oooooooooo05Cooooo000Nooooo`03o`00003DcM80e<gB02`0e<gB00?o00000=oId03OfM00;P3O
fM000ol0003oooooooooo`1Eooooo`007oooool00ol00000e<gB0=C=dP0[0=C=dP03o`00003OfM00
gmW@02`0gmW@0_l0001Hooooo`008?ooool2o`0002X0e<gB00?o00000=oId03OfM00;03OfM000ol0
003oooooooooo`1Hooooo`008_ooool00ol00000e<gB0=C=dP0W0=C=dP03o`00003OfM00gmW@02/0
gmW@00?o0000ooooooooool0FOooool002?ooooo00?o00000=C=dP3DcM809P3DcM800ol00000gmW@
0=oId00Y0=oId0;o0000G?ooool002Cooooo00?o00000=C=dP3DcM80903DcM800ol00000gmW@0=oI
d00Y0=oId003o`000?oooooooooo05cooooo000Uooooo`;o0000903DcM800ol00000gmW@0=oId00W
0=oId0;o0000Goooool002Oooooo00?o00000=C=dP3DcM808@3DcM800ol00000gmW@0=oId00V0=oI
d003o`000?oooooooooo05oooooo000Xooooo`03o`00003DcM80e<gB0200e<gB00?o00000=oId03O
fM009@3OfM000ol0003oooooooooo`1Pooooo`00:Oooool00ol00000e<gB0=C=dP0N0=C=dP03o`00
003OfM00gmW@02@0gmW@0_l0001Sooooo`00:_ooool2o`0001h0e<gB00?o00000=oId03OfM008`3O
fM000ol0003oooooooooo`1Sooooo`00;?ooool00ol00000e<gB0=C=dP0K0=C=dP03o`00003OfM00
gmW@0240gmW@0_l0001Vooooo`00;Oooool00ol00000e<gB0=C=dP0I0=C=dP03o`00003OfM00gmW@
0240gmW@00?o0000ooooooooool0I_ooool002kooooo00?o00000=C=dP3DcM80603DcM800ol00000
gmW@0=oId00P0=oId003o`000?oooooooooo06Oooooo000_ooooo`;o0000603DcM800ol00000gmW@
0=oId00N0=oId0;o0000J_ooool0037ooooo00?o00000=C=dP3DcM805@3DcM800ol00000gmW@0=oI
d00M0=oId003o`000?oooooooooo06[ooooo000booooo`03o`00003DcM80e<gB01<0e<gB00?o0000
0=oId03OfM00703OfM02o`0006gooooo000cooooo`03o`00003DcM80e<gB0180e<gB00?o00000=oI
d03OfM006`3OfM000ol0003oooooooooo`1]ooooo`00=?ooool2o`000180e<gB00?o00000=oId03O
fM006P3OfM000ol0003oooooooooo`1^ooooo`00=_ooool00ol00000e<gB0=C=dP0>0=C=dP03o`00
003OfM00gmW@01T0gmW@0_l0001aooooo`00=oooool00ol00000e<gB0=C=dP0=0=C=dP03o`00003O
fM00gmW@01P0gmW@00?o0000ooooooooool0LOooool003Sooooo00?o00000=C=dP3DcM80303DcM80
0ol00000gmW@0=oId00G0=oId003o`000?oooooooooo07;ooooo000iooooo`03o`00003DcM80e<gB
00/0e<gB00?o00000=oId03OfM005@3OfM02o`0007Gooooo000jooooo`;o00002P3DcM800ol00000
gmW@0=oId00E0=oId003o`000?oooooooooo07Gooooo000looooo`03o`00003DcM80e<gB00L0e<gB
00?o00000=oId03OfM004`3OfM02o`0007Sooooo000mooooo`03o`00003DcM80e<gB00H0e<gB00?o
00000=oId03OfM004P3OfM000ol0003oooooooooo`1hooooo`00?_ooool00ol00000e<gB0=C=dP05
0=C=dP03o`00003OfM00gmW@0140gmW@00?o0000ooooooooool0NOooool003oooooo0_l000040=C=
dP03o`00003OfM00gmW@0100gmW@0_l0001looooo`00@Oooool01Ol00000e<gB0=C=dP3DcM;o0000
0140gmW@00?o0000ooooooooool0O?ooool004;ooooo00Co00000=C=dP3DcM;o00003`3OfM02o`00
07oooooo0013ooooo`;o00003`3OfM000ol0003oooooooooo`1oooooo`00A?ooool2o`0000d0gmW@
00?o0000ooooooooool0P?ooool004Kooooo0_l000090=oId0;o0000Poooool004Sooooo0_l00005
0=oId0;o0000QOooool004[ooooo0_l000000`3OfM3o0000o`000027ooooo`00C?ooool00ol0003o
ooooooooo`27ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00\
\>"],
  ImageRangeCache->{{{0, 213.812}, {286.938, 0}} -> {0.119066, -0.000500526, \
0.00330022, 0.00330022}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.3406 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.168744 1.41719 -1.11022e-16 1.41719 [
[ 0 0 0 0 ]
[ 1 1.3406 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.3406 L
0 1.3406 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.53601 .68794 m .10645 .21595 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.63102 .65725 m .53601 .68794 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.53601 .68794 m .53594 .77534 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.10645 .21595 m .53601 .68794 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.53601 .68794 m .53594 .77534 L .63286 .74517 L p .573 .367 .563 r
F P
0 g
s
.63286 .74517 m .63102 .65725 L .53601 .68794 L p .573 .367 .563 r
F P
0 g
s
.72535 .59786 m .63102 .65725 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.72535 .59786 m .63102 .65725 L .63286 .74517 L p .451 .272 .546 r
F P
0 g
s
.53594 .77534 m .44972 1.00044 L .37086 1.14777 L p .951 .687 .499 r
F P
0 g
s
.53594 .77534 m .44972 1.00044 L .67312 .937 L p .454 .121 .31 r
F P
0 g
s
.67312 .937 m .63286 .74517 L .53594 .77534 L p .454 .121 .31 r
F P
0 g
s
.63286 .74517 m .72921 .68676 L .72535 .59786 L p .451 .272 .546 r
F P
0 g
s
.67312 .937 m .63286 .74517 L .72921 .68676 L p .303 .031 .324 r
F P
0 g
s
.74366 .53161 m .72535 .59786 L p .7084 .26578 L .671 .73 .894 r
F P
0 g
s
.72535 .59786 m .74366 .53161 L .75563 .779 L p 0 0 .324 r
F P
0 g
s
.75563 .779 m .72921 .68676 L .72535 .59786 L p 0 0 .324 r
F P
0 g
s
.72921 .68676 m .75563 .779 L .67312 .937 L p .303 .031 .324 r
F P
0 g
s
.7084 .26578 m .73162 .31552 L .74366 .53161 L p .671 .73 .894 r
F P
0 g
s
.74366 .53161 m .73162 .31552 L .73238 .33127 L p .716 .555 0 r
F P
0 g
s
.73238 .33127 m .75563 .779 L .74366 .53161 L p .716 .555 0 r
F P
0 g
s
.75563 .779 m .67312 .937 L p .7084 .26578 L .932 .78 .669 r
F P
0 g
s
.7084 .26578 m .73238 .33127 L .75563 .779 L p .932 .78 .669 r
F P
0 g
s
.44972 1.00044 m .37086 1.14777 L .3867 1.14354 L p .399 .023 .204 r
F P
0 g
s
.3867 1.14354 m .67312 .937 L .44972 1.00044 L p .399 .023 .204 r
F P
0 g
s
.73238 .33127 m .7084 .26578 L .73162 .31552 L closepath p .975 .696 .295 r
F P
0 g
s
.67312 .937 m .40709 .81749 L p .7084 .26578 L .932 .78 .669 r
F P
0 g
s
.40709 .81749 m .67312 .937 L .3867 1.14354 L p .873 .849 .816 r
F P
0 g
s
.10645 .21595 m .54474 .03568 L .7084 .26578 L p .671 .73 .894 r
F P
0 g
s
.40709 .81749 m .39363 .78987 L .7084 .26578 L p .932 .78 .669 r
F P
0 g
s
.54474 .03568 m .7084 .26578 L .39363 .78987 L p .928 .772 .667 r
F P
0 g
s
.10645 .21595 m .54474 .03568 L .26821 .66611 L p .5 .261 .485 r
F P
0 g
s
.03007 .90264 m .10645 .21595 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.03007 .90264 m .10645 .21595 L p .26821 .66611 L .5 .261 .485 r
F P
0 g
s
.31871 1.13647 m .03007 .90264 L p .37086 1.14777 L .951 .687 .499 r
F P
0 g
s
.37086 1.14777 m .35781 1.1561 L .31871 1.13647 L p .951 .687 .499 r
F P
0 g
s
.3867 1.14354 m .36157 1.16511 L .37086 1.14777 L closepath p .399 .023 .204 \
r
F P
0 g
s
.31871 1.13647 m .40709 .81749 L p .3867 1.14354 L .873 .849 .816 r
F P
0 g
s
.3867 1.14354 m .35781 1.1561 L .31871 1.13647 L p .873 .849 .816 r
F P
0 g
s
.03007 .90264 m .31871 1.13647 L .40709 .81749 L p .83 .801 .824 r
F P
0 g
s
.39363 .78987 m .26821 .66611 L .54474 .03568 L p .928 .772 .667 r
F P
0 g
s
.39363 .78987 m .40709 .81749 L .26309 .6763 L p .918 .779 .692 r
F P
0 g
s
.40709 .81749 m .26309 .6763 L .03007 .90264 L p .83 .801 .824 r
F P
0 g
s
.26309 .6763 m .26821 .66611 L .39363 .78987 L p .918 .779 .692 r
F P
0 g
s
.26821 .66611 m .26309 .6763 L .03007 .90264 L p .5 .261 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.32013 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.159451 1.39722 0 1.39722 [
[ 0 0 0 0 ]
[ 1 1.32013 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.32013 L
0 1.32013 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52817 .68071 m .10619 .21908 L p .69566 .26781 L .671 .73 .894 r
F P
0 g
s
.6211 .65068 m .52817 .68071 L p .69566 .26781 L .671 .73 .894 r
F P
0 g
s
.52817 .68071 m .52795 .76633 L p .36487 1.13139 L .951 .687 .501 r
F P
0 g
s
.10619 .21908 m .52817 .68071 L p .36487 1.13139 L .951 .687 .501 r
F P
0 g
s
.52817 .68071 m .52795 .76633 L .62276 .73682 L p .573 .367 .563 r
F P
0 g
s
.62276 .73682 m .6211 .65068 L .52817 .68071 L p .573 .367 .563 r
F P
0 g
s
.71329 .59259 m .6211 .65068 L p .69566 .26781 L .671 .73 .894 r
F P
0 g
s
.71329 .59259 m .6211 .65068 L .62276 .73682 L p .451 .272 .546 r
F P
0 g
s
.52795 .76633 m .44272 .98698 L .36487 1.13139 L p .951 .687 .501 r
F P
0 g
s
.52795 .76633 m .44272 .98698 L .6612 .92494 L p .454 .121 .31 r
F P
0 g
s
.6612 .92494 m .62276 .73682 L .52795 .76633 L p .454 .121 .31 r
F P
0 g
s
.62276 .73682 m .71691 .67969 L .71329 .59259 L p .451 .272 .546 r
F P
0 g
s
.6612 .92494 m .62276 .73682 L .71691 .67969 L p .302 .03 .323 r
F P
0 g
s
.73101 .52779 m .71329 .59259 L p .69566 .26781 L .671 .73 .894 r
F P
0 g
s
.71329 .59259 m .73101 .52779 L .74227 .77016 L p 0 0 .32 r
F P
0 g
s
.74227 .77016 m .71691 .67969 L .71329 .59259 L p 0 0 .32 r
F P
0 g
s
.71691 .67969 m .74227 .77016 L .6612 .92494 L p .302 .03 .323 r
F P
0 g
s
.69566 .26781 m .71855 .31644 L .73101 .52779 L p .671 .73 .894 r
F P
0 g
s
.73101 .52779 m .71855 .31644 L .71926 .33188 L p .723 .561 0 r
F P
0 g
s
.71926 .33188 m .74227 .77016 L .73101 .52779 L p .723 .561 0 r
F P
0 g
s
.74227 .77016 m .6612 .92494 L p .69566 .26781 L .932 .779 .669 r
F P
0 g
s
.69566 .26781 m .71926 .33188 L .74227 .77016 L p .932 .779 .669 r
F P
0 g
s
.44272 .98698 m .36487 1.13139 L .38037 1.12726 L p .399 .023 .204 r
F P
0 g
s
.38037 1.12726 m .6612 .92494 L .44272 .98698 L p .399 .023 .204 r
F P
0 g
s
.71926 .33188 m .7155 .26472 L .71855 .31644 L closepath p .723 .561 0 r
F P
0 g
s
.6612 .92494 m .39964 .80827 L p .69566 .26781 L .932 .779 .669 r
F P
0 g
s
.39964 .80827 m .6612 .92494 L .38037 1.12726 L p .873 .848 .816 r
F P
0 g
s
.10619 .21908 m .53473 .04282 L .69566 .26781 L p .671 .73 .894 r
F P
0 g
s
.39964 .80827 m .3864 .78125 L .69566 .26781 L p .932 .779 .669 r
F P
0 g
s
.53473 .04282 m .69566 .26781 L .3864 .78125 L p .928 .771 .667 r
F P
0 g
s
.10619 .21908 m .53473 .04282 L .26312 .66028 L p .5 .261 .485 r
F P
0 g
s
.02999 .89181 m .10619 .21908 L p .36487 1.13139 L .951 .687 .501 r
F P
0 g
s
.02999 .89181 m .10619 .21908 L p .26312 .66028 L .5 .261 .485 r
F P
0 g
s
.31358 1.12039 m .02999 .89181 L p .36487 1.13139 L .951 .687 .501 r
F P
0 g
s
.36487 1.13139 m .35202 1.13957 L .31358 1.12039 L p .951 .687 .501 r
F P
0 g
s
.38037 1.12726 m .35571 1.14838 L .36487 1.13139 L closepath p .399 .023 .204 \
r
F P
0 g
s
.31358 1.12039 m .39964 .80827 L p .38037 1.12726 L .873 .848 .816 r
F P
0 g
s
.38037 1.12726 m .35202 1.13957 L .31358 1.12039 L p .873 .848 .816 r
F P
0 g
s
.02999 .89181 m .31358 1.12039 L .39964 .80827 L p .83 .801 .824 r
F P
0 g
s
.3864 .78125 m .26312 .66028 L .53473 .04282 L p .928 .771 .667 r
F P
0 g
s
.3864 .78125 m .39964 .80827 L .2581 .67025 L p .917 .779 .692 r
F P
0 g
s
.39964 .80827 m .2581 .67025 L .02999 .89181 L p .83 .801 .824 r
F P
0 g
s
.2581 .67025 m .26312 .66028 L .3864 .78125 L p .917 .779 .692 r
F P
0 g
s
.26312 .66028 m .2581 .67025 L .02999 .89181 L p .5 .261 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 283.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.37862 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.184279 1.44747 0 1.44747 [
[ 0 0 0 0 ]
[ 1 1.37862 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.37862 L
0 1.37862 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52863 .67807 m .11377 .21873 L p .69334 .26715 L .672 .728 .891 r
F P
0 g
s
.62014 .64815 m .52863 .67807 L p .69334 .26715 L .672 .728 .891 r
F P
0 g
s
.52863 .67807 m .52842 .76182 L p .36813 1.11494 L .951 .687 .501 r
F P
0 g
s
.11377 .21873 m .52863 .67807 L p .36813 1.11494 L .951 .687 .501 r
F P
0 g
s
.52863 .67807 m .52842 .76182 L .62176 .73239 L p .573 .367 .563 r
F P
0 g
s
.62176 .73239 m .62014 .64815 L .52863 .67807 L p .573 .367 .563 r
F P
0 g
s
.71087 .59028 m .62014 .64815 L p .69334 .26715 L .672 .728 .891 r
F P
0 g
s
.71087 .59028 m .62014 .64815 L .62176 .73239 L p .451 .272 .546 r
F P
0 g
s
.52842 .76182 m .44459 .97568 L .36813 1.11494 L p .951 .687 .501 r
F P
0 g
s
.52842 .76182 m .44459 .97568 L .65947 .91362 L p .45 .116 .306 r
F P
0 g
s
.65947 .91362 m .62176 .73239 L .52842 .76182 L p .45 .116 .306 r
F P
0 g
s
.62176 .73239 m .7144 .67543 L .71087 .59028 L p .451 .272 .546 r
F P
0 g
s
.65947 .91362 m .62176 .73239 L .7144 .67543 L p .298 .025 .32 r
F P
0 g
s
.72827 .52576 m .71087 .59028 L p .69334 .26715 L .672 .728 .891 r
F P
0 g
s
.71087 .59028 m .72827 .52576 L .73925 .76252 L p 0 0 .319 r
F P
0 g
s
.73925 .76252 m .7144 .67543 L .71087 .59028 L p 0 0 .319 r
F P
0 g
s
.7144 .67543 m .73925 .76252 L .65947 .91362 L p .298 .025 .32 r
F P
0 g
s
.69334 .26715 m .71589 .3155 L .72827 .52576 L p .672 .728 .891 r
F P
0 g
s
.72827 .52576 m .71589 .3155 L .71657 .33056 L p .723 .561 0 r
F P
0 g
s
.71657 .33056 m .73925 .76252 L .72827 .52576 L p .723 .561 0 r
F P
0 g
s
.73925 .76252 m .65947 .91362 L p .69334 .26715 L .93 .778 .67 r
F P
0 g
s
.69334 .26715 m .71657 .33056 L .73925 .76252 L p .93 .778 .67 r
F P
0 g
s
.44459 .97568 m .36813 1.11494 L .38337 1.1108 L p .394 .015 .196 r
F P
0 g
s
.38337 1.1108 m .65947 .91362 L .44459 .97568 L p .394 .015 .196 r
F P
0 g
s
.71657 .33056 m .71286 .26408 L .71589 .3155 L closepath p .723 .561 0 r
F P
0 g
s
.65947 .91362 m .40241 .79448 L p .69334 .26715 L .93 .778 .67 r
F P
0 g
s
.40241 .79448 m .65947 .91362 L .38337 1.1108 L p .871 .845 .815 r
F P
0 g
s
.11377 .21873 m .5351 .04372 L .69334 .26715 L p .672 .728 .891 r
F P
0 g
s
.40241 .79448 m .38942 .7677 L .69334 .26715 L p .93 .778 .67 r
F P
0 g
s
.5351 .04372 m .69334 .26715 L .38942 .7677 L p .926 .77 .668 r
F P
0 g
s
.11377 .21873 m .5351 .04372 L .26849 .6469 L p .5 .262 .485 r
F P
0 g
s
.03968 .87399 m .11377 .21873 L p .36813 1.11494 L .951 .687 .501 r
F P
0 g
s
.03968 .87399 m .11377 .21873 L p .26849 .6469 L .5 .262 .485 r
F P
0 g
s
.31778 1.10307 m .03968 .87399 L p .36813 1.11494 L .951 .687 .501 r
F P
0 g
s
.36813 1.11494 m .35551 1.12263 L .31778 1.10307 L p .951 .687 .501 r
F P
0 g
s
.38337 1.1108 m .35914 1.13132 L .36813 1.11494 L closepath p .394 .015 .196 \
r
F P
0 g
s
.31778 1.10307 m .40241 .79448 L p .38337 1.1108 L .871 .845 .815 r
F P
0 g
s
.38337 1.1108 m .35551 1.12263 L .31778 1.10307 L p .871 .845 .815 r
F P
0 g
s
.38942 .7677 m .26849 .6469 L .5351 .04372 L p .926 .77 .668 r
F P
0 g
s
.12673 .92719 m .40355 1.15724 L .40241 .79448 L p .916 .777 .693 r
F P
0 g
s
.38942 .7677 m .40241 .79448 L .26357 .65664 L p .916 .777 .693 r
F P
0 g
s
.40241 .79448 m .26357 .65664 L .12673 .92719 L p .916 .777 .693 r
F P
0 g
s
.26357 .65664 m .26849 .6469 L .38942 .7677 L p .916 .777 .693 r
F P
0 g
s
.26849 .6469 m .26357 .65664 L .03968 .87399 L p .5 .262 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 296.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.41015 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.198509 1.47273 0 1.47273 [
[ 0 0 0 0 ]
[ 1 1.41015 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.41015 L
0 1.41015 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52698 .67807 m .11312 .21774 L p .69151 .26596 L .672 .728 .891 r
F P
0 g
s
.61889 .64788 m .52698 .67807 L p .69151 .26596 L .672 .728 .891 r
F P
0 g
s
.52698 .67807 m .52677 .76196 L p .36706 1.11134 L .951 .687 .499 r
F P
0 g
s
.11312 .21774 m .52698 .67807 L p .36706 1.11134 L .951 .687 .499 r
F P
0 g
s
.52698 .67807 m .52677 .76196 L .62046 .73224 L p .572 .365 .562 r
F P
0 g
s
.62046 .73224 m .61889 .64788 L .52698 .67807 L p .572 .365 .562 r
F P
0 g
s
.70988 .58958 m .61889 .64788 L p .69151 .26596 L .672 .728 .891 r
F P
0 g
s
.70988 .58958 m .61889 .64788 L .62046 .73224 L p .449 .269 .544 r
F P
0 g
s
.52677 .76196 m .44298 .97436 L .36706 1.11134 L p .951 .687 .499 r
F P
0 g
s
.52677 .76196 m .44298 .97436 L .65773 .91165 L p .447 .11 .301 r
F P
0 g
s
.65773 .91165 m .62046 .73224 L .52677 .76196 L p .447 .11 .301 r
F P
0 g
s
.62046 .73224 m .71328 .67481 L .70988 .58958 L p .449 .269 .544 r
F P
0 g
s
.65773 .91165 m .62046 .73224 L .71328 .67481 L p .294 .019 .315 r
F P
0 g
s
.72715 .5247 m .70988 .58958 L p .69151 .26596 L .672 .728 .891 r
F P
0 g
s
.70988 .58958 m .72715 .5247 L .73771 .76124 L p 0 0 .315 r
F P
0 g
s
.73771 .76124 m .71328 .67481 L .70988 .58958 L p 0 0 .315 r
F P
0 g
s
.71328 .67481 m .73771 .76124 L .65773 .91165 L p .294 .019 .315 r
F P
0 g
s
.69151 .26596 m .71416 .31417 L .72715 .5247 L p .672 .728 .891 r
F P
0 g
s
.72715 .5247 m .71416 .31417 L .71481 .32924 L p .729 .566 0 r
F P
0 g
s
.71481 .32924 m .73771 .76124 L .72715 .5247 L p .729 .566 0 r
F P
0 g
s
.73771 .76124 m .65773 .91165 L p .69151 .26596 L .93 .777 .67 r
F P
0 g
s
.69151 .26596 m .71481 .32924 L .73771 .76124 L p .93 .777 .67 r
F P
0 g
s
.44298 .97436 m .36706 1.11134 L .38226 1.10714 L p .389 .007 .189 r
F P
0 g
s
.38226 1.10714 m .65773 .91165 L .44298 .97436 L p .389 .007 .189 r
F P
0 g
s
.71481 .32924 m .71099 .2629 L .71416 .31417 L closepath p .729 .566 0 r
F P
0 g
s
.65773 .91165 m .40172 .79046 L p .69151 .26596 L .93 .777 .67 r
F P
0 g
s
.656 1.11938 m .65773 .91165 L .38226 1.10714 L p .389 .007 .189 r
F P
0 g
s
.11312 .21774 m .53352 .04407 L .69151 .26596 L p .672 .728 .891 r
F P
0 g
s
.40172 .79046 m .38886 .76374 L .69151 .26596 L p .93 .777 .67 r
F P
0 g
s
.53352 .04407 m .69151 .26596 L .38886 .76374 L p .926 .77 .669 r
F P
0 g
s
.11312 .21774 m .53352 .04407 L .26946 .64314 L p .502 .265 .487 r
F P
0 g
s
.04291 .86799 m .11312 .21774 L p .36706 1.11134 L .951 .687 .499 r
F P
0 g
s
.04291 .86799 m .11312 .21774 L p .26946 .64314 L .502 .265 .487 r
F P
0 g
s
.31714 1.09863 m .04291 .86799 L p .36706 1.11134 L .951 .687 .499 r
F P
0 g
s
.36706 1.11134 m .35456 1.11871 L .31714 1.09863 L p .951 .687 .499 r
F P
0 g
s
.38226 1.10714 m .35817 1.12739 L .36706 1.11134 L closepath p .389 .007 .189 \
r
F P
0 g
s
.36194 1.15821 m .656 1.11938 L p .38226 1.10714 L .389 .007 .189 r
F P
0 g
s
.38226 1.10714 m .36118 1.1275 L .36194 1.15821 L p .389 .007 .189 r
F P
0 g
s
.38886 .76374 m .26946 .64314 L .53352 .04407 L p .926 .77 .669 r
F P
0 g
s
.12982 .91978 m .40272 1.15155 L .40172 .79046 L p .915 .777 .693 r
F P
0 g
s
.38886 .76374 m .40172 .79046 L .26459 .65278 L p .915 .777 .693 r
F P
0 g
s
.40172 .79046 m .26459 .65278 L .12982 .91978 L p .915 .777 .693 r
F P
0 g
s
.26459 .65278 m .26946 .64314 L .38886 .76374 L p .915 .777 .693 r
F P
0 g
s
.26946 .64314 m .26459 .65278 L .04291 .86799 L p .502 .265 .487 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 302.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4009 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.194378 1.46931 2.22045e-16 1.46931 [
[ 0 0 0 0 ]
[ 1 1.4009 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.4009 L
0 1.4009 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.54182 .68463 m .54185 .76658 L .61349 .722 L p .446 .267 .543 r
F P
0 g
s
.61349 .722 m .6121 .63934 L .54182 .68463 L p .446 .267 .543 r
F P
0 g
s
.52196 .66908 m .11402 .21535 L p .68226 .2629 L .672 .728 .891 r
F P
0 g
s
.6121 .63934 m .52196 .66908 L p .68226 .2629 L .672 .728 .891 r
F P
0 g
s
.52196 .66908 m .52161 .75128 L p .36326 1.09287 L .951 .687 .499 r
F P
0 g
s
.11402 .21535 m .52196 .66908 L p .36326 1.09287 L .951 .687 .499 r
F P
0 g
s
.70125 .5819 m .6121 .63934 L p .68226 .2629 L .672 .728 .891 r
F P
0 g
s
.70125 .5819 m .6121 .63934 L .61349 .722 L p .446 .267 .543 r
F P
0 g
s
.52161 .75128 m .4385 .95898 L .36326 1.09287 L p .951 .687 .499 r
F P
0 g
s
.52161 .75128 m .4385 .95898 L .64915 .89714 L p .444 .105 .296 r
F P
0 g
s
.64915 .89714 m .61349 .722 L .52161 .75128 L p .444 .105 .296 r
F P
0 g
s
.61349 .722 m .70444 .6654 L .70125 .5819 L p .446 .267 .543 r
F P
0 g
s
.64915 .89714 m .61349 .722 L .70444 .6654 L p .288 .013 .31 r
F P
0 g
s
.71801 .51796 m .70125 .5819 L p .68226 .2629 L .672 .728 .891 r
F P
0 g
s
.70125 .5819 m .71801 .51796 L .72796 .74972 L p 0 0 .309 r
F P
0 g
s
.72796 .74972 m .70444 .6654 L .70125 .5819 L p 0 0 .309 r
F P
0 g
s
.70444 .6654 m .72796 .74972 L .64915 .89714 L p .288 .013 .31 r
F P
0 g
s
.68226 .2629 m .70464 .31044 L .71801 .51796 L p .672 .728 .891 r
F P
0 g
s
.71801 .51796 m .70464 .31044 L .70525 .32519 L p .734 .57 0 r
F P
0 g
s
.70525 .32519 m .72796 .74972 L .71801 .51796 L p .734 .57 0 r
F P
0 g
s
.72796 .74972 m .64915 .89714 L p .68226 .2629 L .93 .777 .671 r
F P
0 g
s
.68226 .2629 m .70525 .32519 L .72796 .74972 L p .93 .777 .671 r
F P
0 g
s
.4385 .95898 m .36326 1.09287 L .37817 1.08873 L p .384 .001 .183 r
F P
0 g
s
.37817 1.08873 m .64915 .89714 L .4385 .95898 L p .384 .001 .183 r
F P
0 g
s
.70525 .32519 m .70138 .25988 L .70464 .31044 L closepath p .734 .57 0 r
F P
0 g
s
.64915 .89714 m .39655 .77693 L p .68226 .2629 L .93 .777 .671 r
F P
0 g
s
.64617 1.09988 m .64915 .89714 L .37817 1.08873 L p .384 .001 .183 r
F P
0 g
s
.11402 .21535 m .52639 .04405 L .68226 .2629 L p .672 .728 .891 r
F P
0 g
s
.39655 .77693 m .38385 .75061 L .68226 .2629 L p .93 .777 .671 r
F P
0 g
s
.52639 .04405 m .68226 .2629 L .38385 .75061 L p .926 .77 .669 r
F P
0 g
s
.11402 .21535 m .52639 .04405 L .26597 .63154 L p .5 .261 .485 r
F P
0 g
s
.0433 .85244 m .11402 .21535 L p .36326 1.09287 L .951 .687 .499 r
F P
0 g
s
.0433 .85244 m .11402 .21535 L p .26597 .63154 L .5 .261 .485 r
F P
0 g
s
.31395 1.08015 m .0433 .85244 L p .36326 1.09287 L .951 .687 .499 r
F P
0 g
s
.36326 1.09287 m .35089 1.10004 L .31395 1.08015 L p .951 .687 .499 r
F P
0 g
s
.37817 1.08873 m .35444 1.10856 L .36326 1.09287 L closepath p .384 .001 .183 \
r
F P
0 g
s
.35792 1.13865 m .64617 1.09988 L p .37817 1.08873 L .384 .001 .183 r
F P
0 g
s
.37817 1.08873 m .35738 1.10867 L .35792 1.13865 L p .384 .001 .183 r
F P
0 g
s
.38385 .75061 m .26597 .63154 L .52639 .04405 L p .926 .77 .669 r
F P
0 g
s
.12831 .90299 m .39774 1.13188 L .39655 .77693 L p .915 .777 .693 r
F P
0 g
s
.38385 .75061 m .39655 .77693 L .26118 .64099 L p .915 .777 .693 r
F P
0 g
s
.39655 .77693 m .26118 .64099 L .12831 .90299 L p .915 .777 .693 r
F P
0 g
s
.26118 .64099 m .26597 .63154 L .38385 .75061 L p .915 .777 .693 r
F P
0 g
s
.26597 .63154 m .26118 .64099 L .0433 .85244 L p .5 .261 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 300.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.38999 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.192016 1.46801 1.11022e-16 1.46801 [
[ 0 0 0 0 ]
[ 1 1.38999 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.38999 L
0 1.38999 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.6384 .69144 m .64002 .77029 L .65478 .71193 L p 0 0 .275 r
F P
0 g
s
.65478 .71193 m .65287 .63227 L .6384 .69144 L p 0 0 .275 r
F P
0 g
s
.49819 .64181 m .1043 .20463 L p .64812 .24968 L .671 .731 .895 r
F P
0 g
s
.5856 .61265 m .49819 .64181 L p .64812 .24968 L .671 .731 .895 r
F P
0 g
s
.49819 .64181 m .49743 .72135 L p .34239 1.04201 L .953 .687 .494 r
F P
0 g
s
.1043 .20463 m .49819 .64181 L p .34239 1.04201 L .953 .687 .494 r
F P
0 g
s
.67139 .55652 m .65287 .63227 L .65478 .71193 L p 0 0 .275 r
F P
0 g
s
.67139 .55652 m .5856 .61265 L p .64812 .24968 L .671 .731 .895 r
F P
0 g
s
.49743 .72135 m .41523 .91821 L .34239 1.04201 L p .953 .687 .494 r
F P
0 g
s
.49743 .72135 m .41523 .91821 L .61672 .85742 L p .427 .081 .273 r
F P
0 g
s
.61672 .85742 m .58636 .69258 L .49743 .72135 L p .427 .081 .273 r
F P
0 g
s
.65478 .71193 m .67368 .63718 L .67139 .55652 L p 0 0 .275 r
F P
0 g
s
.61672 .85742 m .58636 .69258 L .67368 .63718 L p .262 0 .285 r
F P
0 g
s
.68658 .49437 m .67139 .55652 L p .64812 .24968 L .671 .731 .895 r
F P
0 g
s
.67139 .55652 m .68658 .49437 L .69377 .71709 L p 0 0 .275 r
F P
0 g
s
.69377 .71709 m .67368 .63718 L .67139 .55652 L p 0 0 .275 r
F P
0 g
s
.67368 .63718 m .69377 .71709 L .61672 .85742 L p .262 0 .285 r
F P
0 g
s
.64812 .24968 m .67031 .29489 L .68658 .49437 L p .671 .731 .895 r
F P
0 g
s
.68658 .49437 m .67031 .29489 L .67073 .30911 L p .767 .597 .028 r
F P
0 g
s
.67073 .30911 m .69377 .71709 L .68658 .49437 L p .767 .597 .028 r
F P
0 g
s
.69377 .71709 m .61672 .85742 L p .64812 .24968 L .929 .777 .671 r
F P
0 g
s
.64812 .24968 m .67073 .30911 L .69377 .71709 L p .929 .777 .671 r
F P
0 g
s
.41523 .91821 m .34239 1.04201 L .35659 1.03791 L p .362 0 .151 r
F P
0 g
s
.35659 1.03791 m .61672 .85742 L .41523 .91821 L p .362 0 .151 r
F P
0 g
s
.67073 .30911 m .66638 .24681 L .67031 .29489 L closepath p .767 .597 .028 r
F P
0 g
s
.61672 .85742 m .37332 .73809 L p .64812 .24968 L .929 .777 .671 r
F P
0 g
s
.60828 1.0416 m .61672 .85742 L .35659 1.03791 L p .362 0 .151 r
F P
0 g
s
.1043 .20463 m .49694 .04379 L .64812 .24968 L p .671 .731 .895 r
F P
0 g
s
.37332 .73809 m .36126 .71301 L .64812 .24968 L p .929 .777 .671 r
F P
0 g
s
.49694 .04379 m .64812 .24968 L .36126 .71301 L p .925 .769 .669 r
F P
0 g
s
.1043 .20463 m .49694 .04379 L .25019 .59963 L p .5 .261 .485 r
F P
0 g
s
.04145 .80664 m .1043 .20463 L p .34239 1.04201 L .953 .687 .494 r
F P
0 g
s
.04145 .80664 m .1043 .20463 L p .25019 .59963 L .5 .261 .485 r
F P
0 g
s
.29533 1.02803 m .04145 .80664 L p .34239 1.04201 L .953 .687 .494 r
F P
0 g
s
.34239 1.04201 m .33054 1.04822 L .29533 1.02803 L p .953 .687 .494 r
F P
0 g
s
.35659 1.03791 m .33393 1.05638 L .34239 1.04201 L closepath p .362 0 .151 r
F P
0 g
s
.3371 1.08334 m .60828 1.0416 L p .35659 1.03791 L .362 0 .151 r
F P
0 g
s
.35659 1.03791 m .33673 1.0564 L .3371 1.08334 L p .362 0 .151 r
F P
0 g
s
.36126 .71301 m .25019 .59963 L .49694 .04379 L p .925 .769 .669 r
F P
0 g
s
.12185 .85232 m .37466 1.07503 L .37332 .73809 L p .915 .776 .693 r
F P
0 g
s
.36126 .71301 m .37332 .73809 L .2457 .60847 L p .915 .776 .693 r
F P
0 g
s
.37332 .73809 m .2457 .60847 L .12185 .85232 L p .915 .776 .693 r
F P
0 g
s
.2457 .60847 m .25019 .59963 L .36126 .71301 L p .915 .776 .693 r
F P
0 g
s
.25019 .59963 m .2457 .60847 L .04145 .80664 L p .5 .261 .485 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 298.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0001:R000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00J@3o
ool2o`0006/0oooo001V0?ooo`?o000000<0Od9lo`00003oool0JP3oool006@0oooo0_l0000307m2
O003o`00003/a:_o000006X0oooo001R0?ooo`;o00001@1o@W`01?l00000k<B[0>c4Zol0001Y0?oo
o`00G`3oool3o`0000H0Od9l00Go00000>c4Z`3/a:/0k<B[o`00001Y0?ooo`00G@3oool2o`0000T0
Od9l00?o00000>c4Z`3/a:/00P3/a:/00ol00000oooo0?ooo`1V0?ooo`00FP3oool3o`0000/0Od9l
00?o00000>c4Z`3/a:/00`3/a:/00ol00000oooo0?ooo`1U0?ooo`00F03oool2o`0000d0Od9l00?o
00000>c4Z`3/a:/01@3/a:/00ol00000oooo0?ooo`1T0?ooo`00EP3oool2o`0000l0Od9l00?o0000
0>c4Z`3/a:/01@3/a:/00ol00000oooo0?ooo`1T0?ooo`00D`3oool3o`000100Od9l00?o00000>c4
Z`3/a:/01`3/a:/00ol00000oooo0?ooo`1S0?ooo`00D@3oool2o`0001<0Od9l00?o00000>c4Z`3/
a:/0203/a:/00ol00000oooo0?ooo`1R0?ooo`00CP3oool3o`0001@0Od9l00?o00000>c4Z`3/a:/0
2@3/a:/00ol00000oooo0?ooo`1R0?ooo`00C03oool2o`0001L0Od9l00?o00000>c4Z`3/a:/02P3/
a:/00ol00000oooo0?ooo`1Q0?ooo`00BP3oool2o`0001P0Od9l00?o00000>c4Z`3/a:/0303/a:/0
0ol00000oooo0?ooo`1P0?ooo`00A`3oool3o`0001X0Od9l00?o00000>c4Z`3/a:/03@3/a:/00ol0
0000oooo0?ooo`1O0?ooo`00A@3oool2o`0001d0Od9l00?o00000>c4Z`3/a:/03@3/a:/00ol00000
oooo0?ooo`1O0?ooo`00@P3oool3o`0001h0Od9l00?o00000>c4Z`3/a:/03`3/a:/00ol00000oooo
0?ooo`1N0?ooo`00@03oool2o`000240Od9l00?o00000>c4Z`3/a:/0403/a:/00ol00000oooo0?oo
o`1M0?ooo`00?P3oool2o`000280Od9l00?o00000>c4Z`3/a:/04@3/a:/00ol00000oooo0?ooo`1M
0?ooo`00>`3oool3o`0002@0Od9l00?o00000>c4Z`3/a:/04P3/a:/00ol00000oooo0?ooo`1L0?oo
o`00>@3oool2o`0002H0Od9l00?o00000>c4Z`3/a:/0503/a:/00ol00000oooo0?ooo`1K0?ooo`00
=P3oool3o`0002P0Od9l00?o00000>c4Z`3/a:/05@3/a:/00ol00000oooo0?ooo`1J0?ooo`00=03o
ool2o`0002X0Od9l00?o00000>c4Z`3/a:/05P3/a:/00ol00000oooo0?ooo`1J0?ooo`00<P3oool2
o`0002`0Od9l00?o00000>c4Z`3/a:/05`3/a:/00ol00000oooo0?ooo`1I0?ooo`00;`3oool3o`00
02h0Od9l00?o00000>c4Z`3/a:/0603/a:/00ol00000oooo0?ooo`1H0?ooo`00;@3oool2o`000300
Od9l00?o00000>c4Z`3/a:/06@3/a:/00ol00000oooo0?ooo`1H0?ooo`00:P3oool3o`000380Od9l
00?o00000>c4Z`3/a:/06P3/a:/00ol00000oooo0?ooo`1G0?ooo`00:03oool2o`0003@0Od9l00?o
00000>c4Z`3/a:/0703/a:/00ol00000oooo0?ooo`1F0?ooo`009P3oool2o`0003H0Od9l00?o0000
0>c4Z`3/a:/07@3/a:/00ol00000oooo0?ooo`1E0?ooo`008`3oool3o`0003L0Od9l00?o00000>c4
Z`3/a:/07P3/a:/00ol00000oooo0?ooo`1E0?ooo`008@3oool2o`0003X0Od9l00?o00000>c4Z`3/
a:/07`3/a:/00ol00000oooo0?ooo`1D0?ooo`007P3oool3o`0003/0Od9l00?o00000>c4Z`3/a:/0
8@3/a:/00ol00000oooo0?ooo`1C0?ooo`00703oool2o`0003h0Od9l00?o00000>c4Z`3/a:/08@3/
a:/00ol00000oooo0?ooo`1C0?ooo`006P3oool2o`000400Od9l00?o00000>c4Z`3/a:/08P3/a:/0
0ol00000oooo0?ooo`1B0?ooo`005`3oool3o`000440Od9l00?o00000>c4Z`3/a:/0903/a:/00ol0
0000oooo0?ooo`1A0?ooo`005P3oool00ol00000Od9l07m2O01207m2O003o`00003/a:/0k<B[02D0
k<B[00?o00000?ooo`3oool0D03oool001H0oooo00?o000007m2O01o@W`0@@1o@W`00ol00000k<B[
0>c4Z`0V0>c4Z`03o`00003oool0oooo0500oooo000F0?ooo`03o`00001o@W`0Od9l0440Od9l00?o
00000>c4Z`3/a:/09`3/a:/00ol00000oooo0?ooo`1?0?ooo`005P3oool00ol00000Od9l07m2O010
07m2O003o`00003/a:/0k<B[02T0k<B[00?o00000?ooo`3oool0CP3oool001H0oooo00?o000007m2
O01o@W`0@01o@W`00ol00000k<B[0>c4Z`0Y0>c4Z`03o`00003oool0oooo04h0oooo000F0?ooo`03
o`00001o@W`0Od9l03l0Od9l00?o00000>c4Z`3/a:/0:`3/a:/00ol00000oooo0?ooo`1=0?ooo`00
5@3oool00ol00000Od9l07m2O01007m2O003o`00003/a:/0k<B[02`0k<B[00?o00000?ooo`3oool0
C03oool001D0oooo00?o000007m2O01o@W`0@01o@W`00ol00000k<B[0>c4Z`0]0>c4Z`03o`00003o
ool0oooo04/0oooo000E0?ooo`03o`00001o@W`0Od9l03l0Od9l00?o00000>c4Z`3/a:/0;P3/a:/0
0ol00000oooo0?ooo`1;0?ooo`005@3oool00ol00000Od9l07m2O00o07m2O003o`00003/a:/0k<B[
02l0k<B[00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`150?ooo`005@3oool00ol00000
Od9l07m2O00n07m2O003o`00003/a:/0k<B[0340k<B[00Go00000?ooo`3oool0ooooo`0000170?oo
o`005@3oool00ol00000Od9l07m2O00n07m2O003o`00003/a:/0k<B[0340k<B[00Go00000?ooo`3o
ool0ooooo`0000170?ooo`005@3oool00ol00000Od9l07m2O00m07m2O003o`00003/a:/0k<B[0340
k<B[00?o00000>g6Zol000000P3oool00ol00000oooo0?ooo`150?ooo`005@3oool00ol00000Od9l
07m2O00m07m2O003o`00003/a:/0k<B[0300k<B[00Co00000>g6Z`3]aZ_o00000P3oool00ol00000
oooo0?ooo`150?ooo`005@3oool00ol00000Od9l07m2O00l07m2O003o`00003/a:/0k<B[0340k<B[
00?o00000>g6Z`3]aZ/00_l000000`3ooooo00000?ooo`160?ooo`00503oool00ol00000Od9l07m2
O00m07m2O003o`00003/a:/0k<B[0300k<B[00?o00000>g6Z`3]aZ/00P3]aZ/4o`0004H0oooo000D
0?ooo`03o`00001o@W`0Od9l03d0Od9l00?o00000>c4Z`3/a:/0<03/a:/00ol00000kLJ[0>g6Z`02
0>g6Z`;o000000<0ooooo`00003oool0A@3oool001@0oooo00?o000007m2O01o@W`0?01o@W`00ol0
0000k<B[0>c4Z`0`0>c4Z`03o`00003]aZ/0kLJ[00@0kLJ[0ol000160?ooo`00503oool00ol00000
Od9l07m2O00l07m2O003o`00003/a:/0k<B[02l0k<B[00?o00000>g6Z`3]aZ/01@3]aZ/3o`0004H0
oooo000D0?ooo`03o`00001o@W`0Od9l03/0Od9l00?o00000>c4Z`3/a:/0<03/a:/00ol00000kLJ[
0>g6Z`060>g6Z`;o0000AP3oool001@0oooo00?o000007m2O01o@W`0>`1o@W`00ol00000k<B[0>c4
Z`0_0>c4Z`03o`00003]aZ/0kLJ[00L0kLJ[0_l000160?ooo`00503oool00ol00000Od9l07m2O00j
07m2O003o`00003/a:/0k<B[0300k<B[00?o00000>g6Z`3]aZ/01`3]aZ/2o`0004H0oooo000D0?oo
o`03o`00001o@W`0Od9l03X0Od9l00?o00000>c4Z`3/a:/0;`3/a:/00ol00000kLJ[0>g6Z`090>g6
Z`03o`00003oool0oooo04@0oooo000D0?ooo`03o`00001o@W`0Od9l03T0Od9l00?o00000>c4Z`3/
a:/0;`3/a:/00ol00000kLJ[0>g6Z`0:0>g6Z`03o`00003oool0oooo04@0oooo000C0?ooo`03o`00
001o@W`0Od9l03X0Od9l00?o00000>c4Z`3/a:/0;`3/a:/00ol00000kLJ[0>g6Z`0:0>g6Z`03o`00
003oool0oooo04@0oooo000C0?ooo`03o`00001o@W`0Od9l03T0Od9l00?o00000>c4Z`3/a:/0;`3/
a:/00ol00000kLJ[0>g6Z`0;0>g6Z`03o`00003oool0oooo04@0oooo000C0?ooo`03o`00001o@W`0
Od9l03T0Od9l00?o00000>c4Z`3/a:/0;P3/a:/00ol00000kLJ[0>g6Z`0<0>g6Z`03o`00003oool0
oooo04@0oooo000C0?ooo`03o`00001o@W`0Od9l03T0Od9l00?o00000>c4Z`3/a:/0;P3/a:/00ol0
0000kLJ[0>g6Z`0<0>g6Z`;o0000A@3oool001<0oooo00?o000007m2O01o@W`0>01o@W`00ol00000
k<B[0>c4Z`0^0>c4Z`03o`00003]aZ/0kLJ[00d0kLJ[0_l000150?ooo`004`3oool00ol00000Od9l
07m2O00h07m2O003o`00003/a:/0k<B[02h0k<B[00?o00000>g6Z`3]aZ/03@3]aZ/2o`0004D0oooo
000C0?ooo`03o`00001o@W`0Od9l03L0Od9l00?o00000>c4Z`3/a:/0;P3/a:/00ol00000kLJ[0>g6
Z`0>0>g6Z`;o0000A@3oool001<0oooo00?o000007m2O01o@W`0=`1o@W`00ol00000k<B[0>c4Z`0]
0>c4Z`03o`00003]aZ/0kLJ[00l0kLJ[0_l000150?ooo`004`3oool00ol00000Od9l07m2O00f07m2
O003o`00003/a:/0k<B[02h0k<B[00?o00000>g6Z`3]aZ/0403]aZ/00ol00000oooo0?ooo`130?oo
o`004P3oool00ol00000Od9l07m2O00g07m2O003o`00003/a:/0k<B[02d0k<B[00?o00000>g6Z`3]
aZ/04@3]aZ/00ol00000oooo0?ooo`130?ooo`004P3oool00ol00000Od9l07m2O00f07m2O003o`00
003/a:/0k<B[02h0k<B[00?o00000>g6Z`3]aZ/04@3]aZ/00ol00000oooo0?ooo`130?ooo`004P3o
ool00ol00000Od9l07m2O00f07m2O003o`00003/a:/0k<B[02d0k<B[00?o00000>g6Z`3]aZ/04P3]
aZ/00ol00000oooo0?ooo`130?ooo`004P3oool00ol00000Od9l07m2O00f07m2O003o`00003/a:/0
k<B[02`0k<B[00?o00000>g6Z`3]aZ/04`3]aZ/00ol00000oooo0?ooo`130?ooo`004P3oool00ol0
0000Od9l07m2O00e07m2O003o`00003/a:/0k<B[02d0k<B[00?o00000>g6Z`3]aZ/04`3]aZ/00ol0
0000oooo0?ooo`130?ooo`004P3oool00ol00000Od9l07m2O00e07m2O003o`00003/a:/0k<B[02`0
k<B[00?o00000>g6Z`3]aZ/0503]aZ/00ol00000oooo0?ooo`130?ooo`004P3oool00ol00000Od9l
07m2O00d07m2O003o`00003/a:/0k<B[02`0k<B[00?o00000>g6Z`3]aZ/05@3]aZ/00ol00000oooo
0?ooo`130?ooo`004P3oool00ol00000Od9l07m2O00d07m2O003o`00003/a:/0k<B[02`0k<B[00?o
00000>g6Z`3]aZ/05@3]aZ/00ol00000oooo0?ooo`130?ooo`004P3oool00ol00000Od9l07m2O00c
07m2O003o`00003/a:/0k<B[02`0k<B[00?o00000>g6Z`3]aZ/05P3]aZ/2o`0004@0oooo000A0?oo
o`03o`00001o@W`0Od9l03@0Od9l00?o00000>c4Z`3/a:/0;03/a:/00ol00000kLJ[0>g6Z`0F0>g6
Z`;o0000A03oool00140oooo00?o000007m2O01o@W`0<`1o@W`00ol00000k<B[0>c4Z`0/0>c4Z`03
o`00003]aZ/0kLJ[01L0kLJ[0_l000140?ooo`004@3oool00ol00000Od9l07m2O00c07m2O003o`00
003/a:/0k<B[02/0k<B[00?o00000>g6Z`3]aZ/0603]aZ/2o`0004@0oooo000A0?ooo`03o`00001o
@W`0Od9l03<0Od9l00?o00000>c4Z`3/a:/0:`3/a:/00ol00000kLJ[0>g6Z`0H0>g6Z`;o0000A03o
ool00140oooo00?o000007m2O01o@W`0<P1o@W`00ol00000k<B[0>c4Z`0[0>c4Z`03o`00003]aZ/0
kLJ[01T0kLJ[0_l000140?ooo`004@3oool00ol00000Od9l07m2O00b07m2O003o`00003/a:/0k<B[
02/0k<B[00?o00000>g6Z`3]aZ/06@3]aZ/2o`0004@0oooo000A0?ooo`03o`00001o@W`0Od9l0340
Od9l00?o00000>c4Z`3/a:/0:`3/a:/00ol00000kLJ[0>g6Z`0J0>g6Z`;o0000A03oool00140oooo
00?o000007m2O01o@W`0<@1o@W`00ol00000k<B[0>c4Z`0Z0>c4Z`03o`00003]aZ/0kLJ[01`0kLJ[
00?o00000?ooo`3oool0@P3oool00140oooo00?o000007m2O01o@W`0<01o@W`00ol00000k<B[0>c4
Z`0[0>c4Z`03o`00003]aZ/0kLJ[01`0kLJ[00?o00000?ooo`3oool0@P3oool00140oooo00?o0000
07m2O01o@W`0<01o@W`00ol00000k<B[0>c4Z`0Z0>c4Z`03o`00003]aZ/0kLJ[01d0kLJ[00?o0000
0?ooo`3oool0@P3oool00100oooo00?o000007m2O01o@W`0<01o@W`00ol00000k<B[0>c4Z`0Z0>c4
Z`03o`00003]aZ/0kLJ[01h0kLJ[00?o00000?ooo`3oool0@P3oool00100oooo00?o000007m2O01o
@W`0<01o@W`00ol00000k<B[0>c4Z`0Z0>c4Z`03o`00003]aZ/0kLJ[01h0kLJ[00?o00000?ooo`3o
ool0@P3oool00100oooo00?o000007m2O01o@W`0<01o@W`00ol00000k<B[0>c4Z`0Y0>c4Z`03o`00
003]aZ/0kLJ[01l0kLJ[00?o00000?ooo`3oool0@P3oool00100oooo00?o000007m2O01o@W`0;`1o
@W`00ol00000k<B[0>c4Z`0Z0>c4Z`03o`00003]aZ/0kLJ[01l0kLJ[00?o00000?ooo`3oool0@P3o
ool00100oooo00?o000007m2O01o@W`0;`1o@W`00ol00000k<B[0>c4Z`0Y0>c4Z`03o`00003]aZ/0
kLJ[0200kLJ[0_l000130?ooo`00403oool00ol00000Od9l07m2O00^07m2O003o`00003/a:/0k<B[
02T0k<B[00?o00000>g6Z`3]aZ/08@3]aZ/2o`0004<0oooo000@0?ooo`03o`00001o@W`0Od9l02h0
Od9l00?o00000>c4Z`3/a:/0:@3/a:/00ol00000kLJ[0>g6Z`0Q0>g6Z`;o0000@`3oool00100oooo
00?o000007m2O01o@W`0;@1o@W`00ol00000k<B[0>c4Z`0Y0>c4Z`03o`00003]aZ/0kLJ[0280kLJ[
0_l000130?ooo`00403oool00ol00000Od9l07m2O00]07m2O003o`00003/a:/0k<B[02P0k<B[00?o
00000>g6Z`3]aZ/08`3]aZ/2o`0004<0oooo000?0?ooo`03o`00001o@W`0Od9l02d0Od9l00?o0000
0>c4Z`3/a:/0:@3/a:/00ol00000kLJ[0>g6Z`0S0>g6Z`;o0000@`3oool000l0oooo00?o000007m2
O01o@W`0;@1o@W`00ol00000k<B[0>c4Z`0X0>c4Z`03o`00003]aZ/0kLJ[02@0kLJ[0_l000130?oo
o`003`3oool00ol00000Od9l07m2O00]07m2O003o`00003/a:/0k<B[02P0k<B[00?o00000>g6Z`3]
aZ/0903]aZ/2o`0004<0oooo000?0?ooo`03o`00001o@W`0Od9l02`0Od9l00?o00000>c4Z`3/a:/0
:03/a:/00ol00000kLJ[0>g6Z`0U0>g6Z`;o0000@`3oool000l0oooo00?o000007m2O01o@W`0;01o
@W`00ol00000k<B[0>c4Z`0W0>c4Z`03o`00003]aZ/0kLJ[02H0kLJ[0_l000130?ooo`003`3oool0
0ol00000Od9l07m2O00[07m2O003o`00003/a:/0k<B[02P0k<B[00?o00000>g6Z`3]aZ/09`3]aZ/0
0ol00000oooo0?ooo`110?ooo`003`3oool00ol00000Od9l07m2O00[07m2O003o`00003/a:/0k<B[
02L0k<B[00?o00000>g6Z`3]aZ/0:03]aZ/00ol00000oooo0?ooo`110?ooo`003`3oool00ol00000
Od9l07m2O00Z07m2O003o`00003/a:/0k<B[02P0k<B[00?o00000>g6Z`3]aZ/0:03]aZ/00ol00000
oooo0?ooo`110?ooo`003`3oool00ol00000Od9l07m2O00Z07m2O003o`00003/a:/0k<B[02L0k<B[
00?o00000>g6Z`3]aZ/0:@3]aZ/00ol00000oooo0?ooo`110?ooo`003P3oool00ol00000Od9l07m2
O00Z07m2O003o`00003/a:/0k<B[02L0k<B[00?o00000>g6Z`3]aZ/0:P3]aZ/00ol00000oooo0?oo
o`110?ooo`003P3oool00ol00000Od9l07m2O00Z07m2O003o`00003/a:/0k<B[02L0k<B[00?o0000
0>g6Z`3]aZ/0:P3]aZ/00ol00000oooo0?ooo`110?ooo`003P3oool00ol00000Od9l07m2O00Z07m2
O003o`00003/a:/0k<B[02H0k<B[00?o00000>g6Z`3]aZ/0:`3]aZ/00ol00000oooo0?ooo`110?oo
o`003P3oool00ol00000Od9l07m2O00Y07m2O003o`00003/a:/0k<B[02H0k<B[00?o00000>g6Z`3]
aZ/0;03]aZ/00ol00000oooo0?ooo`110?ooo`003P3oool00ol00000Od9l07m2O00Y07m2O003o`00
003/a:/0k<B[02H0k<B[00?o00000>g6Z`3]aZ/0;03]aZ/00ol00000oooo0?ooo`110?ooo`003P3o
ool00ol00000Od9l07m2O00X07m2O003o`00003/a:/0k<B[02H0k<B[00?o00000>g6Z`3]aZ/0;@3]
aZ/2o`000480oooo000>0?ooo`03o`00001o@W`0Od9l02P0Od9l00?o00000>c4Z`3/a:/09P3/a:/0
0ol00000kLJ[0>g6Z`0]0>g6Z`;o0000@P3oool000h0oooo00?o000007m2O01o@W`09`1o@W`00ol0
0000k<B[0>c4Z`0V0>c4Z`03o`00003]aZ/0kLJ[02h0kLJ[0_l000120?ooo`003P3oool00ol00000
Od9l07m2O00W07m2O003o`00003/a:/0k<B[02D0k<B[00?o00000>g6Z`3]aZ/0;`3]aZ/2o`000480
oooo000=0?ooo`03o`00001o@W`0Od9l02L0Od9l00?o00000>c4Z`3/a:/09P3/a:/00ol00000kLJ[
0>g6Z`0_0>g6Z`;o0000@P3oool000d0oooo00?o000007m2O01o@W`09`1o@W`00ol00000k<B[0>c4
Z`0U0>c4Z`03o`00003]aZ/0kLJ[0300kLJ[0_l000120?ooo`003@3oool00ol00000Od9l07m2O00W
07m2O003o`00003/a:/0k<B[02D0k<B[00?o00000>g6Z`3]aZ/0<03]aZ/2o`000480oooo000=0?oo
o`03o`00001o@W`0Od9l02H0Od9l00?o00000>c4Z`3/a:/09@3/a:/00ol00000kLJ[0>g6Z`0a0>g6
Z`;o0000@P3oool000d0oooo00?o000007m2O01o@W`09P1o@W`00ol00000k<B[0>c4Z`0T0>c4Z`03
o`00003]aZ/0kLJ[0380kLJ[0_l000120?ooo`003@3oool00ol00000Od9l07m2O00U07m2O003o`00
003/a:/0k<B[02D0k<B[00?o00000>g6Z`3]aZ/0<`3]aZ/00ol00000oooo0?ooo`100?ooo`003@3o
ool00ol00000Od9l07m2O00U07m2O003o`00003/a:/0k<B[02@0k<B[00?o00000>g6Z`3]aZ/0=03]
aZ/00ol00000oooo0?ooo`100?ooo`003@3oool00ol00000Od9l07m2O00S07m2O0;o000000<0j/Ja
o`00003/a:/08`3/a:/00ol00000kLJ[0>g6Z`0e0>g6Z`03o`00003oool0oooo0400oooo000=0?oo
o`03o`00001o@W`0Od9l0280Od9l00?o00000?>_O_l000000P3Za[400ol00000k<B[0>c4Z`0Q0>c4
Z`03o`00003]aZ/0kLJ[03D0kLJ[00?o00000?ooo`3oool0@03oool000d0oooo00?o000007m2O01o
@W`08@1o@W`01Ol00000ljmno`00003Za[7o00000080j/Ja00?o00000>c4Z`3/a:/07`3/a:/00ol0
0000kLJ[0>g6Z`0f0>g6Z`03o`00003oool0oooo0400oooo000<0?ooo`03o`00001o@W`0Od9l0240
Od9l00Co00000?>_OP3c[gko00000P3Za[401?l00000j/Ja0>[6/Ol0000P0>c4Z`03o`00003]aZ/0
kLJ[03H0kLJ[00?o00000?ooo`3oool0@03oool000`0oooo00?o000007m2O01o@W`0801o@W`01?l0
0000ljmn0?>_O_l000040>[6/@04o`00003Za[40j/Jao`0001h0k<B[00?o00000>g6Z`3]aZ/0=`3]
aZ/00ol00000oooo0?ooo`100?ooo`00303oool00ol00000Od9l07m2O00O07m2O005o`00003c[gh0
ljmn0?>_O_l000001@3Za[401?l00000j/Ja0>[6/Ol0000L0>c4Z`03o`00003]aZ/0kLJ[03P0kLJ[
00?o00000?ooo`3oool0@03oool000`0oooo00?o000007m2O01o@W`07P1o@W`01Ol00000ljmn0?>_
OP3c[gko000000L0j/Ja00Co00000>[6/@3Za[7o00006`3/a:/00ol00000kLJ[0>g6Z`0h0>g6Z`03
o`00003oool0oooo0400oooo000<0?ooo`03o`00001o@W`0Od9l01d0Od9l00?o00000?>_OP3c[gh0
0P3c[gh00ol00000j/Ja0>[6/@060>[6/@04o`00003Za[40j/Jao`0001T0k<B[00?o00000>g6Z`3]
aZ/0>@3]aZ/00ol00000oooo0?ooo`100?ooo`00303oool00ol00000Od9l07m2O00L07m2O003o`00
003c[gh0ljmn0080ljmn00?o00000>[6/@3Za[40203Za[401?l00000j/Ja0>[6/Ol0000H0>c4Z`03
o`00003]aZ/0kLJ[03T0kLJ[00?o00000?ooo`3oool0@03oool000`0oooo00?o000007m2O01o@W`0
6`1o@W`00ol00000ljmn0?>_OP030?>_OP03o`00003Za[40j/Ja00T0j/Ja00Co00000>[6/@3Za[7o
00005P3/a:/00ol00000kLJ[0>g6Z`0j0>g6Z`03o`00003oool0oooo0400oooo000<0?ooo`03o`00
001o@W`0Od9l01X0Od9l00?o00000?>_OP3c[gh00`3c[gh00ol00000j/Ja0>[6/@0;0>[6/@04o`00
003Za[40j/Jao`0001@0k<B[00?o00000>g6Z`3]aZ/0>`3]aZ/00ol00000oooo0?ooo`100?ooo`00
303oool00ol00000Od9l07m2O00I07m2O003o`00003c[gh0ljmn00@0ljmn00?o00000>[6/@3Za[40
303Za[401?l00000j/Ja0>[6/Ol0000C0>c4Z`03o`00003]aZ/0kLJ[03/0kLJ[00?o00000?ooo`3o
ool0@03oool000/0oooo00?o000007m2O01o@W`06@1o@W`00ol00000ljmn0?>_OP040?>_OP03o`00
003Za[40j/Ja00h0j/Ja00Co00000>[6/@3Za[7o00004@3/a:/00ol00000kLJ[0>g6Z`0l0>g6Z`;o
0000@@3oool000/0oooo00?o000007m2O01o@W`0601o@W`00ol00000ljmn0?>_OP050?>_OP03o`00
003Za[40j/Ja00l0j/Ja00Co00000>[6/@3Za[7o00003`3/a:/00ol00000kLJ[0>g6Z`0m0>g6Z`;o
0000@@3oool000/0oooo00?o000007m2O01o@W`05`1o@W`00ol00000ljmn0?>_OP050?>_OP03o`00
003Za[40j/Ja0140j/Ja00Co00000>[6/@3Za[7o00003P3/a:/00ol00000kLJ[0>g6Z`0m0>g6Z`;o
0000@@3oool000/0oooo00?o000007m2O01o@W`05P1o@W`00ol00000ljmn0?>_OP060?>_OP03o`00
003Za[40j/Ja0180j/Ja00Co00000>[6/@3Za[7o0000303/a:/00ol00000kLJ[0>g6Z`0o0>g6Z`03
o`00003oool0oooo03l0oooo000;0?ooo`03o`00001o@W`0Od9l01D0Od9l00?o00000?>_OP3c[gh0
1P3c[gh00ol00000j/Ja0>[6/@0D0>[6/@04o`00003Za[40j/Jao`0000/0k<B[00?o00000>g6Z`3]
aZ/0?`3]aZ/00ol00000oooo0?ooo`0o0?ooo`002`3oool00ol00000Od9l07m2O00D07m2O003o`00
003c[gh0ljmn00L0ljmn00?o00000>[6/@3Za[405@3Za[401?l00000j/Ja0>[6/Ol000090>c4Z`03
o`00003]aZ/0kLJ[0400kLJ[00?o00000?ooo`3oool0?`3oool000/0oooo00?o000007m2O01o@W`0
4`1o@W`00ol00000ljmn0?>_OP070?>_OP03o`00003Za[40j/Ja01L0j/Ja00Co00000>[6/@3Za[7o
00001`3/a:/00ol00000kLJ[0>g6Z`110>g6Z`03o`00003oool0oooo03l0oooo000;0?ooo`03o`00
001o@W`0Od9l0180Od9l00?o00000?>_OP3c[gh0203c[gh00ol00000j/Ja0>[6/@0H0>[6/@04o`00
003Za[40j/Jao`0000H0k<B[00?o00000>g6Z`3]aZ/0@@3]aZ/00ol00000oooo0?ooo`0o0?ooo`00
2`3oool00ol00000Od9l07m2O00A07m2O003o`00003c[gh0ljmn00P0ljmn00?o00000>[6/@3Za[40
6P3Za[401?l00000j/Ja0>[6/Ol000040>c4Z`03o`00003]aZ/0kLJ[0480kLJ[00?o00000?ooo`3o
ool0?`3oool000X0oooo00?o000007m2O01o@W`04@1o@W`00ol00000ljmn0?>_OP090?>_OP03o`00
003Za[40j/Ja01/0j/Ja00Co00000>[6/@3Za[7o00000`3/a:/00ol00000kLJ[0>g6Z`120>g6Z`03
o`00003oool0oooo03l0oooo000:0?ooo`03o`00001o@W`0Od9l0100Od9l00?o00000?>_OP3c[gh0
2@3c[gh00ol00000j/Ja0>[6/@0M0>[6/@06o`00003Za[40j/Jao`00003/a:_o0000A@3]aZ/00ol0
0000oooo0?ooo`0o0?ooo`002P3oool00ol00000Od9l07m2O00?07m2O003o`00003c[gh0ljmn00X0
ljmn00?o00000>[6/@3Za[407P3Za[401?l00000j/Ja0>[6/Ol000160>g6Z`03o`00003oool0oooo
03l0oooo000:0?ooo`03o`00001o@W`0Od9l00h0Od9l00?o00000?>_OP3c[gh02P3c[gh00ol00000
j/Ja0>[6/@0P0>[6/@03o`00003Za[7o000004H0kLJ[00?o00000?ooo`3oool0?`3oool000X0oooo
00?o000007m2O01o@W`03@1o@W`00ol00000ljmn0?>_OP0;0?>_OP03o`00003Za[40j/Ja0240j/Ja
00?o00000>[6/Ol00000A03]aZ/00ol00000oooo0?ooo`100?ooo`002P3oool00ol00000Od9l07m2
O00<07m2O003o`00003c[gh0ljmn00/0ljmn00?o00000>[6/@3Za[408`3Za[42o`0004@0kLJ[00?o
00000?ooo`3oool0@03oool000X0oooo00?o000007m2O01o@W`02`1o@W`00ol00000ljmn0?>_OP0<
0?>_OP03o`00003Za[40j/Ja02@0j/Ja00?o00000>g6Z`3]aZ/0@@3]aZ/00ol00000oooo0?ooo`11
0?ooo`002P3oool00ol00000Od9l07m2O00:07m2O003o`00003c[gh0ljmn00`0ljmn00?o00000>[6
/@3Za[409P3Za[42o`000400kLJ[00?o00000?ooo`3oool0@P3oool000X0oooo00?o000007m2O01o
@W`02@1o@W`00ol00000ljmn0?>_OP0=0?>_OP03o`00003Za[40j/Ja02H0j/Ja00Co00000?>_O_l0
003o0000?P3]aZ/00ol00000oooo0?ooo`120?ooo`002@3oool00ol00000Od9l07m2O00907m2O003
o`00003c[gh0ljmn00d0ljmn00?o00000>[6/@3Za[409`3Za[401?l00000ljmn0?>_OP3c[gh2o`00
03/0kLJ[00?o00000?ooo`3oool0@`3oool000T0oooo00?o000007m2O01o@W`0201o@W`00ol00000
ljmn0?>_OP0>0?>_OP03o`00003Za[40j/Ja02L0j/Ja00?o00000?>_OP3c[gh00`3c[gh2o`0003T0
kLJ[00?o00000?ooo`3oool0@`3oool000T0oooo00?o000007m2O01o@W`01`1o@W`00ol00000ljmn
0?>_OP0>0?>_OP03o`00003Za[40j/Ja02P0j/Ja00?o00000?>_OP3c[gh01@3c[gh2o`0003H0kLJ[
00?o00000?ooo`3oool0A03oool000T0oooo00?o000007m2O01o@W`01P1o@W`00ol00000ljmn0?>_
OP0?0?>_OP03o`00003Za[40j/Ja02P0j/Ja00?o00000?>_OP3c[gh01`3c[gh2o`0003@0kLJ[00?o
00000?ooo`3oool0A03oool000T0oooo00?o000007m2O01o@W`01@1o@W`00ol00000ljmn0?>_OP0?
0?>_OP03o`00003Za[40j/Ja02T0j/Ja00?o00000?>_OP3c[gh02@3c[gh3o`000300kLJ[00?o0000
0?ooo`3oool0A@3oool000T0oooo00?o000007m2O01o@W`0101o@W`00ol00000ljmn0?>_OP0@0?>_
OP03o`00003Za[40j/Ja02T0j/Ja00?o00000?>_OP3c[gh0303c[gh2o`0002d0kLJ[00?o00000?oo
o`3oool0AP3oool000T0oooo00?o000007m2O01o@W`00`1o@W`00ol00000ljmn0?>_OP0@0?>_OP03
o`00003Za[40j/Ja02X0j/Ja00?o00000?>_OP3c[gh03P3c[gh2o`0002/0kLJ[00?o00000?ooo`3o
ool0AP3oool000T0oooo00?o000007m2O01o@W`00P1o@W`00ol00000ljmn0?>_OP0A0?>_OP03o`00
003Za[40j/Ja02X0j/Ja00?o00000?>_OP3c[gh0403c[gh2o`0002P0kLJ[00?o00000?ooo`3oool0
A`3oool000T0oooo00Go000007m2O01o@W`0Od9lo`00000C0?>_OP03o`00003Za[40j/Ja02/0j/Ja
00?o00000?>_OP3c[gh04P3c[gh2o`0002H0kLJ[00?o00000?ooo`3oool0A`3oool000P0oooo00Go
000007m2O01o@W`0Od9lo`00000D0?>_OP03o`00003Za[40j/Ja02/0j/Ja00?o00000?>_OP3c[gh0
4P3c[gh01?l00000KAA5o`000?l0000S0>g6Z`03o`00003oool0oooo04P0oooo00080?ooo`04o`00
001o@W`0Od9lo`0001@0ljmn00?o00000>[6/@3Za[40;03Za[400ol00000ljmn0?>_OP0A0?>_OP03
o`00001]54D0KAA50080KAA50_l0000Q0>g6Z`03o`00003oool0oooo04P0oooo00080?ooo`03o`00
001o@Wco000001D0ljmn00?o00000>[6/@3Za[40;03Za[400ol00000ljmn0?>_OP0A0?>_OP03o`00
001]54D0KAA500@0KAA50_l0000N0>g6Z`03o`00003oool0oooo04T0oooo00080?ooo`;o00005@3c
[gh00ol00000j/Ja0>[6/@0]0>[6/@03o`00003c[gh0ljmn0100ljmn00?o000006dDA@1]54D01`1]
54D2o`0001`0kLJ[00?o00000?ooo`3oool0B@3oool000P0oooo0_l0000E0?>_OP03o`00003Za[40
j/Ja02d0j/Ja00?o00000?>_OP3c[gh0403c[gh00ol00000KAA506dDA@0906dDA@;o00006@3]aZ/0
0ol00000oooo0?ooo`1:0?ooo`002P3oool00ol00000ljmn0?>_OP0A0?>_OP03o`00003Za[40j/Ja
02h0j/Ja00?o00000?>_OP3c[gh0403c[gh00ol00000KAA506dDA@0;06dDA@;o00005P3]aZ/00ol0
0000oooo0?ooo`1;0?ooo`002`3oool00ol00000ljmn0?>_OP0@0?>_OP03o`00003Za[40j/Ja02h0
j/Ja00?o00000?>_OP3c[gh03`3c[gh00ol00000KAA506dDA@0>06dDA@;o0000503]aZ/00ol00000
oooo0?ooo`1;0?ooo`00303oool00ol00000ljmn0?>_OP0>0?>_OP03o`00003Za[40j/Ja02l0j/Ja
00?o00000?>_OP3c[gh03`3c[gh00ol00000KAA506dDA@0@06dDA@;o00004@3]aZ/00ol00000oooo
0?ooo`1<0?ooo`003@3oool00ol00000ljmn0?>_OP0=0?>_OP03o`00003Za[40j/Ja02l0j/Ja00?o
00000?>_OP3c[gh03P3c[gh00ol00000KAA506dDA@0C06dDA@?o00003P3]aZ/00ol00000oooo0?oo
o`1<0?ooo`003P3oool00ol00000ljmn0?>_OP0;0?>_OP03o`00003Za[40j/Ja0300j/Ja00?o0000
0?>_OP3c[gh03P3c[gh00ol00000KAA506dDA@0F06dDA@;o00002`3]aZ/00ol00000oooo0?ooo`1=
0?ooo`003`3oool2o`0000/0ljmn00?o00000>[6/@3Za[40<03Za[400ol00000ljmn0?>_OP0=0?>_
OP03o`00001]54D0KAA501T0KAA50_l000090>g6Z`03o`00003oool0oooo04d0oooo000A0?ooo`03
o`00003c[gh0ljmn00L0ljmn00?o00000>[6/@3Za[40<@3Za[400ol00000ljmn0?>_OP0=0?>_OP03
o`00001]54D0KAA501/0KAA50_l000060>g6Z`03o`00003oool0oooo04h0oooo000B0?ooo`03o`00
003c[gh0ljmn00H0ljmn00?o00000>[6/@3Za[40<@3Za[400ol00000ljmn0?>_OP0=0?>_OP03o`00
001]54D0KAA501d0KAA50_l000030>g6Z`03o`00003oool0oooo04l0oooo000C0?ooo`03o`00003c
[gh0ljmn00@0ljmn0_l0000c0>[6/@03o`00003c[gh0ljmn00`0ljmn00?o000006dDA@1]54D0801]
54D2o`0000030>g6Zol00000oooo0500oooo000D0?ooo`03o`00003c[gh0ljmn00D0ljmn00?o0000
0>[6/@3Za[40<03Za[400ol00000ljmn0?>_OP0<0?>_OP03o`00001]54D0KAA50200KAA50ol0001B
0?ooo`005@3oool00ol00000ljmn0?>_OP050?>_OP03o`00003Za[40j/Ja02l0j/Ja00?o00000?>_
OP3c[gh02`3c[gh00ol00000KAA506dDA@0N06dDA@Co000000<0G00Vo`00003oool0D@3oool001H0
oooo0_l000060?>_OP03o`00003Za[40j/Ja02h0j/Ja00?o00000?>_OP3c[gh02`3c[gh00ol00000
KAA506dDA@0K06dDA@?o000000<0G00Vo`000?l000000P1L02H00ol00000oooo0?ooo`1@0?ooo`00
603oool00ol00000ljmn0?>_OP040?>_OP03o`00003Za[40j/Ja02d0j/Ja00?o00000?>_OP3c[gh0
2P3c[gh00ol00000KAA506dDA@0H06dDA@Co00000`1L02H00ol00000G00V05`09P0205`09P03o`00
003oool0oooo0500oooo000I0?ooo`03o`00003c[gh0ljmn00@0ljmn00?o00000>[6/@3Za[40;03Z
a[400ol00000ljmn0?>_OP0:0?>_OP03o`00001]54D0KAA501D0KAA50ol0000605`09P03o`00001L
02H0G00V00<0G00V00?o00000?ooo`3oool0D03oool001X0oooo00?o00000?>_OP3c[gh0103c[gh0
0ol00000j/Ja0>[6/@0[0>[6/@03o`00003c[gh0ljmn00X0ljmn00?o000006dDA@1]54D04P1]54D3
o`0000L0G00V0_l0000605`09P03o`00003oool0oooo0500oooo000K0?ooo`03o`00003c[gh0ljmn
00@0ljmn00?o00000>[6/@3Za[40:P3Za[400ol00000ljmn0?>_OP090?>_OP03o`00001]54D0KAA5
00l0KAA51?l0000905`09P03o`00001L02H0G00V00H0G00V00?o00000?ooo`3oool0D03oool001`0
oooo00?o00000?>_OP3c[gh0103c[gh2o`0002X0j/Ja00?o00000?>_OP3c[gh02@3c[gh00ol00000
KAA506dDA@0<06dDA@?o00002`1L02H2o`0000T0G00V00?o00000?ooo`3oool0D03oool001d0oooo
0_l000060?>_OP03o`00003Za[40j/Ja02L0j/Ja00?o00000?>_OP3c[gh0203c[gh00ol00000KAA5
06dDA@0:06dDA@?o00003@1L02H00ol00000G00V05`09P0905`09P03o`00003oool0oooo0500oooo
000O0?ooo`03o`00003c[gh0ljmn00@0ljmn00?o00000>[6/@3Za[409P3Za[400ol00000ljmn0?>_
OP080?>_OP03o`00001]54D0KAA500L0KAA50ol0000?05`09P03o`00001L02H0G00V00X0G00V00?o
00000?ooo`3oool0D03oool00200oooo00?o00000?>_OP3c[gh0103c[gh00ol00000j/Ja0>[6/@0U
0>[6/@03o`00003c[gh0ljmn00L0ljmn00?o000006dDA@1]54D0101]54D4o`000100G00V0_l0000=
05`09P03o`00003oool0oooo0500oooo000Q0?ooo`03o`00003c[gh0ljmn00@0ljmn00?o00000>[6
/@3Za[40903Za[400ol00000ljmn0?>_OP070?>_OP04o`00001]54D0KAA506dDA@?o00004`1L02H0
0ol00000G00V05`09P0=05`09P03o`00003oool0oooo0500oooo000R0?ooo`03o`00003c[gh0ljmn
00@0ljmn00?o00000>[6/@3Za[40903Za[400ol00000ljmn0?>_OP060?>_OPCo0000501L02H2o`00
0100G00V00?o00000?ooo`3oool0D03oool002<0oooo0_l000050?>_OP03o`00003Za[40j/Ja02<0
j/Ja00?o00000?>_OP3c[gh01@3c[gh2o`0001H0G00V00?o000005`09P1L02H0401L02H00ol00000
oooo0?ooo`1@0?ooo`009@3oool00ol00000ljmn0?>_OP030?>_OP03o`00003Za[40j/Ja0280j/Ja
00?o00000?>_OP3c[gh01@3c[ghG05`09P03o`00001L02H0G00V0140G00V00?o00000?ooo`3oool0
D03oool002H0oooo00?o00000?>_OP3c[gh00`3c[gh2o`000280j/Ja00?o00000?>_OP3c[gh0103c
[gh00ol00000G00V05`09P0C05`09P;o0000501L02H00ol00000oooo0?ooo`1@0?ooo`009`3oool0
0ol00000ljmn0?>_OP040?>_OP03o`00003Za[40j/Ja01l0j/Ja00?o00000?>_OP3c[gh0103c[ghE
05`09P03o`00001L02H0G00V01@0G00V00?o00000?ooo`3oool0D03oool002P0oooo00?o00000?>_
OP3c[gh0103c[gh00ol00000j/Ja0>[6/@0N0>[6/@03o`00003c[gh0ljmn00<0ljmn00?o000005`0
9P1L02H04@1L02H2o`0001L0G00V00?o00000?ooo`3oool0D03oool002T0oooo00?o00000?>_OP3c
[gh0103c[gh00ol00000j/Ja0>[6/@0M0>[6/@03o`00003c[gh0ljmn0080ljmn00?o000005`09P1L
02H04@1L02H00ol00000G00V05`09P0G05`09P03o`00003oool0oooo0500oooo000Z0?ooo`;o0000
1@3c[gh00ol00000j/Ja0>[6/@0L0>[6/@03o`00003c[gh0ljmn0080ljmn00?o000005`09P1L02H0
3`1L02H2o`0001X0G00V00?o00000?ooo`3oool0D03oool002`0oooo00?o00000?>_OP3c[gh00`3c
[gh00ol00000j/Ja0>[6/@0K0>[6/@05o`00003c[gh0ljmn0?>_O_l000004@1L02H00ol00000G00V
05`09P0J05`09P03o`00003oool0oooo0500oooo000]0?ooo`03o`00003c[gh0ljmn00<0ljmn00?o
00000>[6/@3Za[406P3Za[401Ol00000ljmn0?>_OP3c[gko00000100G00V00?o000005`09P1L02H0
6P1L02H00ol00000oooo0?ooo`1A0?ooo`00;P3oool00ol00000ljmn0?>_OP030?>_OP03o`00003Z
a[40j/Ja01T0j/Ja00Co00000?>_OP3c[gko00003`1L02H2o`0001d0G00V00?o00000?ooo`3oool0
D@3oool002l0oooo00?o00000?>_OP3c[gh00`3c[gh2o`0001T0j/Ja00Co00000?>_OP3c[gko0000
3P1L02H00ol00000G00V05`09P0M05`09P03o`00003oool0oooo0540oooo000`0?ooo`03o`00003c
[gh0ljmn00@0ljmn00?o00000>[6/@3Za[405P3Za[400ol00000ljmno`00000=05`09P;o0000801L
02H00ol00000oooo0?ooo`1A0?ooo`00<@3oool2o`0000D0ljmn00?o00000>[6/@3Za[405@3Za[40
0ol00000ljmno`00000<05`09P03o`00001L02H0G00V0200G00V00?o00000?ooo`3oool0D@3oool0
03<0oooo00?o00000?>_OP3c[gh00`3c[gh00ol00000j/Ja0>[6/@0D0>[6/@;o0000301L02H00ol0
0000G00V05`09P0Q05`09P03o`00003oool0oooo0540oooo000d0?ooo`03o`00003c[gh0ljmn00<0
ljmn00?o00000>[6/@3Za[404`3Za[400ol00000G00V05`09P0905`09P;o0000901L02H00ol00000
oooo0?ooo`1A0?ooo`00=@3oool00ol00000ljmn0?>_OP030?>_OP03o`00003Za[40j/Ja0180j/Ja
00?o000005`09P1L02H0201L02H00ol00000G00V05`09P0T05`09P03o`00003oool0oooo0540oooo
000f0?ooo`03o`00003c[gh0ljmn00<0ljmn00?o00000>[6/@3Za[404@3Za[400ol00000G00V05`0
9P0605`09P;o00009`1L02H00ol00000oooo0?ooo`1A0?ooo`00=`3oool00ol00000ljmn0?>_OP03
0?>_OP03o`00003Za[40j/Ja0100j/Ja00?o000005`09P1L02H01@1L02H00ol00000G00V05`09P0W
05`09P03o`00003oool0oooo0540oooo000h0?ooo`;o0000103c[gh2o`000100j/Ja00?o000005`0
9P1L02H0101L02H00ol00000G00V05`09P0X05`09P03o`00003oool0oooo0540oooo000j0?ooo`03
o`00003c[gh0ljmn00<0ljmn00?o00000>[6/@3Za[403@3Za[400ol00000G00V05`09P0205`09P;o
0000:`1L02H00ol00000oooo0?ooo`1A0?ooo`00>`3oool00ol00000ljmn0?>_OP030?>_OP03o`00
003Za[40j/Ja00`0j/Ja00Go000005`09P1L02H0G00Vo`00000]05`09P03o`00003oool0oooo0540
oooo000l0?ooo`03o`00003c[gh0ljmn00<0ljmn00?o00000>[6/@3Za[402`3Za[401?l00000G00V
o`000?l0000^05`09P03o`00003oool0oooo0540oooo000m0?ooo`03o`00003c[gh0ljmn00<0ljmn
00?o00000>[6/@3Za[402P3Za[42o`000300G00V00?o00000?ooo`3oool0D@3oool003h0oooo00?o
00000?>_OP3c[gh00`3c[gh00ol00000j/Ja0>[6/@090>[6/@03o`00001L02H0G00V02l0G00V00?o
00000?ooo`3oool0D@3oool003l0oooo0_l000040?>_OP03o`00003Za[40j/Ja00P0j/Ja00?o0000
05`09P1L02H0;`1L02H00ol00000oooo0?ooo`1A0?ooo`00@@3oool2o`0000<0ljmn00?o00000>[6
/@3Za[401`3Za[400ol00000G00V05`09P0_05`09P03o`00003oool0oooo0540oooo00130?ooo`04
o`00003c[gh0ljmn0?>_OP;o00001`3Za[400ol00000G00V05`09P0_05`09P03o`00003oool0oooo
0540oooo00140?ooo`;o00000P3c[gh2o`0000H0j/Ja00?o000005`09P1L02H0;01L02H4o`0005<0
oooo00160?ooo`;o000000<0ooooo`000?l000001@3Za[400ol00000G00V05`09P0U05`09POo0000
E`3oool004P0oooo00Co000005`09P1L02Ko0000103Za[400ol00000G00V05`09P0O05`09PKo0000
GP3oool004L0oooo00?o000005`09P1L02H00P1L02H01Ol00000j/Ja0>[6/@3Za[7o000001X0G00V
1ol0001T0?ooo`00A`3oool00ol00000G00V05`09P0305`09P04o`00003Za[40j/Jao`0001@0G00V
1_l0001[0?ooo`00A`3oool00ol00000G00V05`09P0405`09P03o`00003Za[7o000000h0G00V1_l0
001a0?ooo`00A`3oool00ol00000G00V05`09P0505`09P;o00001`1L02H7o`0007L0oooo00180?oo
o`03o`00001L02H0G00V00D0G00V00?o000005`09_l000001Ol0001n0?ooo`00B03oool00ol00000
G00V05`09P07o`0008@0oooo00180?ooo`?o0000R`3oool00=H0oooo003F0?ooo`00eP3oool00=H0
oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?oo
o`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F
0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo
003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0
oooo003F0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 213.812}, {297.562, 0}} -> {0.130797, -0.000586594, \
0.00318597, 0.00318597}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .97028 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00716507 1.04007 0 1.04007 [
[ 0 0 0 0 ]
[ 1 .97028 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .97028 L
0 .97028 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.74782 .41671 m .75106 .46292 L .76301 .42654 L p 0 0 .37 r
F P
0 g
s
.76301 .42654 m .75955 .37998 L .74782 .41671 L p 0 0 .37 r
F P
0 g
s
.64021 .44635 m .65749 .45777 L p .60366 .60765 L .345 0 .129 r
F P
0 g
s
.27427 .63735 m .64021 .44635 L p .60366 .60765 L .345 0 .129 r
F P
0 g
s
.66651 .38588 m .4623 .12325 L p .77587 .14959 L .669 .733 .898 r
F P
0 g
s
.72039 .36786 m .66651 .38588 L p .77587 .14959 L .669 .733 .898 r
F P
0 g
s
.77443 .3334 m .75955 .37998 L .76301 .42654 L p 0 0 .37 r
F P
0 g
s
.34196 .75336 m .27427 .63735 L p .60366 .60765 L .345 0 .129 r
F P
0 g
s
.65749 .45777 m .63458 .54194 L .60366 .60765 L p .345 0 .129 r
F P
0 g
s
.77443 .3334 m .72039 .36786 L p .77587 .14959 L .669 .733 .898 r
F P
0 g
s
.66866 .43239 m .63458 .54194 L .75651 .50415 L p .416 .065 .259 r
F P
0 g
s
.75651 .50415 m .72332 .41455 L .66866 .43239 L p .416 .065 .259 r
F P
0 g
s
.76301 .42654 m .77818 .38039 L .77443 .3334 L p 0 0 .37 r
F P
0 g
s
.75651 .50415 m .72332 .41455 L .77818 .38039 L p .275 0 .297 r
F P
0 g
s
.78652 .29554 m .77443 .3334 L p .77587 .14959 L .669 .733 .898 r
F P
0 g
s
.77443 .3334 m .78652 .29554 L .79741 .42425 L p 0 0 .37 r
F P
0 g
s
.79741 .42425 m .77818 .38039 L .77443 .3334 L p 0 0 .37 r
F P
0 g
s
.77818 .38039 m .79741 .42425 L .75651 .50415 L p .275 0 .297 r
F P
0 g
s
.77587 .14959 m .78662 .17619 L .78652 .29554 L p .669 .733 .898 r
F P
0 g
s
.78652 .29554 m .78662 .17619 L .78735 .18444 L p 0 0 .142 r
F P
0 g
s
.78735 .18444 m .79741 .42425 L .78652 .29554 L p 0 0 .142 r
F P
0 g
s
.79741 .42425 m .75651 .50415 L p .77587 .14959 L .948 .794 .657 r
F P
0 g
s
.77587 .14959 m .78735 .18444 L .79741 .42425 L p .948 .794 .657 r
F P
0 g
s
.63458 .54194 m .60366 .60765 L .61221 .60508 L p .345 0 .129 r
F P
0 g
s
.61221 .60508 m .75651 .50415 L .63458 .54194 L p .345 0 .129 r
F P
0 g
s
.78735 .18444 m .78665 .14791 L .78662 .17619 L closepath p 0 0 .142 r
F P
0 g
s
.75651 .50415 m .6337 .42703 L p .77587 .14959 L .948 .794 .657 r
F P
0 g
s
.77083 .59804 m .75651 .50415 L .61221 .60508 L p .345 0 .129 r
F P
0 g
s
.4623 .12325 m .69894 .0305 L .77587 .14959 L p .669 .733 .898 r
F P
0 g
s
.6337 .42703 m .62787 .41233 L .77587 .14959 L p .948 .794 .657 r
F P
0 g
s
.69894 .0305 m .77587 .14959 L .62787 .41233 L p .944 .786 .656 r
F P
0 g
s
.4623 .12325 m .69894 .0305 L .57364 .34519 L p .512 .278 .497 r
F P
0 g
s
.45671 .4617 m .4623 .12325 L p .57364 .34519 L .512 .278 .497 r
F P
0 g
s
.56411 .63563 m .34196 .75336 L p .60366 .60765 L .345 0 .129 r
F P
0 g
s
.60366 .60765 m .5957 .61617 L .56411 .63563 L p .345 0 .129 r
F P
0 g
s
.61221 .60508 m .60012 .61517 L .60366 .60765 L closepath p .345 0 .129 r
F P
0 g
s
.60565 .6285 m .77083 .59804 L p .61221 .60508 L .345 0 .129 r
F P
0 g
s
.61221 .60508 m .60191 .61508 L .60565 .6285 L p .345 0 .129 r
F P
0 g
s
.62787 .41233 m .57364 .34519 L .69894 .0305 L p .944 .786 .656 r
F P
0 g
s
.5083 .48494 m .63124 .62126 L .6337 .42703 L p .932 .793 .685 r
F P
0 g
s
.62787 .41233 m .6337 .42703 L .57134 .35011 L p .932 .793 .685 r
F P
0 g
s
.6337 .42703 m .57134 .35011 L .5083 .48494 L p .932 .793 .685 r
F P
0 g
s
.57134 .35011 m .57364 .34519 L .62787 .41233 L p .932 .793 .685 r
F P
0 g
s
.57364 .34519 m .57134 .35011 L .45671 .4617 L p .512 .278 .497 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 208.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000d2000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool009@0oooo0_l000100?ooo`00
T@3oool3o`00000308=7Ool00000oooo03l0oooo002>0?ooo`?o00000`23Agl00ol00000lLVWo`00
000o0?ooo`00S03oool2o`0000H0PdMo00Co00000?79Y`3abJOo0000?P3oool008T0oooo0ol00008
08=7O`04o`00003abJL0lLVWo`0003h0oooo00260?ooo`?o00002P23Agl00ol00000lLVW0?79Y`02
0?79Y`03o`00003oool0oooo03/0oooo00240?ooo`;o00003@23Agl00ol00000lLVW0?79Y`030?79
Y`03o`00003oool0oooo03X0oooo00210?ooo`?o00003P23Agl00ol00000lLVW0?79Y`040?79Y`03
o`00003oool0oooo03X0oooo001n0?ooo`?o00004@23Agl00ol00000lLVW0?79Y`050?79Y`03o`00
003oool0oooo03T0oooo001k0?ooo`?o00005023Agl00ol00000lLVW0?79Y`050?79Y`03o`00003o
ool0oooo03T0oooo001i0?ooo`;o00005P23Agl00ol00000lLVW0?79Y`070?79Y`03o`00003oool0
oooo03P0oooo001f0?ooo`?o00006023Agl00ol00000lLVW0?79Y`080?79Y`03o`00003oool0oooo
03L0oooo001c0?ooo`?o00006P23Agl00ol00000lLVW0?79Y`090?79Y`03o`00003oool0oooo03L0
oooo001a0?ooo`;o00007@23Agl00ol00000lLVW0?79Y`0:0?79Y`03o`00003oool0oooo03H0oooo
001^0?ooo`?o00007`23Agl00ol00000lLVW0?79Y`0;0?79Y`03o`00003oool0oooo03D0oooo001[
0?ooo`?o00008@23Agl00ol00000lLVW0?79Y`0<0?79Y`03o`00003oool0oooo03D0oooo001Y0?oo
o`;o00009023Agl00ol00000lLVW0?79Y`0=0?79Y`03o`00003oool0oooo03@0oooo001V0?ooo`?o
00009@23Agl00ol00000lLVW0?79Y`0?0?79Y`03o`00003oool0oooo03<0oooo001S0?ooo`?o0000
:023Agl00ol00000lLVW0?79Y`0?0?79Y`03o`00003oool0oooo03<0oooo001R0?ooo`03o`000023
Agl0PdMo02T0PdMo00?o00000?79Y`3abJL0403abJL00ol00000oooo0?ooo`0b0?ooo`00HP3oool0
0ol00000PdMo08=7O`0X08=7O`03o`00003abJL0lLVW0140lLVW00?o00000?ooo`3oool0<P3oool0
0680oooo00?o000008=7O`23Agl0:023Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003oool0oooo
0340oooo001R0?ooo`03o`000023Agl0PdMo02L0PdMo00?o00000?79Y`3abJL0503abJL00ol00000
oooo0?ooo`0`0?ooo`00HP3oool00ol00000PdMo08=7O`0W08=7O`03o`00003abJL0lLVW01@0lLVW
00?o00000?ooo`3oool0<03oool00680oooo00?o000008=7O`23Agl09`23Agl00ol00000lLVW0?79
Y`0E0?79Y`03o`00003oool0oooo02l0oooo001R0?ooo`03o`000023Agl0PdMo02H0PdMo00?o0000
0?79Y`3abJL05`3abJL01?l00000oooo0?ooool0000]0?ooo`00HP3oool00ol00000PdMo08=7O`0V
08=7O`03o`00003abJL0lLVW01L0lLVW00Co00000?ooo`3ooooo0000;@3oool00680oooo00?o0000
08=7O`23Agl09@23Agl00ol00000lLVW0?79Y`0G0?79Y`05o`00003bbjSo00000?ooool00000;@3o
ool00680oooo00?o000008=7O`23Agl09@23Agl00ol00000lLVW0?79Y`0G0?79Y`05o`00003bbjSo
00000?ooool00000;@3oool00680oooo00?o000008=7O`23Agl09@23Agl00ol00000lLVW0?79Y`0F
0?79Y`03o`00003bbjP0l/^X00?o0000;@3oool00680oooo00?o000008=7O`23Agl09023Agl00ol0
0000lLVW0?79Y`0G0?79Y`04o`00003bbjP0l/^X0?;;Z0;o0000;@3oool00680oooo00?o000008=7
O`23Agl09023Agl00ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X0080l/^X0_l0000]0?oo
o`00HP3oool00ol00000PdMo08=7O`0S08=7O`03o`00003abJL0lLVW01H0lLVW00?o00000?;;Z03b
bjP00`3bbjP2o`0002d0oooo001R0?ooo`03o`000023Agl0PdMo02<0PdMo00?o00000?79Y`3abJL0
5P3abJL00ol00000l/^X0?;;Z0040?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023
Agl0PdMo0280PdMo00?o00000?79Y`3abJL05P3abJL00ol00000l/^X0?;;Z0050?;;Z003o`00003o
ool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo0280PdMo00?o00000?79Y`3abJL05P3abJL0
0ol00000l/^X0?;;Z0050?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo
0280PdMo00?o00000?79Y`3abJL05@3abJL00ol00000l/^X0?;;Z0060?;;Z003o`00003oool0oooo
02/0oooo001R0?ooo`03o`000023Agl0PdMo0240PdMo00?o00000?79Y`3abJL05P3abJL00ol00000
l/^X0?;;Z0060?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo0240PdMo
00?o00000?79Y`3abJL05@3abJL00ol00000l/^X0?;;Z0070?;;Z003o`00003oool0oooo02/0oooo
001R0?ooo`03o`000023Agl0PdMo0200PdMo00?o00000?79Y`3abJL05P3abJL00ol00000l/^X0?;;
Z0070?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo0200PdMo00?o0000
0?79Y`3abJL05@3abJL00ol00000l/^X0?;;Z0080?;;Z003o`00003oool0oooo02/0oooo001R0?oo
o`03o`000023Agl0PdMo0200PdMo00?o00000?79Y`3abJL0503abJL00ol00000l/^X0?;;Z0090?;;
Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo01l0PdMo00?o00000?79Y`3a
bJL05@3abJL00ol00000l/^X0?;;Z0090?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`00
0023Agl0PdMo01l0PdMo00?o00000?79Y`3abJL0503abJL00ol00000l/^X0?;;Z00:0?;;Z003o`00
003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo01h0PdMo00?o00000?79Y`3abJL05@3a
bJL00ol00000l/^X0?;;Z00:0?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0
PdMo01h0PdMo00?o00000?79Y`3abJL0503abJL00ol00000l/^X0?;;Z00;0?;;Z003o`00003oool0
oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo01h0PdMo00?o00000?79Y`3abJL0503abJL00ol0
0000l/^X0?;;Z00;0?;;Z003o`00003oool0oooo02/0oooo001R0?ooo`03o`000023Agl0PdMo01d0
PdMo00?o00000?79Y`3abJL0503abJL00ol00000l/^X0?;;Z00=0?;;Z003o`00003oool0oooo02X0
oooo001R0?ooo`03o`000023Agl0PdMo01d0PdMo00?o00000?79Y`3abJL0503abJL00ol00000l/^X
0?;;Z00=0?;;Z003o`00003oool0oooo02X0oooo001R0?ooo`03o`000023Agl0PdMo01`0PdMo00?o
00000?79Y`3abJL0503abJL00ol00000l/^X0?;;Z00>0?;;Z003o`00003oool0oooo02X0oooo001R
0?ooo`03o`000023Agl0PdMo01`0PdMo00?o00000?79Y`3abJL04`3abJL00ol00000l/^X0?;;Z00?
0?;;Z003o`00003oool0oooo02X0oooo001R0?ooo`03o`000023Agl0PdMo01`0PdMo00?o00000?79
Y`3abJL04`3abJL00ol00000l/^X0?;;Z00?0?;;Z003o`00003oool0oooo02X0oooo001R0?ooo`03
o`000023Agl0PdMo01/0PdMo00?o00000?79Y`3abJL04`3abJL00ol00000l/^X0?;;Z00@0?;;Z003
o`00003oool0oooo02X0oooo001R0?ooo`03o`000023Agl0PdMo01/0PdMo00?o00000?79Y`3abJL0
4`3abJL00ol00000l/^X0?;;Z00@0?;;Z003o`00003oool0oooo02X0oooo001R0?ooo`03o`000023
Agl0PdMo01X0PdMo00?o00000?79Y`3abJL04`3abJL00ol00000l/^X0?;;Z00A0?;;Z003o`00003o
ool0oooo02X0oooo001R0?ooo`03o`000023Agl0PdMo01X0PdMo00?o00000?79Y`3abJL04`3abJL0
0ol00000l/^X0?;;Z00A0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo
01/0PdMo00?o00000?79Y`3abJL04P3abJL00ol00000l/^X0?;;Z00B0?;;Z003o`00003oool0oooo
02X0oooo001Q0?ooo`03o`000023Agl0PdMo01X0PdMo00?o00000?79Y`3abJL04`3abJL00ol00000
l/^X0?;;Z00B0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01X0PdMo
00?o00000?79Y`3abJL04P3abJL00ol00000l/^X0?;;Z00C0?;;Z003o`00003oool0oooo02X0oooo
001Q0?ooo`03o`000023Agl0PdMo01T0PdMo00?o00000?79Y`3abJL04P3abJL00ol00000l/^X0?;;
Z00D0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01T0PdMo00?o0000
0?79Y`3abJL04P3abJL00ol00000l/^X0?;;Z00D0?;;Z003o`00003oool0oooo02X0oooo001Q0?oo
o`03o`000023Agl0PdMo01T0PdMo00?o00000?79Y`3abJL04@3abJL00ol00000l/^X0?;;Z00E0?;;
Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01P0PdMo00?o00000?79Y`3a
bJL04P3abJL00ol00000l/^X0?;;Z00E0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`00
0023Agl0PdMo01P0PdMo00?o00000?79Y`3abJL04@3abJL00ol00000l/^X0?;;Z00F0?;;Z003o`00
003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01L0PdMo00?o00000?79Y`3abJL04P3a
bJL00ol00000l/^X0?;;Z00F0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0
PdMo01L0PdMo00?o00000?79Y`3abJL04@3abJL00ol00000l/^X0?;;Z00G0?;;Z003o`00003oool0
oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01L0PdMo00?o00000?79Y`3abJL04@3abJL00ol0
0000l/^X0?;;Z00G0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo01H0
PdMo00?o00000?79Y`3abJL04@3abJL00ol00000l/^X0?;;Z00H0?;;Z003o`00003oool0oooo02X0
oooo001Q0?ooo`03o`000023Agl0PdMo01D0PdMo0_l0000B0?79Y`03o`00003bbjP0l/^X01T0l/^X
00?o00000?ooo`3oool0:P3oool00640oooo00?o000008=7O`23Agl05023Agl01?l00000oooo0>k;
[ol0000A0?79Y`03o`00003bbjP0l/^X01T0l/^X00?o00000?ooo`3oool0:P3oool00640oooo00?o
000008=7O`23Agl04`23Agl00ol00000ooooo`0000020>k;[`03o`00003abJL0lLVW00d0lLVW00?o
00000?;;Z03bbjP06P3bbjP00ol00000oooo0?ooo`0Z0?ooo`00H@3oool00ol00000PdMo08=7O`0B
08=7O`04o`00003oool0ooooo`0000<0k/^_00?o00000?79Y`3abJL0303abJL00ol00000l/^X0?;;
Z00J0?;;Z003o`00003oool0oooo02X0oooo001Q0?ooo`03o`000023Agl0PdMo0140PdMo00Co0000
0?ooo`3ooooo00001@3^bjl00ol00000lLVW0?79Y`0:0?79Y`03o`00003bbjP0l/^X01`0l/^X00?o
00000?ooo`3oool0:@3oool00640oooo00?o000008=7O`23Agl04023Agl01Ol00000oooo0?ooo`3o
oooo000000H0k/^_00?o00000?79Y`3abJL02@3abJL00ol00000l/^X0?;;Z00L0?;;Z003o`00003o
ool0oooo02T0oooo001Q0?ooo`03o`000023Agl0PdMo00l0PdMo00Go00000?ooo`3oool0ooooo`00
00060>k;[`03o`00003^bjoo000000T0lLVW00?o00000?;;Z03bbjP07@3bbjP00ol00000oooo0?oo
o`0Y0?ooo`00H@3oool00ol00000PdMo08=7O`0>08=7O`03o`00003oool0oooo0080oooo00?o0000
0>k;[`3^bjl01@3^bjl2o`0000T0lLVW00?o00000?;;Z03bbjP07@3bbjP00ol00000oooo0?ooo`0Y
0?ooo`00H@3oool00ol00000PdMo08=7O`0=08=7O`03o`00003oool0oooo0080oooo00?o00000>k;
[`3^bjl01`3^bjl2o`0000L0lLVW00?o00000?;;Z03bbjP07P3bbjP00ol00000oooo0?ooo`0Y0?oo
o`00H@3oool00ol00000PdMo08=7O`0<08=7O`03o`00003oool0oooo00<0oooo00?o00000>k;[`3^
bjl0203^bjl2o`0000D0lLVW00?o00000?;;Z03bbjP07`3bbjP00ol00000oooo0?ooo`0Y0?ooo`00
H@3oool00ol00000PdMo08=7O`0;08=7O`03o`00003oool0oooo00<0oooo00?o00000>k;[`3^bjl0
2P3^bjl2o`0000@0lLVW00?o00000?;;Z03bbjP07`3bbjP00ol00000oooo0?ooo`0Y0?ooo`00H@3o
ool00ol00000PdMo08=7O`0:08=7O`03o`00003oool0oooo00@0oooo00?o00000>k;[`3^bjl02`3^
bjl2o`000080lLVW00?o00000?;;Z03bbjP0803bbjP00ol00000oooo0?ooo`0Y0?ooo`00H@3oool0
0ol00000PdMo08=7O`0908=7O`03o`00003oool0oooo00@0oooo00?o00000>k;[`3^bjl0303^bjl0
1Ol00000k/^_o`00003abJOo00000280l/^X00?o00000?ooo`3oool0:@3oool00640oooo00?o0000
08=7O`23Agl02023Agl00ol00000oooo0?ooo`050?ooo`03o`00003^bjl0k/^_00d0k/^_00?o0000
0>k;[ol000008`3bbjP00ol00000oooo0?ooo`0Y0?ooo`00H@3oool00ol00000PdMo08=7O`0708=7
O`03o`00003oool0oooo00D0oooo00?o00000>k;[`3^bjl03`3^bjl2o`0002<0l/^X00?o00000?oo
o`3oool0:@3oool00640oooo00?o000008=7O`23Agl01P23Agl00ol00000oooo0?ooo`060?ooo`03
o`00003^bjl0k/^_0100k/^_0_l0000R0?;;Z003o`00003oool0oooo02T0oooo001Q0?ooo`03o`00
0023Agl0PdMo00D0PdMo00?o00000?ooo`3oool01`3oool00ol00000k/^_0>k;[`0A0>k;[`;o0000
8@3bbjP00ol00000oooo0?ooo`0Y0?ooo`00H@3oool00ol00000PdMo08=7O`0408=7O`03o`00003o
ool0oooo00L0oooo00?o00000>k;[`3^bjl04P3^bjl00ol00000ooooo`00000P0?;;Z003o`00003o
ool0oooo02T0oooo001Q0?ooo`03o`000023Agl0PdMo00<0PdMo00?o00000?ooo`3oool0203oool0
0ol00000k/^_0>k;[`0B0>k;[`03o`00003oool0oooo00;o00007@3bbjP00ol00000oooo0?ooo`0Z
0?ooo`00H@3oool00ol00000PdMo08=7O`0208=7O`03o`00003oool0oooo00P0oooo00?o00000>k;
[`3^bjl04`3^bjl00ol00000oooo0?ooo`020?ooo`03o`00003bbjP0l/^X01X0l/^X00?o00000?oo
o`3oool0:P3oool00640oooo00Go000008=7O`23Agl0PdMoo`00000;0?ooo`03o`00003^bjl0k/^_
01<0k/^_00?o00000?ooo`3oool00`3oool2o`0001T0l/^X00?o00000?ooo`3oool0:`3oool00640
oooo00Co000008=7O`23Agoo00002`3oool00ol00000k/^_0>k;[`0D0>k;[`?o00000`3oool00ol0
0000JQ12o`00000H0?;;Z003o`00003oool0oooo02/0oooo001Q0?ooo`03o`000023Agoo000000`0
oooo00?o00000>k;[`3^bjl0503^bjl00ol00000F00Q05P08@02o`0000040?ooool00000JQ1206X@
@P;o00005@3bbjP00ol00000oooo0?ooo`0/0?ooo`00H@3oool2o`0000`0oooo00?o00000>k;[`3^
bjl05@3^bjl00ol00000F00Q05P08@0205P08@;o0000101Z44800ol00000l/^X0?;;Z00B0?;;Z003
o`00003oool0oooo02`0oooo001Q0?ooo`03o`00003oool0oooo00/0oooo00?o00000>k;[`3^bjl0
5@3^bjl00ol00000F00Q05P08@0205P08@03o`00001Z4480JQ1200@0JQ120_l0000A0?;;Z003o`00
003oool0oooo02d0oooo001^0?ooo`03o`00003^bjl0k/^_01H0k/^_00?o000005P08@1H02400P1H
02400ol00000JQ1206X@@P0606X@@P;o00003P3bbjP00ol00000oooo0?ooo`0^0?ooo`00KP3oool0
0ol00000k/^_0>k;[`0F0>k;[`04o`00001H0240F00Q05P08@;o00002P1Z44800ol00000l/^X0?;;
Z00;0?;;Z003o`00003oool0oooo02h0oooo001]0?ooo`03o`00003^bjl0k/^_01L0k/^_00Go0000
05P08@1H0240F00Qo`00000<06X@@P;o00002P3bbjP00ol00000oooo0?ooo`0_0?ooo`00K@3oool0
0ol00000k/^_0>k;[`0G0>k;[`05o`00001H0240F00Q05P08Ol000003P1Z44800ol00000l/^X0?;;
Z0070?;;Z003o`00003oool0oooo02l0oooo001/0?ooo`03o`00003^bjl0k/^_01P0k/^_00?o0000
05P08@1H02400_l0000?06X@@P;o00001P3bbjP00ol00000oooo0?ooo`0`0?ooo`00K03oool00ol0
0000k/^_0>k;[`0H0>k;[`04o`00001H0240F00Qo`000180JQ1200?o00000?;;Z03bbjP00`3bbjP0
0ol00000oooo0?ooo`0`0?ooo`00K@3oool00ol00000k/^_0>k;[`0G0>k;[`04o`00001H0240F00Q
o`0001<0JQ120_l000020?;;Z003o`00003oool0oooo0340oooo001^0?ooo`03o`00003^bjl0k/^_
01H0k/^_00Co000005P08@1H027o00005@1Z44800ol00000l/^Xo`00000c0?ooo`00K`3oool00ol0
0000k/^_0>k;[`0E0>k;[`04o`00001H027o0000o`0001@0JQ120ol0000d0?ooo`00KP3oool3o`00
01H0k/^_00?o000005P08Ol000004P1Z4484o`00000305P08Ol00000oooo03<0oooo001/0?ooo`;o
00000`1H02400ol00000k/^_0>k;[`0C0>k;[`03o`00001H027o000000l0JQ120ol000000`1H027o
0000o`00000205P08@03o`00003oool0oooo0380oooo001Z0?ooo`;o00001P1H02400ol00000k/^_
0>k;[`0B0>k;[`03o`00001H027o000000`0JQ120ol0000305P08@03o`00001H0240F00Q0080F00Q
00?o00000?ooo`3oool0<P3oool006P0oooo0_l0000905P08@03o`00003^bjl0k/^_0140k/^_0_l0
000906X@@PCo0000101H0242o`0000H0F00Q00?o00000?ooo`3oool0<@3oool006H0oooo0_l0000<
05P08@03o`00003^bjl0k/^_00l0k/^_00?o000005P08Ol000001P1Z4483o`0000L0F00Q00?o0000
05P08@1H02401P1H02400ol00000oooo0?ooo`0a0?ooo`00I03oool2o`0000l0F00Q00?o00000>k;
[`3^bjl03P3^bjl00ol00000F00Qo`00000306X@@P?o0000201H0242o`0000T0F00Q00?o00000?oo
o`3oool0<@3oool00680oooo0_l0000A05P08@03o`00003^bjl0k/^_00h0k/^_0_l00000101Z44;o
0000o`000?l0000:05P08@03o`00001H0240F00Q00T0F00Q00?o00000?ooo`3oool0<@3oool00600
oooo0_l0000D05P08@03o`00003^bjl0k/^_00d0k/^_0ol0000;05P08@;o0000301H02400ol00000
oooo0?ooo`0a0?ooo`00GP3oool2o`0001L0F00Q00?o00000>k;[`3^bjl0303^bjl00ol00000F00Q
05P08@0:05P08@03o`00001H0240F00Q00`0F00Q00?o00000?ooo`3oool0<@3oool005`0oooo0_l0
000J05P08@03o`00003^bjl0k/^_00/0k/^_00?o000005P08@1H0240201H0242o`0000l0F00Q00?o
00000?ooo`3oool0<@3oool005X0oooo0_l0000M05P08@03o`00003^bjl0k/^_00X0k/^_00?o0000
05P08@1H02401`1H02400ol00000F00Q05P08@0@05P08@03o`00003oool0oooo0300oooo001H0?oo
o`;o0000801H02400ol00000k/^_0>k;[`090>k;[`03o`00001H0240F00Q00H0F00Q00?o000005P0
8@1H02404@1H02400ol00000oooo0?ooo`0`0?ooo`00EP3oool2o`0002<0F00Q00?o00000>k;[`3^
bjl0203^bjl00ol00000F00Q05P08@0405P08@;o0000501H02400ol00000oooo0?ooo`0`0?ooo`00
E03oool2o`0002H0F00Q00?o00000>k;[`3^bjl01`3^bjl00ol00000F00Q05P08@0305P08@03o`00
001H0240F00Q01@0F00Q00?o00000?ooo`3oool0<03oool00580oooo0_l0000Y05P08@03o`00003^
bjl0k/^_00H0k/^_00Co000005P08@1H0240F00Q0_l0000G05P08@03o`00003oool0oooo0300oooo
001@0?ooo`;o0000:`1H02400ol00000k/^_0>k;[`060>k;[`04o`00001H0240F00Qo`0001T0F00Q
00?o00000?ooo`3oool0<03oool004h0oooo0_l0000^05P08@03o`00003^bjl0k/^_00D0k/^_0ol0
000J05P08@03o`00003oool0oooo0300oooo001=0?ooo`03o`00001H0240F00Q02l0F00Q00?o0000
0>k;[`3^bjl0103^bjl00ol00000F00Q05P08@0K05P08@03o`00003oool0oooo02l0oooo001;0?oo
o`;o0000<`1H02400ol00000k/^_0>k;[`030>k;[`03o`00001H0240F00Q01/0F00Q00?o00000?oo
o`3oool0;`3oool004T0oooo0_l0000f05P08@03o`00003^bjl0k/^_0080k/^_00?o000005P08@1H
0240601H0244o`000340oooo00170?ooo`;o0000>@1H02401Ol00000k/^_0>k;[`3^bjoo000001@0
F00Q1_l0000e0?ooo`00A@3oool2o`0003X0F00Q0ol000020>k;[`03o`00001H0240F00Q00`0F00Q
1_l0000k0?ooo`00@`3oool2o`0003/0F00Q0_l0000205P08@03o`00003^bjoo000000T0F00Q1Ol0
00110?ooo`00@@3oool2o`0003/0F00Q0ol0000405P08@;o00000`1H0246o`0004H0oooo000o0?oo
o`;o0000>`1H0242o`000080oooo00Co000005P08@1H0240F00Q1_l0001<0?ooo`00?@3oool2o`00
03`0F00Q00?o00000?ooo`3oool00`3oool3o`000580oooo000k0?ooo`;o0000?01H0242o`0005/0
oooo000j0?ooo`03o`00001H0240F00Q03X0F00Q0_l0001M0?ooo`00>P3oool00ol00000F00Q05P0
8@0h05P08@;o0000G`3oool003/0oooo00?o000005P08@1H0240=@1H0242o`000640oooo000l0?oo
o`03o`00001H0240F00Q0380F00Q0_l0001S0?ooo`00?03oool00ol00000F00Q05P08@0a05P08@03
o`00003oool0oooo06<0oooo000m0?ooo`03o`00001H0240F00Q02h0F00Q0_l0001V0?ooo`00?@3o
ool00ol00000F00Q05P08@0/05P08@;o0000J03oool003h0oooo00?o000005P08@1H0240:@1H0242
o`0006X0oooo000o0?ooo`03o`00001H0240F00Q02H0F00Q0_l0001/0?ooo`00?`3oool00ol00000
F00Q05P08@0T05P08@;o0000KP3oool00400oooo00?o000005P08@1H02408@1H0242o`000700oooo
00100?ooo`03o`00001H0240F00Q01l0F00Q0_l0001b0?ooo`00@@3oool00ol00000F00Q05P08@0L
05P08@;o0000M03oool00480oooo00?o000005P08@1H02406P1H02400ol00000oooo0?ooo`1d0?oo
o`00@P3oool00ol00000F00Q05P08@0H05P08@;o0000M`3oool004<0oooo00?o000005P08@1H0240
5@1H0242o`0007T0oooo00130?ooo`03o`00001H0240F00Q01<0F00Q0_l0001k0?ooo`00A03oool0
0ol00000F00Q05P08@0@05P08@;o0000O@3oool004D0oooo00?o000005P08@1H02403@1H0242o`00
07l0oooo00150?ooo`03o`00001H0240F00Q00/0F00Q0_l000210?ooo`00AP3oool00ol00000F00Q
05P08@0805P08@;o0000P`3oool004H0oooo00?o000005P08@1H02401`1H02400ol00000oooo0?oo
o`230?ooo`00A`3oool00ol00000F00Q05P08@0405P08@;o0000QP3oool004P0oooo00Co000005P0
8@1H0240F00Q0_l000280?ooo`00B03oool01?l00000F00Qo`000?l0002:0?ooo`00B@3oool00ol0
0000oooo0?ooo`2:0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?oo
o`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F
0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo
003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0
oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {207.375, 0}} -> {0.00669182, \
-4.66454*^-6, 0.00449865, 0.00449865}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .98083 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0118981 1.04959 0 1.04959 [
[ 0 0 0 0 ]
[ 1 .98083 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .98083 L
0 .98083 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.74702 .41645 m .75024 .46242 L .76215 .42607 L p 0 0 .37 r
F P
0 g
s
.76215 .42607 m .7587 .37975 L .74702 .41645 L p 0 0 .37 r
F P
0 g
s
.62915 .42358 m .64832 .43889 L p .60974 .61877 L .416 .064 .257 r
F P
0 g
s
.27308 .63245 m .62915 .42358 L p .60974 .61877 L .416 .064 .257 r
F P
0 g
s
.66599 .38565 m .46252 .12331 L p .77492 .14961 L .669 .733 .897 r
F P
0 g
s
.71967 .36765 m .66599 .38565 L p .77492 .14961 L .669 .733 .897 r
F P
0 g
s
.77351 .33321 m .7587 .37975 L .76215 .42607 L p 0 0 .37 r
F P
0 g
s
.35759 .77798 m .27308 .63245 L p .60974 .61877 L .416 .064 .257 r
F P
0 g
s
.77351 .33321 m .71967 .36765 L p .77492 .14961 L .669 .733 .897 r
F P
0 g
s
.64832 .43889 m .63415 .54066 L .60974 .61877 L p .416 .064 .257 r
F P
0 g
s
.66813 .43192 m .63415 .54066 L .75563 .50289 L p .416 .064 .257 r
F P
0 g
s
.75563 .50289 m .72259 .41409 L .66813 .43192 L p .416 .064 .257 r
F P
0 g
s
.76215 .42607 m .77725 .37996 L .77351 .33321 L p 0 0 .37 r
F P
0 g
s
.75563 .50289 m .72259 .41409 L .77725 .37996 L p .274 0 .297 r
F P
0 g
s
.78555 .29539 m .77351 .33321 L p .77492 .14961 L .669 .733 .897 r
F P
0 g
s
.77351 .33321 m .78555 .29539 L .79638 .42342 L p 0 0 .37 r
F P
0 g
s
.79638 .42342 m .77725 .37996 L .77351 .33321 L p 0 0 .37 r
F P
0 g
s
.77725 .37996 m .79638 .42342 L .75563 .50289 L p .274 0 .297 r
F P
0 g
s
.77492 .14961 m .78563 .17618 L .78555 .29539 L p .669 .733 .897 r
F P
0 g
s
.78555 .29539 m .78563 .17618 L .78635 .18438 L p 0 0 .142 r
F P
0 g
s
.78635 .18438 m .79638 .42342 L .78555 .29539 L p 0 0 .142 r
F P
0 g
s
.79638 .42342 m .75563 .50289 L p .77492 .14961 L .948 .794 .657 r
F P
0 g
s
.77492 .14961 m .78635 .18438 L .79638 .42342 L p .948 .794 .657 r
F P
0 g
s
.63415 .54066 m .60974 .61877 L .61826 .61623 L p .416 .064 .257 r
F P
0 g
s
.61826 .61623 m .75563 .50289 L .63415 .54066 L p .416 .064 .257 r
F P
0 g
s
.78635 .18438 m .78565 .14794 L .78563 .17618 L closepath p 0 0 .142 r
F P
0 g
s
.75563 .50289 m .63326 .42555 L p .77492 .14961 L .948 .794 .657 r
F P
0 g
s
.78041 .61851 m .75563 .50289 L .61826 .61623 L p .416 .064 .257 r
F P
0 g
s
.46252 .12331 m .69825 .03068 L .77492 .14961 L p .669 .733 .897 r
F P
0 g
s
.63326 .42555 m .62744 .41088 L .77492 .14961 L p .948 .794 .657 r
F P
0 g
s
.69825 .03068 m .77492 .14961 L .62744 .41088 L p .944 .786 .656 r
F P
0 g
s
.46252 .12331 m .69825 .03068 L .57342 .34379 L p .512 .278 .497 r
F P
0 g
s
.45696 .45982 m .46252 .12331 L p .57342 .34379 L .512 .278 .497 r
F P
0 g
s
.57224 .65013 m .35759 .77798 L p .60974 .61877 L .416 .064 .257 r
F P
0 g
s
.60974 .61877 m .60252 .6286 L .57224 .65013 L p .416 .064 .257 r
F P
0 g
s
.61826 .61623 m .60696 .62769 L .60974 .61877 L closepath p .416 .064 .257 r
F P
0 g
s
.61416 .64429 m .78041 .61851 L p .61826 .61623 L .416 .064 .257 r
F P
0 g
s
.61826 .61623 m .60879 .6277 L .61416 .64429 L p .416 .064 .257 r
F P
0 g
s
.62744 .41088 m .57342 .34379 L .69825 .03068 L p .944 .786 .656 r
F P
0 g
s
.50834 .48282 m .63081 .61912 L .63326 .42555 L p .931 .793 .685 r
F P
0 g
s
.62744 .41088 m .63326 .42555 L .57113 .34868 L p .931 .793 .685 r
F P
0 g
s
.63326 .42555 m .57113 .34868 L .50834 .48282 L p .931 .793 .685 r
F P
0 g
s
.57113 .34868 m .57342 .34379 L .62744 .41088 L p .931 .793 .685 r
F P
0 g
s
.57342 .34379 m .57113 .34868 L .45696 .45982 L p .512 .278 .497 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.688, 210.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000dR000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00U?ooool2o`00043ooooo002Aooooo`?o
000000<0PdMoo`000?ooool0?oooool008oooooo0_l0000308=7O`03o`00003abJOo000003oooooo
002<ooooo`?o00001@23Agl01?l00000lLVW0?79Yol0000nooooo`00R_ooool2o`0000P0PdMo00Co
00000?79Y`3abJOo0000?_ooool008Oooooo0ol0000908=7O`03o`00003abJL0lLVW0080lLVW00?o
0000ooooooooool0>oooool008Cooooo0ol0000<08=7O`03o`00003abJL0lLVW0080lLVW00?o0000
ooooooooool0>oooool008;ooooo0_l0000>08=7O`03o`00003abJL0lLVW00@0lLVW00?o0000oooo
ooooool0>_ooool007oooooo0ol0000@08=7O`03o`00003abJL0lLVW00D0lLVW00?o0000oooooooo
ool0>Oooool007gooooo0_l0000C08=7O`03o`00003abJL0lLVW00D0lLVW00?o0000ooooooooool0
>Oooool007[ooooo0ol0000D08=7O`03o`00003abJL0lLVW00L0lLVW00?o0000ooooooooool0>?oo
ool007Sooooo0_l0000G08=7O`03o`00003abJL0lLVW00L0lLVW00?o0000ooooooooool0>?ooool0
07Gooooo0ol0000H08=7O`03o`00003abJL0lLVW00T0lLVW00?o0000ooooooooool0=oooool007?o
oooo0_l0000K08=7O`03o`00003abJL0lLVW00X0lLVW00?o0000ooooooooool0=_ooool0073ooooo
0ol0000M08=7O`03o`00003abJL0lLVW00X0lLVW00?o0000ooooooooool0=_ooool006gooooo0ol0
000O08=7O`03o`00003abJL0lLVW00`0lLVW00?o0000ooooooooool0=Oooool006_ooooo0_l0000R
08=7O`03o`00003abJL0lLVW00d0lLVW00?o0000ooooooooool0=?ooool006Sooooo0ol0000S08=7
O`03o`00003abJL0lLVW00h0lLVW00?o0000ooooooooool0=?ooool006Kooooo0_l0000V08=7O`03
o`00003abJL0lLVW00l0lLVW00?o0000ooooooooool0<oooool006?ooooo0ol0000X08=7O`03o`00
003abJL0lLVW00l0lLVW00?o0000ooooooooool0<oooool006;ooooo00?o000008=7O`23Agl0:023
Agl00ol00000lLVW0?79Y`0A0?79Y`03o`000?oooooooooo03;ooooo001Rooooo`03o`000023Agl0
PdMo02P0PdMo00?o00000?79Y`3abJL04P3abJL00ol0003oooooooooo`0aooooo`00H_ooool00ol0
0000PdMo08=7O`0W08=7O`03o`00003abJL0lLVW01<0lLVW00?o0000ooooooooool0<Oooool006;o
oooo00?o000008=7O`23Agl09`23Agl00ol00000lLVW0?79Y`0D0?79Y`03o`000?oooooooooo033o
oooo001Rooooo`03o`000023Agl0PdMo02L0PdMo00?o00000?79Y`3abJL0503abJL00ol0003ooooo
ooooo`0`ooooo`00H_ooool00ol00000PdMo08=7O`0V08=7O`03o`00003abJL0lLVW01H0lLVW00?o
0000ooooooooool0;oooool006;ooooo00?o000008=7O`23Agl09P23Agl00ol00000lLVW0?79Y`0G
0?79Y`03o`000?oooooo000002kooooo001Rooooo`03o`000023Agl0PdMo02D0PdMo00?o00000?79
Y`3abJL0603abJL00ol0003oooooo`00000^ooooo`00H_ooool00ol00000PdMo08=7O`0U08=7O`03
o`00003abJL0lLVW01L0lLVW00Co00000?;;Z?l0003o0000;_ooool006;ooooo00?o000008=7O`23
Agl09@23Agl00ol00000lLVW0?79Y`0G0?79Y`04o`00003bbjSo0000o`0002kooooo001Rooooo`03
o`000023Agl0PdMo02@0PdMo00?o00000?79Y`3abJL05`3abJL01?l00000l/^X0?;;Z03bbjP2o`00
02gooooo001Rooooo`03o`000023Agl0PdMo02@0PdMo00?o00000?79Y`3abJL05`3abJL01?l00000
l/^X0?;;Z03bbjP2o`0002gooooo001Rooooo`03o`000023Agl0PdMo02<0PdMo00?o00000?79Y`3a
bJL05`3abJL00ol00000l/^X0?;;Z0020?;;Z0;o0000;Oooool006;ooooo00?o000008=7O`23Agl0
8`23Agl00ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X00@0l/^X00?o0000ooooooooool0
:oooool006;ooooo00?o000008=7O`23Agl08P23Agl00ol00000lLVW0?79Y`0G0?79Y`03o`00003b
bjP0l/^X00@0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl08P23Agl0
0ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X00D0l/^X00?o0000ooooooooool0:oooool0
06;ooooo00?o000008=7O`23Agl08P23Agl00ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X
00D0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl08@23Agl00ol00000
lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X00H0l/^X00?o0000ooooooooool0:oooool006;ooooo
00?o000008=7O`23Agl08@23Agl00ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X00H0l/^X
00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl08023Agl00ol00000lLVW0?79
Y`0F0?79Y`03o`00003bbjP0l/^X00L0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o0000
08=7O`23Agl08023Agl00ol00000lLVW0?79Y`0F0?79Y`03o`00003bbjP0l/^X00L0l/^X00?o0000
ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl08023Agl00ol00000lLVW0?79Y`0E0?79
Y`03o`00003bbjP0l/^X00P0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23
Agl07`23Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00003bbjP0l/^X00T0l/^X00?o0000oooooooo
ool0:oooool006;ooooo00?o000008=7O`23Agl07`23Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00
003bbjP0l/^X00T0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl07P23
Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00003bbjP0l/^X00X0l/^X00?o0000ooooooooool0:ooo
ool006;ooooo00?o000008=7O`23Agl07P23Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00003bbjP0
l/^X00X0l/^X00?o0000ooooooooool0:oooool006;ooooo00?o000008=7O`23Agl07P23Agl00ol0
0000lLVW0?79Y`0D0?79Y`03o`00003bbjP0l/^X00/0l/^X00?o0000ooooooooool0:oooool006;o
oooo00?o000008=7O`23Agl07@23Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00003bbjP0l/^X00`0
l/^X00?o0000ooooooooool0:_ooool006;ooooo00?o000008=7O`23Agl07@23Agl00ol00000lLVW
0?79Y`0D0?79Y`03o`00003bbjP0l/^X00d0l/^X00?o0000ooooooooool0:_ooool006;ooooo00?o
000008=7O`23Agl07023Agl00ol00000lLVW0?79Y`0E0?79Y`03o`00003bbjP0l/^X00d0l/^X00?o
0000ooooooooool0:_ooool006;ooooo00?o000008=7O`23Agl07023Agl00ol00000lLVW0?79Y`0D
0?79Y`03o`00003bbjP0l/^X00h0l/^X00?o0000ooooooooool0:_ooool006;ooooo00?o000008=7
O`23Agl07023Agl00ol00000lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X00l0l/^X00?o0000oooo
ooooool0:_ooool006;ooooo00?o000008=7O`23Agl06`23Agl00ol00000lLVW0?79Y`0D0?79Y`03
o`00003bbjP0l/^X00l0l/^X00?o0000ooooooooool0:_ooool006;ooooo00?o000008=7O`23Agl0
6`23Agl00ol00000lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X0100l/^X00?o0000ooooooooool0
:_ooool006;ooooo00?o000008=7O`23Agl06P23Agl00ol00000lLVW0?79Y`0D0?79Y`03o`00003b
bjP0l/^X0100l/^X00?o0000ooooooooool0:_ooool006;ooooo00?o000008=7O`23Agl06P23Agl0
0ol00000lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X0140l/^X00?o0000ooooooooool0:_ooool0
06;ooooo00?o000008=7O`23Agl06P23Agl00ol00000lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X
0140l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl06P23Agl00ol00000
lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X0180l/^X00?o0000ooooooooool0:_ooool0067ooooo
00?o000008=7O`23Agl06P23Agl00ol00000lLVW0?79Y`0C0?79Y`03o`00003bbjP0l/^X0180l/^X
00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl06@23Agl00ol00000lLVW0?79
Y`0C0?79Y`03o`00003bbjP0l/^X01<0l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o0000
08=7O`23Agl06@23Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003bbjP0l/^X01@0l/^X00?o0000
ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl06@23Agl00ol00000lLVW0?79Y`0B0?79
Y`03o`00003bbjP0l/^X01@0l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23
Agl06023Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003bbjP0l/^X01D0l/^X00?o0000oooooooo
ool0:_ooool0067ooooo00?o000008=7O`23Agl06023Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00
003bbjP0l/^X01D0l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl05`23
Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003bbjP0l/^X01H0l/^X00?o0000ooooooooool0:_oo
ool0067ooooo00?o000008=7O`23Agl05`23Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003bbjP0
l/^X01H0l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl05`23Agl00ol0
0000lLVW0?79Y`0A0?79Y`03o`00003bbjP0l/^X01L0l/^X00?o0000ooooooooool0:_ooool0067o
oooo00?o000008=7O`23Agl05P23Agl00ol00000lLVW0?79Y`0B0?79Y`03o`00003bbjP0l/^X01L0
l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o000008=7O`23Agl05@23Agl2o`0001<0lLVW
00?o00000?;;Z03bbjP0603bbjP00ol0003oooooooooo`0Zooooo`00HOooool00ol00000PdMo08=7
O`0D08=7O`04o`000?ooool0k/^_o`000140lLVW00?o00000?;;Z03bbjP06@3bbjP00ol0003ooooo
ooooo`0Zooooo`00HOooool00ol00000PdMo08=7O`0C08=7O`03o`000?oooooo00000080k/^_00?o
00000?79Y`3abJL03P3abJL00ol00000l/^X0?;;Z00I0?;;Z003o`000?oooooooooo02[ooooo001Q
ooooo`03o`000023Agl0PdMo0180PdMo00Co0000oooooooooooo00000`3^bjl00ol00000lLVW0?79
Y`0<0?79Y`03o`00003bbjP0l/^X01X0l/^X00?o0000ooooooooool0:_ooool0067ooooo00?o0000
08=7O`23Agl04@23Agl01?l0003oooooooooool000050>k;[`03o`00003abJL0lLVW00/0lLVW00?o
00000?;;Z03bbjP06`3bbjP00ol0003oooooooooo`0Yooooo`00HOooool00ol00000PdMo08=7O`0@
08=7O`05o`000?ooooooooooooooool00000103^bjl2o`0000`0lLVW00?o00000?;;Z03bbjP0703b
bjP00ol0003oooooooooo`0Yooooo`00HOooool00ol00000PdMo08=7O`0?08=7O`05o`000?oooooo
ooooooooool000001P3^bjl2o`0000/0lLVW00?o00000?;;Z03bbjP0703bbjP00ol0003ooooooooo
o`0Yooooo`00HOooool00ol00000PdMo08=7O`0>08=7O`03o`000?oooooooooo00;ooooo00?o0000
0>k;[`3^bjl01@3^bjl2o`0000T0lLVW00?o00000?;;Z03bbjP07@3bbjP00ol0003oooooooooo`0Y
ooooo`00HOooool00ol00000PdMo08=7O`0=08=7O`03o`000?oooooooooo00;ooooo00?o00000>k;
[`3^bjl0203^bjl00ol00000lLVW0?79Y`060?79Y`03o`00003bbjP0l/^X01d0l/^X00?o0000oooo
ooooool0:Oooool0067ooooo00?o000008=7O`23Agl03023Agl00ol0003oooooooooo`03ooooo`03
o`00003^bjl0k/^_00T0k/^_00?o00000?79Y`3abJL0103abJL00ol00000l/^X0?;;Z00N0?;;Z003
o`000?oooooooooo02Wooooo001Qooooo`03o`000023Agl0PdMo00/0PdMo00?o0000ooooooooool0
0oooool00ol00000k/^_0>k;[`090>k;[`;o00001@3abJL00ol00000l/^X0?;;Z00O0?;;Z003o`00
0?oooooooooo02Wooooo001Qooooo`03o`000023Agl0PdMo00X0PdMo00?o0000ooooooooool01?oo
ool00ol00000k/^_0>k;[`0:0>k;[`;o0000103abJL00ol00000l/^X0?;;Z00O0?;;Z003o`000?oo
oooooooo02Wooooo001Qooooo`03o`000023Agl0PdMo00T0PdMo00?o0000ooooooooool01?ooool0
0ol00000k/^_0>k;[`0<0>k;[`;o00000P3abJL00ol00000l/^X0?;;Z00P0?;;Z003o`000?oooooo
oooo02Wooooo001Qooooo`03o`000023Agl0PdMo00P0PdMo00?o0000ooooooooool01Oooool00ol0
0000k/^_0>k;[`0=0>k;[`;o000000<0lLVWo`00003bbjP08@3bbjP00ol0003oooooooooo`0Yoooo
o`00HOooool00ol00000PdMo08=7O`0708=7O`03o`000?oooooooooo00Gooooo00?o00000>k;[`3^
bjl03P3^bjl00ol00000k/^_o`00000S0?;;Z003o`000?oooooooooo02Wooooo001Qooooo`03o`00
0023Agl0PdMo00H0PdMo00?o0000ooooooooool01_ooool00ol00000k/^_0>k;[`0?0>k;[`;o0000
8`3bbjP00ol0003oooooooooo`0Yooooo`00HOooool00ol00000PdMo08=7O`0508=7O`03o`000?oo
oooooooo00Oooooo00?o00000>k;[`3^bjl0403^bjl2o`000280l/^X00?o0000ooooooooool0:Ooo
ool0067ooooo00?o000008=7O`23Agl01023Agl00ol0003oooooooooo`07ooooo`03o`00003^bjl0
k/^_0180k/^_0_l0000Q0?;;Z003o`000?oooooooooo02Wooooo001Qooooo`03o`000023Agl0PdMo
00<0PdMo00?o0000ooooooooool02?ooool00ol00000k/^_0>k;[`0B0>k;[`?o00007`3bbjP00ol0
003oooooooooo`0Zooooo`00HOooool00ol00000PdMo08=7O`0208=7O`03o`000?oooooooooo00So
oooo00?o00000>k;[`3^bjl04`3^bjl00ol00000JQ11o`000002o`0001d0l/^X00?o0000oooooooo
ool0:_ooool0067ooooo00Go000008=7O`23Agl0PdMoo`00000;ooooo`03o`00003^bjl0k/^_01<0
k/^_00Go000006X@@@1Z447o0000ooooo`02o`0001X0l/^X00?o0000ooooooooool0:oooool0067o
oooo00Co000008=7O`23Agoo00002oooool00ol00000k/^_0>k;[`0D0>k;[`04o`00001Z4440JQ11
o`0000;ooooo0_l0000I0?;;Z003o`000?oooooooooo02_ooooo001Qooooo`03o`000023Agoo0000
00cooooo00?o00000>k;[`3^bjl0503^bjl01?l00000JQ1106X@@Ol00002ooooo`04o`00001Z447o
0000o`0001H0l/^X00?o0000ooooooooool0;?ooool0067ooooo0_l0000<ooooo`03o`00003^bjl0
k/^_01D0k/^_00Co000006X@@@1Z447o00000_ooool01?l00000JQ1106X@@@1Z4442o`0001@0l/^X
00?o0000ooooooooool0;?ooool0067ooooo00?o0000ooooooooool02oooool00ol00000k/^_0>k;
[`0E0>k;[`03o`00001Z447o000000;ooooo00?o000006X@@@1Z4440101Z44400ol00000l/^X0?;;
Z00@0?;;Z003o`000?oooooooooo02gooooo001^ooooo`03o`00003^bjl0k/^_01H0k/^_00?o0000
06X@@Ol000000_ooool00ol00000JQ1106X@@@0506X@@@;o00003`3bbjP00ol0003oooooooooo`0^
ooooo`00K_ooool00ol00000k/^_0>k;[`0F0>k;[`03o`00001Z447o000000;ooooo00?o000006X@
@@1Z44401`1Z44400ol00000l/^X0?;;Z00<0?;;Z003o`000?oooooooooo02kooooo001]ooooo`03
o`00003^bjl0k/^_01L0k/^_00Go000006X@@Ol0003oooooo`00000;06X@@@;o00002`3bbjP00ol0
003oooooooooo`0_ooooo`00KOooool00ol00000k/^_0>k;[`0G0>k;[`05o`00001Z447o0000oooo
ool000003@1Z4442o`0000T0l/^X00?o0000ooooooooool0;oooool006cooooo00?o00000>k;[`3^
bjl0603^bjl01Ol00000JQ11o`000?oooooo000000l0JQ1100?o00000?;;Z03bbjP01@3bbjP00ol0
003oooooooooo`0`ooooo`00K?ooool00ol00000k/^_0>k;[`0H0>k;[`04o`00001Z447o0000o`00
0140JQ110_l000050?;;Z003o`000?oooooooooo033ooooo001/ooooo`;o00006@3^bjl2o`000003
ooooool00000JQ110180JQ110_l000020?;;Z003o`000?oooooooooo037ooooo001Zooooo`;o0000
0P1Z44400ol00000k/^_0>k;[`0F0>k;[`;o000000?oooooo`00001Z4440501Z44400ol00000l/^X
o`00000cooooo`00J?ooool2o`0000D0JQ1100?o00000>k;[`3^bjl05@3^bjl2o`000003ooooool0
0000JQ1101<0JQ110ol0000dooooo`00Ioooool00ol00000JQ1106X@@@0606X@@@03o`00003^bjl0
k/^_01@0k/^_0ol0000B06X@@@Co000000<0JQ11o`000?ooool0<oooool006Gooooo0_l0000:06X@
@@03o`00003^bjl0k/^_01<0k/^_0ol0000?06X@@@?o00000P1Z44401?l00000JQ1106X@@Ol0000d
ooooo`00Hoooool2o`0000d0JQ1100?o00000>k;[`3^bjl04P3^bjl3o`0000`0JQ110ol0000406X@
@@03o`00001Z4440JQ110080JQ1100?o0000ooooooooool0<Oooool006;ooooo00?o000006X@@@1Z
44403P1Z44400ol00000k/^_0>k;[`0A0>k;[`;o00002@1Z4444o`0000H0JQ1100?o000006X@@@1Z
44400`1Z44400ol0003oooooooooo`0aooooo`00H?ooool2o`000180JQ1100?o00000>k;[`3^bjl0
3`3^bjl3o`0000H0JQ110ol0000906X@@@03o`00001Z4440JQ1100@0JQ1100?o0000ooooooooool0
<Oooool005kooooo0_l0000E06X@@@03o`00003^bjl0k/^_00h0k/^_0ol0000306X@@@?o00002P1Z
4442o`0000L0JQ1100?o0000ooooooooool0<Oooool005gooooo00?o000006X@@@1Z44405@1Z4440
0ol00000k/^_0>k;[`0>0>k;[`;o000000@0JQ11o`000?l0003o0000301Z44400ol00000JQ1106X@
@@0706X@@@03o`000?oooooooooo037ooooo001Kooooo`;o00006@1Z44400ol00000k/^_0>k;[`0=
0>k;[`?o00003P1Z44400ol00000JQ1106X@@@0906X@@@03o`000?oooooooooo033ooooo001Ioooo
o`;o0000701Z44400ol00000k/^_0>k;[`0<0>k;[`03o`00001Z4440JQ1100d0JQ1100?o000006X@
@@1Z44402P1Z44400ol0003oooooooooo`0`ooooo`00F?ooool00ol00000JQ1106X@@@0M06X@@@03
o`00003^bjl0k/^_00/0k/^_00?o000006X@@@1Z4440301Z44400ol00000JQ1106X@@@0;06X@@@03
o`000?oooooooooo033ooooo001Fooooo`;o00008@1Z44400ol00000k/^_0>k;[`0:0>k;[`03o`00
001Z4440JQ1100/0JQ1100?o000006X@@@1Z4440301Z44400ol0003oooooooooo`0`ooooo`00E?oo
ool2o`0002@0JQ1100?o00000>k;[`3^bjl02@3^bjl00ol00000JQ1106X@@@0906X@@@;o00003`1Z
44400ol0003oooooooooo`0`ooooo`00D_ooool2o`0002L0JQ1100?o00000>k;[`3^bjl0203^bjl0
0ol00000JQ1106X@@@0806X@@@03o`00001Z4440JQ110100JQ1100?o0000ooooooooool0;oooool0
057ooooo00?o000006X@@@1Z4440:01Z44400ol00000k/^_0>k;[`070>k;[`03o`00001Z4440JQ11
00L0JQ1100?o000006X@@@1Z44404@1Z44400ol0003oooooooooo`0_ooooo`00Coooool2o`0002`0
JQ1100?o00000>k;[`3^bjl01P3^bjl00ol00000JQ1106X@@@0606X@@@03o`00001Z4440JQ110180
JQ1100?o0000ooooooooool0;oooool004gooooo0_l0000^06X@@@03o`00003^bjl0k/^_00H0k/^_
00?o000006X@@@1Z44401@1Z44400ol00000JQ1106X@@@0C06X@@@03o`000?oooooooooo02oooooo
001<ooooo`03o`00001Z4440JQ1102l0JQ1100?o00000>k;[`3^bjl01@3^bjl00ol00000JQ1106X@
@@0406X@@@03o`00001Z4440JQ1101@0JQ1100?o0000ooooooooool0;oooool004[ooooo0_l0000c
06X@@@03o`00003^bjl0k/^_00@0k/^_00?o000006X@@@1Z44400`1Z44400ol00000JQ1106X@@@0F
06X@@@03o`000?oooooooooo02kooooo0018ooooo`;o0000=P1Z44400ol00000k/^_0>k;[`030>k;
[`04o`00001Z4440JQ1106X@@@;o00006@1Z44400ol0003oooooooooo`0^ooooo`00Aoooool00ol0
0000JQ1106X@@@0g06X@@@03o`00003^bjl0k/^_0080k/^_00Co000006X@@@1Z447o00006`1Z4440
0ol0003oooooooooo`0^ooooo`00AOooool2o`0003/0JQ1100Oo00000>k;[`3^bjl0k/^_o`00001Z
447o000001`0JQ1100?o0000ooooooooool0;_ooool004?ooooo0_l0000n06X@@@03o`00003^bjl0
k/^_00;o00007@1Z44400ol0003oooooooooo`0^ooooo`00@_ooool00ol00000JQ1106X@@@0n06X@
@@;o000000<0k/^_o`00001Z44407P1Z44400ol0003oooooooooo`0]ooooo`00@?ooool2o`000400
JQ1100?o000006X@@@1Z44400_l0000O06X@@@03o`000?oooooooooo02gooooo000nooooo`;o0000
@P1Z4443o`00000306X@@Ol00000JQ1101/0JQ111?l0000_ooooo`00?Oooool00ol00000JQ1106X@
@@1106X@@@?o00006@1Z4446o`0003?ooooo000kooooo`;o0000@P1Z4444o`0001@0JQ111_l0000i
ooooo`00>_ooool00ol00000JQ1106X@@@1106X@@@05o`000?ooooooooooooooool000003`1Z4445
o`0003oooooo000jooooo`03o`00001Z4440JQ110400JQ1100?o0000ooooooooool00_ooool00ol0
0000JQ1106X@@@0706X@@@Ko0000A?ooool003_ooooo00?o000006X@@@1Z4440?P1Z44400ol0003o
ooooooooo`04ooooo`03o`00001Z4440JQ1100Ko0000B_ooool003_ooooo00?o000006X@@@1Z4440
?@1Z44400ol0003oooooooooo`05ooooo`?o0000D?ooool003cooooo00?o000006X@@@1Z4440>P1Z
4442o`0005_ooooo000mooooo`03o`00001Z4440JQ1103L0JQ110_l0001Mooooo`00?Oooool00ol0
0000JQ1106X@@@0f06X@@@03o`000?oooooooooo05gooooo000nooooo`03o`00001Z4440JQ1103<0
JQ110_l0001Pooooo`00?_ooool00ol00000JQ1106X@@@0a06X@@@;o0000H_ooool003oooooo00?o
000006X@@@1Z4440;`1Z44400ol0003oooooooooo`1Rooooo`00@?ooool00ol00000JQ1106X@@@0/
06X@@@;o0000IOooool0043ooooo00?o000006X@@@1Z4440:P1Z4442o`0006Oooooo0011ooooo`03
o`00001Z4440JQ1102P0JQ1100?o0000ooooooooool0Ioooool0047ooooo00?o000006X@@@1Z4440
9P1Z4442o`0006[ooooo0012ooooo`03o`00001Z4440JQ1102<0JQ110_l0001/ooooo`00@_ooool0
0ol00000JQ1106X@@@0Q06X@@@;o0000K_ooool004?ooooo00?o000006X@@@1Z44407`1Z44400ol0
003oooooooooo`1^ooooo`00A?ooool00ol00000JQ1106X@@@0L06X@@@;o0000LOooool004Cooooo
00?o000006X@@@1Z44406P1Z4442o`0007?ooooo0015ooooo`03o`00001Z4440JQ1101P0JQ1100?o
0000ooooooooool0Loooool004Gooooo00?o000006X@@@1Z44405P1Z4442o`0007Kooooo0016oooo
o`03o`00001Z4440JQ1101<0JQ110_l0001hooooo`00A_ooool00ol00000JQ1106X@@@0A06X@@@;o
0000N_ooool004Oooooo00?o000006X@@@1Z44403`1Z44400ol0003oooooooooo`1jooooo`00B?oo
ool00ol00000JQ1106X@@@0<06X@@@;o0000OOooool004Sooooo00?o000006X@@@1Z44402P1Z4442
o`0007oooooo0019ooooo`03o`00001Z4440JQ1100P0JQ1100?o0000ooooooooool0Ooooool004Wo
oooo00?o000006X@@@1Z44401P1Z4442o`0008;ooooo001:ooooo`03o`00001Z4440JQ1100<0JQ11
0_l00024ooooo`00Boooool01Ol00000JQ1106X@@@1Z447o000008Kooooo001;ooooo`04o`00001Z
447o0000o`0008Oooooo001<ooooo`03o`000?oooooooooo08Oooooo003Fooooo`00e_ooool00=Ko
oooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00\
\>"],
  ImageRangeCache->{{{0, 213.688}, {209.625, 0}} -> {0.0113312, -8.02233*^-5, \
0.00445867, 0.00445867}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0336 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0351211 1.09964 0 1.09964 [
[ 0 0 0 0 ]
[ 1 1.0336 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0336 L
0 1.0336 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.3569 .75357 m .63703 .45392 L p .63155 .66683 L .271 0 .294 r
F P
0 g
s
.43277 .88932 m .3569 .75357 L p .63155 .66683 L .271 0 .294 r
F P
0 g
s
.73954 .42517 m .74272 .4711 L .7546 .43421 L p 0 0 .369 r
F P
0 g
s
.7546 .43421 m .7512 .38793 L .73954 .42517 L p 0 0 .369 r
F P
0 g
s
.63703 .45392 m .65387 .46586 L p .63155 .66683 L .271 0 .294 r
F P
0 g
s
.65805 .39392 m .45197 .12668 L p .76706 .15357 L .671 .73 .894 r
F P
0 g
s
.71195 .37564 m .65805 .39392 L p .76706 .15357 L .671 .73 .894 r
F P
0 g
s
.766 .34065 m .7512 .38793 L .7546 .43421 L p 0 0 .369 r
F P
0 g
s
.65387 .46586 m .64763 .57789 L .63155 .66683 L p .271 0 .294 r
F P
0 g
s
.766 .34065 m .71195 .37564 L p .76706 .15357 L .671 .73 .894 r
F P
0 g
s
.67005 .45382 m .64763 .57789 L .74765 .50981 L p .271 0 .294 r
F P
0 g
s
.74765 .50981 m .7148 .42204 L .67005 .45382 L p .271 0 .294 r
F P
0 g
s
.7546 .43421 m .7697 .38737 L .766 .34065 L p 0 0 .369 r
F P
0 g
s
.74765 .50981 m .7148 .42204 L .7697 .38737 L p .271 0 .294 r
F P
0 g
s
.77804 .30219 m .766 .34065 L p .76706 .15357 L .671 .73 .894 r
F P
0 g
s
.766 .34065 m .77804 .30219 L .7888 .4302 L p 0 0 .369 r
F P
0 g
s
.7888 .4302 m .7697 .38737 L .766 .34065 L p 0 0 .369 r
F P
0 g
s
.7697 .38737 m .7888 .4302 L .74765 .50981 L p .271 0 .294 r
F P
0 g
s
.76706 .15357 m .77791 .1807 L .77804 .30219 L p .671 .73 .894 r
F P
0 g
s
.77804 .30219 m .77791 .1807 L .77862 .18888 L p 0 0 .141 r
F P
0 g
s
.77862 .18888 m .7888 .4302 L .77804 .30219 L p 0 0 .141 r
F P
0 g
s
.64763 .57789 m .63155 .66683 L .63851 .66224 L p .271 0 .294 r
F P
0 g
s
.63851 .66224 m .74765 .50981 L .64763 .57789 L p .271 0 .294 r
F P
0 g
s
.7888 .4302 m .74765 .50981 L p .76706 .15357 L .946 .793 .659 r
F P
0 g
s
.76706 .15357 m .77862 .18888 L .7888 .4302 L p .946 .793 .659 r
F P
0 g
s
.77862 .18888 m .77788 .15185 L .77791 .1807 L closepath p 0 0 .141 r
F P
0 g
s
.74765 .50981 m .62358 .43004 L p .76706 .15357 L .946 .793 .659 r
F P
0 g
s
.77514 .6288 m .74765 .50981 L .63851 .66224 L p .271 0 .294 r
F P
0 g
s
.45197 .12668 m .68943 .03188 L .76706 .15357 L p .671 .73 .894 r
F P
0 g
s
.62358 .43004 m .61767 .41511 L .76706 .15357 L p .946 .793 .659 r
F P
0 g
s
.68943 .03188 m .76706 .15357 L .61767 .41511 L p .942 .785 .657 r
F P
0 g
s
.45197 .12668 m .68943 .03188 L .56269 .34641 L p .51 .276 .496 r
F P
0 g
s
.44481 .46374 m .45197 .12668 L p .56269 .34641 L .51 .276 .496 r
F P
0 g
s
.60208 .70849 m .43277 .88932 L p .63155 .66683 L .271 0 .294 r
F P
0 g
s
.63155 .66683 m .62608 .67892 L .60208 .70849 L p .271 0 .294 r
F P
0 g
s
.63851 .66224 m .62972 .67697 L .63155 .66683 L closepath p .271 0 .294 r
F P
0 g
s
.63664 .69315 m .77514 .6288 L p .63851 .66224 L .271 0 .294 r
F P
0 g
s
.63851 .66224 m .63125 .67658 L .63664 .69315 L p .271 0 .294 r
F P
0 g
s
.61767 .41511 m .56269 .34641 L .68943 .03188 L p .942 .785 .657 r
F P
0 g
s
.49651 .48655 m .62123 .62586 L .62358 .43004 L p .93 .791 .686 r
F P
0 g
s
.61767 .41511 m .62358 .43004 L .56036 .35134 L p .93 .791 .686 r
F P
0 g
s
.62358 .43004 m .56036 .35134 L .49651 .48655 L p .93 .791 .686 r
F P
0 g
s
.56036 .35134 m .56269 .34641 L .61767 .41511 L p .93 .791 .686 r
F P
0 g
s
.56269 .34641 m .56036 .35134 L .44481 .46374 L p .51 .276 .496 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 222},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000gR000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool009;ooooo0_l00012ooooo`00
Soooool3o`0000030896O_l0003ooooo047ooooo002=ooooo`;o00000`22AWh00ol00000lLRXo`00
0011ooooo`00R_ooool3o`0000D0PTIn00Co00000?78Z03ab:So0000@?ooool008Sooooo0_l00008
0896OP04o`00003ab:P0lLRXo`00043ooooo0026ooooo`;o00002@22AWh00ol00000lLRX0?78Z002
0?78Z003o`000?oooooooooo03gooooo0023ooooo`?o00002`22AWh00ol00000lLRX0?78Z0030?78
Z003o`000?oooooooooo03cooooo0021ooooo`;o00003@22AWh00ol00000lLRX0?78Z0040?78Z003
o`000?oooooooooo03cooooo001nooooo`?o00003`22AWh00ol00000lLRX0?78Z0050?78Z003o`00
0?oooooooooo03_ooooo001looooo`;o00004P22AWh00ol00000lLRX0?78Z0060?78Z003o`000?oo
oooooooo03[ooooo001iooooo`?o00004`22AWh00ol00000lLRX0?78Z0070?78Z003o`000?oooooo
oooo03[ooooo001gooooo`;o00005P22AWh00ol00000lLRX0?78Z0080?78Z003o`000?oooooooooo
03Wooooo001eooooo`;o00005`22AWh00ol00000lLRX0?78Z00:0?78Z003o`000?oooooooooo03So
oooo001booooo`?o00006@22AWh00ol00000lLRX0?78Z00:0?78Z003o`000?oooooooooo03Sooooo
001`ooooo`;o00007022AWh00ol00000lLRX0?78Z00;0?78Z003o`000?oooooooooo03Oooooo001]
ooooo`?o00007@22AWh00ol00000lLRX0?78Z00<0?78Z003o`000?oooooooooo03Oooooo001[oooo
o`;o00008022AWh00ol00000lLRX0?78Z00=0?78Z003o`000?oooooooooo03Kooooo001Xooooo`?o
00008@22AWh00ol00000lLRX0?78Z00?0?78Z003o`000?oooooooooo03Gooooo001Vooooo`;o0000
9022AWh00ol00000lLRX0?78Z00?0?78Z003o`000?oooooooooo03Gooooo001Tooooo`;o00009P22
AWh00ol00000lLRX0?78Z00@0?78Z003o`000?oooooooooo03Cooooo001Qooooo`?o00009`22AWh0
0ol00000lLRX0?78Z00B0?78Z003o`000?oooooooooo03?ooooo001Pooooo`03o`000022AWh0PTIn
02P0PTIn00?o00000?78Z03ab:P04P3ab:P00ol0003oooooooooo`0cooooo`00H?ooool00ol00000
PTIn0896OP0W0896OP03o`00003ab:P0lLRX01@0lLRX00?o0000ooooooooool0<_ooool0063ooooo
00?o00000896OP22AWh09`22AWh00ol00000lLRX0?78Z00E0?78Z003o`000?oooooooooo037ooooo
001Pooooo`03o`000022AWh0PTIn02L0PTIn00?o00000?78Z03ab:P05@3ab:P00ol0003ooooooooo
o`0aooooo`00H?ooool00ol00000PTIn0896OP0V0896OP03o`00003ab:P0lLRX01L0lLRX00?o0000
ooooooooool0<?ooool0063ooooo00?o00000896OP22AWh09P22AWh00ol00000lLRX0?78Z00H0?78
Z003o`000?oooooo000002oooooo001Pooooo`03o`000022AWh0PTIn02D0PTIn00?o00000?78Z03a
b:P06@3ab:P00ol0003oooooo`00000_ooooo`00H?ooool00ol00000PTIn0896OP0U0896OP03o`00
003ab:P0lLRX01P0lLRX1?l0000_ooooo`00H?ooool00ol00000PTIn0896OP0U0896OP03o`00003a
b:P0lLRX01P0lLRX00Co00000?;;Z?l0003o0000;oooool0063ooooo00?o00000896OP22AWh09022
AWh00ol00000lLRX0?78Z00H0?78Z003o`00003bbjP0l/^X00;o0000;oooool0063ooooo00?o0000
0896OP22AWh09022AWh00ol00000lLRX0?78Z00G0?78Z004o`00003bbjP0l/^X0?;;Z0;o0000;ooo
ool0063ooooo00?o00000896OP22AWh08`22AWh00ol00000lLRX0?78Z00H0?78Z004o`00003bbjP0
l/^X0?;;Z0;o0000;oooool0063ooooo00?o00000896OP22AWh08`22AWh00ol00000lLRX0?78Z00G
0?78Z003o`00003bbjP0l/^X00<0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896
OP22AWh08`22AWh00ol00000lLRX0?78Z00G0?78Z003o`00003bbjP0l/^X00<0l/^X00?o0000oooo
ooooool0;Oooool0063ooooo00?o00000896OP22AWh08P22AWh00ol00000lLRX0?78Z00G0?78Z003
o`00003bbjP0l/^X00@0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh0
8P22AWh00ol00000lLRX0?78Z00G0?78Z003o`00003bbjP0l/^X00@0l/^X00?o0000ooooooooool0
;Oooool0063ooooo00?o00000896OP22AWh08P22AWh00ol00000lLRX0?78Z00F0?78Z003o`00003b
bjP0l/^X00D0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh08@22AWh0
0ol00000lLRX0?78Z00F0?78Z003o`00003bbjP0l/^X00H0l/^X00?o0000ooooooooool0;Oooool0
063ooooo00?o00000896OP22AWh08@22AWh00ol00000lLRX0?78Z00F0?78Z003o`00003bbjP0l/^X
00H0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh08022AWh00ol00000
lLRX0?78Z00F0?78Z003o`00003bbjP0l/^X00L0l/^X00?o0000ooooooooool0;Oooool0063ooooo
00?o00000896OP22AWh08022AWh00ol00000lLRX0?78Z00F0?78Z003o`00003bbjP0l/^X00L0l/^X
00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh08022AWh00ol00000lLRX0?78
Z00E0?78Z003o`00003bbjP0l/^X00P0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o0000
0896OP22AWh07`22AWh00ol00000lLRX0?78Z00F0?78Z003o`00003bbjP0l/^X00P0l/^X00?o0000
ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh07`22AWh00ol00000lLRX0?78Z00E0?78
Z003o`00003bbjP0l/^X00T0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22
AWh07P22AWh00ol00000lLRX0?78Z00E0?78Z003o`00003bbjP0l/^X00X0l/^X00?o0000oooooooo
ool0;Oooool0063ooooo00?o00000896OP22AWh07P22AWh00ol00000lLRX0?78Z00E0?78Z003o`00
003bbjP0l/^X00X0l/^X00?o0000ooooooooool0;Oooool0063ooooo00?o00000896OP22AWh07P22
AWh00ol00000lLRX0?78Z00D0?78Z003o`00003bbjP0l/^X00/0l/^X00?o0000ooooooooool0;Ooo
ool0063ooooo00?o00000896OP22AWh07@22AWh00ol00000lLRX0?78Z00E0?78Z003o`00003bbjP0
l/^X00`0l/^X00?o0000ooooooooool0;?ooool0063ooooo00?o00000896OP22AWh07@22AWh00ol0
0000lLRX0?78Z00D0?78Z003o`00003bbjP0l/^X00d0l/^X00?o0000ooooooooool0;?ooool0063o
oooo00?o00000896OP22AWh07022AWh00ol00000lLRX0?78Z00E0?78Z003o`00003bbjP0l/^X00d0
l/^X00?o0000ooooooooool0;?ooool0063ooooo00?o00000896OP22AWh07022AWh00ol00000lLRX
0?78Z00D0?78Z003o`00003bbjP0l/^X00h0l/^X00?o0000ooooooooool0;?ooool0063ooooo00?o
00000896OP22AWh07022AWh00ol00000lLRX0?78Z00C0?78Z003o`00003bbjP0l/^X00l0l/^X00?o
0000ooooooooool0;?ooool0063ooooo00?o00000896OP22AWh06`22AWh00ol00000lLRX0?78Z00D
0?78Z003o`00003bbjP0l/^X00l0l/^X00?o0000ooooooooool0;?ooool0063ooooo00?o00000896
OP22AWh06`22AWh00ol00000lLRX0?78Z00C0?78Z003o`00003bbjP0l/^X0100l/^X00?o0000oooo
ooooool0;?ooool0063ooooo00?o00000896OP22AWh06P22AWh00ol00000lLRX0?78Z00D0?78Z003
o`00003bbjP0l/^X0100l/^X00?o0000ooooooooool0;?ooool0063ooooo00?o00000896OP22AWh0
6P22AWh00ol00000lLRX0?78Z00C0?78Z003o`00003bbjP0l/^X0140l/^X00?o0000ooooooooool0
;?ooool0063ooooo00?o00000896OP22AWh06P22AWh00ol00000lLRX0?78Z00C0?78Z003o`00003b
bjP0l/^X0140l/^X00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22AWh06P22AWh0
0ol00000lLRX0?78Z00C0?78Z003o`00003bbjP0l/^X0180l/^X00?o0000ooooooooool0;?ooool0
05oooooo00?o00000896OP22AWh06P22AWh00ol00000lLRX0?78Z00B0?78Z003o`00003bbjP0l/^X
01<0l/^X00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22AWh06@22AWh00ol00000
lLRX0?78Z00C0?78Z003o`00003bbjP0l/^X01<0l/^X00?o0000ooooooooool0;?ooool005oooooo
00?o00000896OP22AWh06@22AWh00ol00000lLRX0?78Z00B0?78Z003o`00003bbjP0l/^X01@0l/^X
00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22AWh06@22AWh00ol00000lLRX0?78
Z00B0?78Z003o`00003bbjP0l/^X01@0l/^X00?o0000ooooooooool0;?ooool005oooooo00?o0000
0896OP22AWh06022AWh00ol00000lLRX0?78Z00B0?78Z003o`00003bbjP0l/^X01D0l/^X00?o0000
ooooooooool0;?ooool005oooooo00?o00000896OP22AWh06022AWh00ol00000lLRX0?78Z00B0?78
Z003o`00003bbjP0l/^X01D0l/^X00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22
AWh05`22AWh00ol00000lLRX0?78Z00B0?78Z003o`00003bbjP0l/^X01H0l/^X00?o0000oooooooo
ool0;?ooool005oooooo00?o00000896OP22AWh05`22AWh00ol00000lLRX0?78Z00A0?78Z003o`00
003bbjP0l/^X01L0l/^X00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22AWh05`22
AWh00ol00000lLRX0?78Z00A0?78Z003o`00003bbjP0l/^X01L0l/^X00?o0000ooooooooool0;?oo
ool005oooooo00?o00000896OP22AWh05P22AWh00ol00000lLRX0?78Z00A0?78Z003o`00003bbjP0
l/^X01P0l/^X00?o0000ooooooooool0;?ooool005oooooo00?o00000896OP22AWh05@22AWh2o`00
01<0lLRX00?o00000?;;Z03bbjP0603bbjP00ol0003oooooooooo`0/ooooo`00Goooool00ol00000
PTIn0896OP0D0896OP;o000000<0k/Z_o`00003ab:P0403ab:P00ol00000l/^X0?;;Z00I0?;;Z003
o`000?oooooooooo02cooooo001Oooooo`03o`000022AWh0PTIn01<0PTIn0_l00000103^bZoo0000
0>k:[ol0000@0?78Z003o`00003bbjP0l/^X01T0l/^X00?o0000ooooooooool0;?ooool005oooooo
00?o00000896OP22AWh04P22AWh00ol0003oooooo`0000020>k:[`03o`00003^bZoo000000h0lLRX
00?o00000?;;Z03bbjP06P3bbjP00ol0003oooooooooo`0/ooooo`00Goooool00ol00000PTIn0896
OP0A0896OP03o`000?oooooo000000@0k/Z_00?o00000>k:[ol00000303ab:P00ol00000l/^X0?;;
Z00L0?;;Z003o`000?oooooooooo02_ooooo001Oooooo`03o`000022AWh0PTIn0100PTIn00Co0000
oooooooooooo00001@3^bZl00ol00000k/Z_o`00000;0?78Z003o`00003bbjP0l/^X01`0l/^X00?o
0000ooooooooool0:oooool005oooooo00?o00000896OP22AWh03`22AWh01Ol0003ooooooooooooo
oooo000000H0k/Z_00?o00000>k:[ol000002@3ab:P00ol00000l/^X0?;;Z00M0?;;Z003o`000?oo
oooooooo02_ooooo001Oooooo`03o`000022AWh0PTIn00h0PTIn00Go0000ooooooooooooooooo`00
00080>k:[`;o00002@3ab:P00ol00000l/^X0?;;Z00M0?;;Z003o`000?oooooooooo02_ooooo001O
ooooo`03o`000022AWh0PTIn00d0PTIn00?o0000ooooooooool00_ooool00ol00000k/Z_0>k:[`07
0>k:[`;o00001`3ab:P00ol00000l/^X0?;;Z00N0?;;Z003o`000?oooooooooo02_ooooo001Ooooo
o`03o`000022AWh0PTIn00`0PTIn00?o0000ooooooooool00_ooool00ol00000k/Z_0>k:[`080>k:
[`03o`00003^bZoo000000H0lLRX00?o00000?;;Z03bbjP07P3bbjP00ol0003oooooooooo`0[oooo
o`00Goooool00ol00000PTIn0896OP0;0896OP03o`000?oooooooooo00?ooooo00?o00000>k:[`3^
bZl02@3^bZl00ol00000k/Z_o`0000040?78Z003o`00003bbjP0l/^X01l0l/^X00?o0000oooooooo
ool0:oooool005oooooo00?o00000896OP22AWh02P22AWh00ol0003oooooooooo`03ooooo`03o`00
003^bZl0k/Z_00/0k/Z_00?o00000>k:[ol000000P3ab:P00ol00000l/^X0?;;Z00P0?;;Z003o`00
0?oooooooooo02_ooooo001Oooooo`03o`000022AWh0PTIn00T0PTIn00?o0000ooooooooool01?oo
ool00ol00000k/Z_0>k:[`0<0>k:[`05o`00003^bZoo00000?78Z?l000008P3bbjP00ol0003ooooo
ooooo`0[ooooo`00Goooool00ol00000PTIn0896OP080896OP03o`000?oooooooooo00Cooooo00?o
00000>k:[`3^bZl03P3^bZl00ol00000k/Z_o`00000S0?;;Z003o`000?oooooooooo02_ooooo001O
ooooo`03o`000022AWh0PTIn00L0PTIn00?o0000ooooooooool01Oooool00ol00000k/Z_0>k:[`0?
0>k:[`;o00008`3bbjP00ol0003oooooooooo`0[ooooo`00Goooool00ol00000PTIn0896OP060896
OP03o`000?oooooooooo00Gooooo00?o00000>k:[`3^bZl04@3^bZl2o`000280l/^X00?o0000oooo
ooooool0:oooool005oooooo00?o00000896OP22AWh01@22AWh00ol0003oooooooooo`06ooooo`03
o`00003^bZl0k/Z_0180k/Z_0_l0000Q0?;;Z003o`000?oooooooooo02_ooooo001Oooooo`03o`00
0022AWh0PTIn00@0PTIn00?o0000ooooooooool01oooool00ol00000k/Z_0>k:[`0B0>k:[`03o`00
0?oooooo00000200l/^X00?o0000ooooooooool0:oooool005oooooo00?o00000896OP22AWh00`22
AWh00ol0003oooooooooo`07ooooo`03o`00003^bZl0k/Z_01<0k/Z_00?o0000ooooooooool00_l0
000M0?;;Z003o`000?oooooooooo02cooooo001Oooooo`03o`000022AWh0PTIn0080PTIn00?o0000
ooooooooool02?ooool00ol00000k/Z_0>k:[`0C0>k:[`03o`000?oooooooooo00;ooooo00?o0000
0?;;Z03bbjP06P3bbjP00ol0003oooooooooo`0/ooooo`00Goooool01Ol00000PTIn0896OP22AWko
000000[ooooo00?o00000>k:[`3^bZl0503^bZl00ol0003oooooooooo`03ooooo`;o00006@3bbjP0
0ol0003oooooooooo`0]ooooo`00Goooool01?l00000PTIn0896O_l0000;ooooo`03o`00003^bZl0
k/Z_01@0k/Z_00?o0000ooooooooool01Oooool00ol00000l/^X0?;;Z00F0?;;Z003o`000?oooooo
oooo02gooooo001Oooooo`03o`000022AWko000000_ooooo00?o00000>k:[`3^bZl05@3^bZl00ol0
003oooooooooo`02o`0000Cooooo00?o00000?;;Z03bbjP0503bbjP00ol0003oooooooooo`0^oooo
o`00Goooool2o`0000cooooo00?o00000>k:[`3^bZl05@3^bZl00ol0003oooooooooo`0204D0B`03
o`000?oooooooooo00;ooooo0_l0000D0?;;Z003o`000?oooooooooo02kooooo001Oooooo`03o`00
0?oooooooooo00[ooooo00?o00000>k:[`3^bZl05P3^bZl00ol0003oooooo`00000304D0B`07o`00
0?ooooooooooooooool00000A@1;o`00000B0?;;Z003o`000?oooooooooo02oooooo001/ooooo`03
o`00003^bZl0k/Z_01H0k/Z_0_l000001Om504/0A@1;04D0B`1504_o000000?ooooo00?o000004D0
B`1504/00_l0000@0?;;Z003o`000?oooooooooo02oooooo001/ooooo`03o`00003^bZl0k/Z_01H0
k/Z_00?o0000odD0Bom504/00`1504/01?l0003oooooooooool0000504D0B`03o`00003bbjP0l/^X
00`0l/^X00?o0000ooooooooool0<?ooool006_ooooo00?o00000>k:[`3^bZl05`3^bZl00ol0003o
A@1;odD0B`0304D0B`04o`000?ooooooooooo`0000H0A@1;0_l0000<0?;;Z003o`000?oooooooooo
033ooooo001[ooooo`03o`00003^bZl0k/Z_01L0k/Z_00?o0000odD0Bom504/00`1504/01?l0003o
ooooooooool0000804D0B`03o`00003bbjP0l/^X00P0l/^X00?o0000ooooooooool0<Oooool006[o
oooo00?o00000>k:[`3^bZl0603^bZl00ol0003oA@1;odD0B`0304D0B`04o`000?ooooooooooo`00
00T0A@1;0_l000080?;;Z003o`000?oooooooooo037ooooo001Zooooo`03o`00003^bZl0k/Z_01P0
k/Z_00?o0000odD0Bom504/00`1504/01?l0003oooooooooool0000;04D0B`03o`00003bbjP0l/^X
00@0l/^X00?o0000ooooooooool0<_ooool006_ooooo00?o00000>k:[`3^bZl05`3^bZl00ol0003o
A@1;odD0B`0304D0B`03o`000?oooooo000000d0A@1;00?o00000?;;Z03bbjP00`3bbjP00ol0003o
ooooooooo`0booooo`00K?ooool00ol00000k/Z_0>k:[`0F0>k:[`03o`000?m504_oA@1;00<0A@1;
00?o0000ooooool000003P1504/2o`000080l/^X00?o0000ooooooooool0<oooool006gooooo00?o
00000>k:[`3^bZl05@3^bZl00ol0003oA@1;odD0B`0304D0B`03o`000?oooooo00000100A@1;00?o
00000?;;Z?l00000=Oooool006kooooo00?o00000>k:[`3^bZl0503^bZl00ol0003oA@1;odD0B`03
04D0B`03o`000?oooooo00000100A@1;0_l0000fooooo`00Koooool00ol00000k/Z_0>k:[`0C0>k:
[`03o`000?m504_oA@1;00<0A@1;00?o0000ooooool000003`1504/00ol00000A@1;o`00000foooo
o`00L?ooool00ol00000k/Z_0>k:[`0B0>k:[`03o`000?m504_oA@1;00<0A@1;0_l0000>04D0B`;o
000000<0A@1;o`000?l00000=_ooool0077ooooo00?o00000>k:[`3^bZl04@3^bZl00ol0003oA@1;
odD0B`0204D0B`03o`000?oooooo000000d0A@1;00Co000004D0B`1504_o00000P1504/00ol0003o
ooooooooo`0cooooo`00L_ooool00ol00000k/Z_0>k:[`0?0>k:[`04o`000?m504_oA@1;odD0B`80
A@1;00?o0000ooooool000002`1504/2o`000080A@1;00Go000004D0B`1504/0A@1;o`00000eoooo
o`00Loooool00ol00000k/Z_0>k:[`0>0>k:[`04o`000?m504_oA@1;odD0B`80A@1;00?o0000oooo
ool000002P1504/00ol00000A@1;04D0B`0204D0B`05o`00001504/0A@1;04D0Bol00000=Oooool0
07?ooooo00?o00000>k:[`3^bZl03P3^bZl01?l0003oA@1;odD0Bom504/204D0B`03o`000?oooooo
000000P0A@1;0_l0000404D0B`03o`00001504/0A@1;0080A@1;00?o0000ooooooooool0<oooool0
07Cooooo00?o00000>k:[`3^bZl03@3^bZl01?l0003oA@1;odD0Bom504/204D0B`;o0000201504/0
0ol00000A@1;04D0B`0304D0B`03o`00001504/0A@1;00@0A@1;00?o0000ooooooooool0<_ooool0
07Gooooo00?o00000>k:[`3^bZl0303^bZl01?l0003oA@1;odD0Bom504/204D0B`;o00001P1504/2
o`0000H0A@1;00?o000004D0B`1504/0101504/00ol0003oooooooooo`0booooo`00MOooool2o`00
00d0k/Z_00Co0000odD0Bom504_oA@1;0P1504/2o`0000D0A@1;00?o000004D0B`1504/01@1504/0
0ol00000A@1;04D0B`0504D0B`03o`000?oooooooooo03;ooooo001dooooo`04o`000?m504_oA@1;
o`0000`0k/Z_00Co0000odD0Bom504_oA@1;0P1504/2o`0000<0A@1;0_l0000704D0B`03o`000015
04/0A@1;00H0A@1;00?o0000ooooooooool0<_ooool007?ooooo00?o0000odD0Bom504/00_m504/0
0ol00000k/Z_0>k:[`090>k:[`04o`000?m504_oA@1;odD0B`80A@1;0_l0000204D0B`03o`000015
04/0A@1;00H0A@1;00?o000004D0B`1504/0201504/00ol0003oooooooooo`0aooooo`00L_ooool0
0ol0003oA@1;odD0B`04odD0B`03o`00003^bZl0k/Z_00P0k/Z_00?o0000odD0Bom504/00`1504/0
1?l00000A@1;o`000?l0000904D0B`03o`00001504/0A@1;00P0A@1;00?o0000ooooooooool0<Ooo
ool0077ooooo00?o0000odD0Bom504/01_m504/00ol00000k/Z_0>k:[`070>k:[`03o`000?m504_o
A@1;00<0A@1;0_l0000:04D0B`03o`00001504/0A@1;00T0A@1;00?o0000ooooooooool0<Oooool0
073ooooo00?o0000odD0Bom504/02?m504/00ol00000k/Z_0>k:[`060>k:[`03o`000?m504_oA@1;
00<0A@1;00?o000004D0B`1504/0201504/00ol00000A@1;04D0B`0:04D0B`03o`000?oooooooooo
037ooooo001_ooooo`03o`000?m504_oA@1;00WoA@1;00?o00000>k:[`3^bZl01P3^bZl00ol0003o
A@1;odD0B`0>04D0B`03o`00001504/0A@1;00X0A@1;00?o0000ooooooooool0<Oooool006kooooo
00?o0000odD0Bom504/02om504/00ol00000k/Z_0>k:[`050>k:[`03o`000?m504_oA@1;00d0A@1;
00?o000004D0B`1504/0301504/00ol0003oooooooooo`0`ooooo`00KOooool00ol0003oA@1;odD0
B`0=odD0B`03o`00003^bZl0k/Z_00@0k/Z_00?o0000odD0Bom504/0301504/00ol00000A@1;04D0
B`0=04D0B`03o`000?oooooooooo033ooooo001/ooooo`03o`000?m504_oA@1;00ooA@1;00?o0000
0>k:[`3^bZl00`3^bZl00ol0003oA@1;odD0B`0204D0B`03o`00001504/0A@1;00H0A@1;00?o0000
04D0B`1504/03P1504/00ol0003oooooooooo`0`ooooo`00Joooool00ol0003oA@1;odD0B`0AodD0
B`03o`00003^bZl0k/Z_0080k/Z_00?o0000odD0Bom504/00P1504/00ol00000A@1;04D0B`0604D0
B`03o`00001504/0A@1;00h0A@1;00?o0000ooooooooool0<?ooool006[ooooo00?o0000odD0Bom5
04/04om504/01Ol00000k/Z_0>k:[`3^bZoo000000;oA@1;2P1504/00ol00000A@1;04D0B`0@04D0
B`03o`000?oooooooooo02oooooo001Zooooo`03o`000?m504_oA@1;01CoA@1;00Co00000>k:[`3^
bZoo00000_m504/904D0B`03o`00001504/0A@1;0140A@1;00?o0000ooooooooool0;oooool006Wo
oooo00?o0000odD0Bom504/05_m504/00ol00000k/Z_o`000002odD0B`T0A@1;00?o000004D0B`15
04/04@1504/00ol0003oooooooooo`0_ooooo`00J?ooool00ol0003oA@1;odD0B`0HodD0B`;o0000
0_m504/804D0B`03o`00001504/0A@1;0180A@1;00?o0000ooooooooool0;oooool006Oooooo00?o
0000odD0Bom504/06_m504/01Ol0003oA@1;odD0B`1504_o000000D0A@1;00?o000004D0B`1504/0
501504/00ol0003oooooooooo`0^ooooo`00I_ooool00ol0003oA@1;odD0B`0NodD0B`0304D0Bol0
0000A@1;00<0A@1;00?o000004D0B`1504/0501504/2o`00033ooooo001Uooooo`03o`000?m504_o
A@1;01ooA@1;00<0A@1;o`00001504/00`1504/00ol00000A@1;04D0B`0B04D0B`;o0000<_ooool0
06Cooooo00?o0000odD0Bom504/08?m504/00`1504_o000004D0B`0204D0B`03o`00001504/0A@1;
0140A@1;0_l0000dooooo`00Hoooool00ol0003oA@1;odD0B`0QodD0B`0504D0Bol00000A@1;04D0
Bol000004P1504/2o`0003Kooooo001Rooooo`03o`000?m504_oA@1;02;oA@1;101504/00ol00000
A@1;04D0B`0>04D0B`;o0000>?ooool0067ooooo00?o0000odD0Bom504/08om504/304D0B`03o`00
001504/0A@1;00d0A@1;0_l0000jooooo`00H?ooool00ol0003oA@1;odD0B`0TodD0B`03o`000015
04_o000000h0A@1;0_l0000looooo`00Goooool00ol0003oA@1;odD0B`0UodD0B`;o0000301504/3
o`0003kooooo001Nooooo`03o`000?m504_oA@1;02KoA@1;0_l0000:04D0B`;o0000@Oooool005go
oooo00?o0000odD0Bom504/09Om504/204D0B`03o`00001504/0A@1;00L0A@1;0_l00013ooooo`00
G?ooool00ol0003oA@1;odD0B`0SodD0B`@0A@1;00?o000004D0B`1504/01P1504/2o`0004Gooooo
001Kooooo`03o`000?m504_oA@1;027oA@1;1P1504/2o`0000H0A@1;0_l00017ooooo`00Foooool0
0ol0003oA@1;odD0B`0NodD0B`T0A@1;00?o0000ooooool000000`1504/2o`0004Wooooo001Joooo
o`03o`000?m504_oA@1;01coA@1;2`1504/01Ol0003oooooooooool00000A@1;00;o0000Boooool0
05Wooooo00?o0000odD0Bom504/06_m504/=04D0B`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0Boooool005Sooooo00?o0000odD0Bom504/06?m504/?04D0B`03o`000?oooooooooo057o
oooo001Gooooo`03o`000?m504_oA@1;01KoA@1;4@1504/00ol0003oooooooooo`1Booooo`00E_oo
ool00ol0003oA@1;odD0B`0DodD0Ba<0A@1;00?o0000ooooooooool0Doooool005Gooooo00?o0000
odD0Bom504/04Om504/G04D0B`03o`000?oooooooooo05?ooooo001Dooooo`03o`000?m504_oA@1;
00ooA@1;6@1504/00ol0003oooooooooo`1Dooooo`00Doooool00ol0003oA@1;odD0B`0=odD0Ba/0
A@1;00?o0000ooooooooool0EOooool005;ooooo00?o0000odD0Bom504/02om504/M04D0B`03o`00
0?oooooooooo05Kooooo001Aooooo`03o`000?m504_oA@1;00WoA@1;7`1504/00ol0003ooooooooo
o`1Gooooo`00D?ooool00ol0003oA@1;odD0B`07odD0Bb40A@1;00?o0000ooooooooool0F?ooool0
04oooooo00?o0000odD0Bom504/01Om504/S04D0B`03o`000?oooooooooo05Wooooo001>ooooo`03
o`000?m504_oA@1;00?oA@1;9@1504/00ol0003oooooooooo`1Jooooo`00COooool01?l0003oA@1;
odD0Bom504/W04D0B`03o`000?oooooooooo05_ooooo001<ooooo`03o`000?m504/0A@1;02P0A@1;
00?o0000ooooooooool0G?ooool004cooooo00?o000004D0B`1504/09`1504/00ol0003ooooooooo
o`1Mooooo`00COooool00ol00000A@1;04D0B`0U04D0B`03o`000?oooooooooo05kooooo001=oooo
o`03o`00001504/0A@1;02@0A@1;00?o0000ooooooooool0Goooool004kooooo00?o000004D0B`15
04/08`1504/00ol0003oooooooooo`1Oooooo`00C_ooool00ol00000A@1;04D0B`0R04D0B`03o`00
0?oooooooooo063ooooo001?ooooo`03o`00001504/0A@1;0200A@1;00?o0000ooooooooool0HOoo
ool0053ooooo00?o000004D0B`1504/07P1504/00ol0003oooooooooo`1Rooooo`00D?ooool00ol0
0000A@1;04D0B`0M04D0B`03o`000?oooooooooo06?ooooo001Aooooo`03o`00001504/0A@1;01/0
A@1;00?o0000ooooooooool0I?ooool0057ooooo00?o000004D0B`1504/06P1504/00ol0003ooooo
ooooo`1Uooooo`00D_ooool00ol00000A@1;04D0B`0H04D0B`03o`000?oooooooooo06Kooooo001B
ooooo`03o`00001504/0A@1;01L0A@1;00?o0000ooooooooool0Ioooool005?ooooo00?o000004D0
B`1504/05@1504/00ol0003oooooooooo`1Xooooo`00Doooool00ol00000A@1;04D0B`0D04D0B`03
o`000?oooooooooo06Wooooo001Dooooo`03o`00001504/0A@1;0180A@1;00?o0000ooooooooool0
J_ooool005Gooooo00?o000004D0B`1504/0401504/00ol0003oooooooooo`1[ooooo`00EOooool0
0ol00000A@1;04D0B`0@04D0B`03o`000?oooooooooo06_ooooo001Fooooo`03o`00001504/0A@1;
00h0A@1;00?o0000ooooooooool0K?ooool005Kooooo00?o000004D0B`1504/03@1504/00ol0003o
ooooooooo`1]ooooo`00Eoooool00ol00000A@1;04D0B`0;04D0B`03o`000?oooooooooo06kooooo
001Gooooo`03o`00001504/0A@1;00X0A@1;00?o0000ooooooooool0Koooool005Sooooo00?o0000
04D0B`1504/0201504/00ol0003oooooooooo`1`ooooo`00F?ooool00ol00000A@1;04D0B`0704D0
B`03o`000?oooooooooo077ooooo001Iooooo`03o`00001504/0A@1;00D0A@1;00?o0000oooooooo
ool0L_ooool005[ooooo00?o000004D0B`1504/00`1504/00ol0003oooooooooo`1cooooo`00F_oo
ool00ol00000A@1;04D0B`0204D0B`03o`000?oooooooooo07Cooooo001Kooooo`04o`00001504/0
A@1;o`0007Oooooo001Kooooo`03o`00001504_o000007Sooooo001Looooo`03o`000?oooooooooo
07Oooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo0000\
\>"],
  ImageRangeCache->{{{0, 213.812}, {221, 0}} -> {0.0319342, -1.19303*^-5, \
0.00425325, 0.00425325}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03654 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0345233 1.12823 -1.11022e-16 1.12823 [
[ 0 0 0 0 ]
[ 1 1.03654 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.03654 L
0 1.03654 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.43515 .79283 m .67822 .53299 L p .67662 .722 L .302 .029 .323 r
F P
0 g
s
.50849 .91048 m .43515 .79283 L p .67662 .722 L .302 .029 .323 r
F P
0 g
s
.76713 .50798 m .76996 .54859 L .78034 .51783 L p 0 0 .38 r
F P
0 g
s
.78034 .51783 m .77733 .47693 L .76713 .50798 L p 0 0 .38 r
F P
0 g
s
.67822 .53299 m .69323 .54459 L p .67662 .722 L .302 .029 .323 r
F P
0 g
s
.69671 .48191 m .52434 .26411 L p .79136 .28561 L .669 .733 .898 r
F P
0 g
s
.74344 .46673 m .69671 .48191 L p .79136 .28561 L .669 .733 .898 r
F P
0 g
s
.7902 .43777 m .77733 .47693 L .78034 .51783 L p 0 0 .38 r
F P
0 g
s
.69323 .54459 m .68927 .64457 L .67662 .722 L p .302 .029 .323 r
F P
0 g
s
.7902 .43777 m .74344 .46673 L p .79136 .28561 L .669 .733 .898 r
F P
0 g
s
.70728 .53442 m .68927 .64457 L .77484 .58786 L p .302 .029 .323 r
F P
0 g
s
.77484 .58786 m .74605 .50772 L .70728 .53442 L p .302 .029 .323 r
F P
0 g
s
.78034 .51783 m .79342 .47902 L .7902 .43777 L p 0 0 .38 r
F P
0 g
s
.77484 .58786 m .74605 .50772 L .79342 .47902 L p .302 .029 .323 r
F P
0 g
s
.80059 .40613 m .7902 .43777 L p .79136 .28561 L .669 .733 .898 r
F P
0 g
s
.7902 .43777 m .80059 .40613 L .80984 .51865 L p 0 0 .38 r
F P
0 g
s
.80984 .51865 m .79342 .47902 L .7902 .43777 L p 0 0 .38 r
F P
0 g
s
.79342 .47902 m .80984 .51865 L .77484 .58786 L p .302 .029 .323 r
F P
0 g
s
.79136 .28561 m .80056 .30741 L .80059 .40613 L p .669 .733 .898 r
F P
0 g
s
.80059 .40613 m .80056 .30741 L .80117 .31464 L p 0 0 .139 r
F P
0 g
s
.80117 .31464 m .80984 .51865 L .80059 .40613 L p 0 0 .139 r
F P
0 g
s
.68927 .64457 m .67662 .722 L .68255 .71818 L p .302 .029 .323 r
F P
0 g
s
.68255 .71818 m .77484 .58786 L .68927 .64457 L p .302 .029 .323 r
F P
0 g
s
.80984 .51865 m .77484 .58786 L p .79136 .28561 L .943 .79 .661 r
F P
0 g
s
.79136 .28561 m .80117 .31464 L .80984 .51865 L p .943 .79 .661 r
F P
0 g
s
.80117 .31464 m .80055 .28424 L .80056 .30741 L closepath p 0 0 .139 r
F P
0 g
s
.77484 .58786 m .6714 .52567 L p .79136 .28561 L .943 .79 .661 r
F P
0 g
s
.79838 .69258 m .77484 .58786 L .68255 .71818 L p .302 .029 .323 r
F P
0 g
s
.52434 .26411 m .7262 .18897 L .79136 .28561 L p .669 .733 .898 r
F P
0 g
s
.6714 .52567 m .66656 .51348 L .79136 .28561 L p .943 .79 .661 r
F P
0 g
s
.7262 .18897 m .79136 .28561 L .66656 .51348 L p .939 .782 .66 r
F P
0 g
s
.65182 .75746 m .50849 .91048 L p .67662 .722 L .302 .029 .323 r
F P
0 g
s
.67662 .722 m .67207 .73236 L .65182 .75746 L p .302 .029 .323 r
F P
0 g
s
.68255 .71818 m .67519 .73075 L .67662 .722 L closepath p .302 .029 .323 r
F P
0 g
s
.68138 .74487 m .79838 .69258 L p .68255 .71818 L .302 .029 .323 r
F P
0 g
s
.68255 .71818 m .6765 .73045 L .68138 .74487 L p .302 .029 .323 r
F P
0 g
s
.66656 .51348 m .62174 .45884 L .7262 .18897 L p .939 .782 .66 r
F P
0 g
s
.56781 .57691 m .66909 .68918 L .6714 .52567 L p .927 .788 .688 r
F P
0 g
s
.60073 .12329 m .73546 .17537 L .62174 .45884 L p .927 .788 .688 r
F P
0 g
s
.66656 .51348 m .6714 .52567 L .61983 .46301 L p .927 .788 .688 r
F P
0 g
s
.6714 .52567 m .61983 .46301 L .56781 .57691 L p .927 .788 .688 r
F P
0 g
s
.61983 .46301 m .62174 .45884 L .66656 .51348 L p .927 .788 .688 r
F P
0 g
s
.54382 .52967 m .60073 .12329 L p .62174 .45884 L .927 .788 .688 r
F P
0 g
s
.62174 .45884 m .61983 .46301 L .54382 .52967 L p .927 .788 .688 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 222.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000gR000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo00200?oo
o`;o0000E03oool00800oooo00?o00000>g9/?l000000_l0001A0?ooo`00P03oool00ol00000kLV`
0>g9/0020>g9/0?o0000CP3oool00800oooo00?o00000>g9/03]bK001@3]bK02o`0004`0oooo0020
0?ooo`03o`00003]bK00kLV`00L0kLV`0ol000190?ooo`00O`3oool00ol00000kLV`0>g9/00;0>g9
/0?o0000AP3oool007l0oooo00?o00000>g9/03]bK003P3]bK02o`0004@0oooo001o0?ooo`03o`00
003]bK00kLV`0100kLV`0ol000110?ooo`00O`3oool00ol00000kLV`0>g9/00C0>g9/0;o0000?`3o
ool007l0oooo00?o00000>g9/03]bK005@3]bK03o`0003`0oooo001o0?ooo`03o`00003]bK00kLV`
01P0kLV`0ol0000i0?ooo`00O`3oool00ol00000kLV`0>g9/00K0>g9/003o`00003oool0oooo03H0
oooo001n0?ooo`03o`00003]bK00kLV`01`0kLV`00?o00000?ooo`3oool0=P3oool007h0oooo00?o
00000>g9/03]bK006`3]bK000ol00000oooo0?ooo`0g0?ooo`00OP3oool00ol00000kLV`0>g9/00K
0>g9/003o`00003oool0oooo03L0oooo001n0?ooo`03o`00003]bK00kLV`01/0kLV`00?o00000?oo
o`3oool0=`3oool007h0oooo00?o00000>g9/03]bK006P3]bK02o`0003T0oooo001n0?ooo`03o`00
003]bK00kLV`01X0kLV`00?o00000?38Z?l00000>03oool007h0oooo00?o00000>g9/03]bK006@3]
bK001?l00000l<RX0?38Z?l0000h0?ooo`00O@3oool00ol00000kLV`0>g9/00J0>g9/005o`00003`
b:P0l<RX0?38Z?l00000=`3oool007d0oooo00?o00000>g9/03]bK006P3]bK000ol00000l<RX0?38
Z0020?38Z003o`00003oool0oooo03@0oooo001m0?ooo`03o`00003]bK00kLV`01T0kLV`00?o0000
0?38Z03`b:P00`3`b:P00ol00000oooo0?ooo`0d0?ooo`00O@3oool00ol00000kLV`0>g9/00I0>g9
/003o`00003`b:P0l<RX00@0l<RX00?o00000?ooo`3oool0<`3oool007d0oooo00?o00000>g9/03]
bK00603]bK000ol00000l<RX0?38Z0060?38Z003o`00003oool0oooo0380oooo001m0?ooo`03o`00
003]bK00kLV`01P0kLV`00?o00000?38Z03`b:P01P3`b:P00ol00000oooo0?ooo`0b0?ooo`00O03o
ool2o`0001T0kLV`00?o00000?38Z03`b:P0203`b:P00ol00000oooo0?ooo`0a0?ooo`00N@3oool4
o`0001X0kLV`00?o00000?38Z03`b:P02@3`b:P00ol00000oooo0?ooo`0`0?ooo`00M`3oool2o`00
00<0Zk_U00?o00000>g9/03]bK00603]bK000ol00000l<RX0?38Z0090?38Z003o`00003oool0oooo
0300oooo001d0?ooo`?o00001@2[^nD00ol00000kLV`0>g9/00G0>g9/003o`00003`b:P0l<RX00/0
l<RX00?o00000?ooo`3oool0;`3oool00740oooo0ol000080:^ki@03o`00003]bK00kLV`01L0kLV`
00?o00000?38Z03`b:P0303`b:P00ol00000oooo0?ooo`0^0?ooo`00L03oool00ol00000Zk_U0:^k
i@090:^ki@03o`00003]bK00kLV`01H0kLV`00?o00000?38Z03`b:P03@3`b:P00ol00000oooo0?oo
o`0^0?ooo`00L03oool00ol00000Zk_U0:^ki@090:^ki@03o`00003]bK00kLV`01H0kLV`00?o0000
0?38Z03`b:P03P3`b:P00ol00000oooo0?ooo`0]0?ooo`00L@3oool00ol00000Zk_U0:^ki@080:^k
i@03o`00003]bK00kLV`01H0kLV`00?o00000?38Z03`b:P03`3`b:P00ol00000oooo0?ooo`0/0?oo
o`00LP3oool00ol00000Zk_U0:^ki@070:^ki@03o`00003]bK00kLV`01D0kLV`00?o00000?38Z03`
b:P0403`b:P00ol00000oooo0?ooo`0/0?ooo`00L`3oool00ol00000Zk_U0:^ki@050:^ki@03o`00
003]bK00kLV`01H0kLV`00?o00000?38Z03`b:P04@3`b:P00ol00000oooo0?ooo`0[0?ooo`00L`3o
ool00ol00000Zk_U0:^ki@050:^ki@03o`00003]bK00kLV`01D0kLV`00?o00000?38Z03`b:P04`3`
b:P00ol00000ooooo`00000Z0?ooo`00M03oool00ol00000Zk_U0:^ki@040:^ki@03o`00003]bK00
kLV`01D0kLV`00?o00000?38Z03`b:P04`3`b:P00ol00000ooooo`00000Z0?ooo`00M@3oool00ol0
0000Zk_U0:^ki@030:^ki@03o`00003]bK00kLV`01D0kLV`00?o00000?38Z03`b:P04P3`b:P01?l0
0000lLZYo`000?l0000Z0?ooo`00MP3oool00ol00000Zk_U0:^ki@020:^ki@03o`00003]bK00kLV`
01@0kLV`00?o00000?38Z03`b:P04`3`b:P01?l00000lLZYo`000?l0000Z0?ooo`00M`3oool01Ol0
0000Zk_U0:^ki@2[^nGo000001H0kLV`00?o00000?38Z03`b:P04P3`b:P00ol00000lLZY0?7:Z@02
o`0002X0oooo001g0?ooo`05o`00002[^nD0Zk_U0:^kiOl000005@3]bK000ol00000l<RX0?38Z00C
0?38Z005o`00003abZT0lLZY0?7:ZOl00000:P3oool007P0oooo00?o00000:^kiOl000005P3]bK00
0ol00000l<RX0?38Z00B0?38Z003o`00003abZT0lLZY0080lLZY00?o00000?ooo`3oool0:03oool0
07T0oooo0_l0000E0>g9/003o`00003`b:P0l<RX0180l<RX00?o00000?7:Z@3abZT00`3abZT00ol0
0000oooo0?ooo`0X0?ooo`00NP3oool00ol00000kLV`0>g9/00C0>g9/003o`00003`b:P0l<RX0180
l<RX00?o00000?7:Z@3abZT00`3abZT00ol00000oooo0?ooo`0X0?ooo`00NP3oool00ol00000kLV`
0>g9/00C0>g9/003o`00003`b:P0l<RX0140l<RX00?o00000?7:Z@3abZT0103abZT00ol00000oooo
0?ooo`0X0?ooo`00NP3oool00ol00000kLV`0>g9/00B0>g9/003o`00003`b:P0l<RX0180l<RX00?o
00000?7:Z@3abZT0103abZT00ol00000oooo0?ooo`0X0?ooo`00NP3oool00ol00000kLV`0>g9/00B
0>g9/003o`00003`b:P0l<RX0140l<RX00?o00000?7:Z@3abZT01@3abZT00ol00000oooo0?ooo`0X
0?ooo`00NP3oool00ol00000kLV`0>g9/00A0>g9/003o`00003`b:P0l<RX0180l<RX00?o00000?7:
Z@3abZT01@3abZT00ol00000oooo0?ooo`0X0?ooo`00N@3oool00ol00000kLV`0>g9/00B0>g9/003
o`00003`b:P0l<RX0140l<RX00?o00000?7:Z@3abZT01P3abZT00ol00000oooo0?ooo`0X0?ooo`00
N@3oool00ol00000kLV`0>g9/00B0>g9/003o`00003`b:P0l<RX0140l<RX00?o00000?7:Z@3abZT0
1P3abZT00ol00000oooo0?ooo`0X0?ooo`00N@3oool00ol00000kLV`0>g9/00A0>g9/003o`00003`
b:P0l<RX0140l<RX00?o00000?7:Z@3abZT01`3abZT00ol00000oooo0?ooo`0X0?ooo`00N@3oool0
0ol00000kLV`0>g9/00A0>g9/003o`00003`b:P0l<RX0100l<RX00?o00000?7:Z@3abZT0203abZT0
0ol00000oooo0?ooo`0X0?ooo`00N@3oool00ol00000kLV`0>g9/00@0>g9/003o`00003`b:P0l<RX
0140l<RX00?o00000?7:Z@3abZT0203abZT00ol00000oooo0?ooo`0X0?ooo`00N@3oool00ol00000
kLV`0>g9/00@0>g9/003o`00003`b:P0l<RX0100l<RX00?o00000?7:Z@3abZT02P3abZT00ol00000
oooo0?ooo`0W0?ooo`00N@3oool00ol00000kLV`0>g9/00@0>g9/003o`00003`b:P0l<RX0100l<RX
00?o00000?7:Z@3abZT02P3abZT00ol00000oooo0?ooo`0W0?ooo`00N03oool00ol00000kLV`0>g9
/00@0>g9/003o`00003`b:P0l<RX0100l<RX00?o00000?7:Z@3abZT02`3abZT00ol00000oooo0?oo
o`0W0?ooo`00N03oool00ol00000kLV`0>g9/00@0>g9/003o`00003`b:P0l<RX0100l<RX00?o0000
0?7:Z@3abZT02`3abZT00ol00000oooo0?ooo`0W0?ooo`00N03oool00ol00000kLV`0>g9/00?0>g9
/003o`00003`b:P0l<RX0100l<RX00?o00000?7:Z@3abZT0303abZT00ol00000oooo0?ooo`0W0?oo
o`00N03oool00ol00000kLV`0>g9/00?0>g9/003o`00003`b:P0l<RX0100l<RX00?o00000?7:Z@3a
bZT0303abZT00ol00000oooo0?ooo`0W0?ooo`00N03oool00ol00000kLV`0>g9/00?0>g9/003o`00
003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT03@3abZT00ol00000oooo0?ooo`0W0?ooo`00N03o
ool00ol00000kLV`0>g9/00>0>g9/003o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT03P3a
bZT00ol00000oooo0?ooo`0W0?ooo`00N03oool00ol00000kLV`0>g9/00>0>g9/003o`00003`b:P0
l<RX00l0l<RX00?o00000?7:Z@3abZT03P3abZT00ol00000oooo0?ooo`0W0?ooo`00N03oool00ol0
0000kLV`0>g9/00=0>g9/003o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT03`3abZT00ol0
0000oooo0?ooo`0W0?ooo`00M`3oool00ol00000kLV`0>g9/00>0>g9/003o`00003`b:P0l<RX00l0
l<RX00?o00000?7:Z@3abZT03`3abZT00ol00000oooo0?ooo`0W0?ooo`00M`3oool00ol00000kLV`
0>g9/00=0>g9/003o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT0403abZT00ol00000oooo
0?ooo`0W0?ooo`00M`3oool00ol00000kLV`0>g9/00=0>g9/003o`00003`b:P0l<RX00l0l<RX00?o
00000?7:Z@3abZT0403abZT00ol00000oooo0?ooo`0W0?ooo`00M`3oool00ol00000kLV`0>g9/00=
0>g9/003o`00003`b:P0l<RX00h0l<RX00?o00000?7:Z@3abZT04@3abZT00ol00000oooo0?ooo`0W
0?ooo`00M`3oool00ol00000kLV`0>g9/00<0>g9/003o`00003`b:P0l<RX00l0l<RX00?o00000?7:
Z@3abZT04@3abZT00ol00000oooo0?ooo`0W0?ooo`00M`3oool00ol00000kLV`0>g9/00<0>g9/003
o`00003`b:P0l<RX00h0l<RX00?o00000?7:Z@3abZT04P3abZT00ol00000oooo0?ooo`0W0?ooo`00
M`3oool00ol00000kLV`0>g9/00;0>g9/003o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT0
4P3abZT00ol00000oooo0?ooo`0W0?ooo`00MP3oool00ol00000kLV`0>g9/00<0>g9/003o`00003`
b:P0l<RX00h0l<RX00?o00000?7:Z@3abZT04`3abZT00ol00000oooo0?ooo`0W0?ooo`00MP3oool0
0ol00000kLV`0>g9/00<0>g9/003o`00003`b:P0l<RX00d0l<RX00?o00000?7:Z@3abZT0503abZT0
0ol00000oooo0?ooo`0W0?ooo`00MP3oool00ol00000kLV`0>g9/00;0>g9/003o`00003`b:P0l<RX
00h0l<RX00?o00000?7:Z@3abZT0503abZT00ol00000oooo0?ooo`0W0?ooo`00MP3oool00ol00000
kLV`0>g9/00:0>g9/0;o00003`3`b:P00ol00000lLZY0?7:Z@0E0?7:Z@03o`00003oool0oooo02L0
oooo001f0?ooo`03o`00003]bK00kLV`00T0kLV`00Co00000?ooo`3]bK3o00003P3`b:P00ol00000
lLZY0?7:Z@0E0?7:Z@03o`00003oool0oooo02L0oooo001f0?ooo`03o`00003]bK00kLV`00P0kLV`
00?o00000?ooool000000P3]bK000ol00000l<RX0?38Z00:0?38Z003o`00003abZT0lLZY01L0lLZY
00?o00000?ooo`3oool09P3oool007H0oooo00?o00000>g9/03]bK001`3]bK001?l00000oooo0?oo
ool000030>g9/003o`00003`b:P0l<RX00T0l<RX00?o00000?7:Z@3abZT05`3abZT00ol00000oooo
0?ooo`0V0?ooo`00M@3oool00ol00000kLV`0>g9/0070>g9/004o`00003oool0ooooo`0000D0kLV`
00?o00000?38Z03`b:P01`3`b:P00ol00000lLZY0?7:Z@0H0?7:Z@03o`00003oool0oooo02H0oooo
001e0?ooo`03o`00003]bK00kLV`00H0kLV`00Go00000?ooo`3oool0ooooo`0000060>g9/003o`00
003`b:P0l<RX00H0l<RX00?o00000?7:Z@3abZT0603abZT00ol00000oooo0?ooo`0V0?ooo`00M@3o
ool00ol00000kLV`0>g9/0050>g9/005o`00003oool0oooo0?ooool000001`3]bK000ol00000l<RX
0?38Z0050?38Z003o`00003abZT0lLZY01T0lLZY00?o00000?ooo`3oool09P3oool007D0oooo00?o
00000>g9/03]bK000`3]bK02o`0000@0oooo00?o00000>g9/03]bK001P3]bK000ol00000l<RX0?38
Z0030?38Z003o`00003abZT0lLZY01X0lLZY00?o00000?ooo`3oool09P3oool007D0oooo00?o0000
0>g9/03]bK000P3]bK000ol00000oooo0?ooo`040?ooo`03o`00003]bK00kLV`00H0kLV`0_l00004
0?38Z003o`00003abZT0lLZY01X0lLZY00?o00000?ooo`3oool09P3oool007D0oooo00Go00000>g9
/03]bK00kLV`o`0000060?ooo`03o`00003]bK00kLV`00P0kLV`0_l000020?38Z003o`00003abZT0
lLZY01/0lLZY00?o00000?ooo`3oool09P3oool007D0oooo00Co00000>g9/03]bK3o00001`3oool0
0ol00000kLV`0>g9/0090>g9/0;o000000<0l<RXo`00003abZT0703abZT00ol00000oooo0?ooo`0V
0?ooo`00M03oool01?l00000kLV`0>g9/?l000070?ooo`03o`00003]bK00kLV`00/0kLV`0_l0000N
0?7:Z@03o`00003oool0oooo02H0oooo001d0?ooo`03o`00003]bK3o000000P0oooo00?o00000>g9
/03]bK00303]bK000ol00000lLZY0?7:Z@0L0?7:Z@03o`00003oool0oooo02H0oooo001d0?ooo`;o
0000203oool00ol00000kLV`0>g9/00>0>g9/0;o0000703abZT00ol00000oooo0?ooo`0V0?ooo`00
M03oool00ol00000oooo0?ooo`070?ooo`03o`00003]bK00kLV`00h0kLV`00?o00000?ooool00000
6P3abZT00ol00000oooo0?ooo`0W0?ooo`00O@3oool00ol00000kLV`0>g9/00?0>g9/003o`00003o
oooo000000;o0000603abZT00ol00000oooo0?ooo`0W0?ooo`00O@3oool00ol00000kLV`0>g9/00?
0>g9/004o`00003oool0C@MB04d7DP?o00005@3abZT00ol00000oooo0?ooo`0X0?ooo`00O03oool0
0ol00000kLV`0>g9/00@0>g9/0;o00000`1=1e800ol00000ooooo`00000D0?7:Z@03o`00003oool0
oooo02P0oooo001l0?ooo`03o`00003]bK00kLV`0100kLV`00?o0000odd7DP1=1e800P1=1e800ol0
0000oooo0?ooo`02o`000140lLZY00?o00000?ooo`3oool0:@3oool007`0oooo00?o00000>g9/03]
bK00403]bK000ol0003oC@MB04d7DP0204d7DP03o`00003ooooo00000080C@MB00?o00000?7:Z@3a
bZT03P3abZT00ol00000oooo0?ooo`0Y0?ooo`00N`3oool00ol00000kLV`0>g9/00A0>g9/003o`00
0?m=1e80C@MB0080C@MB00?o00000?ooool000000`1=1e82o`0000d0lLZY00?o00000?ooo`3oool0
:P3oool007/0oooo00?o00000>g9/03]bK004@3]bK000ol0003oC@MB04d7DP0204d7DP03o`00003o
oooo000000D0C@MB00?o00000?7:Z@3abZT02@3abZT00ol00000oooo0?ooo`0[0?ooo`00NP3oool0
0ol00000kLV`0>g9/00B0>g9/003o`000?m=1e80C@MB0080C@MB00?o00000?ooool000001P1=1e82
o`0000T0lLZY00?o00000?ooo`3oool0:`3oool007X0oooo00?o00000>g9/03]bK004P3]bK000ol0
003oC@MB04d7DP0204d7DP03o`00003ooooo000000P0C@MB0_l000060?7:Z@03o`00003oool0oooo
02`0oooo001i0?ooo`03o`00003]bK00kLV`01<0kLV`00?o0000odd7DP1=1e800P1=1e800ol00000
ooooo`00000:04d7DP03o`00003abZT0lLZY00<0lLZY00?o00000?ooo`3oool0;03oool007T0oooo
00?o00000>g9/03]bK004`3]bK000ol0003oC@MB04d7DP0204d7DP;o0000301=1e82o`000080lLZY
00?o00000?ooo`3oool0;@3oool007X0oooo00?o00000>g9/03]bK004P3]bK000ol0003oC@MB04d7
DP0204d7DP;o00003P1=1e800ol00000lLZYo`00000_0?ooo`00N`3oool00ol00000kLV`0>g9/00A
0>g9/003o`000?m=1e80C@MB0080C@MB0_l0000>04d7DP;o0000<03oool007`0oooo00?o00000>g9
/03]bK00403]bK000ol0003oC@MB04d7DP0204d7DP;o00003@1=1e800ol00000C@MBo`00000`0?oo
o`00O@3oool00ol00000kLV`0>g9/00?0>g9/007o`000?m=1e80C@MB04d7D_l00000ooooo`00000;
04d7DP;o000000<0C@MBo`000?l00000<03oool007h0oooo00?o00000>g9/03]bK003P3]bK001ol0
003oC@MB04d7DP1=1e;o00000?ooool000002P1=1e801?l00000C@MB04d7D_l0000204d7DP03o`00
003oool0oooo02d0oooo001o0?ooo`03o`00003]bK00kLV`00d0kLV`00Co0000odd7DP1=1e80C@MB
0_l0000904d7DP;o00000P1=1e801Ol00000C@MB04d7DP1=1e;o000002l0oooo00200?ooo`03o`00
003]bK00kLV`00`0kLV`00Co0000odd7DP1=1e80C@MB0_l0000804d7DP03o`00001=1e80C@MB0080
C@MB00Go000004d7DP1=1e80C@MBo`00000_0?ooo`00P03oool2o`0000d0kLV`00Co0000odd7DP1=
1e80C@MB0_l0000604d7DP;o0000101=1e800ol00000C@MB04d7DP0204d7DP03o`00003oool0oooo
02d0oooo00200?ooo`03o`000?m=1e;o000000`0kLV`00Co0000odd7DP1=1e80C@MB0_l0000504d7
DP03o`00001=1e80C@MB00<0C@MB00?o000004d7DP1=1e800`1=1e800ol00000oooo0?ooo`0]0?oo
o`00O`3oool01Ol0003oC@MBodd7D_m=1e;o000000/0kLV`00Co0000odd7DP1=1e80C@MB0_l00003
04d7DP;o00001@1=1e800ol00000C@MB04d7DP0504d7DP03o`00003oool0oooo02`0oooo001n0?oo
o`03o`000?m=1e;oC@MB00?oC@MB00?o00000>g9/03]bK00203]bK001?l0003oC@MB04d7DP1=1e82
o`000080C@MB00?o000004d7DP1=1e801@1=1e800ol00000C@MB04d7DP0504d7DP03o`00003oool0
oooo02`0oooo001m0?ooo`03o`000?m=1e;oC@MB00CoC@MB00?o00000>g9/03]bK00203]bK001_l0
0000C@MB04d7DP1=1e;o000004d7DP;o00001`1=1e800ol00000C@MB04d7DP0604d7DP03o`00003o
ool0oooo02`0oooo001l0?ooo`03o`000?m=1e;oC@MB00KoC@MB00?o00000>g9/03]bK001`3]bK00
1?l00000C@MB04d7DP1=1e82o`0000P0C@MB00?o000004d7DP1=1e801`1=1e800ol00000oooo0?oo
o`0/0?ooo`00N`3oool00ol0003oC@MBodd7DP08odd7DP03o`00003]bK00kLV`00H0kLV`00Go0000
04d7DP1=1e80C@MBo`00000804d7DP03o`00001=1e80C@MB00T0C@MB00?o00000?ooo`3oool0:`3o
ool007X0oooo00?o0000odd7D_m=1e802_m=1e800ol00000kLV`0>g9/0050>g9/003o`00001=1e80
C@MB00X0C@MB00?o000004d7DP1=1e802@1=1e800ol00000oooo0?ooo`0[0?ooo`00N@3oool00ol0
003oC@MBodd7DP0<odd7DP03o`00003]bK00kLV`00@0kLV`00?o000004d7DP1=1e802@1=1e800ol0
0000C@MB04d7DP0:04d7DP03o`00003oool0oooo02/0oooo001h0?ooo`03o`000?m=1e;oC@MB00ko
C@MB00?o00000>g9/03]bK000`3]bK000ol00000C@MB04d7DP0804d7DP03o`00001=1e80C@MB00/0
C@MB00?o00000?ooo`3oool0:`3oool007L0oooo00?o0000odd7D_m=1e804?m=1e800ol00000kLV`
0>g9/0020>g9/004o`00001=1e80C@MBo`0000L0C@MB00?o000004d7DP1=1e80301=1e800ol00000
oooo0?ooo`0Z0?ooo`00MP3oool00ol0003oC@MBodd7DP0Bodd7DP05o`00003]bK00kLV`0>g9/?l0
00000P1=1e800ol00000C@MB04d7DP0404d7DP03o`00001=1e80C@MB00d0C@MB00?o00000?ooo`3o
ool0:P3oool007D0oooo00?o0000odd7D_m=1e805?m=1e801?l00000kLV`0>g9/?l0000804d7DP03
o`00001=1e80C@MB00h0C@MB00?o00000?ooo`3oool0:P3oool007@0oooo00?o0000odd7D_m=1e80
5_m=1e800ol00000kLV`o`00000704d7DP03o`00001=1e80C@MB00l0C@MB00?o00000?ooo`3oool0
:P3oool007<0oooo00?o0000odd7D_m=1e806?m=1e82o`0000L0C@MB00?o000004d7DP1=1e803`1=
1e800ol00000oooo0?ooo`0Z0?ooo`00LP3oool00ol0003oC@MBodd7DP0Jodd7DP03o`00001=1e;o
000000@0C@MB00?o000004d7DP1=1e804@1=1e800ol00000oooo0?ooo`0Y0?ooo`00L@3oool00ol0
003oC@MBodd7DP0Lodd7DP0304d7D_l00000C@MB0080C@MB00?o000004d7DP1=1e804@1=1e82o`00
02/0oooo001`0?ooo`03o`000?m=1e;oC@MB01goC@MB00D0C@MBo`00001=1e80C@MBo`00000B04d7
DP;o0000;@3oool006l0oooo00?o0000odd7D_m=1e807_m=1e801@1=1e;o000004d7DP1=1e;o0000
00l0C@MB0ol0000_0?ooo`00KP3oool00ol0003oC@MBodd7DP0Oodd7DP<0C@MB00?o000004d7DP1=
1e80301=1e82o`000380oooo001^0?ooo`03o`000?m=1e;oC@MB01ooC@MB00?o000004d7D_l00000
3@1=1e82o`0003@0oooo001]0?ooo`03o`000?m=1e;oC@MB023oC@MB0_l0000;04d7DP?o0000=P3o
ool006`0oooo00?o0000odd7D_m=1e808Om=1e82o`0000T0C@MB0_l0000i0?ooo`00J`3oool00ol0
003oC@MBodd7DP0Podd7DP80C@MB00?o000004d7DP1=1e801P1=1e82o`0003/0oooo001Z0?ooo`03
o`000?m=1e;oC@MB01koC@MB101=1e82o`0000H0C@MB0_l0000m0?ooo`00J@3oool00ol0003oC@MB
odd7DP0Kodd7DPP0C@MB0_l0000304d7DP?o0000?`3oool006P0oooo00?o0000odd7D_m=1e806Om=
1e8:04d7DP03o`00003oool0oooo00?o0000@P3oool006L0oooo00?o0000odd7D_m=1e805om=1e8<
04d7DP05o`00003oool0oooo0?ooool00000A03oool006H0oooo00?o0000odd7D_m=1e805?m=1e8@
04d7DP03o`00003oool0oooo04H0oooo001U0?ooo`03o`000?m=1e;oC@MB01;oC@MB4P1=1e800ol0
0000oooo0?ooo`170?ooo`00I03oool00ol0003oC@MBodd7DP0?odd7DQD0C@MB00?o00000?ooo`3o
ool0B03oool006<0oooo00?o0000odd7D_m=1e803Om=1e8H04d7DP03o`00003oool0oooo04P0oooo
001R0?ooo`03o`000?m=1e;oC@MB00_oC@MB6P1=1e800ol00000oooo0?ooo`190?ooo`00H@3oool0
0ol0003oC@MBodd7DP08odd7DQd0C@MB00?o00000?ooo`3oool0BP3oool00600oooo00?o0000odd7
D_m=1e801_m=1e8O04d7DP03o`00003oool0oooo04/0oooo001O0?ooo`03o`000?m=1e;oC@MB00?o
C@MB8P1=1e800ol00000oooo0?ooo`1<0?ooo`00GP3oool01?l0003oC@MBodd7D_m=1e8T04d7DP03
o`00003oool0oooo04d0oooo001M0?ooo`03o`000?m=1e80C@MB02D0C@MB00?o00000?ooo`3oool0
CP3oool005d0oooo00?o000004d7DP1=1e80901=1e800ol00000oooo0?ooo`1?0?ooo`00GP3oool0
0ol00000C@MB04d7DP0R04d7DP03o`00003oool0oooo0500oooo001N0?ooo`03o`00001=1e80C@MB
0240C@MB00?o00000?ooo`3oool0D@3oool005l0oooo00?o000004d7DP1=1e807`1=1e800ol00000
oooo0?ooo`1B0?ooo`00H03oool00ol00000C@MB04d7DP0M04d7DP03o`00003oool0oooo05<0oooo
001P0?ooo`03o`00001=1e80C@MB01`0C@MB00?o00000?ooo`3oool0E03oool00640oooo00?o0000
04d7DP1=1e806P1=1e800ol00000oooo0?ooo`1E0?ooo`00H@3oool00ol00000C@MB04d7DP0I04d7
DP03o`00003oool0oooo05H0oooo001R0?ooo`03o`00001=1e80C@MB01L0C@MB00?o00000?ooo`3o
ool0E`3oool00680oooo00?o000004d7DP1=1e805P1=1e800ol00000oooo0?ooo`1H0?ooo`00H`3o
ool00ol00000C@MB04d7DP0E04d7DP03o`00003oool0oooo05P0oooo001T0?ooo`03o`00001=1e80
C@MB01<0C@MB00?o00000?ooo`3oool0F@3oool006@0oooo00?o000004d7DP1=1e804P1=1e800ol0
0000oooo0?ooo`1J0?ooo`00I@3oool00ol00000C@MB04d7DP0@04d7DP03o`00003oool0oooo05/0
oooo001U0?ooo`03o`00001=1e80C@MB00l0C@MB00?o00000?ooo`3oool0G03oool006H0oooo00?o
000004d7DP1=1e803@1=1e800ol00000oooo0?ooo`1M0?ooo`00I`3oool00ol00000C@MB04d7DP0;
04d7DP03o`00003oool0oooo05h0oooo001W0?ooo`03o`00001=1e80C@MB00X0C@MB00?o00000?oo
o`3oool0G`3oool006P0oooo00?o000004d7DP1=1e80201=1e800ol00000oooo0?ooo`1P0?ooo`00
J03oool00ol00000C@MB04d7DP0704d7DP03o`00003oool0oooo0640oooo001Y0?ooo`03o`00001=
1e80C@MB00D0C@MB00?o00000?ooo`3oool0HP3oool006T0oooo00?o000004d7DP1=1e80101=1e80
0ol00000oooo0?ooo`1S0?ooo`00JP3oool00ol00000C@MB04d7DP0204d7DP03o`00003oool0oooo
06@0oooo001[0?ooo`04o`00001=1e80C@MBo`0006L0oooo001[0?ooo`03o`00001=1e;o000006P0
oooo001/0?ooo`03o`00003oool0oooo06L0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?oo
o`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F
0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {221.625, 0}} -> {0.0305947, -4.5937*^-6, \
0.00414547, 0.00414547}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.04394 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0376725 1.13542 2.22045e-16 1.13542 [
[ 0 0 0 0 ]
[ 1 1.04394 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04394 L
0 1.04394 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.4386 .79766 m .68434 .53497 L p .68325 .7259 L .302 .03 .323 r
F P
0 g
s
.51329 .91645 m .4386 .79766 L p .68325 .7259 L .302 .03 .323 r
F P
0 g
s
.77421 .50969 m .77713 .55073 L .78769 .51961 L p 0 0 .383 r
F P
0 g
s
.78769 .51961 m .7846 .47828 L .77421 .50969 L p 0 0 .383 r
F P
0 g
s
.68434 .53497 m .69959 .54667 L p .68325 .7259 L .302 .03 .323 r
F P
0 g
s
.70308 .48332 m .52928 .26296 L p .7992 .28472 L .669 .733 .898 r
F P
0 g
s
.75036 .46795 m .70308 .48332 L p .7992 .28472 L .669 .733 .898 r
F P
0 g
s
.79769 .43866 m .7846 .47828 L .78769 .51961 L p 0 0 .383 r
F P
0 g
s
.69959 .54667 m .69586 .64766 L .68325 .7259 L p .302 .03 .323 r
F P
0 g
s
.79769 .43866 m .75036 .46795 L p .7992 .28472 L .669 .733 .898 r
F P
0 g
s
.71381 .53638 m .69586 .64766 L .78248 .5903 L p .302 .03 .323 r
F P
0 g
s
.78248 .5903 m .75305 .50938 L .71381 .53638 L p .302 .03 .323 r
F P
0 g
s
.78769 .51961 m .801 .48035 L .79769 .43866 L p 0 0 .383 r
F P
0 g
s
.78248 .5903 m .75305 .50938 L .801 .48035 L p .302 .03 .323 r
F P
0 g
s
.80827 .40665 m .79769 .43866 L p .7992 .28472 L .669 .733 .898 r
F P
0 g
s
.79769 .43866 m .80827 .40665 L .81776 .52036 L p 0 0 .383 r
F P
0 g
s
.81776 .52036 m .801 .48035 L .79769 .43866 L p 0 0 .383 r
F P
0 g
s
.801 .48035 m .81776 .52036 L .78248 .5903 L p .302 .03 .323 r
F P
0 g
s
.7992 .28472 m .80845 .30677 L .80827 .40665 L p .669 .733 .898 r
F P
0 g
s
.80827 .40665 m .80845 .30677 L .80908 .31408 L p 0 0 .144 r
F P
0 g
s
.80908 .31408 m .81776 .52036 L .80827 .40665 L p 0 0 .144 r
F P
0 g
s
.69586 .64766 m .68325 .7259 L .68926 .72203 L p .302 .03 .323 r
F P
0 g
s
.68926 .72203 m .78248 .5903 L .69586 .64766 L p .302 .03 .323 r
F P
0 g
s
.81776 .52036 m .78248 .5903 L p .7992 .28472 L .944 .79 .661 r
F P
0 g
s
.7992 .28472 m .80908 .31408 L .81776 .52036 L p .944 .79 .661 r
F P
0 g
s
.80908 .31408 m .80849 .28333 L .80845 .30677 L closepath p 0 0 .144 r
F P
0 g
s
.78248 .5903 m .67822 .52732 L p .7992 .28472 L .944 .79 .661 r
F P
0 g
s
.80665 .69607 m .78248 .5903 L .68926 .72203 L p .302 .03 .323 r
F P
0 g
s
.52928 .26296 m .73353 .18694 L .7992 .28472 L p .669 .733 .898 r
F P
0 g
s
.67822 .52732 m .67335 .51499 L .7992 .28472 L p .944 .79 .661 r
F P
0 g
s
.73353 .18694 m .7992 .28472 L .67335 .51499 L p .939 .782 .659 r
F P
0 g
s
.6582 .76174 m .51329 .91645 L p .68325 .7259 L .302 .03 .323 r
F P
0 g
s
.68325 .7259 m .67867 .73637 L .6582 .76174 L p .302 .03 .323 r
F P
0 g
s
.68926 .72203 m .68183 .73474 L .68325 .7259 L closepath p .302 .03 .323 r
F P
0 g
s
.68814 .749 m .80665 .69607 L p .68926 .72203 L .302 .03 .323 r
F P
0 g
s
.68926 .72203 m .68316 .73443 L .68814 .749 L p .302 .03 .323 r
F P
0 g
s
.67335 .51499 m .62817 .4597 L .73353 .18694 L p .939 .782 .659 r
F P
0 g
s
.60036 .1205 m .72701 .17323 L .62994 .45983 L p .944 .79 .661 r
F P
0 g
s
.5831 .58008 m .68105 .69338 L .67822 .52732 L p .944 .79 .661 r
F P
0 g
s
.67335 .51499 m .67822 .52732 L .62829 .46408 L p .944 .79 .661 r
F P
0 g
s
.67822 .52732 m .62829 .46408 L .5831 .58008 L p .944 .79 .661 r
F P
0 g
s
.62829 .46408 m .62994 .45983 L .67335 .51499 L p .944 .79 .661 r
F P
0 g
s
.55925 .5322 m .60036 .1205 L p .62994 .45983 L .944 .79 .661 r
F P
0 g
s
.62994 .45983 m .62829 .46408 L .55925 .5322 L p .944 .79 .661 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 224.25},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000h2000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo0020oooo
o`;o0000E?ooool0083ooooo00?o00000?7:ZOl000000_l0001Aooooo`00P?ooool00ol00000lLZY
0?7:Z@020?7:Z@;o0000Coooool0083ooooo00?o00000?7:Z@3abZT0103abZT3o`0004cooooo0020
ooooo`03o`00003abZT0lLZY00L0lLZY0_l0001:ooooo`00P?ooool00ol00000lLZY0?7:Z@090?7:
Z@?o0000Aoooool007oooooo00?o00000?7:Z@3abZT03@3abZT2o`0004Gooooo001oooooo`03o`00
003abZT0lLZY00l0lLZY0_l00013ooooo`00Ooooool00ol00000lLZY0?7:Z@0A0?7:Z@?o0000@?oo
ool007oooooo00?o00000?7:Z@3abZT0503abZT2o`0003kooooo001oooooo`03o`00003abZT0lLZY
01H0lLZY0ol0000kooooo`00Ooooool00ol00000lLZY0?7:Z@0I0?7:Z@03o`000?oooooooooo03So
oooo001oooooo`03o`00003abZT0lLZY01T0lLZY00?o0000ooooooooool0>?ooool007oooooo00?o
00000?7:Z@3abZT0603abZT00ol0003oooooooooo`0iooooo`00Ooooool00ol00000lLZY0?7:Z@0H
0?7:Z@?o0000>Oooool007oooooo00?o00000?7:Z@3abZT0603abZT00ol00000Zk_Uo`00000ioooo
o`00O_ooool00ol00000lLZY0?7:Z@0H0?7:Z@05o`00002[^nGo00000?38Z?l00000>?ooool007ko
oooo00?o00000?7:Z@3abZT0603abZT00ol00000Zk_Uo`0000020?38Z003o`000?oooooooooo03Go
oooo001nooooo`03o`00003abZT0lLZY01P0lLZY00?o00000:^kiOl000000P3`b:P00ol0003ooooo
ooooo`0eooooo`00O_ooool00ol00000lLZY0?7:Z@0G0?7:Z@03o`00002[^nGo000000@0l<RX00?o
0000ooooooooool0=?ooool007kooooo00?o00000?7:Z@3abZT05`3abZT00ol00000Zk_Uo`000005
0?38Z003o`000?oooooooooo03?ooooo001nooooo`03o`00003abZT0lLZY01L0lLZY00?o00000:^k
iOl000001@3`b:P00ol0003oooooooooo`0cooooo`00O_ooool00ol00000lLZY0?7:Z@0F0?7:Z@03
o`00002[^nGo000000L0l<RX00?o0000ooooooooool0<_ooool007kooooo00?o00000?7:Z@3abZT0
5P3abZT00ol00000Zk_Uo`0000080?38Z003o`000?oooooooooo037ooooo001nooooo`03o`00003a
bZT0lLZY01H0lLZY0_l000090?38Z003o`000?oooooooooo037ooooo001mooooo`03o`00003abZT0
lLZY01H0lLZY00?o00000:^kiOl000002P3`b:P00ol0003oooooooooo`0`ooooo`00N_ooool4o`00
01P0lLZY00?o00000:^kiOl000002`3`b:P00ol0003oooooooooo`0_ooooo`00N?ooool2o`0000<0
Zk_U00?o00000?7:Z@3abZT05P3abZT2o`0000`0l<RX00?o0000ooooooooool0;oooool007Gooooo
0ol000050:^ki@03o`00003abZT0lLZY01D0lLZY00?o00000:^kiOl000003@3`b:P00ol0003ooooo
ooooo`0^ooooo`00L_ooool3o`0000P0Zk_U00?o00000?7:Z@3abZT05@3abZT00ol00000Zk_Uo`00
000>0?38Z003o`000?oooooooooo02gooooo001aooooo`03o`00002[^nD0Zk_U00T0Zk_U00?o0000
0?7:Z@3abZT05@3abZT2o`0000l0l<RX00?o0000ooooooooool0;Oooool0077ooooo00?o00000:^k
i@2[^nD02@2[^nD00ol00000lLZY0?7:Z@0D0?7:Z@03o`00002[^nGo00000100l<RX00?o0000oooo
ooooool0;?ooool007;ooooo00?o00000:^ki@2[^nD0202[^nD00ol00000lLZY0?7:Z@0D0?7:Z@;o
00004P3`b:P00ol0003oooooooooo`0[ooooo`00Loooool00ol00000Zk_U0:^ki@070:^ki@03o`00
003abZT0lLZY01@0lLZY0_l0000B0?38Z003o`000?oooooooooo02_ooooo001dooooo`03o`00002[
^nD0Zk_U00H0Zk_U00?o00000?7:Z@3abZT04`3abZT00ol00000Zk_Uo`00000C0?38Z003o`000?oo
oooooooo02[ooooo001dooooo`03o`00002[^nD0Zk_U00D0Zk_U00?o00000?7:Z@3abZT0503abZT2
o`0001D0l<RX00?o0000ooooool00000:Oooool007Gooooo00?o00000:^ki@2[^nD0102[^nD00ol0
0000lLZY0?7:Z@0D0?7:Z@;o00005@3`b:P00ol0003oooooo`00000Yooooo`00M_ooool00ol00000
Zk_U0:^ki@030:^ki@03o`00003abZT0lLZY01<0lLZY00?o00000:^kiOl00000503`b:P01?l00000
lLZYo`000?l0000Yooooo`00Moooool00ol00000Zk_U0:^ki@020:^ki@03o`00003abZT0lLZY01<0
lLZY0_l0000E0?38Z004o`00003abZWo0000o`0002Wooooo001hooooo`05o`00002[^nD0Zk_U0:^k
iOl000005@3abZT2o`0001@0l<RX00?o00000?7:Z@3abZT00_l0000Yooooo`00N?ooool01Ol00000
Zk_U0:^ki@2[^nGo000001@0lLZY0_l0000E0?38Z005o`00003abZT0lLZY0?7:ZOl00000:Oooool0
07Wooooo00Co00000:^ki@2[^nGo0000503abZT2o`0001@0l<RX00?o00000?7:Z@3abZT00P3abZT0
0ol0003oooooooooo`0Wooooo`00N_ooool00ol00000Zk_Uo`00000D0?7:Z@;o00004`3`b:P00ol0
0000lLZY0?7:Z@030?7:Z@03o`000?oooooooooo02Oooooo001kooooo`;o00004`3abZT2o`0001@0
l<RX00?o00000?7:Z@3abZT00`3abZT00ol0003oooooooooo`0Wooooo`00Noooool2o`0001<0lLZY
0_l0000C0?38Z003o`00003abZT0lLZY00@0lLZY00?o0000ooooooooool09oooool007_ooooo00?o
00000?7:Z@3abZT04P3abZT2o`0001<0l<RX00?o00000?7:Z@3abZT0103abZT00ol0003ooooooooo
o`0Wooooo`00Noooool00ol00000lLZY0?7:Z@0A0?7:Z@;o00004`3`b:P00ol00000lLZY0?7:Z@05
0?7:Z@03o`000?oooooooooo02Oooooo001kooooo`03o`00003abZT0lLZY0140lLZY0_l0000C0?38
Z003o`00003abZT0lLZY00D0lLZY00?o0000ooooooooool09oooool007_ooooo00?o00000?7:Z@3a
bZT04@3abZT2o`000180l<RX00?o00000?7:Z@3abZT01P3abZT00ol0003oooooooooo`0Wooooo`00
Noooool00ol00000lLZY0?7:Z@0@0?7:Z@;o00004`3`b:P00ol00000lLZY0?7:Z@060?7:Z@03o`00
0?oooooooooo02Oooooo001kooooo`03o`00003abZT0lLZY0100lLZY0_l0000B0?38Z003o`00003a
bZT0lLZY00L0lLZY00?o0000ooooooooool09oooool007_ooooo00?o00000?7:Z@3abZT0403abZT0
0ol00000l<RX0?38Z00@0?38Z003o`00003abZT0lLZY00P0lLZY00?o0000ooooooooool09oooool0
07_ooooo00?o00000?7:Z@3abZT03`3abZT2o`000180l<RX00?o00000?7:Z@3abZT0203abZT00ol0
003oooooooooo`0Wooooo`00Noooool00ol00000lLZY0?7:Z@0?0?7:Z@;o00004@3`b:P00ol00000
lLZY0?7:Z@0:0?7:Z@03o`000?oooooooooo02Kooooo001kooooo`03o`00003abZT0lLZY00l0lLZY
00?o00000?38Z03`b:P0403`b:P00ol00000lLZY0?7:Z@0:0?7:Z@03o`000?oooooooooo02Kooooo
001jooooo`03o`00003abZT0lLZY00l0lLZY0_l0000A0?38Z003o`00003abZT0lLZY00/0lLZY00?o
0000ooooooooool09_ooool007[ooooo00?o00000?7:Z@3abZT03`3abZT2o`000140l<RX00?o0000
0?7:Z@3abZT02`3abZT00ol0003oooooooooo`0Vooooo`00N_ooool00ol00000lLZY0?7:Z@0?0?7:
Z@03o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z@3abZT0303abZT00ol0003oooooooooo`0Voooo
o`00N_ooool00ol00000lLZY0?7:Z@0>0?7:Z@;o00004@3`b:P00ol00000lLZY0?7:Z@0<0?7:Z@03
o`000?oooooooooo02Kooooo001jooooo`03o`00003abZT0lLZY00h0lLZY00?o00000?38Z03`b:P0
3`3`b:P00ol00000lLZY0?7:Z@0=0?7:Z@03o`000?oooooooooo02Kooooo001jooooo`03o`00003a
bZT0lLZY00h0lLZY00?o00000?38Z03`b:P03P3`b:P00ol00000lLZY0?7:Z@0>0?7:Z@03o`000?oo
oooooooo02Kooooo001jooooo`03o`00003abZT0lLZY00d0lLZY0_l0000@0?38Z003o`00003abZT0
lLZY00h0lLZY00?o0000ooooooooool09_ooool007[ooooo00?o00000?7:Z@3abZT03@3abZT00ol0
0000l<RX0?38Z00>0?38Z003o`00003abZT0lLZY00l0lLZY00?o0000ooooooooool09_ooool007[o
oooo00?o00000?7:Z@3abZT03@3abZT00ol00000l<RX0?38Z00>0?38Z003o`00003abZT0lLZY00l0
lLZY00?o0000ooooooooool09_ooool007[ooooo00?o00000?7:Z@3abZT0303abZT2o`0000l0l<RX
00?o00000?7:Z@3abZT0403abZT00ol0003oooooooooo`0Vooooo`00NOooool00ol00000lLZY0?7:
Z@0=0?7:Z@03o`00003`b:P0l<RX00h0l<RX00?o00000?7:Z@3abZT0403abZT00ol0003ooooooooo
o`0Vooooo`00NOooool00ol00000lLZY0?7:Z@0=0?7:Z@03o`00003`b:P0l<RX00d0l<RX00?o0000
0?7:Z@3abZT04@3abZT00ol0003oooooooooo`0Vooooo`00NOooool00ol00000lLZY0?7:Z@0<0?7:
Z@03o`00003`b:P0l<RX00h0l<RX00?o00000?7:Z@3abZT04@3abZT00ol0003oooooooooo`0Voooo
o`00NOooool00ol00000lLZY0?7:Z@0<0?7:Z@03o`00003`b:P0l<RX00d0l<RX00?o00000?7:Z@3a
bZT04P3abZT00ol0003oooooooooo`0Vooooo`00NOooool00ol00000lLZY0?7:Z@0<0?7:Z@03o`00
003`b:P0l<RX00d0l<RX00?o00000?7:Z@3abZT04P3abZT00ol0003oooooooooo`0Vooooo`00NOoo
ool00ol00000lLZY0?7:Z@0;0?7:Z@03o`00003`b:P0l<RX00d0l<RX00?o00000?7:Z@3abZT04`3a
bZT00ol0003oooooooooo`0Vooooo`00NOooool00ol00000lLZY0?7:Z@0;0?7:Z@03o`00003`b:P0
l<RX00`0l<RX00?o00000?7:Z@3abZT0503abZT00ol0003oooooooooo`0Vooooo`00NOooool00ol0
0000lLZY0?7:Z@0;0?7:Z@03o`00003`b:P0l<RX00`0l<RX00?o00000?7:Z@3abZT0503abZT00ol0
003oooooooooo`0Vooooo`00NOooool00ol00000lLZY0?7:Z@0:0?7:Z@03o`00003`b:P0l<RX00`0
l<RX00?o00000?7:Z@3abZT05@3abZT00ol0003oooooooooo`0Vooooo`00N?ooool00ol00000lLZY
0?7:Z@0:0?7:Z@;o00003P3`b:P00ol00000lLZY0?7:Z@0E0?7:Z@03o`000?oooooooooo02Kooooo
001hooooo`03o`00003abZT0lLZY00T0lLZY0_l000000`3abZWo00000?38Z00;0?38Z003o`00003a
bZT0lLZY01H0lLZY00?o0000ooooooooool09_ooool007Sooooo00?o00000?7:Z@3abZT0203abZT0
0ol0003oooooo`0000020?7:Z@03o`00003`b:P0l<RX00T0l<RX00?o00000?7:Z@3abZT05`3abZT0
0ol0003oooooooooo`0Uooooo`00N?ooool00ol00000lLZY0?7:Z@070?7:Z@04o`000?oooooooooo
o`0000<0lLZY00?o00000?38Z03`b:P01`3`b:P00ol00000lLZY0?7:Z@0H0?7:Z@03o`000?oooooo
oooo02Gooooo001hooooo`03o`00003abZT0lLZY00H0lLZY00Co0000oooooooooooo00001@3abZT0
0ol00000l<RX0?38Z0060?38Z003o`00003abZT0lLZY01P0lLZY00?o0000ooooooooool09Oooool0
07Sooooo00?o00000?7:Z@3abZT01@3abZT01Ol0003ooooooooooooooooo000000D0lLZY0_l00006
0?38Z003o`00003abZT0lLZY01T0lLZY00?o0000ooooooooool09Oooool007Sooooo00?o00000?7:
Z@3abZT0103abZT01Ol0003ooooooooooooooooo000000L0lLZY00?o00000?38Z03`b:P00`3`b:P0
0ol00000lLZY0?7:Z@0J0?7:Z@03o`000?oooooooooo02Gooooo001hooooo`03o`00003abZT0lLZY
00<0lLZY00?o0000ooooooooool00_ooool00ol00000lLZY0?7:Z@060?7:Z@03o`00003`b:P0l<RX
0080l<RX00?o00000?7:Z@3abZT06P3abZT00ol0003oooooooooo`0Uooooo`00N?ooool00ol00000
lLZY0?7:Z@020?7:Z@03o`000?oooooooooo00?ooooo00?o00000?7:Z@3abZT01`3abZT01?l00000
l<RX0?38Z?l0000M0?7:Z@03o`000?oooooooooo02Gooooo001hooooo`05o`00003abZT0lLZY0?7:
ZOl000001Oooool00ol00000lLZY0?7:Z@080?7:Z@;o000000<0l<RXo`00003abZT0703abZT00ol0
003oooooooooo`0Uooooo`00Moooool01Ol00000lLZY0?7:Z@3abZWo000000Kooooo00?o00000?7:
Z@3abZT02@3abZT2o`0001h0lLZY00?o0000ooooooooool09Oooool007Oooooo00Co00000?7:Z@3a
bZWo00001_ooool00ol00000lLZY0?7:Z@0;0?7:Z@03o`00003abZT0lLZY01`0lLZY00?o0000oooo
ooooool09Oooool007Oooooo00?o00000?7:ZOl000001oooool00ol00000lLZY0?7:Z@0<0?7:Z@03
o`00003abZT0lLZY01/0lLZY00?o0000ooooooooool09Oooool007Oooooo0_l00008ooooo`03o`00
003abZT0lLZY00d0lLZY0_l0000K0?7:Z@03o`000?oooooooooo02Gooooo001gooooo`03o`000?oo
oooooooo00Kooooo00?o00000?7:Z@3abZT03P3abZT01?l0003oooooo`000?l0000H0?7:Z@03o`00
0?oooooooooo02Kooooo0020ooooo`03o`00003abZT0lLZY00h0lLZY0ol000000ooooooo00000?7:
Z@0F0?7:Z@03o`000?oooooooooo02Kooooo001oooooo`03o`00003abZT0lLZY00l0lLZY00Go0000
04d7DP1=1e;o0000ooooo`02o`0001@0lLZY00?o0000ooooooooool09oooool007oooooo00?o0000
0?7:Z@3abZT03`3abZT01Ol00000C@MB04d7DP1=1e;o000000;ooooo0_l0000B0?7:Z@03o`000?oo
oooooooo02Oooooo001oooooo`03o`00003abZT0lLZY00l0lLZY00Go000004d7DP1=1e80C@MBo`00
0002ooooo`03o`00001=1e;o00000100lLZY00?o0000ooooooooool0:?ooool007kooooo00?o0000
0?7:Z@3abZT0403abZT01ol00000C@MB04d7DP1=1e;o0000ooooool000000`1=1e82o`0000h0lLZY
00?o0000ooooooooool0:?ooool007kooooo00?o00000?7:Z@3abZT0403abZT01ol00000C@MB04d7
DP1=1e;o0000ooooool000001@1=1e82o`0000/0lLZY00?o0000ooooooooool0:Oooool007gooooo
00?o00000?7:Z@3abZT04@3abZT01ol00000C@MB04d7DP1=1e;o0000ooooool000001`1=1e800ol0
0000lLZY0?7:Z@080?7:Z@03o`000?oooooooooo02Wooooo001mooooo`03o`00003abZT0lLZY0140
lLZY00Oo000004d7DP1=1e80C@MBo`000?oooooo000000P0C@MB0_l000070?7:Z@03o`000?oooooo
oooo02[ooooo001mooooo`03o`00003abZT0lLZY0140lLZY00Oo000004d7DP1=1e80C@MBo`000?oo
oooo000000X0C@MB0_l000050?7:Z@03o`000?oooooooooo02[ooooo001looooo`03o`00003abZT0
lLZY0180lLZY00Oo000004d7DP1=1e80C@MBo`000?oooooo000000`0C@MB00Go00000?7:Z@3abZT0
lLZYo`00000]ooooo`00O?ooool00ol00000lLZY0?7:Z@0B0?7:Z@04o`00001=1e80C@MB04d7DP;o
00003P1=1e82o`0000030?7:ZOl0003ooooo02cooooo001mooooo`03o`00003abZT0lLZY0140lLZY
00Co000004d7DP1=1e80C@MB0_l0000?04d7DP;o0000;_ooool007kooooo00?o00000?7:Z@3abZT0
403abZT01?l00000C@MB04d7DP1=1e82o`0000h0C@MB00?o000004d7D_l00000;_ooool007oooooo
00?o00000?7:Z@3abZT03`3abZT01?l00000C@MB04d7DP1=1e82o`0000`0C@MB0_l000000`1=1e;o
0000o`00000^ooooo`00P?ooool00ol00000lLZY0?7:Z@0>0?7:Z@06o`00001=1e80C@MBo`000?oo
oooo00002`1=1e801?l00000C@MB04d7D_l0000204d7DP03o`000?oooooooooo02_ooooo0021oooo
o`03o`00003abZT0lLZY00d0lLZY00Ko000004d7DP1=1e;o0000ooooool0000904d7DP;o00000`1=
1e801?l00000C@MB04d7D_l0000]ooooo`00POooool00ol00000lLZY0?7:Z@0=0?7:Z@03o`00001=
1e80C@MB00;o00002@1=1e800ol00000C@MB04d7DP0204d7DP05o`00001=1e80C@MB04d7D_l00000
;Oooool008;ooooo00?o00000?7:Z@3abZT0303abZT00ol00000C@MB04d7DP02o`0000L0C@MB0_l0
000404d7DP03o`00001=1e80C@MB0080C@MB00?o0000ooooooooool0:oooool0087ooooo00?o0000
odd7D_l000003@3abZT00ol00000C@MB04d7DP02o`0000H0C@MB00?o000004d7DP1=1e80101=1e80
0ol00000C@MB04d7DP0204d7DP03o`000?oooooooooo02_ooooo0020ooooo`05o`000?m=1e;oC@MB
odd7D_l00000303abZT00ol00000C@MB04d7DP02o`0000D0C@MB00?o000004d7DP1=1e80101=1e80
0ol00000C@MB04d7DP0404d7DP03o`000?oooooooooo02[ooooo0020ooooo`03o`000?m=1e;oC@MB
00;oC@MB00?o00000?7:Z@3abZT02@3abZT00ol00000C@MB04d7DP02o`0000<0C@MB0_l0000604d7
DP03o`00001=1e80C@MB00D0C@MB00?o0000ooooooooool0:_ooool007oooooo00?o0000odd7D_m=
1e801?m=1e800ol00000lLZY0?7:Z@080?7:Z@03o`00001=1e80C@MB00;o00000P1=1e800ol00000
C@MB04d7DP0504d7DP03o`00001=1e80C@MB00H0C@MB00?o0000ooooooooool0:_ooool007kooooo
00?o0000odd7D_m=1e801_m=1e800ol00000lLZY0?7:Z@070?7:Z@05o`00001=1e80C@MBo`00001=
1e800_l0000804d7DP03o`00001=1e80C@MB00H0C@MB00?o0000ooooooooool0:_ooool007gooooo
00?o0000odd7D_m=1e801om=1e800ol00000lLZY0?7:Z@070?7:Z@03o`00001=1e80C@MB00;o0000
2@1=1e800ol00000C@MB04d7DP0804d7DP03o`000?oooooooooo02Wooooo001looooo`03o`000?m=
1e;oC@MB00WoC@MB00?o00000?7:Z@3abZT01P3abZT01?l00000C@MB04d7D_l0000904d7DP03o`00
001=1e80C@MB00T0C@MB00?o0000ooooooooool0:Oooool007_ooooo00?o0000odd7D_m=1e802om=
1e800ol00000lLZY0?7:Z@050?7:Z@03o`00001=1e80C@MB00X0C@MB00?o000004d7DP1=1e802@1=
1e800ol0003oooooooooo`0Yooooo`00N_ooool00ol0003oC@MBodd7DP0=odd7DP03o`00003abZT0
lLZY00@0lLZY00?o000004d7DP1=1e802@1=1e800ol00000C@MB04d7DP0:04d7DP03o`000?oooooo
oooo02Wooooo001iooooo`03o`000?m=1e;oC@MB00ooC@MB00?o00000?7:Z@3abZT00`3abZT00ol0
0000C@MB04d7DP0804d7DP03o`00001=1e80C@MB00/0C@MB00?o0000ooooooooool0:Oooool007So
oooo00?o0000odd7D_m=1e804Om=1e800ol00000lLZY0?7:Z@020?7:Z@03o`00001=1e80C@MB00P0
C@MB00?o000004d7DP1=1e80301=1e800ol0003oooooooooo`0Xooooo`00Moooool00ol0003oC@MB
odd7DP0Bodd7DP03o`00003abZT0lLZY0080lLZY00?o000004d7D_l000001`1=1e800ol00000C@MB
04d7DP0=04d7DP03o`000?oooooooooo02Sooooo001fooooo`03o`000?m=1e;oC@MB01CoC@MB00Oo
00000?7:Z@3abZT0lLZYo`00001=1e;o000000H0C@MB00?o000004d7DP1=1e803P1=1e800ol0003o
ooooooooo`0Xooooo`00MOooool00ol0003oC@MBodd7DP0Fodd7DP06o`00003abZT0lLZYo`00001=
1e;o00001P1=1e800ol00000C@MB04d7DP0>04d7DP03o`000?oooooooooo02Sooooo001dooooo`03
o`000?m=1e;oC@MB01SoC@MB00Go00000?7:ZOl00000C@MBo`00000504d7DP03o`00001=1e80C@MB
00l0C@MB00?o0000ooooooooool0:?ooool007?ooooo00?o0000odd7D_m=1e806_m=1e82o`000003
04d7D_l00000C@MB00<0C@MB00?o000004d7DP1=1e804@1=1e800ol0003oooooooooo`0Wooooo`00
L_ooool00ol0003oC@MBodd7DP0Lodd7DP03o`00001=1e80C@MB00<0C@MB00?o000004d7DP1=1e80
4@1=1e82o`0002Wooooo001aooooo`03o`000?m=1e;oC@MB01koC@MB1@1=1e800ol00000C@MB04d7
DP0?04d7DP;o0000:oooool0073ooooo00?o0000odd7D_m=1e807om=1e8404d7DP03o`00001=1e80
C@MB00d0C@MB0ol0000]ooooo`00Koooool00ol0003oC@MBodd7DP0Podd7DP04o`00001=1e80C@MB
o`0000h0C@MB0_l0000`ooooo`00Koooool00ol0003oC@MBodd7DP0Podd7DP04o`00001=1e80C@MB
o`0000`0C@MB0_l0000booooo`00K_ooool00ol0003oC@MBodd7DP0Qodd7DP03o`00001=1e;o0000
00X0C@MB0ol0000dooooo`00KOooool00ol0003oC@MBodd7DP0Rodd7DP;o00002@1=1e82o`0003Oo
oooo001/ooooo`03o`000?m=1e;oC@MB027oC@MB0P1=1e82o`0000L0C@MB0_l0000iooooo`00Jooo
ool00ol0003oC@MBodd7DP0Oodd7DP@0C@MB0_l0000604d7DP;o0000>oooool006[ooooo00?o0000
odd7D_m=1e807Om=1e8704d7DP;o00000`1=1e83o`0003gooooo001Yooooo`03o`000?m=1e;oC@MB
01[oC@MB2P1=1e800ol0003oooooooooo`03o`00043ooooo001Xooooo`03o`000?m=1e;oC@MB01So
C@MB301=1e801Ol0003ooooooooooooooooo000004;ooooo001Wooooo`03o`000?m=1e;oC@MB01Ko
C@MB3P1=1e800ol0003oooooooooo`15ooooo`00I_ooool00ol0003oC@MBodd7DP0Codd7DQ40C@MB
00?o0000ooooooooool0A_ooool006Gooooo00?o0000odd7D_m=1e804Om=1e8C04d7DP03o`000?oo
oooooooo04Oooooo001Tooooo`03o`000?m=1e;oC@MB00ooC@MB5P1=1e800ol0003oooooooooo`17
ooooo`00Hoooool00ol0003oC@MBodd7DP0=odd7DQP0C@MB00?o0000ooooooooool0B?ooool006;o
oooo00?o0000odd7D_m=1e802_m=1e8K04d7DP03o`000?oooooooooo04Wooooo001Qooooo`03o`00
0?m=1e;oC@MB00SoC@MB7@1=1e800ol0003oooooooooo`1:ooooo`00H?ooool00ol0003oC@MBodd7
DP06odd7DQl0C@MB00?o0000ooooooooool0Boooool005oooooo00?o0000odd7D_m=1e800om=1e8R
04d7DP03o`000?oooooooooo04cooooo001Nooooo`04o`000?m=1e;oC@MBodd7DR@0C@MB00?o0000
ooooooooool0COooool005gooooo00?o0000odd7DP1=1e809@1=1e800ol0003oooooooooo`1>oooo
o`00GOooool00ol00000C@MB04d7DP0T04d7DP03o`000?oooooooooo04oooooo001Nooooo`03o`00
001=1e80C@MB0280C@MB00?o0000ooooooooool0D?ooool005oooooo00?o000004d7DP1=1e80801=
1e800ol0003oooooooooo`1Aooooo`00Goooool00ol00000C@MB04d7DP0O04d7DP03o`000?oooooo
oooo05;ooooo001Pooooo`03o`00001=1e80C@MB01d0C@MB00?o0000ooooooooool0Doooool0067o
oooo00?o000004d7DP1=1e806`1=1e800ol0003oooooooooo`1Dooooo`00HOooool00ol00000C@MB
04d7DP0J04d7DP03o`000?oooooooooo05Gooooo001Rooooo`03o`00001=1e80C@MB01P0C@MB00?o
0000ooooooooool0E_ooool006;ooooo00?o000004d7DP1=1e805`1=1e800ol0003oooooooooo`1G
ooooo`00Hoooool00ol00000C@MB04d7DP0F04d7DP03o`000?oooooooooo05Oooooo001Tooooo`03
o`00001=1e80C@MB01@0C@MB00?o0000ooooooooool0F?ooool006Cooooo00?o000004d7DP1=1e80
4`1=1e800ol0003oooooooooo`1Iooooo`00IOooool00ol00000C@MB04d7DP0A04d7DP03o`000?oo
oooooooo05[ooooo001Vooooo`03o`00001=1e80C@MB00l0C@MB00?o0000ooooooooool0Foooool0
06Kooooo00?o000004d7DP1=1e803P1=1e800ol0003oooooooooo`1Looooo`00Ioooool00ol00000
C@MB04d7DP0<04d7DP03o`000?oooooooooo05gooooo001Xooooo`03o`00001=1e80C@MB00X0C@MB
00?o0000ooooooooool0G_ooool006Sooooo00?o000004d7DP1=1e802@1=1e800ol0003ooooooooo
o`1Oooooo`00JOooool00ol00000C@MB04d7DP0704d7DP03o`000?oooooooooo063ooooo001Yoooo
o`03o`00001=1e80C@MB00H0C@MB00?o0000ooooooooool0HOooool006[ooooo00?o000004d7DP1=
1e80101=1e800ol0003oooooooooo`1Rooooo`00Joooool00ol00000C@MB04d7DP0204d7DP03o`00
0?oooooooooo06?ooooo001[ooooo`05o`00001=1e80C@MB04d7D_l00000I_ooool006cooooo00?o
000004d7D_l00000Ioooool006gooooo00?o0000ooooooooool0I_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {223.25, 0}} -> {0.0331749, -9.22928*^-5, \
0.00411922, 0.00411922}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.19815 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.104753 1.2588 1.11022e-16 1.2588 [
[ 0 0 0 0 ]
[ 1 1.19815 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.19815 L
0 1.19815 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.76444 .56722 m .75171 .24705 L p .76519 .46629 L 0 0 .088 r
F P
0 g
s
.76652 .59127 m .76444 .56722 L p .76519 .46629 L 0 0 .088 r
F P
0 g
s
.41533 .95279 m .65144 .70051 L p .64615 .89405 L .303 .031 .325 r
F P
0 g
s
.4847 1.07525 m .41533 .95279 L p .64615 .89405 L .303 .031 .325 r
F P
0 g
s
.73783 .67614 m .74014 .7167 L .74956 .68844 L p 0 0 .35 r
F P
0 g
s
.74956 .68844 m .74712 .64759 L .73783 .67614 L p 0 0 .35 r
F P
0 g
s
.65144 .70051 m .66542 .71357 L p .64615 .89405 L .303 .031 .325 r
F P
0 g
s
.76833 .60315 m .76652 .59127 L p .76519 .46629 L 0 0 .088 r
F P
0 g
s
.7588 .61171 m .74712 .64759 L .74956 .68844 L p 0 0 .35 r
F P
0 g
s
.66542 .71357 m .6596 .81606 L .64615 .89405 L p .303 .031 .325 r
F P
0 g
s
.67894 .70404 m .6596 .81606 L .74115 .76359 L p .303 .031 .325 r
F P
0 g
s
.74115 .76359 m .71615 .67917 L .67894 .70404 L p .303 .031 .325 r
F P
0 g
s
.74956 .68844 m .76142 .65291 L .7588 .61171 L p 0 0 .35 r
F P
0 g
s
.74115 .76359 m .71615 .67917 L .76142 .65291 L p .303 .031 .325 r
F P
0 g
s
.76821 .58281 m .76833 .60315 L p .76519 .46629 L 0 0 .088 r
F P
0 g
s
.7588 .61171 m .76821 .58281 L .77568 .69498 L p 0 0 .35 r
F P
0 g
s
.77568 .69498 m .76142 .65291 L .7588 .61171 L p 0 0 .35 r
F P
0 g
s
.76142 .65291 m .77568 .69498 L .74115 .76359 L p .303 .031 .325 r
F P
0 g
s
.76519 .46629 m .76612 .49323 L .76821 .58281 L p 0 0 .088 r
F P
0 g
s
.76821 .58281 m .76612 .49323 L .76661 .50047 L p 0 0 .088 r
F P
0 g
s
.76661 .50047 m .77568 .69498 L .76821 .58281 L p 0 0 .088 r
F P
0 g
s
.75171 .24705 m .75991 .33019 L .76519 .46629 L p 0 0 .088 r
F P
0 g
s
.6596 .81606 m .64615 .89405 L .65179 .89051 L p .303 .031 .325 r
F P
0 g
s
.65179 .89051 m .74115 .76359 L .6596 .81606 L p .303 .031 .325 r
F P
0 g
s
.77568 .69498 m .74115 .76359 L p .75683 .47356 L .944 .791 .66 r
F P
0 g
s
.75683 .47356 m .76661 .50047 L .77568 .69498 L p .944 .791 .66 r
F P
0 g
s
.76661 .50047 m .76563 .47232 L .76612 .49323 L closepath p 0 0 .088 r
F P
0 g
s
.74115 .76359 m .63946 .71117 L p .75683 .47356 L .944 .791 .66 r
F P
0 g
s
.76028 .87131 m .74115 .76359 L .65179 .89051 L p .303 .031 .325 r
F P
0 g
s
.63946 .71117 m .63472 .69993 L .75683 .47356 L p .944 .791 .66 r
F P
0 g
s
.69254 .38687 m .75683 .47356 L .63472 .69993 L p .939 .782 .659 r
F P
0 g
s
.62219 .92852 m .4847 1.07525 L p .64615 .89405 L .303 .031 .325 r
F P
0 g
s
.64615 .89405 m .64168 .90428 L .62219 .92852 L p .303 .031 .325 r
F P
0 g
s
.65179 .89051 m .64463 .90282 L .64615 .89405 L closepath p .303 .031 .325 r
F P
0 g
s
.65016 .91743 m .76028 .87131 L p .65179 .89051 L .303 .031 .325 r
F P
0 g
s
.65179 .89051 m .64587 .90259 L .65016 .91743 L p .303 .031 .325 r
F P
0 g
s
.63472 .69993 m .59115 .65113 L .69254 .38687 L p .939 .782 .659 r
F P
0 g
s
.56396 .33729 m .68606 .37496 L .5928 .65131 L p .944 .791 .66 r
F P
0 g
s
.5481 .76684 m .64249 .86704 L .63946 .71117 L p .944 .791 .66 r
F P
0 g
s
.63472 .69993 m .63946 .71117 L .59122 .6554 L p .944 .791 .66 r
F P
0 g
s
.63946 .71117 m .59122 .6554 L .5481 .76684 L p .944 .791 .66 r
F P
0 g
s
.59122 .6554 m .5928 .65131 L .63472 .69993 L p .944 .791 .66 r
F P
0 g
s
.52529 .72374 m .56396 .33729 L p .5928 .65131 L .944 .791 .66 r
F P
0 g
s
.5928 .65131 m .59122 .6554 L .52529 .72374 L p .944 .791 .66 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 257.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F00010B000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?oo
o`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F
0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo
003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0
oooo002P0?ooo`03o`00003oool0oooo03<0oooo002P0?ooo`03o`00003oool0oooo03<0oooo002P
0?ooo`03o`00003oool0oooo03<0oooo002P0?ooo`03o`00003oool0oooo03<0oooo002P0?ooo`03
o`00003oool0oooo03<0oooo002P0?ooo`0300005_l00000oooo03<0oooo002P0?ooo`0300005_l0
0000oooo03<0oooo002P0?ooo`0300005_l00000oooo03<0oooo002P0?ooo`0300005_l00000oooo
03<0oooo002P0?ooo`;o0000=03oool00:00oooo0_l0000d0?ooo`00X03oool2o`0003@0oooo002Q
0?ooo`03o`00003oool0oooo0380oooo002Q0?ooo`03o`00003oool0oooo0380oooo002Q0?ooo`03
00005_l00000oooo0380oooo002Q0?ooo`0300005_l00000oooo0380oooo002Q0?ooo`0300005_l0
0000oooo0380oooo002Q0?ooo`0300005_l00000oooo0380oooo002Q0?ooo`0300005_l00000oooo
0380oooo001h0?ooo`?o00009P3oool00`0001Ko00000?ooo`0b0?ooo`00N03oool00ol00000lLZX
0?7:Z003o`0002<0oooo00<0000Fo`00003oool0<P3oool007P0oooo00?o00000?7:Z03abZP00`3a
bZP3o`000200oooo00<0000Fo`00003oool0<P3oool007P0oooo00?o00000?7:Z03abZP01P3abZP3
o`0001d0oooo00<0000Fo`00003oool0<P3oool007P0oooo00?o00000?7:Z03abZP02@3abZP4o`00
01T0oooo00<0000Fo`00003oool0<P3oool007P0oooo00?o00000?7:Z03abZP03@3abZP3o`0001H0
oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00A0?7:Z0?o00004`3oool2o`0003<0oooo
001g0?ooo`03o`00003abZP0lLZX01@0lLZX0ol0000@0?ooo`;o0000<`3oool007L0oooo00?o0000
0?7:Z03abZP05`3abZP2o`0000h0oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00H0?7:
Z003o`00003oool0oooo00`0oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00G0?7:Z003
o`00003oool0oooo00d0oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00G0?7:Z004o`00
003oool0ooooo`0000`0oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00G0?7:Z004o`00
003oool0ooooo`0000`0oooo0_l0000c0?ooo`00M`3oool00ol00000lLZX0?7:Z00F0?7:Z006o`00
003oool0ooooo`00003`b:So00002`3oool2o`0003<0oooo001g0?ooo`03o`00003abZP0lLZX01H0
lLZX00Co00000?ooo`3ooooo00000P3`b:P00ol00000oooo0?ooo`080?ooo`03o`00000001Ko0000
0380oooo001g0?ooo`03o`00003abZP0lLZX01H0lLZX00Co00000?ooo`3ooooo00000`3`b:P00ol0
0000oooo0?ooo`070?ooo`03o`00000001Ko00000380oooo001g0?ooo`03o`00003abZP0lLZX01D0
lLZX00Co00000?ooo`3ooooo0000103`b:P00ol00000oooo0?ooo`080?ooo`0300005_l00000oooo
0340oooo001f0?ooo`03o`00003abZP0lLZX01H0lLZX00Co00000?ooo`3ooooo00001@3`b:P00ol0
0000oooo0?ooo`070?ooo`0300005_l00000oooo0340oooo001f0?ooo`03o`00003abZP0lLZX01H0
lLZX00?o00000?ooool000001`3`b:P00ol00000oooo0?ooo`060?ooo`0300005_l00000oooo0340
oooo001f0?ooo`03o`00003abZP0lLZX01D0lLZX00Co00000?ooo`3ooooo00001`3`b:P00ol00000
oooo0?ooo`060?ooo`0300005_l00000oooo0340oooo001f0?ooo`03o`00003abZP0lLZX01D0lLZX
00Co00000?ooo`3ooooo0000203`b:P00ol00000oooo0?ooo`050?ooo`0300005_l00000oooo0340
oooo001f0?ooo`03o`00003abZP0lLZX01D0lLZX00?o00000?ooool000002P3`b:P00ol00000oooo
0?ooo`040?ooo`;o0000<P3oool007H0oooo00?o00000?7:Z03abZP0503abZP01?l00000oooo0?oo
ool0000;0?38Z003o`00003oool0oooo00<0oooo0_l0000b0?ooo`00MP3oool00ol00000lLZX0?7:
Z00D0?7:Z003o`00003ooooo000000`0l<RX00?o00000?ooo`3oool00`3oool2o`000380oooo001f
0?ooo`03o`00003abZP0lLZX01@0lLZX00?o00000?ooool000003@3`b:P00ol00000oooo0?ooo`02
0?ooo`;o0000<P3oool007H0oooo00?o00000?7:Z03abZP04`3abZP01?l00000oooo0?ooool0000>
0?38Z004o`00003oool0oooo0?ooo`;o0000<P3oool007H0oooo00?o00000?7:Z03abZP04`3abZP0
0ol00000ooooo`00000?0?38Z004o`00003oool0oooo0?ooo`;o0000<P3oool007D0oooo00?o0000
0?7:Z03abZP0503abZP00ol00000ooooo`00000@0?38Z003o`00003oool0oooo00;o0000<P3oool0
07D0oooo00?o00000?7:Z03abZP04`3abZP01?l00000oooo0?ooool0000A0?38Z004o`00003ooooo
0000o`000380oooo001e0?ooo`03o`00003abZP0lLZX01<0lLZX00?o00000?ooool000004`3`b:P3
o`000380oooo001e0?ooo`03o`00003abZP0lLZX01<0lLZX00?o00000?ooool000004`3`b:P3o`00
0380oooo001e0?ooo`03o`00003abZP0lLZX0180lLZX00?o00000?ooool000004`3`b:P01?l00000
lLZXo`000?l0000b0?ooo`00M@3oool00ol00000lLZX0?7:Z00B0?7:Z003o`00003ooooo000001<0
l<RX00Co00000?7:Z?l0003o0000<P3oool007D0oooo00?o00000?7:Z03abZP04P3abZP00ol00000
ooooo`00000B0?38Z003o`00003abZP0lLZX00;o0000<P3oool007D0oooo00?o00000?7:Z03abZP0
4@3abZP00ol00000ooooo`00000C0?38Z005o`00003abZP0lLZX0?7:Z?l00000<P3oool007D0oooo
00?o00000?7:Z03abZP04@3abZP00ol00000ooooo`00000B0?38Z003o`00003abZP0lLZX0080lLZX
00?o00000?ooo`3oool0<03oool007D0oooo00?o00000?7:Z03abZP04@3abZP2o`0001<0l<RX00?o
00000?7:Z03abZP00P3abZP00ol00000oooo0?ooo`0`0?ooo`00M03oool00ol00000lLZX0?7:Z00A
0?7:Z003o`00003ooooo00000180l<RX00?o00000?7:Z03abZP00`3abZP00ol00000oooo0?ooo`0`
0?ooo`00M03oool00ol00000lLZX0?7:Z00A0?7:Z003o`00003ooooo00000140l<RX00?o00000?7:
Z03abZP0103abZP00ol00000oooo0?ooo`0`0?ooo`00M03oool00ol00000lLZX0?7:Z00A0?7:Z0;o
00004P3`b:P00ol00000lLZX0?7:Z0040?7:Z003o`00003oool0oooo0300oooo001d0?ooo`03o`00
003abZP0lLZX0100lLZX00?o00000?ooool000004@3`b:P00ol00000lLZX0?7:Z0050?7:Z003o`00
003oool0oooo0300oooo001d0?ooo`03o`00003abZP0lLZX0100lLZX0_l0000B0?38Z003o`00003a
bZP0lLZX00D0lLZX00?o00000?ooo`3oool0<03oool007@0oooo00?o00000?7:Z03abZP0403abZP2
o`000140l<RX00?o00000?7:Z03abZP01P3abZP00ol00000oooo0?ooo`0`0?ooo`00M03oool00ol0
0000lLZX0?7:Z00?0?7:Z003o`00003ooooo00000140l<RX00?o00000?7:Z03abZP01P3abZP00ol0
0000oooo0?ooo`0`0?ooo`00M03oool00ol00000lLZX0?7:Z00?0?7:Z0;o00004@3`b:P00ol00000
lLZX0?7:Z0070?7:Z0;o0000<@3oool007@0oooo00?o00000?7:Z03abZP03`3abZP2o`000140l<RX
00?o00000?7:Z03abZP01`3abZP2o`000340oooo001d0?ooo`03o`00003abZP0lLZX00h0lLZX0_l0
000A0?38Z003o`00003abZP0lLZX00T0lLZX00?o00000?ooo`3oool0;`3oool007@0oooo00?o0000
0?7:Z03abZP03P3abZP2o`000140l<RX00?o00000?7:Z03abZP02@3abZP00ol00000oooo0?ooo`0_
0?ooo`00L`3oool00ol00000lLZX0?7:Z00?0?7:Z0;o0000403`b:P00ol00000lLZX0?7:Z00:0?7:
Z003o`00003oool0oooo02l0oooo001c0?ooo`03o`00003abZP0lLZX00h0lLZX0_l0000A0?38Z003
o`00003abZP0lLZX00X0lLZX00?o00000?ooo`3oool0;`3oool007<0oooo00?o00000?7:Z03abZP0
3P3abZP2o`000100l<RX00?o00000?7:Z03abZP02`3abZP00ol00000oooo0?ooo`0_0?ooo`00L`3o
ool00ol00000lLZX0?7:Z00>0?7:Z003o`00003`b:P0l<RX00l0l<RX00?o00000?7:Z03abZP02`3a
bZP00ol00000oooo0?ooo`0_0?ooo`00L`3oool00ol00000lLZX0?7:Z00=0?7:Z0;o0000403`b:P0
0ol00000lLZX0?7:Z00<0?7:Z003o`00003oool0oooo02l0oooo001c0?ooo`03o`00003abZP0lLZX
00d0lLZX0_l0000@0?38Z003o`00003abZP0lLZX00`0lLZX00?o00000?ooo`3oool0;`3oool007<0
oooo00?o00000?7:Z03abZP03@3abZP00ol00000l<RX0?38Z00>0?38Z003o`00003abZP0lLZX00d0
lLZX00?o00000?ooo`3oool0;`3oool007<0oooo00?o00000?7:Z03abZP0303abZP2o`0000l0l<RX
00?o00000?7:Z03abZP03P3abZP00ol00000oooo0?ooo`0_0?ooo`00L`3oool00ol00000lLZX0?7:
Z00<0?7:Z0;o00003`3`b:P00ol00000lLZX0?7:Z00>0?7:Z003o`00003oool0oooo02l0oooo001c
0?ooo`03o`00003abZP0lLZX00`0lLZX00?o00000?38Z03`b:P03@3`b:P00ol00000lLZX0?7:Z00?
0?7:Z003o`00003oool0oooo02l0oooo001b0?ooo`03o`00003abZP0lLZX00`0lLZX0_l0000?0?38
Z003o`00003abZP0lLZX00l0lLZX00?o00000?ooo`3oool0;`3oool00780oooo00?o00000?7:Z03a
bZP0303abZP00ol00000l<RX0?38Z00=0?38Z003o`00003abZP0lLZX0100lLZX00?o00000?ooo`3o
ool0;`3oool00780oooo00?o00000?7:Z03abZP0303abZP00ol00000l<RX0?38Z00=0?38Z003o`00
003abZP0lLZX0100lLZX00?o00000?ooo`3oool0;`3oool00780oooo00?o00000?7:Z03abZP02`3a
bZP2o`0000h0l<RX00?o00000?7:Z03abZP04@3abZP00ol00000oooo0?ooo`0_0?ooo`00LP3oool0
0ol00000lLZX0?7:Z00;0?7:Z003o`00003`b:P0l<RX00d0l<RX00?o00000?7:Z03abZP04@3abZP0
0ol00000oooo0?ooo`0_0?ooo`00LP3oool00ol00000lLZX0?7:Z00;0?7:Z003o`00003`b:P0l<RX
00`0l<RX00?o00000?7:Z03abZP04P3abZP00ol00000oooo0?ooo`0_0?ooo`00LP3oool00ol00000
lLZX0?7:Z00:0?7:Z003o`00003`b:P0l<RX00d0l<RX00?o00000?7:Z03abZP04P3abZP00ol00000
oooo0?ooo`0_0?ooo`00LP3oool00ol00000lLZX0?7:Z00:0?7:Z003o`00003`b:P0l<RX00`0l<RX
00?o00000?7:Z03abZP04`3abZP00ol00000oooo0?ooo`0_0?ooo`00LP3oool00ol00000lLZX0?7:
Z00:0?7:Z003o`00003`b:P0l<RX00`0l<RX00?o00000?7:Z03abZP04`3abZP2o`000300oooo001b
0?ooo`03o`00003abZP0lLZX00T0lLZX00?o00000?38Z03`b:P0303`b:P00ol00000lLZX0?7:Z00E
0?7:Z003o`00003oool0oooo02h0oooo001a0?ooo`03o`00003abZP0lLZX00X0lLZX00?o00000?38
Z03`b:P0303`b:P00ol00000lLZX0?7:Z00E0?7:Z003o`00003oool0oooo02h0oooo001a0?ooo`03
o`00003abZP0lLZX00X0lLZX0_l0000<0?38Z003o`00003abZP0lLZX01H0lLZX00?o00000?ooo`3o
ool0;P3oool00740oooo00?o00000?7:Z03abZP02@3abZP01?l00000lLZX0?7:Z?l0000;0?38Z003
o`00003abZP0lLZX01H0lLZX00?o00000?ooo`3oool0;P3oool00740oooo00?o00000?7:Z03abZP0
203abZP2o`0000<0lLZX00?o00000?38Z03`b:P01`3`b:P00ol00000lLZX0?7:Z00G0?7:Z003o`00
003oool0oooo02h0oooo001a0?ooo`03o`00003abZP0lLZX00L0lLZX00?o00000?ooool00000103a
bZP00ol00000l<RX0?38Z0050?38Z003o`00003abZP0lLZX01P0lLZX00?o00000?ooo`3oool0;P3o
ool00740oooo00?o00000?7:Z03abZP01P3abZP00ol00000ooooo`0000060?7:Z003o`00003`b:P0
l<RX00@0l<RX00?o00000?7:Z03abZP0603abZP00ol00000oooo0?ooo`0^0?ooo`00L@3oool00ol0
0000lLZX0?7:Z0050?7:Z004o`00003oool0ooooo`0000H0lLZX00?o00000?38Z03`b:P00`3`b:P0
0ol00000lLZX0?7:Z00I0?7:Z003o`00003oool0oooo02h0oooo001a0?ooo`03o`00003abZP0lLZX
00@0lLZX00Go00000?ooo`3oool0ooooo`0000060?7:Z0;o0000103`b:P00ol00000lLZX0?7:Z00I
0?7:Z003o`00003oool0oooo02h0oooo001a0?ooo`03o`00003abZP0lLZX00<0lLZX00Go00000?oo
o`3oool0ooooo`0000080?7:Z0;o00000P3`b:P00ol00000lLZX0?7:Z00J0?7:Z003o`00003oool0
oooo02h0oooo001a0?ooo`03o`00003abZP0lLZX0080lLZX00?o00000?ooo`3oool00P3oool00ol0
0000lLZX0?7:Z0070?7:Z0;o000000<0l<RXo`00003abZP06`3abZP00ol00000oooo0?ooo`0^0?oo
o`00L@3oool01Ol00000lLZX0?7:Z03abZSo000000@0oooo00?o00000?7:Z03abZP02@3abZP2o`00
01d0lLZX00?o00000?ooo`3oool0;P3oool00700oooo00Go00000?7:Z03abZP0lLZXo`0000050?oo
o`03o`00003abZP0lLZX00X0lLZX00?o00000?7:Z03abZP06P3abZP00ol00000oooo0?ooo`0_0?oo
o`00L03oool01?l00000lLZX0?7:Z?l000060?ooo`03o`00003abZP0lLZX00/0lLZX0_l0000J0?7:
Z003o`00003oool0oooo02l0oooo001`0?ooo`03o`00003abZSo000000H0oooo00?o00000?7:Z03a
bZP0303abZP4o`0001L0lLZX00?o00000?ooo`3oool0<03oool00700oooo0_l000070?ooo`03o`00
003abZP0lLZX00`0lLZX00Co000004d7D`1=1e<0C@MC0_l0000E0?7:Z003o`00003oool0oooo0300
oooo001`0?ooo`03o`00003oool0oooo00H0oooo00?o00000?7:Z03abZP0303abZP00ol00000C@MC
04d7D`0304d7D`;o00004P3abZP00ol00000oooo0?ooo`0a0?ooo`00N03oool00ol00000lLZX0?7:
Z00=0?7:Z003o`00001=1e<0C@MC00<0C@MC00Co00000?ooool0003o0000403abZP00ol00000oooo
0?ooo`0a0?ooo`00N03oool00ol00000lLZX0?7:Z00=0?7:Z003o`00001=1e<0C@MC00<0C@MC00Co
00000?ooool00000C@MC0_l0000=0?7:Z003o`00003oool0oooo0380oooo001g0?ooo`03o`00003a
bZP0lLZX00h0lLZX00?o000004d7D`1=1e<00`1=1e<00ol00000ooooo`00000304d7D`;o00002`3a
bZP00ol00000oooo0?ooo`0b0?ooo`00M`3oool00ol00000lLZX0?7:Z00>0?7:Z003o`00001=1e<0
C@MC00<0C@MC00?o00000?ooool000001@1=1e<2o`0000P0lLZX00?o00000?ooo`3oool0<`3oool0
07L0oooo00?o00000?7:Z03abZP03P3abZP00ol00000C@MC04d7D`0304d7D`03o`00003ooooo0000
00L0C@MC0_l000060?7:Z003o`00003oool0oooo03<0oooo001f0?ooo`03o`00003abZP0lLZX00l0
lLZX00?o000004d7D`1=1e<00`1=1e<2o`0000X0C@MC0_l000030?7:Z003o`00003oool0oooo03@0
oooo001f0?ooo`03o`00003abZP0lLZX00l0lLZX00?o000004d7D`1=1e<00`1=1e<2o`0000`0C@MC
0_l000000`3abZSo00000?ooo`0e0?ooo`00MP3oool00ol00000lLZX0?7:Z00?0?7:Z003o`00001=
1e<0C@MC00<0C@MC0_l0000=04d7D`;o0000=`3oool007D0oooo00?o00000?7:Z03abZP0403abZP0
0ol00000C@MC04d7D`0304d7D`;o0000301=1e<00ol00000C@MCo`00000g0?ooo`00M@3oool00ol0
0000lLZX0?7:Z00@0?7:Z003o`00001=1e<0C@MC0080C@MC00?o00000?ooool000002P1=1e<2o`00
000304d7Dol0003o000003L0oooo001f0?ooo`03o`00003abZP0lLZX00l0lLZX00?o000004d7D`1=
1e<00P1=1e<00ol00000ooooo`00000904d7D`06o`00001=1e<0C@MCo`00001=1e?o0000=`3oool0
07L0oooo00?o00000?7:Z03abZP03P3abZP00ol00000C@MC04d7D`0204d7D`;o00002@1=1e<01Ol0
0000C@MC04d7D`1=1e?o00000080C@MC00?o00000?ooo`3oool0=03oool007P0oooo00?o00000?7:
Z03abZP03@3abZP00ol00000C@MC04d7D`0204d7D`;o00001`1=1e<2o`0000<0C@MC00Go000004d7
D`1=1e<0C@MCo`00000f0?ooo`00N@3oool00ol00000lLZX0?7:Z00<0?7:Z003o`00001=1e<0C@MC
0080C@MC0_l0000604d7D`03o`00001=1e<0C@MC0080C@MC00?o000004d7D`1=1e<00P1=1e<00ol0
0000oooo0?ooo`0d0?ooo`00N@3oool2o`0000h0lLZX00Co000004d7D`1=1e<0C@MC0_l0000404d7
D`;o00001@1=1e<00ol00000C@MC04d7D`0204d7D`03o`00003oool0oooo03@0oooo001h0?ooo`04
o`00001=1e<0C@MCo`0000d0lLZX00Co000004d7D`1=1e<0C@MC0_l0000304d7D`03o`00001=1e<0
C@MC00@0C@MC00?o000004d7D`1=1e<00`1=1e<00ol00000oooo0?ooo`0d0?ooo`00M`3oool00ol0
0000C@MC04d7D`0204d7D`03o`00003abZP0lLZX00X0lLZX00Co000004d7D`1=1e<0C@MC0_l00002
04d7D`03o`00001=1e<0C@MC00@0C@MC00?o000004d7D`1=1e<0101=1e<00ol00000oooo0?ooo`0d
0?ooo`00MP3oool00ol00000C@MC04d7D`0404d7D`03o`00003abZP0lLZX00T0lLZX00Ko000004d7
D`1=1e<0C@MCo`00001=1e<2o`0000L0C@MC00?o000004d7D`1=1e<01@1=1e<00ol00000oooo0?oo
o`0c0?ooo`00M@3oool00ol00000C@MC04d7D`0604d7D`03o`00003abZP0lLZX00P0lLZX00Co0000
04d7D`1=1e<0C@MC0_l0000804d7D`03o`00001=1e<0C@MC00H0C@MC00?o00000?ooo`3oool0<`3o
ool007@0oooo00?o000004d7D`1=1e<0201=1e<00ol00000lLZX0?7:Z0070?7:Z005o`00001=1e<0
C@MC04d7Dol00000201=1e<00ol00000C@MC04d7D`0704d7D`03o`00003oool0oooo03<0oooo001c
0?ooo`03o`00001=1e<0C@MC00T0C@MC00?o00000?7:Z03abZP01`3abZP00ol00000C@MC04d7D`0:
04d7D`03o`00001=1e<0C@MC00L0C@MC00?o00000?ooo`3oool0<`3oool00780oooo00?o000004d7
D`1=1e<02`1=1e<00ol00000lLZX0?7:Z0060?7:Z003o`00001=1e<0C@MC00T0C@MC00?o000004d7
D`1=1e<0201=1e<00ol00000oooo0?ooo`0c0?ooo`00L@3oool00ol00000C@MC04d7D`0=04d7D`03
o`00003abZP0lLZX00D0lLZX00?o000004d7D`1=1e<0201=1e<00ol00000C@MC04d7D`0904d7D`03
o`00003oool0oooo03<0oooo001`0?ooo`03o`00001=1e<0C@MC00l0C@MC00?o00000?7:Z03abZP0
103abZP01?l00000C@MC04d7Dol0000604d7D`03o`00001=1e<0C@MC00/0C@MC00?o00000?ooo`3o
ool0<P3oool006l0oooo00?o000004d7D`1=1e<04@1=1e<00ol00000lLZX0?7:Z0030?7:Z004o`00
001=1e<0C@MCo`0000H0C@MC00?o000004d7D`1=1e<02`1=1e<00ol00000oooo0?ooo`0b0?ooo`00
KP3oool00ol00000C@MC04d7D`0C04d7D`03o`00003abZP0lLZX0080lLZX00?o000004d7D`1=1e<0
1P1=1e<00ol00000C@MC04d7D`0<04d7D`03o`00003oool0oooo0380oooo001]0?ooo`03o`00001=
1e<0C@MC01D0C@MC00Go00000?7:Z03abZP0lLZXo`00000704d7D`03o`00001=1e<0C@MC00d0C@MC
00?o00000?ooo`3oool0<P3oool006`0oooo00?o000004d7D`1=1e<05`1=1e<01?l00000lLZX0?7:
Z?l0000704d7D`03o`00001=1e<0C@MC00d0C@MC00?o00000?ooo`3oool0<P3oool006/0oooo00?o
000004d7D`1=1e<06@1=1e<01Ol00000lLZXo`00001=1e?o000000@0C@MC00?o000004d7D`1=1e<0
3P1=1e<00ol00000oooo0?ooo`0b0?ooo`00JP3oool00ol00000C@MC04d7D`0K04d7D`;o000000<0
C@MCo`00001=1e<00P1=1e<00ol00000C@MC04d7D`0@04d7D`03o`00003oool0oooo0340oooo001Y
0?ooo`03o`00001=1e<0C@MC01d0C@MC00?o000004d7Dol000000`1=1e<00ol00000C@MC04d7D`0@
04d7D`03o`00003oool0oooo0340oooo001Y0?ooo`03o`00001=1e<0C@MC01l0C@MC00Co000004d7
D`1=1e?o00004P1=1e<2o`0003<0oooo001X0?ooo`03o`00001=1e<0C@MC0200C@MC00?o000004d7
Dol00000401=1e<3o`0003D0oooo001W0?ooo`03o`00001=1e<0C@MC0200C@MC00Co000004d7D`1=
1e?o00003P1=1e<2o`0003P0oooo001V0?ooo`03o`00001=1e<0C@MC0240C@MC00?o000004d7Dol0
0000301=1e<3o`0003X0oooo001U0?ooo`03o`00001=1e<0C@MC0280C@MC0_l0000:04d7D`?o0000
?@3oool006@0oooo00?o000004d7D`1=1e<08`1=1e<2o`0000P0C@MC0_l000100?ooo`00H`3oool0
0ol00000C@MC04d7D`0S04d7D`;o00001P1=1e<3o`000480oooo001R0?ooo`03o`00001=1e<0C@MC
02@0C@MC0_l0000404d7D`;o0000A@3oool00640oooo00?o000004d7D`1=1e<09@1=1e<00ol00000
ooooo`000003o`0004L0oooo001P0?ooo`03o`00001=1e<0C@MC02D0C@MC00Co00000?ooo`3ooooo
0000BP3oool005l0oooo00?o000004d7D`1=1e<09@1=1e<00ol00000oooo0?ooo`1<0?ooo`00GP3o
ool00ol00000C@MC04d7D`0U04d7D`03o`00003oool0oooo04d0oooo001M0?ooo`03o`00001=1e<0
C@MC02D0C@MC00?o00000?ooo`3oool0CP3oool005`0oooo00?o000004d7D`1=1e<09P1=1e<00ol0
0000oooo0?ooo`1>0?ooo`00F`3oool00ol00000C@MC04d7D`0V04d7D`03o`00003oool0oooo04l0
oooo001J0?ooo`03o`00001=1e<0C@MC02H0C@MC00?o00000?ooo`3oool0D03oool005T0oooo00?o
000004d7D`1=1e<09P1=1e<00ol00000oooo0?ooo`1A0?ooo`00F03oool00ol00000C@MC04d7D`0V
04d7D`03o`00003oool0oooo0580oooo001H0?ooo`03o`00001=1e<0C@MC02D0C@MC00?o00000?oo
o`3oool0D`3oool005T0oooo00?o000004d7D`1=1e<08`1=1e<00ol00000oooo0?ooo`1D0?ooo`00
F@3oool00ol00000C@MC04d7D`0R04d7D`03o`00003oool0oooo05D0oooo001J0?ooo`03o`00001=
1e<0C@MC0200C@MC00?o00000?ooo`3oool0EP3oool005/0oooo00?o000004d7D`1=1e<07P1=1e<0
0ol00000oooo0?ooo`1G0?ooo`00F`3oool00ol00000C@MC04d7D`0M04d7D`03o`00003oool0oooo
05P0oooo001L0?ooo`03o`00001=1e<0C@MC01/0C@MC00?o00000?ooo`3oool0F@3oool005`0oooo
00?o000004d7D`1=1e<06P1=1e<00ol00000oooo0?ooo`1J0?ooo`00G@3oool00ol00000C@MC04d7
D`0H04d7D`03o`00003oool0oooo05/0oooo001M0?ooo`03o`00001=1e<0C@MC01L0C@MC00?o0000
0?ooo`3oool0G03oool005h0oooo00?o000004d7D`1=1e<05@1=1e<00ol00000oooo0?ooo`1M0?oo
o`00G`3oool00ol00000C@MC04d7D`0C04d7D`03o`00003oool0oooo05h0oooo001O0?ooo`03o`00
001=1e<0C@MC0180C@MC00?o00000?ooo`3oool0G`3oool00600oooo00?o000004d7D`1=1e<0401=
1e<00ol00000oooo0?ooo`1P0?ooo`00H03oool00ol00000C@MC04d7D`0?04d7D`03o`00003oool0
oooo0640oooo001Q0?ooo`03o`00001=1e<0C@MC00d0C@MC00?o00000?ooo`3oool0HP3oool00680
oooo00?o000004d7D`1=1e<02`1=1e<00ol00000oooo0?ooo`1S0?ooo`00HP3oool00ol00000C@MC
04d7D`0:04d7D`03o`00003oool0oooo06@0oooo001S0?ooo`03o`00001=1e<0C@MC00P0C@MC00?o
00000?ooo`3oool0I@3oool006<0oooo00?o000004d7D`1=1e<01`1=1e<00ol00000oooo0?ooo`1V
0?ooo`00I03oool00ol00000C@MC04d7D`0504d7D`03o`00003oool0oooo06L0oooo001T0?ooo`03
o`00001=1e<0C@MC00@0C@MC00?o00000?ooo`3oool0J03oool006D0oooo00?o000004d7D`1=1e<0
0P1=1e<00ol00000oooo0?ooo`1Y0?ooo`00IP3oool01?l00000C@MC04d7Dol0001/0?ooo`00IP3o
ool00ol00000C@MCo`00001]0?ooo`00I`3oool00ol00000oooo0?ooo`1/0?ooo`00eP3oool00=H0
oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 213.812}, {256.375, 0}} -> {0.0832126, -0.000368046, \
0.00371548, 0.00371548}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.14891 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0837216 1.21201 -1.11022e-16 1.21201 [
[ 0 0 0 0 ]
[ 1 1.14891 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.14891 L
0 1.14891 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.70583 .55416 m .75722 .25411 L p .76046 .46063 L 0 0 .338 r
F P
0 g
s
.711 .57695 m .70583 .55416 L p .76046 .46063 L 0 0 .338 r
F P
0 g
s
.39762 .91743 m .61985 .67993 L p .61231 .86283 L .301 .028 .322 r
F P
0 g
s
.46029 1.03336 m .39762 .91743 L p .61231 .86283 L .301 .028 .322 r
F P
0 g
s
.7012 .65698 m .70313 .69524 L .71167 .66873 L p 0 0 .338 r
F P
0 g
s
.71167 .66873 m .70962 .6302 L .7012 .65698 L p 0 0 .338 r
F P
0 g
s
.61985 .67993 m .63263 .69234 L p .61231 .86283 L .301 .028 .322 r
F P
0 g
s
.71995 .58838 m .711 .57695 L p .76046 .46063 L 0 0 .338 r
F P
0 g
s
.7202 .59656 m .70962 .6302 L .71167 .66873 L p 0 0 .338 r
F P
0 g
s
.63263 .69234 m .62584 .7892 L .61231 .86283 L p .301 .028 .322 r
F P
0 g
s
.64529 .68339 m .62584 .7892 L .70209 .73995 L p .301 .028 .322 r
F P
0 g
s
.70209 .73995 m .68011 .66004 L .64529 .68339 L p .301 .028 .322 r
F P
0 g
s
.71167 .66873 m .7224 .63542 L .7202 .59656 L p 0 0 .338 r
F P
0 g
s
.70209 .73995 m .68011 .66004 L .7224 .63542 L p .301 .028 .322 r
F P
0 g
s
.72871 .56946 m .71995 .58838 L p .76046 .46063 L 0 0 .338 r
F P
0 g
s
.7202 .59656 m .72871 .56946 L .73502 .67526 L p 0 0 .338 r
F P
0 g
s
.73502 .67526 m .7224 .63542 L .7202 .59656 L p 0 0 .338 r
F P
0 g
s
.7224 .63542 m .73502 .67526 L .70209 .73995 L p .301 .028 .322 r
F P
0 g
s
.76046 .46063 m .75501 .48583 L .72871 .56946 L p 0 0 .338 r
F P
0 g
s
.72871 .56946 m .75501 .48583 L .75548 .49266 L p 0 0 .338 r
F P
0 g
s
.75548 .49266 m .73502 .67526 L .72871 .56946 L p 0 0 .338 r
F P
0 g
s
.75722 .25411 m .78337 .33319 L .76046 .46063 L p 0 0 .338 r
F P
0 g
s
.62584 .7892 m .61231 .86283 L .61759 .85951 L p .301 .028 .322 r
F P
0 g
s
.61759 .85951 m .70209 .73995 L .62584 .7892 L p .301 .028 .322 r
F P
0 g
s
.73502 .67526 m .70209 .73995 L p .71674 .46705 L .941 .788 .662 r
F P
0 g
s
.71674 .46705 m .72612 .49232 L .73502 .67526 L p .941 .788 .662 r
F P
0 g
s
.75548 .49266 m .76114 .46632 L .75501 .48583 L closepath p 0 0 .338 r
F P
0 g
s
.70209 .73995 m .60484 .69109 L p .71674 .46705 L .941 .788 .662 r
F P
0 g
s
.71831 .84181 m .70209 .73995 L .61759 .85951 L p .301 .028 .322 r
F P
0 g
s
.60484 .69109 m .6003 .68054 L .71674 .46705 L p .941 .788 .662 r
F P
0 g
s
.65525 .38582 m .71674 .46705 L .6003 .68054 L p .937 .78 .661 r
F P
0 g
s
.58964 .8953 m .46029 1.03336 L p .61231 .86283 L .301 .028 .322 r
F P
0 g
s
.61231 .86283 m .60803 .87247 L .58964 .8953 L p .301 .028 .322 r
F P
0 g
s
.61759 .85951 m .61078 .87111 L .61231 .86283 L closepath p .301 .028 .322 r
F P
0 g
s
.6157 .88493 m .71831 .84181 L p .61759 .85951 L .301 .028 .322 r
F P
0 g
s
.61759 .85951 m .61193 .87089 L .6157 .88493 L p .301 .028 .322 r
F P
0 g
s
.6003 .68054 m .55866 .63483 L .65525 .38582 L p .937 .78 .661 r
F P
0 g
s
.53229 .33989 m .64899 .37467 L .5602 .63501 L p .941 .788 .662 r
F P
0 g
s
.51763 .74384 m .60792 .83768 L .60484 .69109 L p .941 .788 .662 r
F P
0 g
s
.6003 .68054 m .60484 .69109 L .55869 .63886 L p .941 .788 .662 r
F P
0 g
s
.60484 .69109 m .55869 .63886 L .51763 .74384 L p .941 .788 .662 r
F P
0 g
s
.55869 .63886 m .5602 .63501 L .6003 .68054 L p .941 .788 .662 r
F P
0 g
s
.4958 .70342 m .53229 .33989 L p .5602 .63501 L .941 .788 .662 r
F P
0 g
s
.5602 .63501 m .55869 .63886 L .4958 .70342 L p .941 .788 .662 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 246.75},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000mR000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?oo
o`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F
0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo
003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0
oooo003F0?ooo`00X@3oool00ol00000oooo0?ooo`0b0?ooo`00X@3oool00ol00000oooo0?ooo`0b
0?ooo`00X@3oool00`0005Ko00000?ooo`0b0?ooo`00X@3oool00`0005Ko00000?ooo`0b0?ooo`00
X03oool00ol00000001Fo`00000c0?ooo`00X03oool01?l00000001F0000E_l0000b0?ooo`00X03o
ool01?l00000001F0000E_l0000b0?ooo`00X03oool01?l00000001F0000E_l0000b0?ooo`00X03o
ool01Ol00000001F0000EP0005Ko00000340oooo002P0?ooo`05o`00000005H0001F0000E_l00000
<@3oool009l0oooo00?o0000o`00EP0005H00P0005H00ol00000oooo0?ooo`0_0?ooo`00W`3oool0
0ol0003o001F0000EP030000EP03o`00003oool0oooo02h0oooo002O0?ooo`03o`000?l005H0001F
00<0001F00?o00000?ooo`3oool0;P3oool009l0oooo00?o0000o`00EP0005H00`0005H00ol00000
oooo0?ooo`0^0?ooo`00W`3oool00ol0003o001F0000EP040000EP03o`00003oool0oooo02d0oooo
002O0?ooo`03o`000?l005H0001F00@0001F00?o00000?ooo`3oool0;@3oool009h0oooo00?o0000
o`00E_l005H01@0005H00ol00000oooo0?ooo`0]0?ooo`00WP3oool00ol0003o001Fo`00EP060000
EP03o`00003oool0oooo02`0oooo001a0?ooo`?o0000:P3oool00ol0003o001Fo`00EP060000EP03
o`00003oool0oooo02`0oooo001a0?ooo`03o`00003`bJT0l<VY00?o00009`3oool00ol0003o001F
o`00EP060000EP03o`00003oool0oooo02`0oooo001a0?ooo`03o`00003`bJT0l<VY00<0l<VY0ol0
000T0?ooo`03o`000?l005Ko001F00H0001F00?o00000?ooo`3oool0;03oool00740oooo00?o0000
0?39Z@3`bJT01P3`bJT3o`000200oooo00Co0000o`00E_l005Ko001F1@0005H00ol00000oooo0?oo
o`0]0?ooo`00L@3oool00ol00000l<VY0?39Z@090?39Z@?o00007@3oool01?l0003o001Fo`00E_l0
05H50000EP03o`00003oool0oooo02d0oooo001a0?ooo`03o`00003`bJT0l<VY00`0l<VY0ol0000J
0?ooo`03o`000?l005Ko001F00;o001F100005H00ol00000oooo0?ooo`0]0?ooo`00L@3oool00ol0
0000l<VY0?39Z@0?0?39Z@?o00005`3oool00ol0003o001Fo`00EP02o`00EP@0001F00?o00000?oo
o`3oool0;@3oool00700oooo00?o00000?39Z@3`bJT04`3`bJT3o`0001@0oooo00?o0000o`00E_l0
05H00_l005H40000EP03o`00003oool0oooo02d0oooo001`0?ooo`03o`00003`bJT0l<VY01H0l<VY
0_l0000B0?ooo`03o`000?l005Ko001F00;o001F0`0005H00ol00000oooo0?ooo`0^0?ooo`00L03o
ool00ol00000l<VY0?39Z@0G0?39Z@03o`00003oool0oooo00l0oooo00?o0000o`00E_l005H00ol0
05H30000EP03o`00003oool0oooo02h0oooo001`0?ooo`03o`00003`bJT0l<VY01H0l<VY00Co0000
0?ooo`3ooooo00003`3oool00ol0003o001Fo`00EP03o`00EP<0001F00?o00000?ooo`3oool0;P3o
ool00700oooo00?o00000?39Z@3`bJT05P3`bJT01?l00000oooo0?ooool0000?0?ooo`03o`000?l0
05Ko001F00?o001F0`0005H00ol00000oooo0?ooo`0^0?ooo`00L03oool00ol00000l<VY0?39Z@0F
0?39Z@05o`00003ooooo00000>o7ZOl000003P3oool00ol0003o001Fo`00EP03o`00EP<0001F00?o
00000?ooo`3oool0;P3oool00700oooo00?o00000?39Z@3`bJT05@3`bJT01?l00000oooo0?ooool0
00020>o7Z@03o`00003oool0oooo00/0oooo00?o0000o`00E_l005H00ol005H20000EP03o`00003o
ool0oooo02l0oooo001`0?ooo`03o`00003`bJT0l<VY01D0l<VY00Co00000?ooo`3ooooo00000`3_
ajT00ol00000oooo0?ooo`0:0?ooo`03o`000?l005Ko001F00?o001F0P0005H00ol00000oooo0?oo
o`0_0?ooo`00L03oool00ol00000l<VY0?39Z@0E0?39Z@03o`00003ooooo000000@0klNY00?o0000
0?ooo`3oool02@3oool00ol0003o001Fo`00EP04o`00EP80001F00?o00000?ooo`3oool0;`3oool0
0700oooo00?o00000?39Z@3`bJT0503`bJT01?l00000oooo0?ooool000050>o7Z@03o`00003oool0
oooo00P0oooo00?o0000o`00E_l005H01?l005H20000EP03o`00003oool0oooo02l0oooo001`0?oo
o`03o`00003`bJT0l<VY01@0l<VY00?o00000?ooool000001`3_ajT00ol00000oooo0?ooo`070?oo
o`03o`000?l005Ko001F00Co001F0P0005H00ol00000oooo0?ooo`0_0?ooo`00K`3oool00ol00000
l<VY0?39Z@0E0?39Z@03o`00003ooooo000000L0klNY00?o00000?ooo`3oool01`3oool00ol0003o
001Fo`00EP04o`00EP80001F00?o00000?ooo`3oool0;`3oool006l0oooo00?o00000?39Z@3`bJT0
503`bJT01?l00000oooo0?ooool000080>o7Z@03o`00003oool0oooo00H0oooo00?o0000o`00E_l0
05H01?l005H00`0005Ko00000?ooo`0a0?ooo`00K`3oool00ol00000l<VY0?39Z@0D0?39Z@03o`00
003ooooo000000X0klNY00?o00000?ooo`3oool01@3oool00ol0003o001Fo`00EP04o`00EP030000
E_l00000oooo0340oooo001_0?ooo`03o`00003`bJT0l<VY01@0l<VY00?o00000?ooool000002`3_
ajT00ol00000oooo0?ooo`030?ooo`03o`000?l005Ko001F00Go001F00<0001Fo`00003oool0<@3o
ool006l0oooo00?o00000?39Z@3`bJT04`3`bJT01?l00000oooo0?ooool0000;0>o7Z@03o`00003o
ool0oooo00<0oooo00?o0000o`00E_l005H01Ol005H00`0005Ko00000?ooo`0a0?ooo`00K`3oool0
0ol00000l<VY0?39Z@0C0?39Z@03o`00003ooooo000000d0klNY00?o00000?ooo`3oool00P3oool0
0ol0003o001Fo`00EP05o`00EP030000E_l00000oooo0340oooo001_0?ooo`03o`00003`bJT0l<VY
01<0l<VY00?o00000?ooool000003P3_ajT01Ol00000oooo0?ooo`3ooooo000000Oo001F00?o0000
0?ooo`3oool0<@3oool006l0oooo00?o00000?39Z@3`bJT04P3`bJT00ol00000ooooo`00000?0>o7
Z@05o`00003oool0oooo0?ooool000001ol005H00ol00000oooo0?ooo`0a0?ooo`00K`3oool00ol0
0000l<VY0?39Z@0B0?39Z@03o`00003ooooo00000100klNY00Co00000?ooo`3ooooo00001ol005H0
0ol00000oooo0?ooo`0a0?ooo`00K`3oool00ol00000l<VY0?39Z@0B0?39Z@03o`00003ooooo0000
0140klNY0_l00008o`00EP03o`00003oool0oooo0340oooo001_0?ooo`03o`00003`bJT0l<VY0140
l<VY00?o00000?ooool000004`3_ajT00ol0003o001Fo`00EP06o`00EP03o`00003oool0oooo0340
oooo001^0?ooo`03o`00003`bJT0l<VY0180l<VY00?o00000?ooool000004`3_ajT00ol0003o001F
o`00EP05o`00EP030000E_l00000oooo0380oooo001^0?ooo`03o`00003`bJT0l<VY0180l<VY0_l0
000C0>o7Z@03o`00003`bJWo000000Go001F00<0001Fo`000?l00000<`3oool006h0oooo00?o0000
0?39Z@3`bJT04@3`bJT00ol00000ooooo`00000C0>o7Z@03o`00003`bJWo000000Go001F00<0001F
o`00003oool0<`3oool006h0oooo00?o00000?39Z@3`bJT04@3`bJT00ol00000ooooo`00000B0>o7
Z@04o`00003`bJT0l<VYo`0000Co001F0P0005H00ol00000oooo0?ooo`0b0?ooo`00KP3oool00ol0
0000l<VY0?39Z@0A0?39Z@;o00004P3_ajT00ol00000l<VY0?39Z@020?39Z@04o`000?l005Ko001F
o`00EP80001F00?o00000?ooo`3oool0<P3oool006h0oooo00?o00000?39Z@3`bJT0403`bJT00ol0
0000ooooo`00000B0>o7Z@03o`00003`bJT0l<VY0080l<VY00?o0000o`00E_l005H00P0005H2o`00
03@0oooo001^0?ooo`03o`00003`bJT0l<VY0100l<VY0_l0000B0>o7Z@03o`00003`bJT0l<VY00<0
l<VY00?o0000o`00EP0005H00P0005H2o`0003@0oooo001^0?ooo`03o`00003`bJT0l<VY0100l<VY
0_l0000B0>o7Z@03o`00003`bJT0l<VY00<0l<VY00?o0000o`00EP0005H00`0005H00ol00000oooo
0?ooo`0b0?ooo`00KP3oool00ol00000l<VY0?39Z@0?0?39Z@03o`00003ooooo00000140klNY00?o
00000?39Z@3`bJT0103`bJT01ol00000001F0000EP0005Ko00000000E_l00000=03oool006h0oooo
00?o00000?39Z@3`bJT03`3`bJT2o`000180klNY00?o00000?39Z@3`bJT0103`bJT01ol00000001F
0000EP0005Ko00000000E_l00000=03oool006h0oooo00?o00000?39Z@3`bJT03`3`bJT2o`000140
klNY00?o00000?39Z@3`bJT01@3`bJT00ol00000001F0000EP020000EP03o`00003oool0oooo03<0
oooo001]0?ooo`03o`00003`bJT0l<VY00l0l<VY00?o00000?ooool000004@3_ajT00ol00000l<VY
0?39Z@050?39Z@06o`00000005H0001Fo`00000005Ko0000=@3oool006d0oooo00?o00000?39Z@3`
bJT03`3`bJT2o`000140klNY00?o00000?39Z@3`bJT01P3`bJT01_l00000001F0000E_l00000001F
o`0003D0oooo001]0?ooo`03o`00003`bJT0l<VY00l0l<VY0_l0000@0>o7Z@03o`00003`bJT0l<VY
00L0l<VY00?o00000000EP0005H00P0005H00ol00000oooo0?ooo`0c0?ooo`00K@3oool00ol00000
l<VY0?39Z@0>0?39Z@;o00004@3_ajT00ol00000l<VY0?39Z@070?39Z@03o`00000005Ko00000080
001F00?o00000?ooo`3oool0<`3oool006d0oooo00?o00000?39Z@3`bJT03P3`bJT2o`000100klNY
00?o00000?39Z@3`bJT02@3`bJT2o`000080001F00?o00000?ooo`3oool0<`3oool006d0oooo00?o
00000?39Z@3`bJT03P3`bJT2o`000100klNY00?o00000?39Z@3`bJT02@3`bJT01Ol00000001F0000
EP0005Ko000003D0oooo001]0?ooo`03o`00003`bJT0l<VY00d0l<VY0_l0000@0>o7Z@03o`00003`
bJT0l<VY00X0l<VY00Go00000000EP0005H0001Fo`00000e0?ooo`00K@3oool00ol00000l<VY0?39
Z@0=0?39Z@;o0000403_ajT00ol00000l<VY0?39Z@0:0?39Z@05o`00000005H0001F0000E_l00000
=@3oool006d0oooo00?o00000?39Z@3`bJT03@3`bJT00ol00000klNY0>o7Z@0>0>o7Z@03o`00003`
bJT0l<VY00/0l<VY00Go00000000EP0005H0001Fo`00000e0?ooo`00K@3oool00ol00000l<VY0?39
Z@0<0?39Z@;o0000403_ajT00ol00000l<VY0?39Z@0;0?39Z@04o`00000005H0001Fo`0003H0oooo
001]0?ooo`03o`00003`bJT0l<VY00`0l<VY0_l0000?0>o7Z@03o`00003`bJT0l<VY00`0l<VY00Co
00000000EP0005Ko0000=P3oool006`0oooo00?o00000?39Z@3`bJT03@3`bJT00ol00000klNY0>o7
Z@0=0>o7Z@03o`00003`bJT0l<VY00d0l<VY00Co00000000EP0005Ko0000=P3oool006`0oooo00?o
00000?39Z@3`bJT0303`bJT2o`0000l0klNY00?o00000?39Z@3`bJT03@3`bJT01?l00000001F0000
E_l0000f0?ooo`00K03oool00ol00000l<VY0?39Z@0<0?39Z@03o`00003_ajT0klNY00d0klNY00?o
00000?39Z@3`bJT03P3`bJT01?l00000001F0000E_l0000f0?ooo`00K03oool00ol00000l<VY0?39
Z@0<0?39Z@03o`00003_ajT0klNY00d0klNY00?o00000?39Z@3`bJT03P3`bJT01?l00000001F0000
E_l0000f0?ooo`00K03oool00ol00000l<VY0?39Z@0;0?39Z@;o00003P3_ajT00ol00000l<VY0?39
Z@0?0?39Z@04o`00000005H0001Fo`0003H0oooo001/0?ooo`03o`00003`bJT0l<VY00/0l<VY00?o
00000>o7Z@3_ajT03@3_ajT00ol00000l<VY0?39Z@0?0?39Z@04o`00000005H0001Fo`0003H0oooo
001/0?ooo`03o`00003`bJT0l<VY00/0l<VY00?o00000>o7Z@3_ajT0303_ajT00ol00000l<VY0?39
Z@0@0?39Z@04o`00000005H0001Fo`0003H0oooo001/0?ooo`03o`00003`bJT0l<VY00X0l<VY0_l0
000>0>o7Z@03o`00003`bJT0l<VY0100l<VY00?o00000000E_l00000=`3oool006`0oooo00?o0000
0?39Z@3`bJT02P3`bJT00ol00000klNY0>o7Z@0<0>o7Z@03o`00003`bJT0l<VY0140l<VY00?o0000
0000E_l00000=`3oool006`0oooo00?o00000?39Z@3`bJT02P3`bJT00ol00000klNY0>o7Z@0;0>o7
Z@03o`00003`bJT0l<VY0180l<VY00?o00000000E_l00000=`3oool006`0oooo00?o00000?39Z@3`
bJT02@3`bJT00ol00000klNY0>o7Z@0<0>o7Z@03o`00003`bJT0l<VY0180l<VY00?o00000000E_l0
0000=`3oool006/0oooo00?o00000?39Z@3`bJT02P3`bJT00ol00000klNY0>o7Z@0;0>o7Z@03o`00
003`bJT0l<VY01<0l<VY00?o00000000E_l00000=`3oool006/0oooo00?o00000?39Z@3`bJT02P3`
bJT00ol00000klNY0>o7Z@0;0>o7Z@03o`00003`bJT0l<VY01@0l<VY0_l0000g0?ooo`00J`3oool0
0ol00000l<VY0?39Z@090?39Z@03o`00003_ajT0klNY00/0klNY00?o00000?39Z@3`bJT05@3`bJT2
o`0003L0oooo001[0?ooo`03o`00003`bJT0l<VY00T0l<VY0_l0000<0>o7Z@03o`00003`bJT0l<VY
01D0l<VY0_l0000g0?ooo`00J`3oool00ol00000l<VY0?39Z@080?39Z@04o`00003`bJWo0000o`00
00X0klNY00?o00000?39Z@3`bJT05P3`bJT2o`0003L0oooo001[0?ooo`03o`00003`bJT0l<VY00L0
l<VY0_l000020?39Z@;o00002@3_ajT00ol00000l<VY0?39Z@0F0?39Z@;o0000=`3oool006/0oooo
00?o00000?39Z@3`bJT01P3`bJT00ol00000ooooo`0000030?39Z@;o00001`3_ajT00ol00000l<VY
0?39Z@0G0?39Z@03o`00003oool0oooo03H0oooo001[0?ooo`03o`00003`bJT0l<VY00D0l<VY00?o
00000?ooool000001@3`bJT2o`0000D0klNY00?o00000?39Z@3`bJT0603`bJT00ol00000oooo0?oo
o`0f0?ooo`00J`3oool00ol00000l<VY0?39Z@040?39Z@04o`00003oool0ooooo`0000H0l<VY0_l0
00040>o7Z@03o`00003`bJT0l<VY01P0l<VY00?o00000?ooo`3oool0=P3oool006/0oooo00?o0000
0?39Z@3`bJT00`3`bJT01?l00000oooo0?ooool000070?39Z@03o`00003`bJWo00000080klNY00?o
00000?39Z@3`bJT06@3`bJT00ol00000oooo0?ooo`0f0?ooo`00J`3oool00ol00000l<VY0?39Z@02
0?39Z@05o`00003oool0oooo0?ooool00000203`bJT01Ol00000l<VYo`00003_ajWo000001/0l<VY
00?o00000?ooo`3oool0=P3oool006X0oooo00?o00000?39Z@3`bJT00P3`bJT00ol00000oooo0?oo
o`020?ooo`03o`00003`bJT0l<VY00L0l<VY00?o00000?39ZOl00000703`bJT00ol00000oooo0?oo
o`0f0?ooo`00JP3oool01Ol00000l<VY0?39Z@3`bJWo000000@0oooo00?o00000?39Z@3`bJT02@3`
bJT2o`0001/0l<VY00?o00000?ooo`3oool0=`3oool006X0oooo00Co00000?39Z@3`bJWo00001@3o
ool00ol00000l<VY0?39Z@0:0?39Z@;o00006P3`bJT00ol00000oooo0?ooo`0g0?ooo`00JP3oool0
0ol00000l<VYo`0000050?ooo`03o`00003`bJT0l<VY00`0l<VY0_l0000H0?39Z@03o`00003oool0
oooo03P0oooo001Z0?ooo`;o00001P3oool00ol00000l<VY0?39Z@0<0?39Z@04o`00001=1e;o0000
o`0001H0l<VY00?o00000?ooo`3oool0>03oool006X0oooo00?o00000?ooo`3oool01@3oool00ol0
0000l<VY0?39Z@0<0?39Z@04o`00001=1e80C@MB04d7DP;o00004`3`bJT00ol00000oooo0?ooo`0i
0?ooo`00L@3oool00ol00000l<VY0?39Z@0=0?39Z@03o`00001=1e80C@MB00<0C@MB0_l0000A0?39
Z@03o`00003oool0oooo03T0oooo001a0?ooo`03o`00003`bJT0l<VY00d0l<VY00?o000004d7DP1=
1e800`1=1e84o`0000h0l<VY00?o00000?ooo`3oool0>P3oool00740oooo00?o00000?39Z@3`bJT0
3@3`bJT00ol00000C@MB04d7DP0304d7DP;o00000P1=1e83o`0000/0l<VY00?o00000?ooo`3oool0
>P3oool00700oooo00?o00000?39Z@3`bJT03P3`bJT00ol00000C@MB04d7DP0204d7DP03o`00003o
oooo000000D0C@MB0_l000080?39Z@03o`00003oool0oooo03/0oooo001`0?ooo`03o`00003`bJT0
l<VY00h0l<VY00?o000004d7DP1=1e800P1=1e800ol00000ooooo`00000704d7DP;o00001P3`bJT0
0ol00000oooo0?ooo`0k0?ooo`00K`3oool00ol00000l<VY0?39Z@0?0?39Z@03o`00001=1e80C@MB
0080C@MB0_l0000:04d7DP;o00000`3`bJT00ol00000oooo0?ooo`0l0?ooo`00K`3oool00ol00000
l<VY0?39Z@0?0?39Z@03o`00001=1e80C@MB0080C@MB0_l0000<04d7DP;o000000<0l<VYo`00003o
ool0?@3oool006l0oooo00?o00000?39Z@3`bJT03`3`bJT00ol00000C@MB04d7DP0204d7DP;o0000
3@1=1e82o`0003l0oooo001^0?ooo`03o`00003`bJT0l<VY0100l<VY00?o000004d7DP1=1e800P1=
1e82o`0000`0C@MB00?o000004d7D_l00000?`3oool006h0oooo00?o00000?39Z@3`bJT0403`bJT0
0ol00000C@MB04d7DP0204d7DP;o00002P1=1e82o`00000304d7D_l0003o000003l0oooo001_0?oo
o`03o`00003`bJT0l<VY00l0l<VY00?o000004d7DP1=1e800P1=1e800ol00000C@MB04d7DP0804d7
DP06o`00001=1e80C@MBo`00001=1e;o0000?`3oool00700oooo00?o00000?39Z@3`bJT03P3`bJT0
0ol00000C@MB04d7DP0204d7DP03o`00001=1e80C@MB00H0C@MB0_l0000304d7DP03o`00001=1e;o
000003l0oooo001a0?ooo`03o`00003`bJT0l<VY00d0l<VY00?o000004d7DP1=1e800P1=1e800ol0
0000C@MB04d7DP0404d7DP;o0000101=1e801Ol00000C@MB04d7DP1=1e;o000003h0oooo001b0?oo
o`03o`00003`bJT0l<VY00`0l<VY00?o000004d7DP1=1e800P1=1e800ol00000C@MB04d7DP0304d7
DP03o`00001=1e80C@MB00<0C@MB00?o000004d7DP1=1e800P1=1e800ol00000oooo0?ooo`0l0?oo
o`00LP3oool2o`0000d0l<VY00Co000004d7DP1=1e80C@MB0_l0000304d7DP;o00001@1=1e800ol0
0000C@MB04d7DP0304d7DP03o`00003oool0oooo03`0oooo001a0?ooo`04o`00001=1e80C@MBo`00
00`0l<VY00Co000004d7DP1=1e80C@MB0_l0000204d7DP03o`00001=1e80C@MB00D0C@MB00?o0000
04d7DP1=1e800`1=1e800ol00000oooo0?ooo`0l0?ooo`00L03oool00ol00000C@MB04d7DP0204d7
DP03o`00003`bJT0l<VY00T0l<VY00Ko000004d7DP1=1e80C@MBo`00001=1e82o`0000L0C@MB00?o
000004d7DP1=1e80101=1e800ol00000oooo0?ooo`0l0?ooo`00K`3oool00ol00000C@MB04d7DP04
04d7DP03o`00003`bJT0l<VY00P0l<VY00Co000004d7DP1=1e80C@MB0_l0000804d7DP03o`00001=
1e80C@MB00D0C@MB00?o00000?ooo`3oool0?03oool006h0oooo00?o000004d7DP1=1e801P1=1e80
0ol00000l<VY0?39Z@070?39Z@05o`00001=1e80C@MB04d7D_l000002@1=1e800ol00000C@MB04d7
DP0504d7DP03o`00003oool0oooo03`0oooo001]0?ooo`03o`00001=1e80C@MB00P0C@MB00?o0000
0?39Z@3`bJT01P3`bJT00ol00000C@MB04d7DP0:04d7DP03o`00001=1e80C@MB00L0C@MB00?o0000
0?ooo`3oool0>`3oool006`0oooo00?o000004d7DP1=1e802P1=1e800ol00000l<VY0?39Z@050?39
Z@03o`00001=1e80C@MB00T0C@MB00?o000004d7DP1=1e80201=1e800ol00000oooo0?ooo`0k0?oo
o`00K03oool00ol00000C@MB04d7DP0;04d7DP03o`00003`bJT0l<VY00@0l<VY00Co000004d7DP1=
1e;o0000201=1e800ol00000C@MB04d7DP0804d7DP03o`00003oool0oooo03/0oooo001[0?ooo`03
o`00001=1e80C@MB00d0C@MB00?o00000?39Z@3`bJT00`3`bJT01?l00000C@MB04d7D_l0000704d7
DP03o`00001=1e80C@MB00T0C@MB00?o00000?ooo`3oool0>`3oool006X0oooo00?o000004d7DP1=
1e803`1=1e800ol00000l<VY0?39Z@020?39Z@04o`00001=1e80C@MBo`0000H0C@MB00?o000004d7
DP1=1e802P1=1e800ol00000oooo0?ooo`0k0?ooo`00J@3oool00ol00000C@MB04d7DP0A04d7DP05
o`00003`bJT0l<VY0?39ZOl000000P1=1e800ol00000C@MB04d7DP0404d7DP03o`00001=1e80C@MB
00X0C@MB00?o00000?ooo`3oool0>`3oool006P0oooo00?o000004d7DP1=1e804`1=1e801?l00000
l<VY0?39ZOl0000204d7DP03o`00001=1e80C@MB00<0C@MB00?o000004d7DP1=1e802`1=1e800ol0
0000oooo0?ooo`0k0?ooo`00I`3oool00ol00000C@MB04d7DP0E04d7DP05o`00003`bJWo000004d7
D_l000001@1=1e800ol00000C@MB04d7DP0=04d7DP03o`00003oool0oooo03X0oooo001V0?ooo`03
o`00001=1e80C@MB01L0C@MB0_l000000`1=1e;o000004d7DP0304d7DP03o`00001=1e80C@MB00h0
C@MB00?o00000?ooo`3oool0>P3oool006D0oooo00?o000004d7DP1=1e806@1=1e800ol00000C@MB
o`00000404d7DP03o`00001=1e80C@MB00h0C@MB00?o00000?ooo`3oool0>P3oool006@0oooo00?o
000004d7DP1=1e80701=1e801Ol00000C@MB04d7DP1=1e;o00000100C@MB0_l0000l0?ooo`00H`3o
ool00ol00000C@MB04d7DP0M04d7DP04o`00001=1e80C@MBo`0000h0C@MB0ol0000n0?ooo`00HP3o
ool00ol00000C@MB04d7DP0M04d7DP05o`00001=1e80C@MB04d7D_l00000301=1e82o`000440oooo
001Q0?ooo`03o`00001=1e80C@MB01h0C@MB00Co000004d7DP1=1e;o00002P1=1e83o`0004<0oooo
001Q0?ooo`03o`00001=1e80C@MB01h0C@MB0ol0000904d7DP;o0000AP3oool00600oooo00?o0000
04d7DP1=1e807`1=1e82o`0000P0C@MB0_l000180?ooo`00G`3oool00ol00000C@MB04d7DP0P04d7
DP03o`00001=1e80C@MB00@0C@MB0ol0001:0?ooo`00GP3oool00ol00000C@MB04d7DP0Q04d7DP03
o`00001=1e80C@MB0080C@MB0_l0001=0?ooo`00G@3oool00ol00000C@MB04d7DP0Q04d7DP03o`00
003ooooo000000?o0000C`3oool005`0oooo00?o000004d7DP1=1e808@1=1e801?l00000oooo0?oo
ool0001B0?ooo`00F`3oool00ol00000C@MB04d7DP0Q04d7DP03o`00003oool0oooo05@0oooo001J
0?ooo`03o`00001=1e80C@MB0240C@MB00?o00000?ooo`3oool0E@3oool005T0oooo00?o000004d7
DP1=1e808P1=1e800ol00000oooo0?ooo`1E0?ooo`00F03oool00ol00000C@MB04d7DP0R04d7DP03
o`00003oool0oooo05H0oooo001G0?ooo`03o`00001=1e80C@MB0280C@MB00?o00000?ooo`3oool0
E`3oool005H0oooo00?o000004d7DP1=1e808P1=1e800ol00000oooo0?ooo`1H0?ooo`00E@3oool0
0ol00000C@MB04d7DP0R04d7DP03o`00003oool0oooo05T0oooo001E0?ooo`03o`00001=1e80C@MB
0240C@MB00?o00000?ooo`3oool0FP3oool005H0oooo00?o000004d7DP1=1e807`1=1e800ol00000
oooo0?ooo`1K0?ooo`00EP3oool00ol00000C@MB04d7DP0N04d7DP03o`00003oool0oooo05`0oooo
001G0?ooo`03o`00001=1e80C@MB01`0C@MB00?o00000?ooo`3oool0G@3oool005L0oooo00?o0000
04d7DP1=1e806`1=1e800ol00000oooo0?ooo`1N0?ooo`00F03oool00ol00000C@MB04d7DP0I04d7
DP03o`00003oool0oooo05l0oooo001H0?ooo`03o`00001=1e80C@MB01P0C@MB00?o00000?ooo`3o
ool0H03oool005T0oooo00?o000004d7DP1=1e805P1=1e800ol00000oooo0?ooo`1Q0?ooo`00F@3o
ool00ol00000C@MB04d7DP0E04d7DP03o`00003oool0oooo0680oooo001J0?ooo`03o`00001=1e80
C@MB01<0C@MB00?o00000?ooo`3oool0H`3oool005X0oooo00?o000004d7DP1=1e804`1=1e800ol0
0000oooo0?ooo`1S0?ooo`00F`3oool00ol00000C@MB04d7DP0A04d7DP03o`00003oool0oooo06@0
oooo001L0?ooo`03o`00001=1e80C@MB00l0C@MB00?o00000?ooo`3oool0I@3oool005`0oooo00?o
000004d7DP1=1e803P1=1e800ol00000oooo0?ooo`1V0?ooo`00G@3oool00ol00000C@MB04d7DP0<
04d7DP03o`00003oool0oooo06L0oooo001M0?ooo`03o`00001=1e80C@MB00/0C@MB00?o00000?oo
o`3oool0J03oool005h0oooo00?o000004d7DP1=1e802@1=1e800ol00000oooo0?ooo`1Y0?ooo`00
GP3oool00ol00000C@MB04d7DP0804d7DP03o`00003oool0oooo06X0oooo001O0?ooo`03o`00001=
1e80C@MB00H0C@MB00?o00000?ooo`3oool0J`3oool005l0oooo00?o000004d7DP1=1e801@1=1e80
0ol00000oooo0?ooo`1/0?ooo`00H03oool00ol00000C@MB04d7DP0304d7DP03o`00003oool0oooo
06d0oooo001P0?ooo`03o`00001=1e80C@MB0080C@MB00?o00000?ooo`3oool0KP3oool00640oooo
00Co000004d7DP1=1e;o0000L@3oool00640oooo00?o000004d7D_l00000LP3oool00680oooo00?o
00000?ooo`3oool0L@3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool0
0=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3o
ool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00=H0oooo003F0?ooo`00
eP3oool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {245.75, 0}} -> {0.0690725, -0.00019514, \
0.00385891, 0.00385891}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.02222 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0301908 1.08796 0 1.08796 [
[ 0 0 0 0 ]
[ 1 1.02222 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.02222 L
0 1.02222 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.63824 .50699 m .8577 .32687 L p .7825 .47179 L .285 .009 .307 r
F P
0 g
s
.63929 .52608 m .63824 .50699 L p .7825 .47179 L .285 .009 .307 r
F P
0 g
s
.35421 .82282 m .55037 .6131 L p .53772 .77256 L .285 .009 .307 r
F P
0 g
s
.40477 .92139 m .35421 .82282 L p .53772 .77256 L .285 .009 .307 r
F P
0 g
s
.55037 .6131 m .56072 .624 L p .53772 .77256 L .285 .009 .307 r
F P
0 g
s
.58686 .57786 m .57505 .60631 L .60317 .59186 L p .285 .009 .307 r
F P
0 g
s
.60317 .59186 m .6148 .56326 L .58686 .57786 L p .285 .009 .307 r
F P
0 g
s
.65246 .53912 m .63929 .52608 L p .7825 .47179 L .285 .009 .307 r
F P
0 g
s
.64963 .54506 m .6148 .56326 L .60317 .59186 L p .285 .009 .307 r
F P
0 g
s
.56072 .624 m .55159 .70869 L .53772 .77256 L p .285 .009 .307 r
F P
0 g
s
.5717 .6161 m .55159 .70869 L .61716 .66536 L p .285 .009 .307 r
F P
0 g
s
.61716 .66536 m .60184 .59551 L .5717 .6161 L p .285 .009 .307 r
F P
0 g
s
.60317 .59186 m .63823 .57385 L .64963 .54506 L p .285 .009 .307 r
F P
0 g
s
.67745 .53052 m .65246 .53912 L p .7825 .47179 L .285 .009 .307 r
F P
0 g
s
.61716 .66536 m .60184 .59551 L .63823 .57385 L p .285 .009 .307 r
F P
0 g
s
.64963 .54506 m .67745 .53052 L .64715 .60881 L p .285 .009 .307 r
F P
0 g
s
.64715 .60881 m .63823 .57385 L .64963 .54506 L p .285 .009 .307 r
F P
0 g
s
.8577 .32687 m .87561 .39676 L .7825 .47179 L p .285 .009 .307 r
F P
0 g
s
.7825 .47179 m .76207 .4863 L .67745 .53052 L p .285 .009 .307 r
F P
0 g
s
.67745 .53052 m .76207 .4863 L .76026 .49133 L p .285 .009 .307 r
F P
0 g
s
.76026 .49133 m .64715 .60881 L .67745 .53052 L p .285 .009 .307 r
F P
0 g
s
.63823 .57385 m .64715 .60881 L .61716 .66536 L p .285 .009 .307 r
F P
0 g
s
.55159 .70869 m .53772 .77256 L .54225 .76964 L p .285 .009 .307 r
F P
0 g
s
.54225 .76964 m .61716 .66536 L .55159 .70869 L p .285 .009 .307 r
F P
0 g
s
.64715 .60881 m .61716 .66536 L p .62969 .42668 L .933 .781 .668 r
F P
0 g
s
.62969 .42668 m .63837 .44867 L .64715 .60881 L p .933 .781 .668 r
F P
0 g
s
.76026 .49133 m .78153 .47613 L .76207 .4863 L closepath p .285 .009 .307 r
F P
0 g
s
.61716 .66536 m .52854 .62237 L p .62969 .42668 L .933 .781 .668 r
F P
0 g
s
.62665 .75324 m .61716 .66536 L .54225 .76964 L p .285 .009 .307 r
F P
0 g
s
.52854 .62237 m .52441 .61319 L .62969 .42668 L p .933 .781 .668 r
F P
0 g
s
.57349 .35658 m .62969 .42668 L .52441 .61319 L p .929 .773 .666 r
F P
0 g
s
.51767 .80082 m .40477 .92139 L p .53772 .77256 L .285 .009 .307 r
F P
0 g
s
.53772 .77256 m .53382 .78093 L .51767 .80082 L p .285 .009 .307 r
F P
0 g
s
.54225 .76964 m .53617 .77972 L .53772 .77256 L closepath p .285 .009 .307 r
F P
0 g
s
.53981 .79154 m .62665 .75324 L p .54225 .76964 L .285 .009 .307 r
F P
0 g
s
.54225 .76964 m .53714 .77952 L .53981 .79154 L p .285 .009 .307 r
F P
0 g
s
.52441 .61319 m .48685 .57351 L .57349 .35658 L p .929 .773 .666 r
F P
0 g
s
.46243 .31879 m .56763 .34704 L .48816 .57366 L p .933 .781 .668 r
F P
0 g
s
.45027 .66778 m .53173 .74994 L .52854 .62237 L p .933 .781 .668 r
F P
0 g
s
.52441 .61319 m .52854 .62237 L .48682 .577 L p .933 .781 .668 r
F P
0 g
s
.52854 .62237 m .48682 .577 L .45027 .66778 L p .933 .781 .668 r
F P
0 g
s
.48682 .577 m .48816 .57366 L .52441 .61319 L p .933 .781 .668 r
F P
0 g
s
.43068 .63276 m .46243 .31879 L p .48816 .57366 L .933 .781 .668 r
F P
0 g
s
.48816 .57366 m .48682 .577 L .43068 .63276 L p .933 .781 .668 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 219.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000fb000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Ko
oooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo001Rooooo`?o0000
LOooool006;ooooo00?o00000>k7Z`3^aj/01?l0001]ooooo`00H_ooool00ol00000k/N[0>k7Z`04
0>k7Z`Co0000BOooool2o`0001kooooo001Rooooo`03o`00003^aj/0k/N[00P0k/N[0ol00015oooo
o`03o`000?m80Tko000001kooooo001Rooooo`03o`00003^aj/0k/N[00/0k/N[1?l00010ooooo`04
o`000?m80TkoB09>o`0001kooooo001Rooooo`03o`00003^aj/0k/N[00l0k/N[1?l0000kooooo`03
o`000?m80TkoB09>0080B09>00?o0000ooooooooool06oooool006;ooooo00?o00000>k7Z`3^aj/0
4`3^aj/2o`0003Oooooo0_l00003odP2CP80B09>00?o0000ooooooooool06oooool0067ooooo00?o
00000>k7Z`3^aj/05@3^aj/00ol0003oooooooooo`0dooooo`03o`000?m80TkoB09>00;oB09>0`18
0Th00ol0003oooooooooo`0Kooooo`00HOooool00ol00000k/N[0>k7Z`0D0>k7Z`03o`000?oooooo
000003Cooooo00?o0000odP2C_m80Th00om80Th304P2CP03o`000?oooooooooo01_ooooo001Qoooo
o`03o`00003^aj/0k/N[01@0k/N[00?o0000ooooool00000<oooool00ol0003oB09>odP2CP03odP2
CPD0B09>00?o0000ooooooooool06_ooool0067ooooo00?o00000>k7Z`3^aj/0503^aj/2o`000003
0>g5Z_l0003ooooo02oooooo0_l00006odP2CPD0B09>00?o0000ooooooooool06_ooool0067ooooo
00?o00000>k7Z`3^aj/04`3^aj/00ol0003oooooo`0000020>g5ZP03o`000?oooooooooo02cooooo
00?o0000odP2C_m80Th01Om80Th604P2CP03o`000?oooooooooo01[ooooo001Qooooo`03o`00003^
aj/0k/N[01<0k/N[00?o0000ooooool000000`3]aJX00ol0003oooooooooo`0Zooooo`03o`000?m8
0TkoB09>00KoB09>1`180Th00ol0003oooooooooo`0Iooooo`00HOooool00ol00000k/N[0>k7Z`0C
0>k7Z`;o00001@3]aJX00ol0003oooooooooo`0Xooooo`03o`000?m80TkoB09>00KoB09>20180Th0
0ol0003oooooooooo`0Iooooo`00HOooool00ol00000k/N[0>k7Z`0B0>k7Z`03o`000?oooooo0000
00D0kLFZ00?o0000ooooooooool09oooool00ol0003oB09>odP2CP07odP2CPP0B09>00?o0000oooo
ooooool06Oooool0067ooooo00?o00000>k7Z`3^aj/04P3^aj/00ol0003oooooo`0000060>g5ZP03
o`000?oooooooooo02Cooooo0_l00009odP2CPT0B09>00?o0000ooooooooool06Oooool0067ooooo
00?o00000>k7Z`3^aj/04P3^aj/2o`0000P0kLFZ00?o0000ooooooooool08_ooool00ol0003oB09>
odP2CP09odP2CPX0B09>00?o0000ooooooooool06?ooool0067ooooo00?o00000>k7Z`3^aj/04@3^
aj/00ol0003oooooo`0000090>g5ZP03o`000?oooooooooo023ooooo00?o0000odP2C_m80Th02Om8
0Th:04P2CP;o00006_ooool0063ooooo00?o00000>k7Z`3^aj/04P3^aj/2o`0000/0kLFZ00?o0000
ooooooooool07_ooool00ol0003oB09>odP2CP0:odP2CPT0B09>00?o0000ooooooooool06_ooool0
063ooooo00?o00000>k7Z`3^aj/04P3^aj/2o`0000/0kLFZ00?o0000ooooooooool07?ooool2o`00
00coB09>2@180Th00ol0003oooooooooo`0Kooooo`00H?ooool00ol00000k/N[0>k7Z`0A0>k7Z`03
o`000?oooooo000000`0kLFZ00?o0000ooooooooool06_ooool00ol0003oB09>odP2CP0;odP2CPT0
B09>00?o0000ooooooooool07?ooool0063ooooo00?o00000>k7Z`3^aj/04@3^aj/2o`0000h0kLFZ
00?o0000ooooooooool06?ooool00ol0003oB09>odP2CP0<odP2CPL0B09>0_l0000Oooooo`00H?oo
ool00ol00000k/N[0>k7Z`0A0>k7Z`;o00003`3]aJX00ol0003oooooooooo`0Fooooo`03o`000?m8
0TkoB09>00coB09>1`180Th00ol0003oooooooooo`0Oooooo`00H?ooool00ol00000k/N[0>k7Z`0@
0>k7Z`;o00004@3]aJX00ol0003oooooooooo`0Cooooo`;o00003om80Th604P2CP03o`000?oooooo
oooo023ooooo001Pooooo`03o`00003^aj/0k/N[0100k/N[0_l0000A0>g5ZP03o`000?oooooooooo
01;ooooo00?o0000odP2C_m80Th03_m80Th604P2CP03o`000?oooooooooo027ooooo001Pooooo`03
o`00003^aj/0k/N[0100k/N[0_l0000@0>g5ZP03o`00003^aj_o000001;ooooo00?o0000odP2C_m8
0Th03om80Th404P2CP;o00009?ooool0063ooooo00?o00000>k7Z`3^aj/03`3^aj/2o`000140kLFZ
00?o00000>k7Zol000004Oooool00ol0003oB09>odP2CP0?odP2CP@0B09>00?o0000ooooooooool0
9?ooool0063ooooo00?o00000>k7Z`3^aj/03`3^aj/2o`000100kLFZ00Co00000>k7Z`3^aj_o0000
3oooool2o`0001;oB09>0`180Th00ol0003oooooooooo`0Uooooo`00H?ooool00ol00000k/N[0>k7
Z`0?0>k7Z`;o0000403]aJX01Ol00000k/N[0>k7Z`3^aj_o000000gooooo00?o0000odP2C_m80Th0
4Om80Th304P2CP03o`000?oooooooooo02Kooooo001Oooooo`03o`00003^aj/0k/N[00l0k/N[0_l0
000@0>g5ZP03o`00003^aj/0k/N[0080k/N[00?o0000ooooooooool02_ooool00ol0003oB09>odP2
CP0BodP2CP0304P2C_l0003o000002Wooooo001Oooooo`03o`00003^aj/0k/N[00l0k/N[0_l0000?
0>g5ZP03o`00003^aj/0k/N[00<0k/N[00?o0000ooooooooool02Oooool00ol0003oB09>odP2CP0B
odP2CP0304P2C_l0003ooooo02[ooooo001Oooooo`03o`00003^aj/0k/N[00h0k/N[0_l0000@0>g5
ZP03o`00003^aj/0k/N[00<0k/N[00?o0000ooooooooool02?ooool00ol0003oB09>odP2CP0CodP2
CP03o`000?oooooooooo02[ooooo001Oooooo`03o`00003^aj/0k/N[00h0k/N[0_l0000?0>g5ZP03
o`00003^aj/0k/N[00@0k/N[00?o0000ooooooooool01_ooool2o`0001GoB09>00?o0000oooooooo
ool0:oooool005oooooo00?o00000>k7Z`3^aj/03P3^aj/2o`0000l0kLFZ00?o00000>k7Z`3^aj/0
103^aj/00ol0003oooooooooo`05ooooo`03o`000?m80TkoB09>01?oB09>0_l0000^ooooo`00Gooo
ool00ol00000k/N[0>k7Z`0=0>k7Z`;o00003`3]aJX00ol00000k/N[0>k7Z`050>k7Z`03o`000?oo
oooooooo00Cooooo00?o0000odP2C_m80Th04_m80Th4o`0002kooooo001Oooooo`03o`00003^aj/0
k/N[00d0k/N[0_l0000?0>g5ZP03o`00003^aj/0k/N[00D0k/N[00?o0000ooooooooool00oooool0
0ol0003oB09>odP2CP0?odP2CP<0B09>0ol0000`ooooo`00Goooool00ol00000k/N[0>k7Z`0=0>k7
Z`03o`00003]aJX0kLFZ00d0kLFZ00?o00000>k7Z`3^aj/01P3^aj/01?l0003oooooooooooooool2
o`0000koB09>1@180Th3o`0003;ooooo001Oooooo`03o`00003^aj/0k/N[00`0k/N[0_l0000?0>g5
ZP03o`00003^aj/0k/N[00L0k/N[00?o0000ooooool000002om80Th804P2CP;o000000<0B09>o`00
0?ooool0<_ooool005oooooo00?o00000>k7Z`3^aj/0303^aj/2o`0000h0kLFZ00?o00000>k7Z`3^
aj/0203^aj/2o`0000SoB09>2P180Th2o`0000<0B09>00?o0000ooooooooool0<Oooool005oooooo
00?o00000>k7Z`3^aj/0303^aj/00ol00000kLFZ0>g5ZP0<0>g5ZP03o`00003^aj/0k/N[00T0k/N[
00?o0000odP2C_m80Th00om80Th<04P2CP;o000010180Th00ol0003oooooooooo`0booooo`00G_oo
ool00ol00000k/N[0>k7Z`0<0>k7Z`;o00003P3]aJX00ol00000k/N[0>k7Z`090>k7Z`03o`000018
0Th0B09>00d0B09>0_l0000504P2CP03o`000?oooooooooo03?ooooo001Nooooo`03o`00003^aj/0
k/N[00`0k/N[0_l0000=0>g5ZP03o`00003^aj/0k/N[00X0k/N[00?o000004P2CP180Th02`180Th2
o`0000H0B09>00?o0000ooooooooool0=?ooool005kooooo00?o00000>k7Z`3^aj/0303^aj/00ol0
0000kLFZ0>g5ZP0<0>g5ZP03o`00003^aj/0k/N[00X0k/N[00?o000004P2CP180Th02@180Th2o`00
00L0B09>00?o0000ooooooooool0=Oooool005kooooo00?o00000>k7Z`3^aj/02`3^aj/2o`0000d0
kLFZ00?o00000>k7Z`3^aj/02`3^aj/00ol00000B09>04P2CP0704P2CP;o000020180Th00ol0003o
ooooooooo`0fooooo`00G_ooool00ol00000k/N[0>k7Z`0;0>k7Z`03o`00003]aJX0kLFZ00`0kLFZ
00?o00000>k7Z`3^aj/02`3^aj/00ol00000B09>04P2CP0504P2CP;o00002@180Th00ol0003ooooo
ooooo`0gooooo`00G_ooool00ol00000k/N[0>k7Z`0;0>k7Z`03o`00003]aJX0kLFZ00/0kLFZ00?o
00000>k7Z`3^aj/0303^aj/00ol00000B09>04P2CP0304P2CP;o00002P180Th00ol0003ooooooooo
o`0hooooo`00G_ooool00ol00000k/N[0>k7Z`0:0>k7Z`;o00003@3]aJX00ol00000k/N[0>k7Z`0<
0>k7Z`;o000000H0B09>o`000?l0003o000004P2C_l0000904P2CP03o`000?oooooooooo03Wooooo
001Nooooo`03o`00003^aj/0k/N[00X0k/N[00?o00000>g5ZP3]aJX02`3]aJX00ol00000k/N[0>k7
Z`0=0>k7Z`04o`000?oooooo0000o`000080B09>00?o000004P2CP180Th01`180Th00ol0003ooooo
ooooo`0jooooo`00G_ooool00ol00000k/N[0>k7Z`0:0>k7Z`03o`00003]aJX0kLFZ00/0kLFZ00?o
00000>k7Z`3^aj/03@3^aj/2o`0000@0B09>00?o000004P2CP180Th01P180Th00ol0003ooooooooo
o`0kooooo`00G_ooool00ol00000k/N[0>k7Z`090>k7Z`03o`00003]aJX0kLFZ00/0kLFZ00?o0000
0>k7Z`3^aj/03P3^aj/2o`0000@0B09>00?o000004P2CP180Th01@180Th00ol0003oooooooooo`0l
ooooo`00G_ooool00ol00000k/N[0>k7Z`090>k7Z`03o`00003]aJX0kLFZ00X0kLFZ00?o00000>k7
Z`3^aj/03`3^aj/2o`0000<0B09>00?o000004P2CP180Th01@180Th00ol0003oooooooooo`0moooo
o`00GOooool00ol00000k/N[0>k7Z`0:0>k7Z`03o`00003]aJX0kLFZ00X0kLFZ00?o00000>k7Z`3^
aj/03`3^aj/00ol00000B09>04P2CP0204P2CP03o`0000180Th0B09>00@0B09>00?o0000oooooooo
ool0?_ooool005gooooo00?o00000>k7Z`3^aj/02@3^aj/00ol00000kLFZ0>g5ZP0:0>g5ZP03o`00
003^aj/0k/N[0100k/N[00?o000004P2CP180Th00P180Th00ol00000B09>04P2CP0304P2CP03o`00
0?oooooooooo03oooooo001Mooooo`03o`00003^aj/0k/N[00T0k/N[00?o00000>g5ZP3]aJX02P3]
aJX00ol00000k/N[0>k7Z`0@0>k7Z`05o`0000180Th0B09>04P2C_l000001@180Th00ol0003ooooo
ooooo`10ooooo`00GOooool00ol00000k/N[0>k7Z`090>k7Z`03o`00003]aJX0kLFZ00T0kLFZ00?o
00000>k7Z`3^aj/04P3^aj/01?l00000B09>04P2C_l0000404P2CP03o`000?oooooooooo047ooooo
001Mooooo`03o`00003^aj/0k/N[00P0k/N[00?o00000>g5ZP3]aJX02P3]aJX00ol00000k/N[0>k7
Z`0B0>k7Z`04o`0000180Th0B09>o`0000<0B09>00?o0000ooooooooool0@_ooool005gooooo00?o
00000>k7Z`3^aj/01`3^aj/3o`0000X0kLFZ00?o00000>k7Z`3^aj/04`3^aj/00ol00000B09>o`00
000304P2CP03o`000?oooooooooo04?ooooo001Mooooo`03o`00003^aj/0k/N[00H0k/N[0_l00000
0`3^aj_o0000o`0000090>g5ZP03o`00003^aj/0k/N[01<0k/N[00?o000004P2C_l000000P180Th0
0ol0003oooooooooo`14ooooo`00GOooool00ol00000k/N[0>k7Z`050>k7Z`03o`000?oooooo0000
0080k/N[0_l000070>g5ZP03o`00003^aj/0k/N[01@0k/N[00Go000004P2C_l00000B09>o`000017
ooooo`00GOooool00ol00000k/N[0>k7Z`040>k7Z`04o`000?ooooooooooo`0000<0k/N[0_l00005
0>g5ZP03o`00003^aj/0k/N[01D0k/N[0_l000000`180Tko0000ooooo`17ooooo`00GOooool00ol0
0000k/N[0>k7Z`030>k7Z`04o`000?ooooooooooo`0000D0k/N[0_l000040>g5ZP03o`00003^aj/0
k/N[01D0k/N[0ol00019ooooo`00GOooool00ol00000k/N[0>k7Z`020>k7Z`05o`000?oooooooooo
ooooool000001P3^aj/2o`000080kLFZ00?o00000>k7Z`3^aj/05P3^aj/2o`0004[ooooo001Loooo
o`03o`00003^aj/0k/N[0080k/N[00Go0000ooooooooooooooooo`0000080>k7Z`;o000000<0kLFZ
o`00003^aj/05`3^aj/00ol0003oooooooooo`19ooooo`00G?ooool01Ol00000k/N[0>k7Z`3^aj_o
000000Cooooo00?o00000>k7Z`3^aj/01`3^aj/2o`0001T0k/N[00?o0000ooooooooool0BOooool0
05cooooo00Co00000>k7Z`3^aj_o00001Oooool00ol00000k/N[0>k7Z`080>k7Z`03o`00003^aj/0
k/N[01H0k/N[00?o0000ooooooooool0B_ooool005cooooo00?o00000>k7Zol000001Oooool00ol0
0000k/N[0>k7Z`0:0>k7Z`;o00005P3^aj/00ol0003oooooooooo`1:ooooo`00G?ooool2o`0000Ko
oooo00?o00000>k7Z`3^aj/02P3^aj/01?l0003oooooo`000?l0000C0>k7Z`03o`000?oooooooooo
04_ooooo001Looooo`03o`000?oooooooooo00Cooooo00?o00000>k7Z`3^aj/02`3^aj/2o`000080
B09>0_l0000@0>k7Z`03o`000?oooooooooo04cooooo001Sooooo`03o`00003^aj/0k/N[00/0k/N[
00?o000004P2CP180Th00`180Th2o`0000h0k/N[00?o0000ooooooooool0C?ooool006?ooooo00?o
00000>k7Z`3^aj/02`3^aj/00ol00000B09>04P2CP0304P2CP04o`000?oooooo0000o`0000/0k/N[
00?o0000ooooooooool0COooool006;ooooo00?o00000>k7Z`3^aj/0303^aj/00ol00000B09>04P2
CP0204P2CP05o`000?ooooooooooo`0000180Th00_l000090>k7Z`03o`000?oooooooooo04gooooo
001Rooooo`03o`00003^aj/0k/N[00`0k/N[00?o000004P2CP180Th00P180Th00ol0003oooooo`00
000404P2CP;o00001P3^aj/00ol0003oooooooooo`1>ooooo`00HOooool00ol00000k/N[0>k7Z`0=
0>k7Z`03o`0000180Th0B09>0080B09>00?o0000ooooool000001P180Th2o`0000<0k/N[00?o0000
ooooooooool0Coooool0067ooooo00?o00000>k7Z`3^aj/03@3^aj/00ol00000B09>04P2CP0204P2
CP03o`000?oooooo000000P0B09>0_l000000`3^aj_o0000ooooo`1@ooooo`00HOooool00ol00000
k/N[0>k7Z`0=0>k7Z`03o`0000180Th0B09>0080B09>0_l0000:04P2CP;o0000D_ooool0063ooooo
00?o00000>k7Z`3^aj/03P3^aj/00ol00000B09>04P2CP0204P2CP;o00002@180Th00ol00000B09>
o`00001Booooo`00HOooool00ol00000k/N[0>k7Z`0=0>k7Z`03o`0000180Th0B09>0080B09>0_l0
000704P2CP;o000000<0B09>o`000?l00000D_ooool006;ooooo00?o00000>k7Z`3^aj/0303^aj/0
0ol00000B09>04P2CP0204P2CP;o00001P180Th01_l00000B09>04P2C_l00000B09>o`0005;ooooo
001Sooooo`03o`00003^aj/0k/N[00/0k/N[00?o000004P2CP180Th00P180Th00ol00000B09>04P2
CP0304P2CP;o00000P180Th01?l00000B09>04P2C_l0001Booooo`00I?ooool00ol00000k/N[0>k7
Z`0:0>k7Z`04o`0000180Th0B09>04P2CP;o00000`180Th2o`0000@0B09>00Co000004P2CP180Tko
0000D_ooool006Gooooo00?o00000>k7Z`3^aj/02@3^aj/01?l00000B09>04P2CP180Th2o`000080
B09>00?o000004P2CP180Th00`180Th00ol00000B09>04P2CP0204P2CP03o`000?oooooooooo04oo
oooo001Uooooo`;o00002P3^aj/01?l00000B09>04P2CP180Th4o`0000D0B09>00?o000004P2CP18
0Th00`180Th00ol0003oooooooooo`1?ooooo`00I?ooool01?l00000B09>04P2C_l000090>k7Z`04
o`0000180Th0B09>04P2CP;o00001`180Th00ol00000B09>04P2CP0304P2CP03o`000?oooooooooo
04oooooo001Sooooo`03o`0000180Th0B09>0080B09>00?o00000>k7Z`3^aj/01P3^aj/01Ol00000
B09>04P2CP180Tko000000L0B09>00?o000004P2CP180Th010180Th00ol0003oooooooooo`1?oooo
o`00H_ooool00ol00000B09>04P2CP0404P2CP03o`00003^aj/0k/N[00D0k/N[00?o000004P2CP18
0Th020180Th00ol00000B09>04P2CP0504P2CP03o`000?oooooooooo04oooooo001Qooooo`03o`00
00180Th0B09>00H0B09>00?o00000>k7Z`3^aj/0103^aj/00ol00000B09>04P2CP0704P2CP03o`00
00180Th0B09>00H0B09>00?o0000ooooooooool0Coooool0063ooooo00?o000004P2CP180Th02018
0Th00ol00000k/N[0>k7Z`030>k7Z`04o`0000180Th0B09>o`0000H0B09>00?o000004P2CP180Th0
1P180Th00ol0003oooooooooo`1?ooooo`00Goooool00ol00000B09>04P2CP0:04P2CP03o`00003^
aj/0k/N[0080k/N[00Co000004P2CP180Tko00001@180Th00ol00000B09>04P2CP0704P2CP03o`00
0?oooooooooo04oooooo001Nooooo`03o`0000180Th0B09>00`0B09>00Go00000>k7Z`3^aj/0k/N[
o`00000704P2CP03o`0000180Th0B09>00P0B09>00?o0000ooooooooool0Coooool005gooooo00?o
000004P2CP180Th03P180Th01?l00000k/N[0>k7Zol0000604P2CP03o`0000180Th0B09>00X0B09>
00?o0000ooooooooool0C_ooool005cooooo00?o000004P2CP180Th040180Th00ol00000k/N[o`00
000604P2CP03o`0000180Th0B09>00X0B09>00?o0000ooooooooool0C_ooool005_ooooo00?o0000
04P2CP180Th04P180Th2o`00000304P2C_l00000B09>0080B09>00?o000004P2CP180Th02`180Th0
0ol0003oooooooooo`1>ooooo`00F_ooool00ol00000B09>04P2CP0D04P2CP03o`0000180Tko0000
0080B09>00?o000004P2CP180Th030180Th00ol0003oooooooooo`1>ooooo`00FOooool00ol00000
B09>04P2CP0G04P2CP04o`0000180Th0B09>o`0000d0B09>0_l0001@ooooo`00FOooool00ol00000
B09>04P2CP0G04P2CP03o`0000180Tko000000`0B09>0_l0001Booooo`00F?ooool00ol00000B09>
04P2CP0I04P2CP03o`0000180Th0B09>00P0B09>0ol0001Dooooo`00Eoooool00ol00000B09>04P2
CP0H04P2CP;o00002@180Th2o`0005Oooooo001Fooooo`03o`0000180Th0B09>01T0B09>0_l00007
04P2CP;o0000FOooool005Gooooo00?o000004P2CP180Th06P180Th00ol00000B09>04P2CP0404P2
CP;o0000Foooool005Cooooo00?o000004P2CP180Th06`180Th01?l00000B09>04P2CP180Th3o`00
05gooooo001Cooooo`03o`0000180Th0B09>01/0B09>0_l000000`180Tko0000o`00001Pooooo`00
D_ooool00ol00000B09>04P2CP0K04P2CP04o`000?ooooooooooo`0006;ooooo001Aooooo`03o`00
00180Th0B09>01/0B09>00?o0000ooooooooool0I?ooool0053ooooo00?o000004P2CP180Th06`18
0Th00ol0003oooooooooo`1Uooooo`00Coooool00ol00000B09>04P2CP0L04P2CP03o`000?oooooo
oooo06Gooooo001>ooooo`03o`0000180Th0B09>01`0B09>00?o0000ooooooooool0I_ooool004go
oooo00?o000004P2CP180Th070180Th00ol0003oooooooooo`1Wooooo`00C?ooool00ol00000B09>
04P2CP0L04P2CP03o`000?oooooooooo06Sooooo001;ooooo`03o`0000180Th0B09>01`0B09>00?o
0000ooooooooool0JOooool004_ooooo00?o000004P2CP180Th06`180Th00ol0003oooooooooo`1Z
ooooo`00C?ooool00ol00000B09>04P2CP0I04P2CP03o`000?oooooooooo06_ooooo001<ooooo`03
o`0000180Th0B09>01P0B09>00?o0000ooooooooool0K?ooool004gooooo00?o000004P2CP180Th0
5P180Th00ol0003oooooooooo`1]ooooo`00COooool00ol00000B09>04P2CP0E04P2CP03o`000?oo
oooooooo06kooooo001>ooooo`03o`0000180Th0B09>01<0B09>00?o0000ooooooooool0Koooool0
04kooooo00?o000004P2CP180Th04P180Th00ol0003oooooooooo`1`ooooo`00Coooool00ol00000
B09>04P2CP0@04P2CP03o`000?oooooooooo077ooooo001?ooooo`03o`0000180Th0B09>0100B09>
00?o0000ooooooooool0LOooool0053ooooo00?o000004P2CP180Th03P180Th00ol0003ooooooooo
o`1booooo`00DOooool00ol00000B09>04P2CP0<04P2CP03o`000?oooooooooo07?ooooo001Aoooo
o`03o`0000180Th0B09>00/0B09>00?o0000ooooooooool0M?ooool005;ooooo00?o000004P2CP18
0Th02@180Th00ol0003oooooooooo`1eooooo`00D_ooool00ol00000B09>04P2CP0804P2CP03o`00
0?oooooooooo07Kooooo001Cooooo`03o`0000180Th0B09>00H0B09>00?o0000ooooooooool0Mooo
ool005?ooooo00?o000004P2CP180Th01@180Th00ol0003oooooooooo`1hooooo`00E?ooool00ol0
0000B09>04P2CP0304P2CP03o`000?oooooooooo07Wooooo001Dooooo`03o`0000180Th0B09>0080
B09>00?o0000ooooooooool0N_ooool005Gooooo00Co000004P2CP180Tko0000OOooool005Gooooo
00?o000004P2C_l00000O_ooool005Kooooo00?o0000ooooooooool0OOooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {218.562, 0}} -> {0.0277434, -4.69792*^-6, \
0.00429893, 0.00429893}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.53126 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.255965 1.60151 1.11022e-16 1.60151 [
[ 0 0 0 0 ]
[ 1 1.53126 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.53126 L
0 1.53126 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.74481 .76988 m .71917 .37156 L p .60503 .56726 L .927 .775 .672 r
F P
0 g
s
.71467 .78218 m .74481 .76988 L p .60503 .56726 L .927 .775 .672 r
F P
0 g
s
.70389 .95683 m .67353 .95105 L p .48399 1.08227 L .927 .775 .672 r
F P
0 g
s
.6527 1.36021 m .70389 .95683 L p .48399 1.08227 L .927 .775 .672 r
F P
0 g
s
.70762 .88526 m .6808 .92032 L .66469 .87431 L p .927 .775 .672 r
F P
0 g
s
.66469 .87431 m .69189 .83943 L .70762 .88526 L p .927 .775 .672 r
F P
0 g
s
.67748 .77494 m .71467 .78218 L p .60503 .56726 L .927 .775 .672 r
F P
0 g
s
.43876 1.35577 m .6527 1.36021 L p .48399 1.08227 L .927 .775 .672 r
F P
0 g
s
.67241 .78269 m .69189 .83943 L .66469 .87431 L p .927 .775 .672 r
F P
0 g
s
.67353 .95105 m .55966 1.02111 L .48399 1.08227 L p .927 .775 .672 r
F P
0 g
s
.71917 .37156 m .59319 .40239 L .60503 .56726 L p .927 .775 .672 r
F P
0 g
s
.67063 .93143 m .55966 1.02111 L .53751 .9077 L p .927 .775 .672 r
F P
0 g
s
.53751 .9077 m .66102 .87855 L .67063 .93143 L p .927 .775 .672 r
F P
0 g
s
.65696 .73767 m .67748 .77494 L p .60503 .56726 L .927 .775 .672 r
F P
0 g
s
.67241 .78269 m .65696 .73767 L .58129 .83069 L p .927 .775 .672 r
F P
0 g
s
.58129 .83069 m .64475 .81734 L .67241 .78269 L p .927 .775 .672 r
F P
0 g
s
.66469 .87431 m .64475 .81734 L .67241 .78269 L p .927 .775 .672 r
F P
0 g
s
.53751 .9077 m .66102 .87855 L .64475 .81734 L p .927 .775 .672 r
F P
0 g
s
.60503 .56726 m .61051 .60235 L .65696 .73767 L p .927 .775 .672 r
F P
0 g
s
.65696 .73767 m .61051 .60235 L .6055 .60816 L p .927 .775 .672 r
F P
0 g
s
.6055 .60816 m .58129 .83069 L .65696 .73767 L p .927 .775 .672 r
F P
0 g
s
.64475 .81734 m .58129 .83069 L .53751 .9077 L p .927 .775 .672 r
F P
0 g
s
.6055 .60816 m .59994 .57156 L .61051 .60235 L closepath p .927 .775 .672 r
F P
0 g
s
.58129 .83069 m .53751 .9077 L p .55421 .57832 L .927 .775 .672 r
F P
0 g
s
.55421 .57832 m .56715 .60894 L .58129 .83069 L p .927 .775 .672 r
F P
0 g
s
.55966 1.02111 m .48399 1.08227 L .48239 1.07444 L p .927 .775 .672 r
F P
0 g
s
.48239 1.07444 m .53751 .9077 L .55966 1.02111 L p .927 .775 .672 r
F P
0 g
s
.53751 .9077 m .40738 .84478 L p .55421 .57832 L .927 .775 .672 r
F P
0 g
s
.39796 .95583 m .53751 .9077 L .48239 1.07444 L p .927 .775 .672 r
F P
0 g
s
.40738 .84478 m .4013 .83199 L .55421 .57832 L p .927 .775 .672 r
F P
0 g
s
.47151 .48038 m .55421 .57832 L .4013 .83199 L p .923 .768 .67 r
F P
0 g
s
.46872 1.12721 m .43876 1.35577 L p .48399 1.08227 L .927 .775 .672 r
F P
0 g
s
.48399 1.08227 m .47684 1.09294 L .46872 1.12721 L p .927 .775 .672 r
F P
0 g
s
.48239 1.07444 m .47556 1.08908 L .48399 1.08227 L closepath p .927 .775 .672 \
r
F P
0 g
s
.45363 1.09229 m .39796 .95583 L p .48239 1.07444 L .927 .775 .672 r
F P
0 g
s
.48239 1.07444 m .47459 1.08769 L .45363 1.09229 L p .927 .775 .672 r
F P
0 g
s
.4013 .83199 m .34654 .77611 L .47151 .48038 L p .923 .768 .67 r
F P
0 g
s
.30932 .42619 m .46259 .46706 L .34827 .7763 L p .927 .775 .672 r
F P
0 g
s
.29392 .90399 m .41289 1.02059 L .40738 .84478 L p .927 .775 .672 r
F P
0 g
s
.4013 .83199 m .40738 .84478 L .34634 .78083 L p .927 .775 .672 r
F P
0 g
s
.40738 .84478 m .34634 .78083 L .29392 .90399 L p .927 .775 .672 r
F P
0 g
s
.34634 .78083 m .34827 .7763 L .4013 .83199 L p .927 .775 .672 r
F P
0 g
s
.26537 .85518 m .30932 .42619 L p .34827 .7763 L .927 .775 .672 r
F P
0 g
s
.34827 .7763 m .34634 .78083 L .26537 .85518 L p .927 .775 .672 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 328.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0001B2000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Ko
oooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool009Oooooo0ol0000looooo`00Toooool4o`000080kLJ/00?o0000ooooooooool0>_ooool0
08oooooo1?l000060>g6[003o`000?oooooooooo03[ooooo002;ooooo`Co00002@3]aZ`00oo]aZco
0000ooooo`0kooooo`00R?ooool3o`0000d0kLJ/00?okLJ/o`000?ooool0>oooool008Cooooo1?l0
000?0>g6[0;okLJ/00?o0000ooooooooool0>_ooool0083ooooo1?l0000B0>g6[0?okLJ/00?o0000
ooooooooool0>_ooool007kooooo0_l0000F0>g6[0?okLJ/00?o0000ooooooooool0>_ooool007ko
oooo00?o00000>g6[03]aZ`0503]aZ`5ong6[003o`000?oooooooooo03Wooooo001nooooo`03o`00
003]aZ`0kLJ/01@0kLJ/1Oo]aZ`00ol0003oooooooooo`0iooooo`00O_ooool00ol00000kLJ/0>g6
[00C0>g6[0KokLJ/00?o0000ooooooooool0>Oooool007kooooo00?o00000>g6[03]aZ`04`3]aZ`6
ong6[003o`000?oooooooooo03Wooooo0012ooooo`?o0000>Oooool00ol00000kLJ/0>g6[00B0>g6
[0OokLJ/00?o0000ooooooooool0>Oooool004;ooooo00?o00000>g6[03]aZ`00ol0000fooooo`03
o`00003]aZ`0kLJ/0140kLJ/2?o]aZ`00ol0003oooooooooo`0iooooo`00@_ooool00ol00000kLJ/
0>g6[0030>g6[0Co0000<oooool00ol00000kLJ/0>g6[00@0>g6[0SokLJ/00?o0000ooooooooool0
>Oooool004;ooooo00?o00000>g6[03]aZ`01`3]aZ`3o`00033ooooo00?o00000>g6[03]aZ`03`3]
aZ`9ong6[003o`000?oooooooooo03Wooooo0012ooooo`03o`00003]aZ`0kLJ/00X0kLJ/1?l0000/
ooooo`03o`00003]aZ`0kLJ/00l0kLJ/2Oo]aZ`00ol0003oooooooooo`0iooooo`00@_ooool00ol0
0000kLJ/0>g6[00>0>g6[0Co0000:?ooool00ol00000kLJ/0>g6[00>0>g6[0[okLJ/00?o0000oooo
ooooool0>Oooool0047ooooo00?o00000>g6[03]aZ`04`3]aZ`3o`0002Gooooo00?o00000>g6[03]
aZ`03P3]aZ`:ong6[003o`000?oooooooooo03Wooooo0011ooooo`03o`00003]aZ`0kLJ/01H0kLJ/
1?l0000Qooooo`03o`00003]aZ`0kLJ/00d0kLJ/2oo]aZ`00ol0003oooooooooo`0iooooo`00@Ooo
ool00ol00000kLJ/0>g6[00J0>g6[0?o00007_ooool00ol00000kLJ/0>g6[00<0>g6[0cokLJ/00?o
0000ooooooooool0>Oooool0047ooooo00?o00000>g6[03]aZ`07@3]aZ`2o`0001cooooo00?o0000
0>g6[03]aZ`0303]aZ`<ong6[003o`000?oooooooooo03Wooooo0011ooooo`03o`00003]aZ`0kLJ/
01h0kLJ/00?o0000ooooooooool06_ooool00ol00000kLJ/0>g6[00;0>g6[0kokLJ/00?o0000oooo
ooooool0>?ooool0047ooooo00?o00000>g6[03]aZ`07@3]aZ`00ol0003oooooooooo`0Kooooo`03
o`00003]aZ`0kLJ/00/0kLJ/3_o]aZ`00ol0003oooooooooo`0hooooo`00@Oooool00ol00000kLJ/
0>g6[00M0>g6[004o`000?ooooooooooo`0001[ooooo00?o00000>g6[03]aZ`02P3]aZ`?ong6[003
o`000?oooooooooo03Sooooo0011ooooo`03o`00003]aZ`0kLJ/01d0kLJ/00Co0000oooooooooooo
00006oooool00ol00000kLJ/0>g6[0090>g6[0ookLJ/00?o0000ooooooooool0>?ooool0047ooooo
00?o00000>g6[03]aZ`0703]aZ`01_l0003oooooooooool00000k<B[o`0001[ooooo00?o00000>g6
[03]aZ`0203]aZ`@ong6[003o`000?oooooooooo03Sooooo0010ooooo`03o`00003]aZ`0kLJ/01d0
kLJ/00Co0000oooooooooooo00000P3/a:/00ol0003oooooooooo`0Gooooo`03o`00003]aZ`0kLJ/
00L0kLJ/4Oo]aZ`00ol0003oooooooooo`0hooooo`00@?ooool00ol00000kLJ/0>g6[00M0>g6[004
o`000?ooooooooooo`0000<0k<B[00?o0000ooooooooool05_ooool00ol00000kLJ/0>g6[0070>g6
[17okLJ/00?o0000ooooooooool0>?ooool0043ooooo00?o00000>g6[03]aZ`0703]aZ`01?l0003o
ooooooooool000050>c4Z`03o`000?oooooooooo01Gooooo00?o00000>g6[03]aZ`01P3]aZ`Bong6
[003o`000?oooooooooo03Sooooo0010ooooo`03o`00003]aZ`0kLJ/01`0kLJ/00Co0000oooooooo
oooo00001P3/a:/00ol0003oooooooooo`0Dooooo`03o`00003]aZ`0kLJ/00H0kLJ/4_o]aZ`00ol0
003oooooooooo`0hooooo`00@?ooool00ol00000kLJ/0>g6[00L0>g6[003o`000?oooooo000000P0
k<B[00?o0000ooooooooool04oooool00ol00000kLJ/0>g6[0050>g6[1?okLJ/00?o0000oooooooo
ool0>?ooool0043ooooo00?o00000>g6[03]aZ`06`3]aZ`01?l0003oooooooooool000080>c4Z`03
o`000?oooooooooo01?ooooo00?o00000>g6[03]aZ`01@3]aZ`Cong6[003o`000?oooooooooo03So
oooo0010ooooo`03o`00003]aZ`0kLJ/01/0kLJ/00?o0000ooooool000002P3/a:/00ol0003ooooo
ooooo`0Booooo`03o`00003]aZ`0kLJ/00@0kLJ/5?o]aZ`00ol0003oooooooooo`0hooooo`00@?oo
ool00ol00000kLJ/0>g6[00J0>g6[004o`000?ooooooooooo`0000/0k<B[00?o0000ooooooooool0
4Oooool00ol00000kLJ/0>g6[0030>g6[1GokLJ/00?o0000ooooooooool0>?ooool0043ooooo00?o
00000>g6[03]aZ`06P3]aZ`01?l0003oooooooooool0000<0>c4Z`03o`000?oooooooooo013ooooo
00?o00000>g6[03]aZ`00`3]aZ`Eong6[003o`000?oooooooooo03Sooooo000oooooo`03o`00003]
aZ`0kLJ/01/0kLJ/00?o0000ooooool000003P3/a:/00ol0003oooooooooo`0?ooooo`03o`00003]
aZ`0kLJ/0080kLJ/5oo]aZ`00ol0003oooooooooo`0gooooo`00?oooool00ol00000kLJ/0>g6[00J
0>g6[004o`000?ooooooooooo`0000l0k<B[00?o0000ooooooooool03oooool01?l00000kLJ/0>g6
[03]aZ`Gong6[003o`000?oooooooooo03Oooooo000oooooo`03o`00003]aZ`0kLJ/01X0kLJ/00?o
0000ooooool000004@3/a:/00ol0003oooooooooo`0>ooooo`03o`00003]aZ`0kLJ/01SokLJ/00?o
0000ooooooooool0=oooool003oooooo00?o00000>g6[03]aZ`06P3]aZ`00ol0003oooooo`00000A
0>c4Z`03o`000?oooooooooo00kooooo00?o00000>g6[03]aZ`06?o]aZ`00ol0003oooooooooo`0g
ooooo`00?oooool00ol00000kLJ/0>g6[00I0>g6[004o`000?ooooooooooo`000180k<B[00?o0000
ooooooooool03Oooool00ol00000kLJ/ong6[00Hong6[003o`000?oooooooooo03Oooooo000ooooo
o`03o`00003]aZ`0kLJ/01T0kLJ/00?o0000ooooool00000503/a:/00ol0003oooooooooo`0<oooo
o`03o`000?o]aZcokLJ/01SokLJ/00?o0000ooooooooool0=oooool003oooooo00?o00000>g6[03]
aZ`06@3]aZ`00ol0003oooooo`00000E0>c4Z`03o`000?oooooooooo00_ooooo00?o0000ong6[?o]
aZ`06?o]aZ`00ol0003oooooooooo`0gooooo`00?oooool00ol00000kLJ/0>g6[00H0>g6[003o`00
0?oooooo000001L0k<B[00?o0000ooooooooool02Oooool2o`0001[okLJ/00?o0000ooooooooool0
=oooool003oooooo00?o00000>g6[03]aZ`0603]aZ`00ol0003oooooo`00000H0>c4Z`03o`000?oo
oooooooo00Sooooo0_l0000Jong6[003o`000?oooooooooo03Oooooo000nooooo`03o`00003]aZ`0
kLJ/01P0kLJ/00Co0000oooooooooooo00006@3/a:/00ol0003oooooooooo`07ooooo`;o000000<0
kLJ/ong6[?o]aZ`05oo]aZ`00ol0003oooooooooo`0gooooo`00?_ooool00ol00000kLJ/0>g6[00H
0>g6[003o`000?oooooo000001X0k<B[00?o0000ooooooooool01oooool2o`0000030>g6[?o]aZco
kLJ/01OokLJ/00?o0000ooooooooool0=oooool003kooooo00?o00000>g6[03]aZ`0603]aZ`00ol0
003oooooo`00000I0>c4Z`03o`00003]aZco000000Sooooo0ol000000`3]aZcokLJ/ong6[00Fong6
[003o`000?oooooooooo03Oooooo000nooooo`03o`00003]aZ`0kLJ/01L0kLJ/00?o0000ooooool0
00006@3/a:/01?l00000kLJ/0>g6[?l00009ooooo`;o00000P3]aZ`Gong6[003o`000?oooooooooo
03Oooooo000nooooo`03o`00003]aZ`0kLJ/01L0kLJ/00?o0000ooooool000006@3/a:/01Ol00000
kLJ/0>g6[03]aZco000000Sooooo0_l000030>g6[1KokLJ/00?o0000ooooooooool0=oooool003ko
oooo00?o00000>g6[03]aZ`05`3]aZ`2o`0001T0k<B[00?o00000>g6[03]aZ`00P3]aZ`00ol0003o
ooooooooo`06ooooo`;o00000`3]aZ`Fong6[003o`000?oooooooooo03Oooooo000nooooo`03o`00
003]aZ`0kLJ/01H0kLJ/00?o0000ooooool000006@3/a:/00ol00000kLJ/0>g6[0030>g6[003o`00
0?oooooooooo00Gooooo0_l000040>g6[1KokLJ/00?o0000ooooooooool0=_ooool003kooooo00?o
00000>g6[03]aZ`05P3]aZ`00ol0003oooooo`00000H0>c4Z`03o`00003]aZ`0kLJ/00@0kLJ/00?o
0000ooooooooool01Oooool00ol00000kLJ/o`0000040>g6[1GokLJ/00?o0000ooooooooool0=_oo
ool003kooooo00?o00000>g6[03]aZ`05P3]aZ`2o`0001P0k<B[00?o00000>g6[03]aZ`01@3]aZ`0
0ol0003oooooooooo`05ooooo`03o`00003]aZco000000@0kLJ/5Oo]aZ`00ol0003oooooooooo`0f
ooooo`00?Oooool00ol00000kLJ/0>g6[00F0>g6[003o`000?oooooo000001P0k<B[00?o00000>g6
[03]aZ`01@3]aZ`00ol0003oooooooooo`05ooooo`03o`00003]aZco000000D0kLJ/5?o]aZ`00ol0
003oooooooooo`0fooooo`00?Oooool00ol00000kLJ/0>g6[00F0>g6[0;o0000603/a:/00ol00000
kLJ/0>g6[0060>g6[003o`000?oooooooooo00Gooooo00Co00000>g6[03]aZco00001@3]aZ`Cong6
[003o`000?oooooooooo03Kooooo000mooooo`03o`00003]aZ`0kLJ/01D0kLJ/00?o0000ooooool0
0000603/a:/00ol00000kLJ/0>g6[0060>g6[003o`000?oooooooooo00Gooooo00Co00000>g6[03]
aZco00001@3]aZ`Cong6[003o`000?oooooooooo03Kooooo000mooooo`03o`00003]aZ`0kLJ/01D0
kLJ/00?o0000ooooool000005`3/a:/00ol00000kLJ/0>g6[0070>g6[003o`000?oooooooooo00Co
oooo00Go00000>g6[03]aZ`0kLJ/o`0000060>g6[1;okLJ/00?o0000ooooooooool0=_ooool003go
oooo00?o00000>g6[03]aZ`05@3]aZ`2o`0001L0k<B[00?o00000>g6[03]aZ`0203]aZ`00ol0003o
ooooooooo`04ooooo`03o`00003]aZ`0kLJ/0080kLJ/00?o00000>g6[03]aZ`0103]aZ`Aong6[003
o`000?oooooooooo03Kooooo000mooooo`03o`00003]aZ`0kLJ/01@0kLJ/00?o0000ooooool00000
5`3/a:/00ol00000kLJ/0>g6[0080>g6[003o`000?oooooooooo00Cooooo00?o00000>g6[03]aZ`0
0P3]aZ`00ol00000kLJ/0>g6[0050>g6[13okLJ/00?o0000ooooooooool0=_ooool003gooooo00?o
00000>g6[03]aZ`0503]aZ`2o`0001L0k<B[00?o00000>g6[03]aZ`02P3]aZ`00ol0003ooooooooo
o`03ooooo`03o`00003]aZ`0kLJ/0080kLJ/00?o00000>g6[03]aZ`01@3]aZ`@ong6[003o`000?oo
oooooooo03Kooooo000mooooo`03o`00003]aZ`0kLJ/01@0kLJ/0_l0000G0>c4Z`03o`00003]aZ`0
kLJ/00X0kLJ/00?o0000ooooooooool00oooool00ol00000kLJ/0>g6[0030>g6[003o`00003]aZ`0
kLJ/00D0kLJ/3oo]aZ`00ol0003oooooooooo`0fooooo`00?Oooool00ol00000kLJ/0>g6[00C0>g6
[003o`000?oooooo000001H0k<B[00?o00000>g6[03]aZ`02`3]aZ`00ol0003oooooooooo`03oooo
o`03o`00003]aZ`0kLJ/00<0kLJ/00?o00000>g6[03]aZ`01P3]aZ`>ong6[003o`000?oooooooooo
03Kooooo000mooooo`03o`00003]aZ`0kLJ/01<0kLJ/0_l0000F0>c4Z`03o`00003]aZ`0kLJ/00`0
kLJ/00?o0000ooooooooool00oooool00ol00000kLJ/0>g6[0030>g6[003o`00003]aZ`0kLJ/00H0
kLJ/3_o]aZ`00ol0003oooooooooo`0fooooo`00??ooool00ol00000kLJ/0>g6[00D0>g6[0;o0000
5P3/a:/00ol00000kLJ/0>g6[00<0>g6[003o`000?oooooooooo00?ooooo00?o00000>g6[03]aZ`0
103]aZ`00ol00000kLJ/0>g6[0060>g6[0gokLJ/00?o0000ooooooooool0=_ooool003cooooo00?o
00000>g6[03]aZ`04`3]aZ`2o`0001H0k<B[00?o00000>g6[03]aZ`03@3]aZ`00ol0003ooooooooo
o`03ooooo`03o`00003]aZ`0kLJ/00@0kLJ/00?o00000>g6[03]aZ`01`3]aZ`=ong6[003o`000?oo
oooooooo03Gooooo000looooo`03o`00003]aZ`0kLJ/01<0kLJ/0_l0000E0>c4Z`03o`00003]aZ`0
kLJ/00h0kLJ/00?o0000ooooooooool00_ooool00ol00000kLJ/0>g6[0050>g6[003o`00003]aZ`0
kLJ/00L0kLJ/3Oo]aZ`00ol0003oooooooooo`0eooooo`00??ooool00ol00000kLJ/0>g6[00B0>g6
[0;o00005P3/a:/00ol00000kLJ/0>g6[00>0>g6[003o`000?oooooooooo00;ooooo00?o00000>g6
[03]aZ`01P3]aZ`00ol00000kLJ/0>g6[0070>g6[0cokLJ/00?o0000ooooooooool0=Oooool003co
oooo00?o00000>g6[03]aZ`04P3]aZ`2o`0001D0k<B[00?o00000>g6[03]aZ`03`3]aZ`00ol0003o
ooooooooo`02ooooo`03o`00003]aZ`0kLJ/00H0kLJ/00?o00000>g6[03]aZ`0203]aZ`;ong6[003
o`000?oooooooooo03Gooooo000looooo`03o`00003]aZ`0kLJ/0180kLJ/0_l0000E0>c4Z`03o`00
003]aZ`0kLJ/00l0kLJ/00?o0000ooooooooool00_ooool00ol00000kLJ/0>g6[0060>g6[003o`00
003]aZ`0kLJ/00P0kLJ/2oo]aZ`00ol0003oooooooooo`0eooooo`00??ooool00ol00000kLJ/0>g6
[00A0>g6[0;o00005@3/a:/00ol00000kLJ/0>g6[00@0>g6[003o`000?oooooooooo00;ooooo00?o
00000>g6[03]aZ`01`3]aZ`00ol00000kLJ/0>g6[0080>g6[0[okLJ/00?o0000ooooooooool0=Ooo
ool003cooooo00?o00000>g6[03]aZ`04@3]aZ`2o`0001@0k<B[00?o00000>g6[03]aZ`04@3]aZ`0
0ol0003oooooooooo`02ooooo`03o`00003]aZ`0kLJ/00L0kLJ/00?o00000>g6[03]aZ`02@3]aZ`9
ong6[003o`000?oooooooooo03Gooooo000looooo`03o`00003]aZ`0kLJ/0140kLJ/00?o00000>c4
Z`3/a:/04`3/a:/00ol00000kLJ/0>g6[00A0>g6[003o`000?oooooooooo00;ooooo00?o00000>g6
[03]aZ`01`3]aZ`00ol00000kLJ/0>g6[00:0>g6[0SokLJ/00?o0000ooooooooool0=Oooool003_o
oooo00?o00000>g6[03]aZ`04@3]aZ`2o`0001@0k<B[00?o00000>g6[03]aZ`04P3]aZ`00ol0003o
ooooooooo`02ooooo`03o`00003]aZ`0kLJ/00P0kLJ/00?o00000>g6[03]aZ`02@3]aZ`8ong6[003
o`000?oooooooooo03Gooooo000kooooo`03o`00003]aZ`0kLJ/0140kLJ/0_l0000D0>c4Z`03o`00
003]aZ`0kLJ/0180kLJ/00?o0000ooooooooool00_ooool00ol00000kLJ/0>g6[0080>g6[003o`00
003]aZ`0kLJ/00X0kLJ/1oo]aZ`00ol0003oooooooooo`0eooooo`00>oooool00ol00000kLJ/0>g6
[00A0>g6[003o`00003/a:/0k<B[0180k<B[00?o00000>g6[03]aZ`0503]aZ`01?l0003ooooooooo
ool0000;0>g6[003o`00003]aZ`0kLJ/00/0kLJ/1_o]aZ`00ol0003oooooooooo`0eooooo`00>ooo
ool00ol00000kLJ/0>g6[00@0>g6[0;o00004`3/a:/00ol00000kLJ/0>g6[00E0>g6[004o`000?oo
ooooooooo`0000`0kLJ/00?o00000>g6[03]aZ`02P3]aZ`6ong6[003o`000?oooooooooo03Gooooo
000kooooo`03o`00003]aZ`0kLJ/0100kLJ/00?o00000>c4Z`3/a:/04P3/a:/00ol00000kLJ/0>g6
[00E0>g6[004o`000?ooooooooooo`0000`0kLJ/00?o00000>g6[03]aZ`02`3]aZ`5ong6[003o`00
0?oooooooooo03Gooooo000kooooo`03o`00003]aZ`0kLJ/00l0kLJ/0_l0000C0>c4Z`03o`00003]
aZ`0kLJ/01H0kLJ/00Co0000oooooooooooo0000303]aZ`00ol00000kLJ/0>g6[00<0>g6[0CokLJ/
00?o0000ooooooooool0=Oooool003_ooooo00?o00000>g6[03]aZ`03`3]aZ`2o`0001<0k<B[00?o
00000>g6[03]aZ`05P3]aZ`01?l0003oooooooooool0000=0>g6[003o`00003]aZ`0kLJ/00/0kLJ/
1Oo]aZ`00ol0003oooooooooo`0dooooo`00>oooool00ol00000kLJ/0>g6[00?0>g6[003o`00003/
a:/0k<B[0140k<B[00?o00000>g6[03]aZ`05`3]aZ`01?l0003oooooooooool0000=0>g6[003o`00
003]aZ`0kLJ/00`0kLJ/1?o]aZ`00ol0003oooooooooo`0dooooo`00>oooool00ol00000kLJ/0>g6
[00>0>g6[0;o00004P3/a:/00ol00000kLJ/0>g6[00H0>g6[004o`000?ooooooooooo`0000`0kLJ/
00?o00000>g6[?l000003P3]aZ`3ong6[003o`000?oooooooooo03Cooooo000jooooo`03o`00003]
aZ`0kLJ/00l0kLJ/00?o00000>c4Z`3/a:/04@3/a:/00ol00000kLJ/0>g6[00H0>g6[004o`000?oo
ooooooooo`0000/0kLJ/00Co00000>g6[03]aZco00003`3]aZ`2ong6[003o`000?oooooooooo03Co
oooo000jooooo`03o`00003]aZ`0kLJ/00l0kLJ/00?o00000>c4Z`3/a:/0403/a:/00ol00000kLJ/
0>g6[00I0>g6[004o`000?ooooooooooo`0000X0kLJ/00Co00000>g6[03]aZ`0kLJ/0_l0000>0>g6
[0;okLJ/00?o0000ooooooooool0=?ooool003[ooooo00?o00000>g6[03]aZ`03P3]aZ`00ol00000
k<B[0>c4Z`0@0>c4Z`03o`00003]aZ`0kLJ/01X0kLJ/00Co0000oooooooooooo00002@3]aZ`00ol0
0000kLJ/0>g6[0030>g6[003o`00003]aZ`0kLJ/00d0kLJ/00?okLJ/o`000?ooool0=Oooool003[o
oooo00?o00000>g6[03]aZ`03P3]aZ`00ol00000k<B[0>c4Z`0@0>c4Z`03o`00003]aZ`0kLJ/01X0
kLJ/00?o0000ooooool000002@3]aZ`00ol00000kLJ/0>g6[0040>g6[0;o00003P3]aZ`2o`0003Ko
oooo000jooooo`03o`00003]aZ`0kLJ/00h0kLJ/00?o00000>c4Z`3/a:/03`3/a:/00ol00000kLJ/
0>g6[00K0>g6[003o`000?oooooo000000T0kLJ/00?o00000>g6[03]aZ`0103]aZ`2o`0000/0kLJ/
0ol0000hooooo`00>_ooool00ol00000kLJ/0>g6[00=0>g6[003o`00003/a:/0k<B[0100k<B[00?o
00000>g6[03]aZ`06`3]aZ`00ol0003oooooo`0000080>g6[003o`00003]aZ`0kLJ/00H0kLJ/1_l0
00040>g6[0;o0000>oooool003[ooooo00?o00000>g6[03]aZ`0303]aZ`2o`000140k<B[00?o0000
0>g6[03]aZ`0703]aZ`00ol0003oooooo`0000070>g6[003o`00003]aZ`0kLJ/00L0kLJ/00?o0000
ooooooooool00oooool4o`0003gooooo000jooooo`03o`00003]aZ`0kLJ/00/0kLJ/00Co0000oooo
ool0003o00003`3/a:/00ol00000kLJ/0>g6[00M0>g6[003o`000?oooooo000000H0kLJ/00?o0000
0>g6[03]aZ`0203]aZ`00ol0003oooooooooo`14ooooo`00>_ooool00ol00000kLJ/0>g6[00:0>g6
[003o`000?oooooo00000080kLJ/00?o00000>c4Z`3/a:/0303/a:/00ol00000kLJ/0>g6[00M0>g6
[003o`000?oooooo000000D0kLJ/00?o00000>g6[03]aZ`0203]aZ`00ol00000kLJ/o`000015oooo
o`00>Oooool00ol00000kLJ/0>g6[00:0>g6[004o`000?ooooooooooo`0000<0kLJ/00?o00000>c4
Z`3/a:/02P3/a:/00ol00000kLJ/0>g6[00O0>g6[0;o0000103]aZ`00ol00000kLJ/0>g6[0080>g6
[004o`00003]aZ`0kLJ/o`0004Gooooo000iooooo`03o`00003]aZ`0kLJ/00T0kLJ/00Co0000oooo
oooooooo00001@3]aZ`00ol00000k<B[0>c4Z`090>c4Z`03o`00003]aZ`0kLJ/01l0kLJ/0_l00003
0>g6[003o`00003]aZ`0kLJ/00P0kLJ/00Go00000>g6[03]aZ`0kLJ/o`000015ooooo`00>Oooool0
0ol00000kLJ/0>g6[0080>g6[005o`000?ooooooooooooooool000001P3]aZ`00ol00000k<B[0>c4
Z`070>c4Z`03o`00003]aZ`0kLJ/0200kLJ/0_l000030>g6[003o`00003]aZ`0kLJ/00P0kLJ/00?o
00000>g6[03]aZ`00P3]aZ`00ol0003oooooooooo`12ooooo`00>Oooool00ol00000kLJ/0>g6[007
0>g6[005o`000?ooooooooooooooool00000203]aZ`00ol00000k<B[0>c4Z`050>c4Z`03o`00003]
aZ`0kLJ/0240kLJ/00Go00000>g6[03]aZ`0kLJ/o`00000:0>g6[003o`00003]aZ`0kLJ/00<0kLJ/
00?o0000ooooooooool0@_ooool003Wooooo00?o00000>g6[03]aZ`01P3]aZ`00ol0003ooooooooo
o`02ooooo`03o`00003]aZ`0kLJ/00L0kLJ/00?o00000>c4Z`3/a:/0103/a:/00ol00000kLJ/0>g6
[00Q0>g6[004o`00003]aZ`0kLJ/o`0000X0kLJ/00?o00000>g6[03]aZ`0103]aZ`00ol0003ooooo
ooooo`12ooooo`00>Oooool00ol00000kLJ/0>g6[0040>g6[0;o00001Oooool00ol00000kLJ/0>g6
[0080>g6[003o`00003/a:/0k<B[0080k<B[00?o00000>g6[03]aZ`08P3]aZ`00ol00000kLJ/o`00
00070>g6[0Co0000203]aZ`00ol0003oooooooooo`11ooooo`00>Oooool00ol00000kLJ/0>g6[003
0>g6[003o`000?oooooooooo00Cooooo00?o00000>g6[03]aZ`02P3]aZ`01Ol00000k<B[0>c4Z`3/
a:_o000002@0kLJ/0_l000000`3]aZco0000o`000005o`0000<0kLJ/00?o00000>g6[03]aZ`01P3]
aZ`00ol0003oooooooooo`11ooooo`00>Oooool00ol00000kLJ/0>g6[0020>g6[003o`000?oooooo
oooo00Gooooo00?o00000>g6[03]aZ`02`3]aZ`00ol00000k<B[o`00000U0>g6[0?o00002P3]aZ`2
o`0000L0kLJ/00?o0000ooooooooool0@Oooool003Wooooo00Go00000>g6[03]aZ`0kLJ/o`000007
ooooo`03o`00003]aZ`0kLJ/00d0kLJ/00?o00000>g6[03]aZ`0903]aZ`00ol00000kLJ/0>g6[00;
0>g6[003o`00003]aZ`0kLJ/00H0kLJ/00?o0000ooooooooool0@?ooool003Sooooo00Go00000>g6
[03]aZ`0kLJ/o`000008ooooo`03o`00003]aZ`0kLJ/00h0kLJ/00?o00000>g6[03]aZ`08P3]aZ`0
0ol00000kLJ/0>g6[00<0>g6[003o`00003]aZ`0kLJ/00H0kLJ/00?o0000ooooooooool0@?ooool0
03Sooooo00Co00000>g6[03]aZco00002?ooool00ol00000kLJ/0>g6[00@0>g6[0;o00008P3]aZ`0
0ol00000kLJ/0>g6[00<0>g6[0;o00001`3]aZ`00ol0003oooooooooo`10ooooo`00>?ooool00ol0
0000kLJ/o`000009ooooo`03o`00003]aZ`0kLJ/0100kLJ/00Co0000ooooool0003o00007`3]aZ`0
0ol00000kLJ/0>g6[00>0>g6[003o`00003]aZ`0kLJ/00@0kLJ/00?o00000>g6[?l00000@Oooool0
03Sooooo0_l00009ooooo`03o`00003]aZ`0kLJ/0140kLJ/00Co0000oooooooooooooooo0_l0000L
0>g6[003o`00003]aZ`0kLJ/00l0kLJ/0_l000040>g6[004o`00003]aZ`0kLJ/o`00047ooooo000h
ooooo`03o`000?oooooooooo00Sooooo00?o00000>g6[03]aZ`04@3]aZ`00ol0003oooooooooo`03
ooooo`;o00006P3]aZ`00ol00000kLJ/0>g6[00?0>g6[0;o0000103]aZ`01?l00000kLJ/0>g6[?l0
0011ooooo`00@_ooool00ol00000kLJ/0>g6[00B0>g6[003o`000?oooooooooo00Gooooo0_l0000G
0>g6[003o`00003]aZ`0kLJ/0140kLJ/0_l000020>g6[003o`00003]aZ`0kLJ/0080kLJ/00?o0000
ooooooooool0?_ooool004;ooooo00?o00000>g6[03]aZ`04P3]aZ`00ol0003oooooooooo`07oooo
o`;o00005@3]aZ`00ol00000kLJ/0>g6[00A0>g6[0;o00000P3]aZ`00ol00000kLJ/0>g6[0020>g6
[003o`000?oooooooooo03kooooo0011ooooo`03o`00003]aZ`0kLJ/01<0kLJ/00?o0000oooooooo
ool02Oooool2o`000180kLJ/00?o00000>g6[03]aZ`04P3]aZ`2o`0000030>g6[?l00000kLJ/00D0
kLJ/00?o0000ooooooooool0?Oooool0047ooooo00?o00000>g6[03]aZ`04`3]aZ`00ol0003ooooo
ooooo`0;ooooo`03o`00003]aZ`0kLJ/00h0kLJ/00?o00000>g6[03]aZ`0503]aZ`2o`0000L0kLJ/
00?o0000ooooooooool0?Oooool0047ooooo00?o00000>g6[03]aZ`04`3]aZ`00ol0003ooooooooo
o`0<ooooo`;o00003P3]aZ`00ol00000kLJ/0>g6[00B0>g6[0Co00001`3]aZ`00ol0003ooooooooo
o`0mooooo`00@?ooool00ol00000kLJ/0>g6[00D0>g6[003o`000?oooooooooo00kooooo0_l0000;
0>g6[003o`00003]aZ`0kLJ/00h0kLJ/1Ol000020>g6[0;o0000203]aZ`00ol0003oooooooooo`0l
ooooo`00@?ooool00ol00000kLJ/0>g6[00D0>g6[003o`000?oooooooooo013ooooo0_l000090>g6
[003o`00003]aZ`0kLJ/00X0kLJ/1?l000070>g6[003o`000?oooooo000000L0kLJ/00?o0000oooo
ooooool0??ooool003oooooo00?o00000>g6[03]aZ`05@3]aZ`00ol0003oooooooooo`0Booooo`;o
00001P3]aZ`00ol00000kLJ/0>g6[0060>g6[0Go00002`3]aZ`00ol0003oooooo`0000060>g6[003
o`000?oooooooooo03gooooo000oooooo`03o`00003]aZ`0kLJ/01D0kLJ/00?o0000ooooooooool0
5?ooool2o`0000<0kLJ/00?o00000>g6[03]aZ`00`3]aZ`4o`000140kLJ/0_l000050>g6[003o`00
0?oooooooooo03kooooo000nooooo`;o00005`3]aZ`00ol0003oooooooooo`0Fooooo`;o000000<0
kLJ/o`000?l000001?l0000E0>g6[003o`000?oooooo000000<0kLJ/00?o0000ooooooooool0?ooo
ool0043ooooo00?o00000>g6[03]aZ`0503]aZ`00ol0003oooooooooo`0Gooooo`?o00006P3]aZ`0
0ol0003oooooo`0000030>g6[003o`000?oooooooooo03oooooo0011ooooo`03o`00003]aZ`0kLJ/
01<0kLJ/00?o0000ooooooooool05?ooool3o`0000030>g6[?l00000kLJ/01X0kLJ/00?o0000oooo
ool000000P3]aZ`00ol0003oooooooooo`10ooooo`00@_ooool00ol00000kLJ/0>g6[00B0>g6[003
o`000?oooooooooo017ooooo0ol000040>g6[003o`00003]aZ`0kLJ/01T0kLJ/00?o0000oooooooo
ool00_l00013ooooo`00@oooool00ol00000kLJ/0>g6[00A0>g6[003o`000?oooooooooo00kooooo
0ol000060>g6[003o`00003]aZco000001/0kLJ/00?o0000ooooool00000A?ooool004Cooooo00?o
00000>g6[03]aZ`0403]aZ`00ol0003oooooooooo`0;ooooo`?o00002@3]aZ`00ol00000kLJ/o`00
000K0>g6[003o`000?oooooooooo04Cooooo0015ooooo`03o`00003]aZ`0kLJ/00l0kLJ/00?o0000
ooooooooool02?ooool3o`0000`0kLJ/00?o00000>g6[?l000006`3]aZ`00ol0003oooooooooo`14
ooooo`00A_ooool00ol00000kLJ/0>g6[00?0>g6[003o`000?oooooooooo00Cooooo0ol0000>0>g6
[004o`00003]aZ`0kLJ/o`0001T0kLJ/00?o0000ooooooooool0A_ooool004Oooooo00?o00000>g6
[03]aZ`03P3]aZ`01?l0003oooooooooooooool3o`000140kLJ/00Co00000>g6[03]aZco0000603]
aZ`00ol0003oooooooooo`17ooooo`00B?ooool00ol00000kLJ/0>g6[00=0>g6[0Co0000503]aZ`0
1Ol00000kLJ/0>g6[03]aZco000001H0kLJ/00?o0000ooooooooool0B?ooool004Wooooo00?o0000
0>g6[03]aZ`0303]aZ`00ol00000kLJ/0>g6[00D0>g6[003o`00003]aZ`0kLJ/0080kLJ/00?o0000
0>g6[03]aZ`04P3]aZ`2o`0000Cooooo1Ol00012ooooo`00B_ooool00ol00000kLJ/0>g6[00;0>g6
[003o`00003]aZ`0kLJ/01@0kLJ/00?o00000>g6[03]aZ`00P3]aZ`00ol00000kLJ/0>g6[00A0>g6
[003o`000?oooooooooo00;ooooo0_l000050>g6[0?o0000?oooool004_ooooo00?o00000>g6[03]
aZ`02P3]aZ`00ol00000kLJ/0>g6[00D0>g6[003o`00003]aZ`0kLJ/0080kLJ/00?o00000>g6[03]
aZ`0403]aZ`00ol0003oooooooooo`02ooooo`03o`00003]aZ`0kLJ/00L0kLJ/00?o0000oooooooo
ool0?Oooool004cooooo00?o00000>g6[03]aZ`02@3]aZ`00ol00000kLJ/0>g6[00C0>g6[003o`00
003]aZ`0kLJ/00<0kLJ/00?o00000>g6[03]aZ`03`3]aZ`01?l0003oooooooooooooool2o`0000X0
kLJ/00?o0000ooooooooool0?Oooool004gooooo00?o00000>g6[03]aZ`0203]aZ`00ol00000kLJ/
0>g6[00C0>g6[003o`00003]aZ`0kLJ/00@0kLJ/00?o00000>g6[03]aZ`0303]aZ`2o`0000;ooooo
0_l0000<0>g6[003o`000?oooooooooo03gooooo001>ooooo`03o`00003]aZ`0kLJ/00L0kLJ/00?o
00000>g6[03]aZ`04`3]aZ`00ol00000kLJ/0>g6[0040>g6[003o`00003]aZ`0kLJ/00/0kLJ/00Go
0000ooooooooooooooooo`00000>0>g6[003o`000?oooooooooo03gooooo001?ooooo`03o`00003]
aZ`0kLJ/00H0kLJ/00?o00000>g6[03]aZ`04`3]aZ`00ol00000kLJ/0>g6[0040>g6[003o`00003]
aZ`0kLJ/00X0kLJ/00?o0000ooooooooool00_l0000>0>g6[003o`000?oooooooooo03kooooo001@
ooooo`03o`00003]aZ`0kLJ/00D0kLJ/00?o00000>g6[03]aZ`04P3]aZ`00ol00000kLJ/0>g6[005
0>g6[003o`00003]aZ`0kLJ/00P0kLJ/0_l000000ooooooo0000o`00000@0>g6[003o`000?oooooo
oooo03kooooo001Aooooo`03o`00003]aZ`0kLJ/00@0kLJ/00?o00000>g6[03]aZ`04P3]aZ`00ol0
0000kLJ/0>g6[0050>g6[003o`00003]aZ`0kLJ/00L0kLJ/00Co0000oooooooooooo00004P3]aZ`0
0ol0003oooooooooo`0nooooo`00D_ooool00ol00000kLJ/0>g6[0030>g6[003o`00003]aZ`0kLJ/
0180kLJ/00?o00000>g6[03]aZ`01P3]aZ`00ol00000kLJ/0>g6[0050>g6[004o`000?oooooo0000
o`0001<0kLJ/00?o0000ooooooooool0?_ooool005?ooooo00?o00000>g6[03]aZ`00P3]aZ`00ol0
0000kLJ/0>g6[00A0>g6[003o`00003]aZ`0kLJ/00L0kLJ/00?o00000>g6[03]aZ`0103]aZ`3o`00
01D0kLJ/00?o0000ooooooooool0?_ooool005Cooooo00Co00000>g6[03]aZ`0kLJ/0_l0000B0>g6
[003o`00003]aZ`0kLJ/00L0kLJ/00?o00000>g6[03]aZ`00P3]aZ`3o`0001L0kLJ/00?o0000oooo
ooooool0?_ooool005Gooooo00?o00000>g6[03]aZ`00_l0000B0>g6[003o`00003]aZ`0kLJ/00L0
kLJ/00Co00000>g6[03]aZ`0kLJ/0ol0000H0>g6[003o`000?oooooooooo03kooooo001Fooooo`04
o`00003]aZco0000o`000140kLJ/00?o00000>g6[03]aZ`0203]aZ`00ol00000kLJ/0>g6[002o`00
01X0kLJ/00?o0000ooooooooool0?_ooool005Oooooo0_l000000ooooooo00000>g6[00?0>g6[003
o`00003]aZ`0kLJ/00T0kLJ/0_l0000K0>g6[003o`000?oooooooooo03oooooo001Hooooo`03o`00
0?oooooo00000100kLJ/00?o00000>g6[03]aZ`02@3]aZ`00ol00000kLJ/0>g6[00J0>g6[003o`00
0?oooooooooo03oooooo001Kooooo`03o`00003]aZ`0kLJ/00d0kLJ/00?o00000>g6[03]aZ`09P3]
aZ`00ol0003oooooooooo`0oooooo`00Foooool00ol00000kLJ/0>g6[00<0>g6[003o`00003]aZ`0
kLJ/02L0kLJ/00?o0000ooooooooool0?oooool005_ooooo00?o00000>g6[03]aZ`0303]aZ`00ol0
0000kLJ/0>g6[00W0>g6[003o`000?oooooooooo03oooooo001Looooo`03o`00003]aZ`0kLJ/00/0
kLJ/00?o00000>g6[03]aZ`01@3]aZ`00ol00000kLJ/0>g6[00O0>g6[003o`000?oooooooooo03oo
oooo001Looooo`03o`00003]aZ`0kLJ/00X0kLJ/00?o00000>g6[03]aZ`0:03]aZ`00ol0003ooooo
ooooo`0oooooo`00G?ooool00ol00000kLJ/0>g6[00:0>g6[003o`00003]aZ`0kLJ/02P0kLJ/00?o
0000ooooooooool0?oooool005gooooo00?o00000>g6[03]aZ`02@3]aZ`00ol00000kLJ/0>g6[002
0>g6[003o`00003]aZ`0kLJ/0280kLJ/00?o0000ooooooooool0@?ooool005gooooo00?o00000>g6
[03]aZ`0203]aZ`00ol00000kLJ/0>g6[0020>g6[003o`00003]aZ`0kLJ/02<0kLJ/00?o0000oooo
ooooool0@?ooool005kooooo00?o00000>g6[03]aZ`01`3]aZ`01Ol00000kLJ/0>g6[03]aZco0000
02H0kLJ/00?o0000ooooooooool0@?ooool005kooooo00?o00000>g6[03]aZ`01`3]aZ`00ol00000
kLJ/o`00000X0>g6[003o`000?oooooooooo043ooooo001Nooooo`03o`00003]aZ`0kLJ/00H0kLJ/
00?o00000>g6[?l00000:@3]aZ`00ol0003oooooooooo`10ooooo`00Goooool00ol00000kLJ/0>g6
[0050>g6[0;o0000:P3]aZ`00ol0003oooooooooo`10ooooo`00Goooool00ol00000kLJ/0>g6[004
0>g6[0;o0000:`3]aZ`00ol0003oooooooooo`10ooooo`00Goooool01?l00000kLJ/0>g6[03]aZ`5
o`0002/0kLJ/00?o0000ooooooooool0@?ooool0063ooooo0ol00002ooooo`;o0000:`3]aZ`00ol0
003oooooooooo`11ooooo`00IOooool00ol00000kLJ/0>g6[00Z0>g6[003o`000?oooooooooo047o
oooo001Uooooo`03o`00003]aZ`0kLJ/02X0kLJ/00?o0000ooooooooool0@Oooool006Gooooo00?o
00000>g6[03]aZ`0:P3]aZ`00ol0003oooooooooo`11ooooo`00IOooool00ol00000kLJ/0>g6[00Z
0>g6[003o`000?oooooooooo047ooooo001Tooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000oooo
ooooool0@Oooool006Cooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003oooooooooo`11ooooo`00
I?ooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oooooooooo047ooooo001Tooooo`03o`00003]
aZ`0kLJ/02X0kLJ/00?o0000ooooooooool0@_ooool006Cooooo00?o00000>g6[03]aZ`0:P3]aZ`0
0ol0003oooooooooo`12ooooo`00I?ooool00ol00000kLJ/0>g6[00Z0>g6[003o`000?oooooooooo
04;ooooo001Tooooo`03o`00003]aZ`0kLJ/02X0kLJ/00?o0000ooooooooool0@_ooool006?ooooo
00?o00000>g6[03]aZ`0:`3]aZ`00ol0003oooooooooo`12ooooo`00Hoooool00ol00000kLJ/0>g6
[00[0>g6[003o`000?oooooooooo04;ooooo001Sooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000
ooooooooool0@_ooool006?ooooo00?o00000>g6[03]aZ`0:P3]aZ`00ol0003oooooooooo`13oooo
o`00Hoooool00ol00000kLJ/0>g6[00Z0>g6[003o`000?oooooooooo04?ooooo001Sooooo`03o`00
003]aZ`0kLJ/02X0kLJ/00?o0000ooooooooool0@oooool006?ooooo00?o00000>g6[03]aZ`0:P3]
aZ`00ol0003oooooooooo`13ooooo`00H_ooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oooooo
oooo04?ooooo001Rooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0@oooool006;o
oooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003oooooooooo`13ooooo`00H_ooool00ol00000kLJ/
0>g6[00[0>g6[003o`000?oooooooooo04?ooooo001Rooooo`03o`00003]aZ`0kLJ/02X0kLJ/00?o
0000ooooooooool0A?ooool006;ooooo00?o00000>g6[03]aZ`0:P3]aZ`00ol0003oooooooooo`14
ooooo`00H_ooool00ol00000kLJ/0>g6[00Z0>g6[003o`000?oooooooooo04Cooooo001Qooooo`03
o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0A?ooool0067ooooo00?o00000>g6[03]aZ`0
:`3]aZ`00ol0003oooooooooo`14ooooo`00HOooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oo
oooooooo04Cooooo001Qooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0A?ooool0
067ooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003oooooooooo`14ooooo`00HOooool00ol00000
kLJ/0>g6[00Z0>g6[003o`000?oooooooooo04Gooooo001Qooooo`03o`00003]aZ`0kLJ/02X0kLJ/
00?o0000ooooooooool0AOooool0063ooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003ooooooooo
o`15ooooo`00H?ooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oooooooooo04Gooooo001Poooo
o`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0AOooool0063ooooo00?o00000>g6[03]
aZ`0:`3]aZ`00ol0003oooooooooo`15ooooo`00H?ooool00ol00000kLJ/0>g6[00[0>g6[003o`00
0?oooooooooo04Gooooo001Pooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0AOoo
ool0063ooooo00?o00000>g6[03]aZ`0:P3]aZ`00ol0003oooooooooo`16ooooo`00Goooool00ol0
0000kLJ/0>g6[00[0>g6[003o`000?oooooooooo04Kooooo001Oooooo`03o`00003]aZ`0kLJ/02/0
kLJ/00?o0000ooooooooool0A_ooool005oooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003ooooo
ooooo`16ooooo`00Goooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oooooooooo04Kooooo001O
ooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0A_ooool005oooooo00?o00000>g6
[03]aZ`0:`3]aZ`00ol0003oooooooooo`16ooooo`00Goooool00ol00000kLJ/0>g6[00[0>g6[003
o`000?oooooooooo04Kooooo001Nooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0
Aoooool005kooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003oooooooooo`17ooooo`00G_ooool0
0ol00000kLJ/0>g6[00[0>g6[003o`000?oooooooooo04Oooooo001Nooooo`03o`00003]aZ`0kLJ/
02/0kLJ/00?o0000ooooooooool0Aoooool005kooooo00?o00000>g6[03]aZ`0:`3]aZ`00ol0003o
ooooooooo`17ooooo`00G_ooool00ol00000kLJ/0>g6[00[0>g6[003o`000?oooooooooo04Oooooo
001Nooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000ooooooooool0Aoooool005gooooo00?o0000
0>g6[03]aZ`0;03]aZ`00ol0003oooooooooo`17ooooo`00GOooool00ol00000kLJ/0>g6[00[0>g6
[003o`000?oooooooooo04Sooooo001Mooooo`03o`00003]aZ`0kLJ/02/0kLJ/00?o0000oooooooo
ool0B?ooool005gooooo6?l0000F0>g6[003o`000?oooooooooo04Sooooo001eoooooaOo0000B_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {327.875, 0}} -> {0.159824, -0.000694682, \
0.00292039, 0.00292039}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.54231 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.261033 1.6121 2.22045e-16 1.6121 [
[ 0 0 0 0 ]
[ 1 1.54231 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.54231 L
0 1.54231 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.74924 .77514 m .71747 .37393 L p .60253 .57087 L .923 .767 .67 r
F P
0 g
s
.71833 .7875 m .74924 .77514 L p .60253 .57087 L .923 .767 .67 r
F P
0 g
s
.70954 .96363 m .67817 .95773 L p .48458 1.08961 L .923 .767 .67 r
F P
0 g
s
.66212 1.37084 m .70954 .96363 L p .48458 1.08961 L .923 .767 .67 r
F P
0 g
s
.71244 .89144 m .68525 .92674 L .66803 .88031 L p .923 .767 .67 r
F P
0 g
s
.66803 .88031 m .6956 .84519 L .71244 .89144 L p .923 .767 .67 r
F P
0 g
s
.67989 .78014 m .71833 .7875 L p .60253 .57087 L .923 .767 .67 r
F P
0 g
s
.67477 .78795 m .6956 .84519 L .66803 .88031 L p .923 .767 .67 r
F P
0 g
s
.44149 1.36548 m .66212 1.37084 L p .48458 1.08961 L .923 .767 .67 r
F P
0 g
s
.71747 .37393 m .58818 .40497 L .60253 .57087 L p .923 .767 .67 r
F P
0 g
s
.67817 .95773 m .56172 1.02813 L .48458 1.08961 L p .923 .767 .67 r
F P
0 g
s
.67491 .93793 m .56172 1.02813 L .53744 .91372 L p .923 .767 .67 r
F P
0 g
s
.53744 .91372 m .6643 .88458 L .67491 .93793 L p .923 .767 .67 r
F P
0 g
s
.65825 .74255 m .67989 .78014 L p .60253 .57087 L .923 .767 .67 r
F P
0 g
s
.67477 .78795 m .65825 .74255 L .58152 .83618 L p .923 .767 .67 r
F P
0 g
s
.58152 .83618 m .64673 .82283 L .67477 .78795 L p .923 .767 .67 r
F P
0 g
s
.66803 .88031 m .64673 .82283 L .67477 .78795 L p .923 .767 .67 r
F P
0 g
s
.53744 .91372 m .6643 .88458 L .64673 .82283 L p .923 .767 .67 r
F P
0 g
s
.60253 .57087 m .60862 .6062 L .65825 .74255 L p .923 .767 .67 r
F P
0 g
s
.65825 .74255 m .60862 .6062 L .60355 .61204 L p .923 .767 .67 r
F P
0 g
s
.60355 .61204 m .58152 .83618 L .65825 .74255 L p .923 .767 .67 r
F P
0 g
s
.64673 .82283 m .58152 .83618 L .53744 .91372 L p .923 .767 .67 r
F P
0 g
s
.60355 .61204 m .59734 .57519 L .60862 .6062 L closepath p .923 .767 .67 r
F P
0 g
s
.58152 .83618 m .53744 .91372 L p .55036 .58197 L .923 .767 .67 r
F P
0 g
s
.55036 .58197 m .56408 .6128 L .58152 .83618 L p .923 .767 .67 r
F P
0 g
s
.56172 1.02813 m .48458 1.08961 L .48283 1.08171 L p .923 .767 .67 r
F P
0 g
s
.48283 1.08171 m .53744 .91372 L .56172 1.02813 L p .923 .767 .67 r
F P
0 g
s
.53744 .91372 m .40272 .85007 L p .55036 .58197 L .923 .767 .67 r
F P
0 g
s
.39443 .96192 m .53744 .91372 L .48283 1.08171 L p .923 .767 .67 r
F P
0 g
s
.40272 .85007 m .39631 .83717 L .55036 .58197 L p .923 .767 .67 r
F P
0 g
s
.46701 .48343 m .55036 .58197 L .39631 .83717 L p .923 .767 .67 r
F P
0 g
s
.46944 1.13489 m .44149 1.36548 L p .48458 1.08961 L .923 .767 .67 r
F P
0 g
s
.48458 1.08961 m .47735 1.10035 L .46944 1.13489 L p .923 .767 .67 r
F P
0 g
s
.48283 1.08171 m .47598 1.09645 L .48458 1.08961 L closepath p .923 .767 .67 \
r
F P
0 g
s
.45345 1.09963 m .39443 .96192 L p .48283 1.08171 L .923 .767 .67 r
F P
0 g
s
.48283 1.08171 m .47498 1.09505 L .45345 1.09963 L p .923 .767 .67 r
F P
0 g
s
.39631 .83717 m .34113 .78095 L .46701 .48343 L p .923 .767 .67 r
F P
0 g
s
.29675 .42891 m .45469 .47 L .3411 .78101 L p .923 .767 .67 r
F P
0 g
s
.28683 .90947 m .41062 1.02722 L .40272 .85007 L p .923 .767 .67 r
F P
0 g
s
.39631 .83717 m .40272 .85007 L .33917 .78557 L p .923 .767 .67 r
F P
0 g
s
.40272 .85007 m .33917 .78557 L .28683 .90947 L p .923 .767 .67 r
F P
0 g
s
.33917 .78557 m .3411 .78101 L .39631 .83717 L p .923 .767 .67 r
F P
0 g
s
.2569 .86028 m .29675 .42891 L p .3411 .78101 L .923 .767 .67 r
F P
0 g
s
.3411 .78101 m .33917 .78557 L .2569 .86028 L p .923 .767 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.812, 331.25},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0001Bb000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Ko
oooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_oo
ool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00
e_ooool00=Kooooo002Gooooo`?o0000??ooool009?ooooo1?l000020>c4Z`03o`000?oooooooooo
03[ooooo002?ooooo`Co00001P3/a:/00ol0003oooooooooo`0jooooo`00Roooool4o`0000T0k<B[
00?ok<B[o`000?ooool0>oooool008Oooooo1?l0000=0>c4Z`03onc4Zol0003ooooo03_ooooo0023
ooooo`Co0000403/a:/2onc4Z`03o`000?oooooooooo03[ooooo001oooooo`Co00004`3/a:/3onc4
Z`03o`000?oooooooooo03[ooooo001mooooo`;o00005`3/a:/4onc4Z`03o`000?oooooooooo03Wo
oooo001mooooo`03o`00003/a:/0k<B[01D0k<B[1Oo/a:/00ol0003oooooooooo`0iooooo`00OOoo
ool00ol00000k<B[0>c4Z`0E0>c4Z`Gok<B[00?o0000ooooooooool0>Oooool007gooooo00?o0000
0>c4Z`3/a:/0503/a:/6onc4Z`03o`000?oooooooooo03Wooooo001mooooo`03o`00003/a:/0k<B[
01<0k<B[1oo/a:/00ol0003oooooooooo`0iooooo`00?oooool3o`0003_ooooo00?o00000>c4Z`3/
a:/04`3/a:/7onc4Z`03o`000?oooooooooo03Wooooo000oooooo`03o`00003/a:/0k<B[00Co0000
=oooool00ol00000k<B[0>c4Z`0B0>c4Z`Sok<B[00?o0000ooooooooool0>Oooool003oooooo00?o
00000>c4Z`3/a:/0103/a:/3o`0003Gooooo00?o00000>c4Z`3/a:/04@3/a:/8onc4Z`03o`000?oo
oooooooo03Wooooo000oooooo`03o`00003/a:/0k<B[00L0k<B[1?l0000aooooo`03o`00003/a:/0
k<B[0100k<B[2Oo/a:/00ol0003oooooooooo`0iooooo`00?oooool00ol00000k<B[0>c4Z`0;0>c4
Z`Co0000;Oooool00ol00000k<B[0>c4Z`0@0>c4Z`Wok<B[00?o0000ooooooooool0>Oooool003oo
oooo00?o00000>c4Z`3/a:/03`3/a:/4o`0002Wooooo00?o00000>c4Z`3/a:/03`3/a:/:onc4Z`03
o`000?oooooooooo03Wooooo000nooooo`03o`00003/a:/0k<B[01@0k<B[1?l0000Uooooo`03o`00
003/a:/0k<B[00h0k<B[2oo/a:/00ol0003oooooooooo`0iooooo`00?_ooool00ol00000k<B[0>c4
Z`0H0>c4Z`?o00008_ooool00ol00000k<B[0>c4Z`0>0>c4Z`cok<B[00?o0000ooooooooool0>?oo
ool003kooooo00?o00000>c4Z`3/a:/06`3/a:/4o`0001kooooo00?o00000>c4Z`3/a:/03@3/a:/=
onc4Z`03o`000?oooooooooo03Sooooo000nooooo`03o`00003/a:/0k<B[01l0k<B[0_l0000Loooo
o`03o`00003/a:/0k<B[00d0k<B[3Oo/a:/00ol0003oooooooooo`0hooooo`00?_ooool00ol00000
k<B[0>c4Z`0P0>c4Z`03o`000?oooooooooo01[ooooo00?o00000>c4Z`3/a:/0303/a:/>onc4Z`03
o`000?oooooooooo03Sooooo000nooooo`03o`00003/a:/0k<B[01l0k<B[00?o0000ooooooooool0
6oooool00ol00000k<B[0>c4Z`0;0>c4Z`ook<B[00?o0000ooooooooool0>?ooool003kooooo00?o
00000>c4Z`3/a:/07`3/a:/01?l0003oooooooooool0000Jooooo`03o`00003/a:/0k<B[00/0k<B[
3oo/a:/00ol0003oooooooooo`0hooooo`00?_ooool00ol00000k<B[0>c4Z`0O0>c4Z`04o`000?oo
ooooooooo`0001[ooooo00?o00000>c4Z`3/a:/02P3/a:/@onc4Z`03o`000?oooooooooo03Sooooo
000nooooo`03o`00003/a:/0k<B[01h0k<B[00Ko0000oooooooooooo00000>c4Zol0000Jooooo`03
o`00003/a:/0k<B[00T0k<B[4?o/a:/00ol0003oooooooooo`0hooooo`00?_ooool00ol00000k<B[
0>c4Z`0N0>c4Z`04o`000?ooooooooooo`000080k<B[00?o0000ooooooooool05oooool00ol00000
k<B[0>c4Z`080>c4Za7ok<B[00?o0000ooooooooool0>?ooool003gooooo00?o00000>c4Z`3/a:/0
7`3/a:/00ol0003oooooo`0000040>c4Z`03o`000?oooooooooo01Kooooo00?o00000>c4Z`3/a:/0
203/a:/Aonc4Z`03o`000?oooooooooo03Sooooo000mooooo`03o`00003/a:/0k<B[01h0k<B[00Co
0000oooooooooooo00001@3/a:/00ol0003oooooooooo`0Eooooo`03o`00003/a:/0k<B[00L0k<B[
4_o/a:/00ol0003oooooooooo`0hooooo`00?Oooool00ol00000k<B[0>c4Z`0N0>c4Z`04o`000?oo
ooooooooo`0000H0k<B[00?o0000ooooooooool05?ooool00ol00000k<B[0>c4Z`060>c4Za?ok<B[
00?o0000ooooooooool0>?ooool003gooooo00?o00000>c4Z`3/a:/07@3/a:/01?l0003ooooooooo
ool000080>c4Z`03o`000?oooooooooo01?ooooo00?o00000>c4Z`3/a:/01P3/a:/Conc4Z`03o`00
0?oooooooooo03Sooooo000mooooo`03o`00003/a:/0k<B[01d0k<B[00Co0000oooooooooooo0000
203/a:/00ol0003oooooooooo`0Cooooo`03o`00003/a:/0k<B[00D0k<B[5Oo/a:/00ol0003ooooo
ooooo`0gooooo`00?Oooool00ol00000k<B[0>c4Z`0M0>c4Z`03o`000?oooooo000000X0k<B[00?o
0000ooooooooool04_ooool00ol00000k<B[0>c4Z`050>c4ZaGok<B[00?o0000ooooooooool0=ooo
ool003gooooo00?o00000>c4Z`3/a:/0703/a:/01?l0003oooooooooool0000;0>c4Z`03o`000?oo
oooooooo017ooooo00?o00000>c4Z`3/a:/0103/a:/Fonc4Z`03o`000?oooooooooo03Oooooo000m
ooooo`03o`00003/a:/0k<B[01`0k<B[00?o0000ooooool000003@3/a:/00ol0003oooooooooo`0@
ooooo`03o`00003/a:/0k<B[00@0k<B[5_o/a:/00ol0003oooooooooo`0gooooo`00?Oooool00ol0
0000k<B[0>c4Z`0L0>c4Z`03o`000?oooooo000000h0k<B[00?o0000ooooooooool03oooool00ol0
0000k<B[0>c4Z`030>c4ZaOok<B[00?o0000ooooooooool0=oooool003gooooo00?o00000>c4Z`3/
a:/06`3/a:/01?l0003oooooooooool0000?0>c4Z`03o`000?oooooooooo00kooooo00?o00000>c4
Z`3/a:/00P3/a:/Honc4Z`03o`000?oooooooooo03Oooooo000mooooo`03o`00003/a:/0k<B[01/0
k<B[00?o0000ooooool000004@3/a:/00ol0003oooooooooo`0>ooooo`04o`00003/a:/0k<B[0>c4
ZaSok<B[00?o0000ooooooooool0=oooool003cooooo00?o00000>c4Z`3/a:/06`3/a:/01?l0003o
ooooooooool0000A0>c4Z`03o`000?oooooooooo00kooooo00?o00000>c4Z`3/a:/06Oo/a:/00ol0
003oooooooooo`0gooooo`00??ooool00ol00000k<B[0>c4Z`0K0>c4Z`03o`000?oooooo000001<0
k<B[00?o0000ooooooooool03Oooool00ol00000k<B[0>c4Z`0Ionc4Z`03o`000?oooooooooo03Oo
oooo000looooo`03o`00003/a:/0k<B[01/0k<B[00?o0000ooooool00000503/a:/00ol0003ooooo
ooooo`0<ooooo`03o`00003/a:_ok<B[01Wok<B[00?o0000ooooooooool0=oooool003cooooo00?o
00000>c4Z`3/a:/06P3/a:/00ol0003oooooo`00000F0>c4Z`03o`000?oooooooooo00_ooooo00?o
0000onc4Zoo/a:/06Oo/a:/00ol0003oooooooooo`0gooooo`00??ooool00ol00000k<B[0>c4Z`0J
0>c4Z`03o`000?oooooo000001L0k<B[00?o0000ooooooooool02Oooool2o`0001_ok<B[00?o0000
ooooooooool0=oooool003cooooo00?o00000>c4Z`3/a:/06@3/a:/01?l0003oooooooooool0000H
0>c4Z`03o`000?oooooooooo00Sooooo0_l0000Lonc4Z`03o`000?oooooooooo03Kooooo000loooo
o`03o`00003/a:/0k<B[01T0k<B[00?o0000ooooool000006P3/a:/00ol0003oooooooooo`07oooo
o`;o00007?o/a:/00ol0003oooooooooo`0fooooo`00??ooool00ol00000k<B[0>c4Z`0I0>c4Z`03
o`000?oooooo000001X0k<B[00?o0000ooooooooool02?ooool2o`0001_ok<B[00?o0000oooooooo
ool0=_ooool003cooooo00?o00000>c4Z`3/a:/0603/a:/00ol0003oooooo`00000J0>c4Z`03o`00
003/a:_o000000Wooooo0_l000000`3/a:_ok<B[onc4Z`0Honc4Z`03o`000?oooooooooo03Kooooo
000looooo`03o`00003/a:/0k<B[01P0k<B[00?o0000ooooool000006@3/a:/01?l00000k<B[0>c4
Zol00009ooooo`;o000000<0k<B[onc4Zoo/a:/06?o/a:/00ol0003oooooooooo`0fooooo`00>ooo
ool00ol00000k<B[0>c4Z`0I0>c4Z`;o00006P3/a:/01Ol00000k<B[0>c4Z`3/a:_o000000Sooooo
0ol000000`3/a:_ok<B[onc4Z`0Gonc4Z`03o`000?oooooooooo03Kooooo000kooooo`03o`00003/
a:/0k<B[01P0k<B[00?o0000ooooool000006@3/a:/00ol00000k<B[0>c4Z`020>c4Z`03o`000?oo
oooooooo00Oooooo0_l000020>c4ZaSok<B[00?o0000ooooooooool0=_ooool003_ooooo00?o0000
0>c4Z`3/a:/0603/a:/00ol0003oooooo`00000I0>c4Z`03o`00003/a:/0k<B[0080k<B[00?o0000
ooooooooool01oooool2o`0000<0k<B[5oo/a:/00ol0003oooooooooo`0fooooo`00>oooool00ol0
0000k<B[0>c4Z`0G0>c4Z`03o`000?oooooo000001T0k<B[00?o00000>c4Z`3/a:/0103/a:/00ol0
003oooooooooo`06ooooo`03o`00003/a:_o00000080k<B[5oo/a:/00ol0003oooooooooo`0foooo
o`00>oooool00ol00000k<B[0>c4Z`0G0>c4Z`03o`000?oooooo000001P0k<B[00?o00000>c4Z`3/
a:/01@3/a:/00ol0003oooooooooo`06ooooo`03o`00003/a:_o000000<0k<B[5_o/a:/00ol0003o
ooooooooo`0fooooo`00>oooool00ol00000k<B[0>c4Z`0G0>c4Z`;o00006@3/a:/00ol00000k<B[
0>c4Z`050>c4Z`03o`000?oooooooooo00Kooooo00?o00000>c4Zol00000103/a:/Eonc4Z`03o`00
0?oooooooooo03Kooooo000kooooo`03o`00003/a:/0k<B[01H0k<B[00?o0000ooooool00000603/
a:/00ol00000k<B[0>c4Z`060>c4Z`03o`000?oooooooooo00Kooooo00Co00000>c4Z`3/a:_o0000
103/a:/Donc4Z`03o`000?oooooooooo03Kooooo000kooooo`03o`00003/a:/0k<B[01H0k<B[0_l0
000I0>c4Z`03o`00003/a:/0k<B[00H0k<B[00?o0000ooooooooool01_ooool01?l00000k<B[0>c4
Zol000040>c4ZaGok<B[00?o0000ooooooooool0=Oooool003_ooooo00?o00000>c4Z`3/a:/05P3/
a:/2o`0001P0k<B[00?o00000>c4Z`3/a:/01`3/a:/00ol0003oooooooooo`05ooooo`05o`00003/
a:/0k<B[0>c4Zol000001@3/a:/Donc4Z`03o`000?oooooooooo03Gooooo000kooooo`03o`00003/
a:/0k<B[01D0k<B[00?o0000ooooool000005`3/a:/00ol00000k<B[0>c4Z`080>c4Z`03o`000?oo
oooooooo00Gooooo00?o00000>c4Z`3/a:/00P3/a:/00ol00000k<B[0>c4Z`030>c4Za?ok<B[00?o
0000ooooooooool0=Oooool003[ooooo00?o00000>c4Z`3/a:/05P3/a:/2o`0001P0k<B[00?o0000
0>c4Z`3/a:/02@3/a:/00ol0003oooooooooo`04ooooo`03o`00003/a:/0k<B[0080k<B[00?o0000
0>c4Z`3/a:/0103/a:/Bonc4Z`03o`000?oooooooooo03Gooooo000jooooo`03o`00003/a:/0k<B[
01D0k<B[00?o0000ooooool000005`3/a:/00ol00000k<B[0>c4Z`0:0>c4Z`03o`000?oooooooooo
00Cooooo00?o00000>c4Z`3/a:/00P3/a:/00ol00000k<B[0>c4Z`040>c4Za;ok<B[00?o0000oooo
ooooool0=Oooool003[ooooo00?o00000>c4Z`3/a:/05@3/a:/2o`0001P0k<B[00?o00000>c4Z`3/
a:/02P3/a:/00ol0003oooooooooo`04ooooo`03o`00003/a:/0k<B[00<0k<B[00?o00000>c4Z`3/
a:/0103/a:/Aonc4Z`03o`000?oooooooooo03Gooooo000jooooo`03o`00003/a:/0k<B[01D0k<B[
0_l0000G0>c4Z`03o`00003/a:/0k<B[00/0k<B[00?o0000ooooooooool01?ooool00ol00000k<B[
0>c4Z`030>c4Z`03o`00003/a:/0k<B[00D0k<B[4?o/a:/00ol0003oooooooooo`0eooooo`00>_oo
ool00ol00000k<B[0>c4Z`0D0>c4Z`;o00005`3/a:/00ol00000k<B[0>c4Z`0<0>c4Z`03o`000?oo
oooooooo00Cooooo00?o00000>c4Z`3/a:/00`3/a:/00ol00000k<B[0>c4Z`060>c4Z`ook<B[00?o
0000ooooooooool0=Oooool003[ooooo00?o00000>c4Z`3/a:/0503/a:/2o`0001L0k<B[00?o0000
0>c4Z`3/a:/0303/a:/00ol0003oooooooooo`04ooooo`03o`00003/a:/0k<B[00@0k<B[00?o0000
0>c4Z`3/a:/01@3/a:/?onc4Z`03o`000?oooooooooo03Gooooo000jooooo`03o`00003/a:/0k<B[
01@0k<B[0_l0000F0>c4Z`03o`00003/a:/0k<B[00d0k<B[00?o0000ooooooooool01?ooool00ol0
0000k<B[0>c4Z`040>c4Z`03o`00003/a:/0k<B[00H0k<B[3_o/a:/00ol0003oooooooooo`0eoooo
o`00>_ooool00ol00000k<B[0>c4Z`0C0>c4Z`;o00005P3/a:/00ol00000k<B[0>c4Z`0>0>c4Z`03
o`000?oooooooooo00?ooooo00?o00000>c4Z`3/a:/01@3/a:/00ol00000k<B[0>c4Z`070>c4Z`go
k<B[00?o0000ooooooooool0=Oooool003[ooooo00?o00000>c4Z`3/a:/04`3/a:/2o`0001H0k<B[
00?o00000>c4Z`3/a:/03P3/a:/00ol0003oooooooooo`03ooooo`03o`00003/a:/0k<B[00H0k<B[
00?o00000>c4Z`3/a:/01P3/a:/=onc4Z`03o`000?oooooooooo03Gooooo000jooooo`03o`00003/
a:/0k<B[0180k<B[0_l0000F0>c4Z`03o`00003/a:/0k<B[00l0k<B[00?o0000ooooooooool00ooo
ool00ol00000k<B[0>c4Z`060>c4Z`03o`00003/a:/0k<B[00L0k<B[3?o/a:/00ol0003ooooooooo
o`0eooooo`00>Oooool00ol00000k<B[0>c4Z`0C0>c4Z`;o00005P3/a:/00ol00000k<B[0>c4Z`0?
0>c4Z`03o`000?oooooooooo00?ooooo00?o00000>c4Z`3/a:/01P3/a:/00ol00000k<B[0>c4Z`08
0>c4Z`cok<B[00?o0000ooooooooool0=?ooool003Wooooo00?o00000>c4Z`3/a:/04`3/a:/00ol0
0000k<B[0>c4Z`0D0>c4Z`03o`00003/a:/0k<B[0100k<B[00?o0000ooooooooool00oooool00ol0
0000k<B[0>c4Z`070>c4Z`03o`00003/a:/0k<B[00P0k<B[2oo/a:/00ol0003oooooooooo`0doooo
o`00>Oooool00ol00000k<B[0>c4Z`0B0>c4Z`;o00005@3/a:/00ol00000k<B[0>c4Z`0B0>c4Z`03
o`000?oooooooooo00;ooooo00?o00000>c4Z`3/a:/01`3/a:/00ol00000k<B[0>c4Z`080>c4Z`_o
k<B[00?o0000ooooooooool0=?ooool003Wooooo00?o00000>c4Z`3/a:/04P3/a:/2o`0001D0k<B[
00?o00000>c4Z`3/a:/04P3/a:/00ol0003oooooooooo`02ooooo`03o`00003/a:/0k<B[00L0k<B[
00?o00000>c4Z`3/a:/02@3/a:/:onc4Z`03o`000?oooooooooo03Cooooo000iooooo`03o`00003/
a:/0k<B[0140k<B[0_l0000E0>c4Z`03o`00003/a:/0k<B[01<0k<B[00?o0000ooooooooool00_oo
ool00ol00000k<B[0>c4Z`080>c4Z`03o`00003/a:/0k<B[00T0k<B[2Oo/a:/00ol0003ooooooooo
o`0dooooo`00>Oooool00ol00000k<B[0>c4Z`0A0>c4Z`;o00005@3/a:/00ol00000k<B[0>c4Z`0C
0>c4Z`03o`000?oooooooooo00;ooooo00?o00000>c4Z`3/a:/0203/a:/00ol00000k<B[0>c4Z`0:
0>c4Z`Sok<B[00?o0000ooooooooool0=?ooool003Wooooo00?o00000>c4Z`3/a:/04@3/a:/00ol0
0000k<B[0>c4Z`0C0>c4Z`03o`00003/a:/0k<B[01@0k<B[00?o0000ooooooooool00_ooool00ol0
0000k<B[0>c4Z`080>c4Z`03o`00003/a:/0k<B[00X0k<B[2?o/a:/00ol0003oooooooooo`0doooo
o`00>Oooool00ol00000k<B[0>c4Z`0@0>c4Z`;o0000503/a:/00ol00000k<B[0>c4Z`0E0>c4Z`05
o`000?ooooooooooooooool00000303/a:/00ol00000k<B[0>c4Z`0:0>c4Z`Ook<B[00?o0000oooo
ooooool0=?ooool003Wooooo00?o00000>c4Z`3/a:/0403/a:/00ol00000k<B[0>c4Z`0C0>c4Z`03
o`00003/a:/0k<B[01D0k<B[00Go0000ooooooooooooooooo`00000<0>c4Z`03o`00003/a:/0k<B[
00/0k<B[1_o/a:/00ol0003oooooooooo`0dooooo`00>Oooool00ol00000k<B[0>c4Z`0@0>c4Z`03
o`00003/a:/0k<B[0180k<B[00?o00000>c4Z`3/a:/05P3/a:/01Ol0003ooooooooooooooooo0000
00`0k<B[00?o00000>c4Z`3/a:/0303/a:/5onc4Z`03o`000?oooooooooo03Cooooo000hooooo`03
o`00003/a:/0k<B[0100k<B[0_l0000D0>c4Z`03o`00003/a:/0k<B[01H0k<B[00Go0000oooooooo
ooooooooo`00000=0>c4Z`03o`00003/a:/0k<B[00/0k<B[1Oo/a:/00ol0003oooooooooo`0doooo
o`00>?ooool00ol00000k<B[0>c4Z`0@0>c4Z`03o`00003/a:/0k<B[0180k<B[00?o00000>c4Z`3/
a:/05`3/a:/01Ol0003ooooooooooooooooo000000d0k<B[00?o00000>c4Z`3/a:/0303/a:/4onc4
Z`03o`000?oooooooooo03Cooooo000hooooo`03o`00003/a:/0k<B[00l0k<B[0_l0000C0>c4Z`03
o`00003/a:/0k<B[01P0k<B[00Go0000ooooooooooooooooo`00000<0>c4Z`03o`00003/a:_o0000
00h0k<B[1?o/a:/00ol0003oooooooooo`0cooooo`00>?ooool00ol00000k<B[0>c4Z`0?0>c4Z`03
o`00003/a:/0k<B[0180k<B[00?o00000>c4Z`3/a:/06@3/a:/01?l0003oooooooooool0000;0>c4
Z`03o`00003/a:/0k<B[00;o00003P3/a:/3onc4Z`03o`000?oooooooooo03?ooooo000hooooo`03
o`00003/a:/0k<B[00l0k<B[00?o00000>c4Z`3/a:/04@3/a:/00ol00000k<B[0>c4Z`0J0>c4Z`04
o`000?ooooooooooo`0000X0k<B[00Co00000>c4Z`3/a:/0k<B[0_l0000>0>c4Z`?ok<B[00?o0000
ooooooooool0<oooool003Sooooo00?o00000>c4Z`3/a:/03P3/a:/00ol00000k<B[0>c4Z`0A0>c4
Z`03o`00003/a:/0k<B[01/0k<B[00Co0000oooooooooooo00002@3/a:/00ol00000k<B[0>c4Z`03
0>c4Z`;o00003P3/a:/2onc4Z`03o`000?oooooooooo03?ooooo000hooooo`03o`00003/a:/0k<B[
00h0k<B[00?o00000>c4Z`3/a:/04@3/a:/00ol00000k<B[0>c4Z`0K0>c4Z`04o`000?oooooooooo
o`0000T0k<B[00?o00000>c4Z`3/a:/00`3/a:/2o`0000l0k<B[00?ok<B[o`000?ooool0=?ooool0
03Sooooo00?o00000>c4Z`3/a:/03P3/a:/00ol00000k<B[0>c4Z`0@0>c4Z`03o`00003/a:/0k<B[
01`0k<B[00?o0000ooooool000002@3/a:/00ol00000k<B[0>c4Z`050>c4Z`;o00003P3/a:/2o`00
03Gooooo000hooooo`03o`00003/a:/0k<B[00d0k<B[00?o00000>c4Z`3/a:/04@3/a:/00ol00000
k<B[0>c4Z`0L0>c4Z`03o`000?oooooo000000P0k<B[00?o00000>c4Z`3/a:/01P3/a:/00ol0003o
ooooo`000002o`0000P0k<B[0ol0000gooooo`00>?ooool00ol00000k<B[0>c4Z`0<0>c4Z`?o0000
4@3/a:/00ol00000k<B[0>c4Z`0M0>c4Z`03o`000?oooooo000000L0k<B[00?o00000>c4Z`3/a:/0
1`3/a:/00ol0003oooooooooo`02ooooo`Co00000P3/a:/2o`0003[ooooo000hooooo`03o`00003/
a:/0k<B[00/0k<B[00?o0000ooooool000000_l0000?0>c4Z`03o`00003/a:/0k<B[01h0k<B[00?o
0000ooooool000001P3/a:/00ol00000k<B[0>c4Z`090>c4Z`03o`000?oooooooooo00Gooooo0_l0
000looooo`00=oooool00ol00000k<B[0>c4Z`0;0>c4Z`03o`000?oooooo00000080k<B[0_l0000>
0>c4Z`03o`00003/a:/0k<B[01h0k<B[00?o0000ooooool000001P3/a:/00ol00000k<B[0>c4Z`09
0>c4Z`03o`000?oooooooooo04?ooooo000gooooo`03o`00003/a:/0k<B[00X0k<B[00Co0000oooo
oooooooo00000`3/a:/2o`0000`0k<B[00?o00000>c4Z`3/a:/07`3/a:/00ol0003oooooo`000005
0>c4Z`03o`00003/a:/0k<B[00T0k<B[00?o00000>c4Zol00000A?ooool003Oooooo00?o00000>c4
Z`3/a:/02@3/a:/01Ol0003ooooooooooooooooo000000@0k<B[0_l0000;0>c4Z`03o`00003/a:/0
k<B[01l0k<B[00?o0000ooooool00000103/a:/00ol00000k<B[0>c4Z`090>c4Z`04o`00003/a:/0
k<B[o`0004Cooooo000gooooo`03o`00003/a:/0k<B[00P0k<B[00Go0000ooooooooooooooooo`00
00060>c4Z`;o00002@3/a:/00ol00000k<B[0>c4Z`0P0>c4Z`03o`000?oooooo000000<0k<B[00?o
00000>c4Z`3/a:/02@3/a:/01Ol00000k<B[0>c4Z`3/a:_o000004Cooooo000gooooo`03o`00003/
a:/0k<B[00L0k<B[00?o0000ooooooooool00_ooool00ol00000k<B[0>c4Z`050>c4Z`;o00001`3/
a:/00ol00000k<B[0>c4Z`0R0>c4Z`;o00000P3/a:/00ol00000k<B[0>c4Z`090>c4Z`03o`00003/
a:/0k<B[00<0k<B[00?o0000ooooooooool0@Oooool003Oooooo00?o00000>c4Z`3/a:/01P3/a:/0
0ol0003oooooooooo`02ooooo`03o`00003/a:/0k<B[00L0k<B[0_l000060>c4Z`03o`00003/a:/0
k<B[0280k<B[00Go00000>c4Z`3/a:/0k<B[o`00000:0>c4Z`03o`00003/a:/0k<B[00@0k<B[00?o
0000ooooooooool0@Oooool003Oooooo00?o00000>c4Z`3/a:/0103/a:/2o`0000Gooooo00?o0000
0>c4Z`3/a:/0203/a:/2o`0000@0k<B[00?o00000>c4Z`3/a:/08`3/a:/01?l00000k<B[0>c4Zol0
00080>c4Z`?o00001`3/a:/00ol0003oooooooooo`11ooooo`00=oooool00ol00000k<B[0>c4Z`03
0>c4Z`03o`000?oooooooooo00Gooooo00?o00000>c4Z`3/a:/02@3/a:/2o`0000<0k<B[00?o0000
0>c4Z`3/a:/08`3/a:/00ol00000k<B[o`0000040>c4Z`Go00000P3/a:/00ol00000k<B[0>c4Z`06
0>c4Z`03o`000?oooooooooo043ooooo000gooooo`03o`00003/a:/0k<B[0080k<B[00?o0000oooo
ooooool01Oooool00ol00000k<B[0>c4Z`0;0>c4Z`;o000000<0k<B[o`00003/a:/09@3/a:/7o`00
00L0k<B[00?o00000>c4Z`3/a:/01P3/a:/00ol0003oooooooooo`10ooooo`00=oooool01Ol00000
k<B[0>c4Z`3/a:_o000000Sooooo00?o00000>c4Z`3/a:/0303/a:/2o`0002L0k<B[0_l0000=0>c4
Z`03o`00003/a:/0k<B[00D0k<B[00?o0000ooooooooool0@?ooool003Kooooo00Go00000>c4Z`3/
a:/0k<B[o`000008ooooo`03o`00003/a:/0k<B[00h0k<B[00?o00000>c4Z`3/a:/09@3/a:/00ol0
0000k<B[0>c4Z`0<0>c4Z`03o`00003/a:/0k<B[00H0k<B[00?o0000ooooooooool0?oooool003Ko
oooo00Co00000>c4Z`3/a:_o00002Oooool00ol00000k<B[0>c4Z`0?0>c4Z`03o`00003/a:/0k<B[
02<0k<B[00?o00000>c4Z`3/a:/03@3/a:/00ol00000k<B[0>c4Z`060>c4Z`03o`000?oooooooooo
03oooooo000fooooo`03o`00003/a:_o000000Wooooo00?o00000>c4Z`3/a:/04@3/a:/2o`0002<0
k<B[00?o00000>c4Z`3/a:/03P3/a:/00ol00000k<B[0>c4Z`050>c4Z`03o`000?oooooooooo03oo
oooo000fooooo`;o00002_ooool00ol00000k<B[0>c4Z`0A0>c4Z`04o`000?oooooo0000o`000200
k<B[00?o00000>c4Z`3/a:/03`3/a:/00ol00000k<B[0>c4Z`040>c4Z`03o`00003/a:_o0000043o
oooo000fooooo`03o`000?oooooooooo00Wooooo00?o00000>c4Z`3/a:/04@3/a:/01?l0003ooooo
ooooooooool2o`0001d0k<B[00?o00000>c4Z`3/a:/0403/a:/00ol00000k<B[0>c4Z`030>c4Z`04
o`00003/a:/0k<B[o`00043ooooo0011ooooo`03o`00003/a:/0k<B[0180k<B[00?o0000oooooooo
ool00oooool2o`0001/0k<B[00?o00000>c4Z`3/a:/0403/a:/2o`0000<0k<B[00Go00000>c4Z`3/
a:/0k<B[o`000010ooooo`00@Oooool00ol00000k<B[0>c4Z`0B0>c4Z`03o`000?oooooooooo00Go
oooo0_l0000H0>c4Z`03o`00003/a:/0k<B[0180k<B[00Go00000>c4Z`3/a:/0k<B[o`0000040>c4
Z`03o`000?oooooooooo03gooooo0010ooooo`03o`00003/a:/0k<B[01<0k<B[00?o0000oooooooo
ool01oooool2o`0001H0k<B[00?o00000>c4Z`3/a:/04P3/a:/01?l00000k<B[0>c4Zol000050>c4
Z`03o`000?oooooooooo03gooooo0010ooooo`03o`00003/a:/0k<B[01<0k<B[00?o0000oooooooo
ool02Oooool2o`0001<0k<B[00?o00000>c4Z`3/a:/04`3/a:/3o`0000L0k<B[00?o0000oooooooo
ool0??ooool0043ooooo00?o00000>c4Z`3/a:/04`3/a:/00ol0003oooooooooo`0;ooooo`;o0000
403/a:/00ol00000k<B[0>c4Z`0E0>c4Z`03o`00003/a:/0k<B[00H0k<B[00?o0000ooooooooool0
??ooool003oooooo00?o00000>c4Z`3/a:/0503/a:/00ol0003oooooooooo`0=ooooo`;o00003P3/
a:/00ol00000k<B[0>c4Z`0C0>c4Z`?o0000203/a:/00ol0003oooooooooo`0looooo`00?oooool0
0ol00000k<B[0>c4Z`0D0>c4Z`03o`000?oooooooooo00oooooo0_l0000;0>c4Z`03o`00003/a:/0
k<B[00l0k<B[1Ol000020>c4Z`;o0000203/a:/00ol0003oooooooooo`0kooooo`00?_ooool00ol0
0000k<B[0>c4Z`0E0>c4Z`03o`000?oooooooooo017ooooo0_l000090>c4Z`03o`00003/a:/0k<B[
00X0k<B[1Ol000070>c4Z`;o0000203/a:/00ol0003oooooooooo`0kooooo`00?_ooool00ol00000
k<B[0>c4Z`0E0>c4Z`03o`000?oooooooooo01?ooooo0_l000060>c4Z`03o`00003/a:/0k<B[00L0
k<B[1?l0000<0>c4Z`;o00001`3/a:/00ol0003oooooooooo`0looooo`00?_ooool00ol00000k<B[
0>c4Z`0E0>c4Z`03o`000?oooooooooo01Gooooo0_l000030>c4Z`03o`00003/a:/0k<B[00<0k<B[
1Ol0000A0>c4Z`;o00001@3/a:/00ol0003oooooooooo`0mooooo`00?Oooool2o`0001L0k<B[00?o
0000ooooooooool05oooool2o`0000030>c4Zol0003o000000Co00005P3/a:/2o`0000@0k<B[00?o
0000ooooooooool0?_ooool003oooooo00?o00000>c4Z`3/a:/0503/a:/00ol0003oooooooooo`0H
ooooo`?o00006`3/a:/00ol0003oooooo`0000030>c4Z`03o`000?oooooooooo03kooooo0010oooo
o`03o`00003/a:/0k<B[01<0k<B[00?o0000ooooooooool05Oooool3o`0000030>c4Zol00000k<B[
01/0k<B[00?o0000ooooool000000P3/a:/00ol0003oooooooooo`0oooooo`00@Oooool00ol00000
k<B[0>c4Z`0B0>c4Z`03o`000?oooooooooo01;ooooo0ol000040>c4Z`03o`00003/a:/0k<B[01X0
k<B[00Go0000ooooool00000k<B[o`000012ooooo`00@_ooool00ol00000k<B[0>c4Z`0A0>c4Z`03
o`000?oooooooooo00oooooo0ol000060>c4Z`03o`00003/a:_o000001`0k<B[00?o0000ooooool0
0000@oooool004?ooooo00?o00000>c4Z`3/a:/0403/a:/00ol0003oooooooooo`0<ooooo`?o0000
2@3/a:/00ol00000k<B[o`00000L0>c4Z`03o`000?oooooooooo04?ooooo0014ooooo`03o`00003/
a:/0k<B[00l0k<B[00?o0000ooooooooool02Oooool3o`0000`0k<B[00?o00000>c4Zol00000703/
a:/00ol0003oooooooooo`13ooooo`00AOooool00ol00000k<B[0>c4Z`0?0>c4Z`03o`000?oooooo
oooo00Gooooo0ol0000>0>c4Z`04o`00003/a:/0k<B[o`0001X0k<B[00?o0000ooooooooool0AOoo
ool004Kooooo00?o00000>c4Z`3/a:/03P3/a:/00ol0003oooooooooo`02ooooo`?o00004@3/a:/0
1Ol00000k<B[0>c4Z`3/a:_o000001P0k<B[00?o0000ooooooooool0A_ooool004Oooooo00?o0000
0>c4Z`3/a:/03@3/a:/00ol0003oooooo`000002o`0001@0k<B[00Go00000>c4Z`3/a:/0k<B[o`00
000G0>c4Z`03o`000?oooooooooo04Oooooo0018ooooo`03o`00003/a:/0k<B[00`0k<B[0_l0000F
0>c4Z`03o`00003/a:/0k<B[0080k<B[00?o00000>c4Z`3/a:/04`3/a:/2o`0000Cooooo1?l00012
ooooo`00BOooool00ol00000k<B[0>c4Z`0;0>c4Z`03o`00003/a:/0k<B[01D0k<B[00?o00000>c4
Z`3/a:/00P3/a:/00ol00000k<B[0>c4Z`0B0>c4Z`03o`000?oooooooooo00;ooooo0_l000040>c4
Z`?o0000?oooool004[ooooo00?o00000>c4Z`3/a:/02P3/a:/00ol00000k<B[0>c4Z`0E0>c4Z`03
o`00003/a:/0k<B[00<0k<B[00?o00000>c4Z`3/a:/0403/a:/00ol0003oooooooooo`02ooooo`03
o`00003/a:/0k<B[00L0k<B[00?o0000ooooooooool0??ooool004_ooooo00?o00000>c4Z`3/a:/0
2@3/a:/00ol00000k<B[0>c4Z`0D0>c4Z`03o`00003/a:/0k<B[00@0k<B[00?o00000>c4Z`3/a:/0
3`3/a:/01?l0003oooooooooooooool2o`0000X0k<B[00?o0000ooooooooool0??ooool004cooooo
00?o00000>c4Z`3/a:/0203/a:/00ol00000k<B[0>c4Z`0D0>c4Z`03o`00003/a:/0k<B[00@0k<B[
00?o00000>c4Z`3/a:/03@3/a:/2o`0000;ooooo0_l0000<0>c4Z`03o`000?oooooooooo03cooooo
001=ooooo`03o`00003/a:/0k<B[00L0k<B[00?o00000>c4Z`3/a:/0503/a:/00ol00000k<B[0>c4
Z`040>c4Z`03o`00003/a:/0k<B[00`0k<B[00Go0000ooooooooooooooooo`00000>0>c4Z`03o`00
0?oooooooooo03cooooo001>ooooo`03o`00003/a:/0k<B[00H0k<B[00?o00000>c4Z`3/a:/0503/
a:/00ol00000k<B[0>c4Z`050>c4Z`03o`00003/a:/0k<B[00X0k<B[00?o0000ooooooooool00_l0
000?0>c4Z`03o`000?oooooooooo03cooooo001?ooooo`03o`00003/a:/0k<B[00D0k<B[00?o0000
0>c4Z`3/a:/04`3/a:/00ol00000k<B[0>c4Z`060>c4Z`03o`00003/a:/0k<B[00P0k<B[0_l00000
0ooooooo0000o`00000@0>c4Z`03o`000?oooooooooo03gooooo001@ooooo`03o`00003/a:/0k<B[
00@0k<B[00?o00000>c4Z`3/a:/04`3/a:/00ol00000k<B[0>c4Z`060>c4Z`03o`00003/a:/0k<B[
00L0k<B[00Co0000oooooooooooo00004P3/a:/00ol0003oooooooooo`0mooooo`00DOooool00ol0
0000k<B[0>c4Z`030>c4Z`03o`00003/a:/0k<B[01<0k<B[00?o00000>c4Z`3/a:/01P3/a:/00ol0
0000k<B[0>c4Z`060>c4Z`04o`000?oooooo0000o`0001<0k<B[00?o0000ooooooooool0?Oooool0
05;ooooo00?o00000>c4Z`3/a:/00P3/a:/00ol00000k<B[0>c4Z`0B0>c4Z`03o`00003/a:/0k<B[
00P0k<B[00?o00000>c4Z`3/a:/0103/a:/3o`0001D0k<B[00?o0000ooooooooool0?Oooool005?o
oooo00Co00000>c4Z`3/a:/0k<B[0_l0000C0>c4Z`03o`00003/a:/0k<B[00P0k<B[00?o00000>c4
Z`3/a:/00P3/a:/3o`0001L0k<B[00?o0000ooooooooool0?Oooool005Cooooo00?o00000>c4Z`3/
a:/00_l0000C0>c4Z`03o`00003/a:/0k<B[00P0k<B[00Co00000>c4Z`3/a:/0k<B[0ol0000H0>c4
Z`03o`000?oooooooooo03gooooo001Eooooo`05o`00003/a:_o0000ooooool000004@3/a:/00ol0
0000k<B[0>c4Z`090>c4Z`03o`00003/a:/0k<B[00;o00006P3/a:/00ol0003oooooooooo`0moooo
o`00E_ooool2o`000003ooooool00000k<B[0100k<B[00?o00000>c4Z`3/a:/02P3/a:/2o`0001`0
k<B[00?o0000ooooooooool0?Oooool005Oooooo00?o0000ooooool000004@3/a:/00ol00000k<B[
0>c4Z`0:0>c4Z`03o`00003/a:/0k<B[01/0k<B[00?o0000ooooooooool0?Oooool005[ooooo00?o
00000>c4Z`3/a:/03P3/a:/00ol00000k<B[0>c4Z`0W0>c4Z`03o`000?oooooooooo03kooooo001J
ooooo`03o`00003/a:/0k<B[00d0k<B[00?o00000>c4Z`3/a:/0:03/a:/00ol0003oooooooooo`0n
ooooo`00Foooool00ol00000k<B[0>c4Z`0<0>c4Z`03o`00003/a:/0k<B[00L0k<B[00?o00000>c4
Z`3/a:/07P3/a:/00ol0003oooooooooo`0nooooo`00Foooool00ol00000k<B[0>c4Z`0<0>c4Z`03
o`00003/a:/0k<B[02P0k<B[00?o0000ooooooooool0?_ooool005_ooooo00?o00000>c4Z`3/a:/0
2`3/a:/00ol00000k<B[0>c4Z`0Y0>c4Z`03o`000?oooooooooo03kooooo001Looooo`03o`00003/
a:/0k<B[00X0k<B[00?o00000>c4Z`3/a:/0103/a:/00ol00000k<B[0>c4Z`0R0>c4Z`03o`000?oo
oooooooo03kooooo001Looooo`03o`00003/a:/0k<B[00X0k<B[00?o00000>c4Z`3/a:/0:@3/a:/0
0ol0003oooooooooo`0nooooo`00GOooool00ol00000k<B[0>c4Z`080>c4Z`03o`00003/a:/0k<B[
0080k<B[00?o00000>c4Z`3/a:/09@3/a:/00ol0003oooooooooo`0nooooo`00GOooool00ol00000
k<B[0>c4Z`080>c4Z`05o`00003/a:/0k<B[0>c4Zol00000:03/a:/00ol0003oooooooooo`0noooo
o`00GOooool00ol00000k<B[0>c4Z`080>c4Z`04o`00003/a:/0k<B[o`0002P0k<B[00?o0000oooo
ooooool0?oooool005kooooo00?o00000>c4Z`3/a:/01P3/a:/00ol00000k<B[o`00000Z0>c4Z`03
o`000?oooooooooo03oooooo001Nooooo`03o`00003/a:/0k<B[00H0k<B[0_l0000[0>c4Z`03o`00
0?oooooooooo03oooooo001Oooooo`03o`00003/a:/0k<B[00D0k<B[00?o00000>c4Z`3/a:/0:P3/
a:/00ol0003oooooooooo`0oooooo`00Goooool00ol00000k<B[0>c4Z`040>c4Z`;o0000;03/a:/0
0ol0003oooooooooo`0oooooo`00Goooool01?l00000k<B[0>c4Z`3/a:/4o`0002d0k<B[00?o0000
ooooooooool0?oooool0063ooooo0ol00003ooooo`03o`00003/a:/0k<B[02/0k<B[00?o0000oooo
ooooool0?oooool006Kooooo00?o00000>c4Z`3/a:/0:`3/a:/00ol0003oooooooooo`0oooooo`00
I_ooool00ol00000k<B[0>c4Z`0Z0>c4Z`03o`000?oooooooooo043ooooo001Uooooo`03o`00003/
a:/0k<B[02/0k<B[00?o0000ooooooooool0@?ooool006Gooooo00?o00000>c4Z`3/a:/0:`3/a:/0
0ol0003oooooooooo`10ooooo`00IOooool00ol00000k<B[0>c4Z`0[0>c4Z`03o`000?oooooooooo
043ooooo001Tooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@?ooool006Cooooo
00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`10ooooo`00I?ooool00ol00000k<B[0>c4
Z`0/0>c4Z`03o`000?oooooooooo043ooooo001Tooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000
ooooooooool0@?ooool006Cooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`10oooo
o`00I?ooool00ol00000k<B[0>c4Z`0[0>c4Z`03o`000?oooooooooo047ooooo001Sooooo`03o`00
003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@Oooool006?ooooo00?o00000>c4Z`3/a:/0;03/
a:/00ol0003oooooooooo`11ooooo`00Hoooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooo
oooo047ooooo001Sooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@Oooool006?o
oooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`11ooooo`00Hoooool00ol00000k<B[
0>c4Z`0/0>c4Z`03o`000?oooooooooo047ooooo001Sooooo`03o`00003/a:/0k<B[02`0k<B[00?o
0000ooooooooool0@Oooool006?ooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`11
ooooo`00H_ooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04;ooooo001Rooooo`03
o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@_ooool006;ooooo00?o00000>c4Z`3/a:/0
;03/a:/00ol0003oooooooooo`12ooooo`00H_ooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oo
oooooooo04;ooooo001Rooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@_ooool0
06;ooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`12ooooo`00H_ooool00ol00000
k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04;ooooo001Rooooo`03o`00003/a:/0k<B[02`0k<B[
00?o0000ooooooooool0@_ooool0067ooooo00?o00000>c4Z`3/a:/0;@3/a:/00ol0003ooooooooo
o`12ooooo`00HOooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04?ooooo001Qoooo
o`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@oooool0067ooooo00?o00000>c4Z`3/
a:/0;03/a:/00ol0003oooooooooo`13ooooo`00HOooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`00
0?oooooooooo04?ooooo001Qooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0@ooo
ool0067ooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`13ooooo`00HOooool00ol0
0000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04?ooooo001Qooooo`03o`00003/a:/0k<B[02`0
k<B[00?o0000ooooooooool0@oooool0063ooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003ooooo
ooooo`14ooooo`00H?ooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04Cooooo001P
ooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0A?ooool0063ooooo00?o00000>c4
Z`3/a:/0;03/a:/00ol0003oooooooooo`14ooooo`00H?ooool00ol00000k<B[0>c4Z`0/0>c4Z`03
o`000?oooooooooo04Cooooo001Pooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0
A?ooool0063ooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`14ooooo`00H?ooool0
0ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04Cooooo001Oooooo`03o`00003/a:/0k<B[
02d0k<B[00?o0000ooooooooool0A?ooool005oooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003o
ooooooooo`15ooooo`00Goooool00ol00000k<B[0>c4Z`0/0>c4Z`03o`000?oooooooooo04Gooooo
001Oooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000ooooooooool0AOooool005oooooo00?o0000
0>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`15ooooo`00Goooool00ol00000k<B[0>c4Z`0/0>c4
Z`03o`000?oooooooooo04Gooooo001Oooooo`03o`00003/a:/0k<B[02`0k<B[00?o0000oooooooo
ool0AOooool005oooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0003oooooooooo`15ooooo`00G_oo
ool00ol00000k<B[0>c4Z`0]0>c4Z`03o`000?oooooooooo04Gooooo001Nooooo`03o`00003/a:/0
k<B[02d0k<B[00?o0000ooooooooool0AOooool005kooooo00?o00000>c4Z`3/a:/0;03/a:/00ol0
003oooooooooo`16ooooo`00G_ooool=o`000280k<B[00?o0000ooooooooool0A_ooool006_ooooo
5ol0000;0>c4Z`03o`000?oooooooooo04Kooooo0022ooooo`co0000B?ooool00=Kooooo003Foooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003F
ooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo
003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Ko
oooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`00e_ooool0
0001\
\>"],
  ImageRangeCache->{{{0, 213.812}, {330.25, 0}} -> {0.161918, -0.0007081, \
0.00290121, 0.00290121}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .87294 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1 -0.0635293 1 [
[ 0 0 0 0 ]
[ 1 .87294 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .87294 L
0 .87294 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.50131 .02078 m .36755 .1504 L .45876 .24454 L p .707 .577 .707 r
F P
0 g
s
.73559 .26256 m .50131 .02078 L p .45876 .24454 L .707 .577 .707 r
F P
0 g
s
.70124 .29584 m .73559 .26256 L p .45876 .24454 L .707 .577 .707 r
F P
0 g
s
.6488 .32104 m .70124 .29584 L p .45876 .24454 L .707 .577 .707 r
F P
0 g
s
.60417 .31288 m .6488 .32104 L p .45876 .24454 L .707 .577 .707 r
F P
0 g
s
.64611 .33017 m .6999 .35234 L .68167 .39656 L p .707 .577 .707 r
F P
0 g
s
.74412 .37057 m .72589 .41479 L .68167 .39656 L p .707 .577 .707 r
F P
0 g
s
.68167 .39656 m .6999 .35234 L .74412 .37057 L p .707 .577 .707 r
F P
0 g
s
.64611 .33017 m .60417 .31288 L .55579 .43023 L p .707 .577 .707 r
F P
0 g
s
.55579 .43023 m .62788 .37439 L .64611 .33017 L p .707 .577 .707 r
F P
0 g
s
.68167 .39656 m .62788 .37439 L .64611 .33017 L p .707 .577 .707 r
F P
0 g
s
.47874 .27012 m .45483 .25131 L .48189 .26246 L closepath p .707 .577 .707 r
F P
0 g
s
.45876 .24454 m .48189 .26246 L .60417 .31288 L p .707 .577 .707 r
F P
0 g
s
.08968 .37528 m .25623 .29186 L .27441 .55281 L p .707 .577 .707 r
F P
0 g
s
.73168 .44075 m .62029 .56718 L .55811 .65459 L p .707 .577 .707 r
F P
0 g
s
.7755 .42159 m .73168 .44075 L p .55811 .65459 L .707 .577 .707 r
F P
0 g
s
.91032 .73008 m .7755 .42159 L p .55811 .65459 L .707 .577 .707 r
F P
0 g
s
.53985 .50995 m .679 .40216 L .62788 .37439 L p .707 .577 .707 r
F P
0 g
s
.71798 .42989 m .62029 .56718 L .53985 .50995 L p .707 .577 .707 r
F P
0 g
s
.53985 .50995 m .679 .40216 L .71798 .42989 L p .707 .577 .707 r
F P
0 g
s
.36524 .5566 m .35317 .55275 L .40548 .29117 L p .707 .577 .707 r
F P
0 g
s
.53985 .50995 m .36524 .5566 L p .40548 .29117 L .707 .577 .707 r
F P
0 g
s
.55579 .43023 m .53985 .50995 L p .40548 .29117 L .707 .577 .707 r
F P
0 g
s
.40548 .29117 m .43447 .30041 L .55579 .43023 L p .707 .577 .707 r
F P
0 g
s
.60417 .31288 m .48189 .26246 L .47874 .27012 L p .707 .577 .707 r
F P
0 g
s
.47874 .27012 m .55579 .43023 L .60417 .31288 L p .707 .577 .707 r
F P
0 g
s
.27441 .29117 m .40548 .29117 L .35317 .55275 L p .707 .577 .707 r
F P
0 g
s
.35317 .55275 m .27441 .55275 L .27441 .29117 L p .707 .577 .707 r
F P
0 g
s
.22622 .64786 m .08968 .37528 L p .27441 .55281 L .707 .577 .707 r
F P
0 g
s
.63097 .85216 m .91032 .73008 L p .55811 .65459 L .707 .577 .707 r
F P
0 g
s
.62788 .37439 m .55579 .43023 L .53985 .50995 L p .707 .577 .707 r
F P
0 g
s
.35317 .55275 m .36524 .5566 L .27441 .55666 L p .707 .577 .707 r
F P
0 g
s
.40421 .62939 m .53985 .50995 L .55261 .65068 L p .707 .577 .707 r
F P
0 g
s
.52746 .67934 m .40421 .62939 L p .55261 .65068 L .707 .577 .707 r
F P
0 g
s
.55261 .65068 m .54962 .66376 L .52746 .67934 L p .707 .577 .707 r
F P
0 g
s
.27449 .65981 m .44925 .65969 L .36524 .5566 L p .707 .577 .707 r
F P
0 g
s
.36524 .5566 m .27441 .55666 L .27449 .65981 L p .707 .577 .707 r
F P
0 g
s
.55261 .65068 m .55139 .66404 L .55811 .65459 L closepath p .707 .577 .707 r
F P
0 g
s
.62029 .56718 m .55811 .65459 L .55261 .65068 L p .707 .577 .707 r
F P
0 g
s
.55261 .65068 m .53985 .50995 L .62029 .56718 L p .707 .577 .707 r
F P
0 g
s
.56098 .69201 m .63097 .85216 L p .55811 .65459 L .707 .577 .707 r
F P
0 g
s
.55811 .65459 m .55467 .66566 L .56098 .69201 L p .707 .577 .707 r
F P
0 g
s
.27441 .55666 m .27441 .55281 L .35317 .55275 L p .707 .577 .707 r
F P
0 g
s
.27441 .55281 m .27441 .55666 L .22622 .64786 L p .707 .577 .707 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{214.688, 187.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000^b000`400?l00000o`00003oeP3oool0
0=H0oooo003F0?ooo`00eP3oool006X0oooo0_l0001Z0?ooo`00J@3oool00ol00000]9>do`00001Z
0?ooo`00J03oool01Ol00000]9>d0;BC]02dTkCo000006T0oooo001W0?ooo`03o`00002dTk@0]9>d
00<0]9>d00?o00000?ooo`3oool0IP3oool006H0oooo00?o00000;BC]02dTk@01@2dTk@00ol00000
oooo0?ooo`1U0?ooo`00I@3oool00ol00000]9>d0;BC]0070;BC]003o`00003oool0oooo06@0oooo
001T0?ooo`03o`00002dTk@0]9>d00T0]9>d00?o00000?ooo`3oool0H`3oool006<0oooo00?o0000
0;BC]02dTk@02`2dTk@00ol00000oooo0?ooo`1R0?ooo`00HP3oool00ol00000]9>d0;BC]00=0;BC
]003o`00003oool0oooo0640oooo001Q0?ooo`03o`00002dTk@0]9>d00l0]9>d00?o00000?ooo`3o
ool0H03oool00600oooo00?o00000;BC]02dTk@04@2dTk@00ol00000oooo0?ooo`1O0?ooo`00G`3o
ool00ol00000]9>d0;BC]00C0;BC]003o`00003oool0oooo05h0oooo001N0?ooo`03o`00002dTk@0
]9>d01D0]9>d00?o00000?ooo`3oool0G@3oool005d0oooo00?o00000;BC]02dTk@05`2dTk@00ol0
0000oooo0?ooo`1L0?ooo`00G03oool00ol00000]9>d0;BC]00I0;BC]003o`00003oool0oooo05/0
oooo001K0?ooo`03o`00002dTk@0]9>d01/0]9>d00?o00000?ooo`3oool0FP3oool005X0oooo00?o
00000;BC]02dTk@07@2dTk@00ol00000oooo0?ooo`1I0?ooo`00F@3oool00ol00000]9>d0;BC]00O
0;BC]003o`00003oool0oooo05P0oooo001H0?ooo`03o`00002dTk@0]9>d0240]9>d00?o00000?oo
o`3oool0E`3oool005L0oooo00?o00000;BC]02dTk@08`2dTk@00ol00000oooo0?ooo`1F0?ooo`00
EP3oool00ol00000]9>d0;BC]00U0;BC]003o`00003oool0oooo05D0oooo001E0?ooo`03o`00002d
Tk@0]9>d02L0]9>d00?o00000?ooo`3oool0E03oool005@0oooo00?o00000;BC]02dTk@0:@2dTk@0
0ol00000oooo0?ooo`1C0?ooo`00D`3oool00ol00000]9>d0;BC]00[0;BC]003o`00003oool0oooo
0580oooo001B0?ooo`03o`00002dTk@0]9>d02d0]9>d00?o00000?ooo`3oool0D@3oool00540oooo
00?o00000;BC]02dTk@0;`2dTk@00ol00000oooo0?ooo`1@0?ooo`00D03oool00ol00000]9>d0;BC
]00a0;BC]003o`00003oool0oooo04l0oooo001?0?ooo`03o`00002dTk@0]9>d0380]9>d00?o0000
0?ooo`3oool0C`3oool004h0oooo00?o00000;BC]02dTk@0=02dTk@00ol00000oooo0?ooo`1>0?oo
o`00C`3oool00ol00000]9>d0;BC]00d0;BC]003o`00003oool0oooo04d0oooo001@0?ooo`03o`00
002dTk@0]9>d03@0]9>d00?o00000?ooo`3oool0C03oool00540oooo00?o00000;BC]02dTk@0=02d
Tk@00ol00000oooo0?ooo`1;0?ooo`00DP3oool00ol00000]9>d0;BC]00d0;BC]003o`00003oool0
oooo04X0oooo001C0?ooo`03o`00002dTk@0]9>d03@0]9>d00?o00000?ooo`3oool0B@3oool005@0
oooo00?o00000;BC]02dTk@0=02dTk@00ol00000oooo0?ooo`180?ooo`00E@3oool00ol00000]9>d
0;BC]00d0;BC]003o`00003oool0oooo04L0oooo001F0?ooo`03o`00002dTk@0]9>d03@0]9>d00?o
00000?ooo`3oool0AP3oool005L0oooo00?o00000;BC]02dTk@0=02dTk@00ol00000oooo0?ooo`15
0?ooo`00F03oool00ol00000]9>d0;BC]00d0;BC]003o`00003oool0oooo04@0oooo001I0?ooo`03
o`00002dTk@0]9>d03@0]9>d00?o00000?ooo`3oool0@`3oool005X0oooo00?o00000;BC]02dTk@0
=02dTk@00ol00000oooo0?ooo`120?ooo`00F`3oool00ol00000]9>d0;BC]00d0;BC]003o`00003o
ool0oooo0440oooo001L0?ooo`03o`00002dTk@0]9>d03@0]9>d00?o00000?ooo`3oool0@03oool0
05d0oooo00?o00000;BC]02dTk@0=02dTk@00ol00000oooo0?ooo`0o0?ooo`00GP3oool00ol00000
]9>d0;BC]00d0;BC]003o`00003oool0oooo03h0oooo001O0?ooo`03o`00002dTk@0]9>d03@0]9>d
00?o00000?ooo`3oool0?@3oool00600oooo00?o00000;BC]02dTk@0=02dTk@00ol00000oooo0?oo
o`0l0?ooo`00H@3oool00ol00000]9>d0;BC]00d0;BC]003o`00003oool0oooo03/0oooo001R0?oo
o`03o`00002dTk@0]9>d03@0]9>d00?o00000?ooo`3oool0>P3oool006<0oooo00?o00000;BC]02d
Tk@0=02dTk@00ol00000oooo0?ooo`0i0?ooo`00H@3oool2o`0000030?ooool00000]9>d03D0]9>d
00?o00000?ooo`3oool0>03oool006<0oooo0ol0000f0;BC]003o`00003oool0oooo03L0oooo001T
0?ooo`04o`00002dTkCo0000o`0003@0]9>d0_l0000h0?ooo`00I@3oool2o`0000040;BC]?l0003o
0000o`000300]9>d00?o00000?ooo`3oool0>03oool006H0oooo00?o00000;BC]02dTk@00P2dTk@2
o`0002d0]9>d00?o00000?ooo`3oool0>@3oool006H0oooo00?o00000;BC]02dTk@0102dTk@3o`00
02T0]9>d00?o00000?ooo`3oool0>P3oool006L0oooo00?o00000;BC]02dTk@01P2dTk@2o`0002H0
]9>d00?o00000?ooo`3oool0>`3oool006L0oooo00?o00000;BC]02dTk@0202dTk@3o`000280]9>d
00?o00000?ooo`3oool0?03oool003D0oooo0_l000030?oooaoo00003`3oool00ol00000]9>d0;BC
]00:0;BC]0;o00007`2dTk@00ol00000oooo0?ooo`0m0?ooo`00<`3oool2o`0000030;BC]?l00000
oooo0080oooo00?o00000;BC]02dTk@06@2dTk@00ol00000]9>d0;BC]003o`0000`0oooo00?o0000
0;BC]02dTk@0302dTk@2o`0001/0]9>d0_l000100?ooo`00<@3oool2o`0000<0]9>d00Go00000?oo
o`3oool0ooooo`00000K0;BC]003o`00002dTk@0]9>d00<0]9>d00?o00000?ooo`3oool02P3oool0
0ol00000]9>d0;BC]00=0;BC]0?o00005P2dTk@2o`000480oooo000_0?ooo`;o00001@2dTk@01Ol0
0000oooo0?ooo`3ooooo000001/0]9>d00?o00000;BC]02dTk@00`2dTk@00ol00000oooo0?ooo`0:
0?ooo`03o`00002dTk@0]9>d0100]9>d0_l0000B0;BC]0;o0000A03oool002d0oooo0_l000070;BC
]005o`00003oool0oooo0?ooool000006P2dTk@00ol00000]9>d0;BC]0050;BC]003o`00003oool0
oooo00X0oooo00?o00000;BC]02dTk@04@2dTk@3o`0000h0]9>d00?o00000?ooo`3oool0A03oool0
02/0oooo0_l000090;BC]005o`00003oool0oooo0?ooool000006P2dTk@00ol00000]9>d0;BC]006
0;BC]003o`00003oool0oooo00T0oooo00?o00000;BC]02dTk@0502dTk@3o`0000T0]9>d0_l00017
0?ooo`00:@3oool2o`0000/0]9>d00Go00000?ooo`3oool0ooooo`00000J0;BC]003o`00002dTk@0
]9>d00L0]9>d00?o00000?ooo`3oool0203oool00ol00000]9>d0;BC]00D0;BC]003o`00002dTkCo
000000Go00000P2dTk@2o`0004T0oooo000W0?ooo`;o00003@2dTk@01Ol00000oooo0?ooo`3ooooo
000001X0]9>d00?o00000;BC]02dTk@0202dTk@00ol00000oooo0?ooo`080?ooo`03o`00002dTk@0
]9>d0180]9>d00?o00000;BC]02dTk@00P2dTk@3o`0000030?ooool0003o000004/0oooo000U0?oo
o`;o0000402dTk@01?l00000oooo0?ooool0000J0;BC]003o`00002dTk@0]9>d00T0]9>d00?o0000
0?ooo`3oool01`3oool00ol00000]9>d0;BC]00B0;BC]003o`00002dTk@0]9>d00D0]9>d0_l0001<
0?ooo`00903oool00ol00000]9>d0;BC]00@0;BC]004o`00003oool0ooooo`0001T0]9>d00?o0000
0;BC]02dTk@02`2dTk@00ol00000oooo0?ooo`070?ooo`03o`00002dTk@0]9>d0100]9>d00?o0000
0;BC]02dTk@0202dTk@2o`0004X0oooo000R0?ooo`;o00004`2dTk@01?l00000oooo0?ooool0000I
0;BC]003o`00002dTk@0]9>d00`0]9>d00?o00000?ooo`3oool01P3oool00ol00000]9>d0;BC]00@
0;BC]003o`00002dTk@0]9>d00P0]9>d00?o00000;BC]?l000000_l000170?ooo`00803oool2o`00
01D0]9>d00Co00000?ooo`3ooooo00006@2dTk@00ol00000]9>d0;BC]00=0;BC]003o`00003oool0
oooo00H0oooo00?o00000;BC]02dTk@03`2dTk@00ol00000]9>d0;BC]0070;BC]003o`00002dTk@0
]9>d00<0]9>d0ol000140?ooo`007P3oool2o`0001L0]9>d00Co00000?ooo`3ooooo00006@2dTk@0
0ol00000]9>d0;BC]00>0;BC]003o`00003oool0oooo00D0oooo00?o00000;BC]02dTk@03P2dTk@0
0ol00000]9>d0;BC]0080;BC]003o`00002dTk@0]9>d00H0]9>d0ol000110?ooo`00703oool2o`00
01T0]9>d00Co00000?ooo`3ooooo00006@2dTk@00ol00000]9>d0;BC]00?0;BC]003o`00003oool0
oooo00D0oooo00?o00000;BC]02dTk@03@2dTk@00ol00000]9>d0;BC]0070;BC]003o`00002dTk@0
]9>d00X0]9>d0_l0000o0?ooo`006P3oool2o`0001/0]9>d00Co00000?ooo`3ooooo0000602dTk@0
0ol00000]9>d0;BC]00A0;BC]003o`00003oool0oooo00@0oooo00?o00000;BC]02dTk@0302dTk@0
0ol00000]9>d0;BC]0080;BC]003o`00002dTk@0]9>d00X0]9>d00Co00000;BC]?l0003o0000?@3o
ool001P0oooo0_l0000M0;BC]004o`00003oool0ooooo`0001P0]9>d00?o00000;BC]02dTk@04P2d
Tk@00ol00000oooo0?ooo`040?ooo`03o`00002dTk@0]9>d00/0]9>d00?o00000;BC]02dTk@0202d
Tk@00ol00000]9>d0;BC]0090;BC]003o`00002dTk@0]9>d0080]9>d0ol0000j0?ooo`005P3oool2
o`0001l0]9>d00Co00000?ooo`3ooooo0000602dTk@00ol00000]9>d0;BC]00C0;BC]003o`00003o
ool0oooo00<0oooo00?o00000;BC]02dTk@02P2dTk@00ol00000]9>d0;BC]0080;BC]003o`00002d
Tk@0]9>d00X0]9>d00?o00000;BC]02dTk@01@2dTk@2o`0003P0oooo000D0?ooo`;o00008@2dTk@0
1?l00000oooo0?ooool0000H0;BC]003o`00002dTk@0]9>d01<0]9>d00?o00000?ooo`3oool0103o
ool00ol00000]9>d0;BC]0090;BC]003o`00002dTk@0]9>d00P0]9>d00?o00000;BC]02dTk@02P2d
Tk@00ol00000]9>d0;BC]0070;BC]003o`00003oool0oooo03D0oooo000C0?ooo`03o`00002dTk@0
]9>d0240]9>d00Co00000?ooo`3ooooo0000602dTk@00ol00000]9>d0;BC]00D0;BC]003o`00003o
ool0oooo00<0oooo00?o00000;BC]02dTk@0202dTk@00ol00000]9>d0;BC]0070;BC]0?o00002`2d
Tk@00ol00000]9>d0;BC]0080;BC]003o`00003oool0oooo03D0oooo000C0?ooo`03o`00002dTk@0
]9>d0240]9>d00Co00000?ooo`3ooooo00005`2dTk@00ol00000]9>d0;BC]00F0;BC]003o`00003o
ool0oooo00<0oooo00?o00000;BC]02dTk@01`2dTk@00ol00000]9>d0;BC]0060;BC]004o`00002d
Tk@0]9>d0;BC]0;o00002@2dTk@00ol00000]9>d0;BC]0080;BC]003o`00003oool0oooo03D0oooo
000D0?ooo`03o`00002dTk@0]9>d0200]9>d00Co00000?ooo`3ooooo00005`2dTk@00ol00000]9>d
0;BC]00G0;BC]003o`00003oool0oooo0080oooo00?o00000;BC]02dTk@01`2dTk@00ol00000]9>d
0;BC]0050;BC]003o`00002dTk@0]9>d00@0]9>d0ol000050;BC]003o`00002dTk@0]9>d00P0]9>d
00?o00000?ooo`3oool0=P3oool001@0oooo00?o00000;BC]02dTk@0802dTk@01?l00000oooo0?oo
ool0000G0;BC]003o`00002dTk@0]9>d01P0]9>d00?o00000?ooo`3oool00P3oool00ol00000]9>d
0;BC]0050;BC]003o`00002dTk@0]9>d00@0]9>d0_l000090;BC]0?o00000`2dTk@00ol00000]9>d
0;BC]0080;BC]003o`00003oool0oooo03H0oooo000E0?ooo`03o`00002dTk@0]9>d0200]9>d00?o
00000?ooool000005`2dTk@00ol00000]9>d0;BC]00I0;BC]005o`00003oool0oooo0?ooool00000
1`2dTk@00ol00000]9>d0;BC]0030;BC]003o`00002dTk@0]9>d00X0]9>d1?l000000`2dTkCo0000
0;BC]0090;BC]003o`00003oool0oooo03H0oooo000E0?ooo`03o`00002dTk@0]9>d0200]9>d00?o
00000?ooool000005`2dTk@00ol00000]9>d0;BC]00J0;BC]004o`00003oool0ooooo`0000H0]9>d
00?o00000;BC]02dTk@00`2dTk@00ol00000]9>d0;BC]00=0;BC]0Co00002@2dTk@00ol00000oooo
0?ooo`0g0?ooo`005P3oool00ol00000]9>d0;BC]00O0;BC]003o`00003ooooo000001H0]9>d00?o
00000;BC]02dTk@0702dTk@01?l00000oooo0?ooool000050;BC]004o`00002dTk@0]9>d0;BC]0;o
00004@2dTk@6o`0000H0]9>d00?o00000?ooo`3oool0=`3oool001H0oooo00?o00000;BC]02dTk@0
7`2dTk@00ol00000ooooo`00000F0;BC]003o`00002dTk@0]9>d01d0]9>d00?o00000?ooool00000
102dTk@01Ol00000]9>d0;BC]02dTkCo00000180]9>d00Go00000;BC]02dTk@0]9>do`0000020?oo
o`;o0000102dTk@00ol00000oooo0?ooo`0g0?ooo`005`3oool00ol00000]9>d0;BC]00N0;BC]003
o`00003ooooo000001H0]9>d00?o00000;BC]02dTk@07P2dTk@00ol00000ooooo`0000030;BC]004
o`00002dTk@0]9>do`000180]9>d00?o00000;BC]02dTk@00`2dTk@01?l00000oooo0?ooo`3oool4
o`0003X0oooo000G0?ooo`03o`00002dTk@0]9>d01h0]9>d00?o00000?ooool000005P2dTk@00ol0
0000]9>d0;BC]00O0;BC]0;o00000`2dTk@3o`000140]9>d0_l000070;BC]0;o0000103oool00ol0
0000oooo0?ooo`0h0?ooo`00603oool00ol00000]9>d0;BC]00M0;BC]003o`00003ooooo000001H0
]9>d00?o00000;BC]02dTk@0802dTk@2o`0000030;BC]?l0003o00000180]9>d00?o00000;BC]02d
Tk@02@2dTk@00ol00000oooo0?ooo`0:0?ooo`;o0000<03oool001P0oooo00?o00000;BC]02dTk@0
7@2dTk@00ol00000ooooo`00000E0;BC]003o`00002dTk@0]9>d0280]9>d00?o00000;BC]?l00000
4P2dTk@00ol00000]9>d0;BC]00;0;BC]003o`00003oool0oooo00L0oooo0_l000000`2dTkCo0000
0?ooo`0_0?ooo`006@3oool00ol00000]9>d0;BC]00L0;BC]003o`00003ooooo000001D0]9>d00?o
00000;BC]02dTk@08`2dTk@00ol00000]9>d0;BC]00@0;BC]003o`00002dTk@0]9>d00d0]9>d00?o
00000?ooo`3oool00`3oool3o`0000@0]9>d00?o00000?ooo`3oool0;@3oool001T0oooo00?o0000
0;BC]02dTk@0702dTk@00ol00000ooooo`00000E0;BC]003o`00002dTk@0]9>d02<0]9>d00?o0000
0;BC]02dTk@03P2dTk@2o`000100]9>d00Co00000?ooo`3oool0oooo0_l000070;BC]003o`00003o
ool0oooo02d0oooo000J0?ooo`03o`00002dTk@0]9>d01/0]9>d00?o00000?ooool000005@2dTk@0
0ol00000]9>d0;BC]00S0;BC]003o`00002dTk@0]9>d00d0]9>d00?o00000;BC]02dTk@03`2dTk@0
1Ol00000oooo0?ooo`3ooooo000000X0]9>d00?o00000?ooo`3oool0;03oool001X0oooo00?o0000
0;BC]02dTk@06`2dTk@00ol00000ooooo`00000E0;BC]003o`00002dTk@0]9>d02<0]9>d00?o0000
0;BC]02dTk@0302dTk@00ol00000]9>d0;BC]00?0;BC]003o`00003oool0oooo0080oooo2`2dTk@0
0ol00000oooo0?ooo`0/0?ooo`006`3oool00ol00000]9>d0;BC]00J0;BC]003o`00003ooooo0000
01@0]9>d00?o00000;BC]02dTk@08`2dTk@00ol00000]9>d0;BC]00;0;BC]0;o00004@2dTk@00ol0
0000oooo0?ooo`020?ooo`03o`00002dTk@0]9>d00T0]9>d00?o00000?ooo`3oool0;03oool001/0
oooo00?o00000;BC]02dTk@06P2dTk@00ol00000ooooo`00000D0;BC]003o`00002dTk@0]9>d02<0
]9>d00?o00000;BC]02dTk@02P2dTk@00ol00000]9>d0;BC]00A0;BC]005o`00003oool0oooo0?oo
ool000003@2dTk@00ol00000oooo0?ooo`0[0?ooo`00703oool00ol00000]9>d0;BC]00J0;BC]0;o
0000502dTk@00ol00000]9>d0;BC]00S0;BC]003o`00002dTk@0]9>d00T0]9>d00?o00000;BC]02d
Tk@04@2dTk@01Ol00000oooo0?ooo`3ooooo000000h0]9>d00?o00000?ooo`3oool0:`3oool001`0
oooo00?o00000;BC]02dTk@06P2dTk@2o`0001@0]9>d00?o00000;BC]02dTk@08`2dTk@00ol00000
]9>d0;BC]0070;BC]0;o00004`2dTk@01Ol00000oooo0?ooo`3ooooo00000100]9>d00?o00000?oo
o`3oool0:P3oool001d0oooo00?o00000;BC]02dTk@06@2dTk@2o`0001@0]9>d00?o00000;BC]02d
Tk@08`2dTk@00ol00000]9>d0;BC]0060;BC]003o`00002dTk@0]9>d01<0]9>d00Co00000?ooo`3o
oooo00004@2dTk@00ol00000oooo0?ooo`0Z0?ooo`007@3oool00ol00000]9>d0;BC]00I0;BC]0;o
00004`2dTk@00ol00000]9>d0;BC]00S0;BC]003o`00002dTk@0]9>d00H0]9>d00?o00000;BC]02d
Tk@04`2dTk@01?l00000oooo0?ooool0000C0;BC]003o`00003oool0oooo02T0oooo000N0?ooo`03
o`00002dTk@0]9>d01P0]9>d0_l0000C0;BC]003o`00002dTk@0]9>d02<0]9>d00?o00000;BC]02d
Tk@0102dTk@2o`0001D0]9>d00Co00000?ooo`3ooooo0000502dTk@00ol00000oooo0?ooo`0Y0?oo
o`007P3oool00ol00000]9>d0;BC]00H0;BC]0;o00004`2dTk@00ol00000]9>d0;BC]00S0;BC]003
o`00002dTk@0]9>d00<0]9>d00?o00000;BC]02dTk@0502dTk@01?l00000oooo0?ooool0000E0;BC
]003o`00003oool0oooo02T0oooo000O0?ooo`03o`00002dTk@0]9>d01L0]9>d0_l0000C0;BC]003
o`00002dTk@0]9>d02<0]9>d00?o00000;BC]02dTk@00P2dTk@00ol00000]9>d0;BC]00E0;BC]004
o`00003oool0ooooo`0001H0]9>d00?o00000?ooo`3oool0:03oool001l0oooo00?o00000;BC]02d
Tk@05`2dTk@2o`0001<0]9>d00?o00000;BC]02dTk@08`2dTk@01Ol00000]9>d0;BC]02dTkCo0000
01L0]9>d00Co00000?ooo`3ooooo00005`2dTk@00ol00000oooo0?ooo`0X0?ooo`00803oool00ol0
0000]9>d0;BC]00F0;BC]0;o00004P2dTk@00ol00000]9>d0;BC]00T0;BC]004o`00002dTkCo0000
o`0001L0]9>d00Co00000?ooo`3ooooo00006@2dTk@00ol00000oooo0?ooo`0W0?ooo`00803oool0
0ol00000]9>d0;BC]00F0;BC]0;o00004P2dTk@00ol00000]9>d0;BC]00S0;BC]003o`00002dTkCo
000001P0]9>d00Co00000?ooo`3ooooo00006P2dTk@00ol00000oooo0?ooo`0W0?ooo`008@3oool0
0ol00000]9>d0;BC]00E0;BC]0;o00004P2dTk@00ol00000]9>d0;BC]00S0;BC]003o`00002dTk@0
]9>d01P0]9>d00?o00000?ooool00000702dTk@00ol00000oooo0?ooo`0V0?ooo`008@3oool00ol0
0000]9>d0;BC]00E0;BC]0;o00004P2dTk@00ol00000]9>d0;BC]00Q0;BC]0Co0000602dTk@00ol0
0000ooooo`00000M0;BC]003o`00003oool0oooo02H0oooo000R0?ooo`03o`00002dTk@0]9>d01@0
]9>d0_l0000B0;BC]003o`00002dTk@0]9>d01d0]9>d1Ol00000102dTkCo00000;BC]?l0000F0;BC
]003o`00003ooooo000001l0]9>d00?o00000?ooo`3oool09@3oool00280oooo00?o00000;BC]02d
Tk@0502dTk@2o`000140]9>d00?o00000;BC]02dTk@06`2dTk@3o`0000<0oooo00Co00000;BC]02d
TkCo00000P2dTk@2o`0001@0]9>d0_l0000P0;BC]003o`00003oool0oooo02D0oooo000S0?ooo`03
o`00002dTk@0]9>d01@0]9>d00?o00000;BC]02dTk@03`2dTk@00ol00000]9>d0;BC]00G0;BC]0Co
00001@3oool01Ol00000]9>d0;BC]02dTkCo000000@0]9>d00?o00000;BC]02dTk@0402dTk@2o`00
0240]9>d00?o00000?ooo`3oool09@3oool002<0oooo00?o00000;BC]02dTk@0502dTk@00ol00000
]9>d0;BC]00?0;BC]003o`00002dTk@0]9>d01<0]9>d1?l000080?ooo`03o`00002dTk@0]9>d0080
]9>d00?o00000;BC]02dTk@00`2dTk@00ol00000]9>d0;BC]00>0;BC]003o`00003ooooo00000280
]9>d00?o00000?ooo`3oool0903oool002@0oooo00?o00000;BC]02dTk@04`2dTk@00ol00000]9>d
0;BC]00?0;BC]003o`00002dTk@0]9>d0100]9>d0ol0000;0?ooo`03o`00002dTk@0]9>d00<0]9>d
00?o00000;BC]02dTk@0102dTk@2o`0000d0]9>d00?o00000?ooool000008`2dTk@00ol00000oooo
0?ooo`0T0?ooo`00903oool00ol00000]9>d0;BC]00C0;BC]003o`00002dTk@0]9>d00l0]9>d00?o
00000;BC]02dTk@0302dTk@4o`0000`0oooo0_l000070;BC]003o`00002dTk@0]9>d00D0]9>d00?o
00000;BC]02dTk@02P2dTk@2o`0002D0]9>d00?o00000?ooo`3oool08`3oool002D0oooo00?o0000
0;BC]02dTk@04P2dTk@00ol00000]9>d0;BC]00>0;BC]003o`00002dTk@0]9>d00T0]9>d1?l0000?
0?ooo`03o`00002dTk@0]9>d00L0]9>d00?o00000;BC]02dTk@01P2dTk@2o`0000T0]9>d0_l0000V
0;BC]003o`00003oool0oooo02<0oooo000U0?ooo`03o`00002dTk@0]9>d0180]9>d00?o00000;BC
]02dTk@03P2dTk@00ol00000]9>d0;BC]0060;BC]0?o00004P3oool00ol00000]9>d0;BC]0080;BC
]003o`00002dTk@0]9>d00P0]9>d00?o00000;BC]02dTk@01@2dTk@2o`0002P0]9>d00?o00000?oo
o`3oool08P3oool002H0oooo00?o00000;BC]02dTk@04@2dTk@Do`000080]9>d1?l0000D0?ooo`03
o`00002dTk@0]9>d00T0]9>d00?o00000;BC]02dTk@02@2dTk@00ol00000]9>d0;BC]0040;BC]003
o`00002dTk@0]9>d02L0]9>d00?o00000?ooo`3oool08P3oool002H0oooo00?o00000;BC]02dTk@0
4@2dTk@00ol00000]9>d0;BC]0060;BC]0go00005`3oool00ol00000]9>d0;BC]00:0;BC]003o`00
002dTk@0]9>d00X0]9>d0_l000030;BC]003o`00002dTk@0]9>d02T0]9>d00?o00000?ooo`3oool0
8@3oool002L0oooo00?o00000;BC]02dTk@0402dTk@00ol00000]9>d0;BC]00A0;BC]003o`00003o
ool0oooo01D0oooo00?o00000;BC]02dTk@02`2dTk@00ol00000]9>d0;BC]00<0;BC]003o`00002d
TkCo000002`0]9>d00?o00000?ooo`3oool08@3oool002L0oooo00?o00000;BC]02dTk@03`2dTk@2
o`0001@0]9>d00?o00000?ooo`3oool04P3oool2o`0000h0]9>d00?o00000;BC]02dTk@03@2dTk@0
0ol00000]9>d0;BC]00[0;BC]003o`00003oool0oooo0240oooo000X0?ooo`03o`00002dTk@0]9>d
00h0]9>d0_l0000E0;BC]003o`00003oool0oooo0100oooo00?o00000;BC]02dTk@03P2dTk@00ol0
0000]9>d0;BC]00=0;BC]003o`00002dTk@0]9>d02`0]9>d00?o00000?ooo`3oool0803oool002P0
oooo00?o00000;BC]02dTk@03@2dTk@00ol00000ooooo`00000F0;BC]003o`00003oool0oooo00h0
oooo00?o00000;BC]02dTk@03`2dTk@00ol00000]9>d0;BC]00l0;BC]003o`00003oool0oooo0200
oooo000Y0?ooo`03o`00002dTk@0]9>d00`0]9>d00?o00000?ooool000005`2dTk@00ol00000oooo
0?ooo`0<0?ooo`03o`00002dTk@0]9>d0100]9>d00?o00000;BC]02dTk@0?@2dTk@00ol00000oooo
0?ooo`0O0?ooo`00:@3oool00ol00000]9>d0;BC]00;0;BC]004o`00003oool0ooooo`0001P0]9>d
00?o00000?ooo`3oool02P3oool00ol00000]9>d0;BC]00B0;BC]003o`00002dTk@0]9>d00X0]9>d
00?o00000;BC]02dTk@0;`2dTk@00ol00000oooo0?ooo`0O0?ooo`00:P3oool00ol00000]9>d0;BC
]00:0;BC]004o`00003oool0ooooo`0001P0]9>d00?o00000?ooo`3oool02@3oool00ol00000]9>d
0;BC]00C0;BC]003o`00002dTk@0]9>d00T0]9>d00?o00000;BC]02dTk@0<@2dTk@00ol00000oooo
0?ooo`0N0?ooo`00:P3oool00ol00000]9>d0;BC]0090;BC]005o`00003oool0oooo0?ooool00000
6@2dTk@00ol00000oooo0?ooo`070?ooo`03o`00002dTk@0]9>d01@0]9>d00?o00000;BC]02dTk@0
202dTk@00ol00000]9>d0;BC]00b0;BC]003o`00003oool0oooo01h0oooo000[0?ooo`03o`00002d
Tk@0]9>d00P0]9>d00Go00000?ooo`3oool0ooooo`00000J0;BC]003o`00003oool0oooo00@0oooo
0_l0000G0;BC]003o`00002dTk@0]9>d00P0]9>d00?o00000;BC]02dTk@0<P2dTk@00ol00000oooo
0?ooo`0N0?ooo`00:`3oool00ol00000]9>d0;BC]0070;BC]003o`00003oool0oooo0080oooo00?o
00000;BC]02dTk@06@2dTk@00ol00000oooo0?ooo`020?ooo`03o`00002dTk@0]9>d01L0]9>d00?o
00000;BC]02dTk@01`2dTk@00ol00000]9>d0;BC]00d0;BC]003o`00003oool0oooo01d0oooo000/
0?ooo`03o`00002dTk@0]9>d00D0]9>d00?o00000?ooo`3oool00`3oool00ol00000]9>d0;BC]00J
0;BC]004o`00003oool0ooooo`0001X0]9>d00?o00000;BC]02dTk@01P2dTk@00ol00000]9>d0;BC
]00e0;BC]003o`00003oool0oooo01d0oooo000/0?ooo`03o`00002dTk@0]9>d00D0]9>d00?o0000
0?ooo`3oool00`3oool00ol00000]9>d0;BC]00J0;BC]003o`00003ooooo000001/0]9>d00?o0000
0;BC]02dTk@01@2dTk@00ol00000]9>d0;BC]00g0;BC]003o`00003oool0oooo01`0oooo000]0?oo
o`03o`00002dTk@0]9>d00<0]9>d00?o00000?ooo`3oool0103oool00ol00000]9>d0;BC]00K0;BC
]003o`00002dTk@0]9>d01X0]9>d00?o00000;BC]02dTk@01@2dTk@00ol00000]9>d0;BC]00g0;BC
]003o`00003oool0oooo01`0oooo000]0?ooo`03o`00002dTk@0]9>d00<0]9>d00?o00000?ooo`3o
ool0103oool00ol00000]9>d0;BC]00L0;BC]003o`00002dTk@0]9>d01T0]9>d00?o00000;BC]02d
Tk@0102dTk@00ol00000]9>d0;BC]00i0;BC]003o`00003oool0oooo01/0oooo000^0?ooo`05o`00
002dTk@0]9>d0;BC]?l000001`3oool00ol00000]9>d0;BC]00M0;BC]003o`00002dTk@0]9>d01P0
]9>d00?o00000;BC]02dTk@00`2dTk@00ol00000]9>d0;BC]00j0;BC]003o`00003oool0oooo01/0
oooo000^0?ooo`05o`00002dTk@0]9>d0;BC]?l000001`3oool00ol00000]9>d0;BC]00N0;BC]003
o`00002dTk@0]9>d01P0]9>d00?o00000;BC]02dTk@00P2dTk@00ol00000]9>d0;BC]00k0;BC]003
o`00003oool0oooo01X0oooo000_0?ooo`03o`00002dTkCo000000P0oooo00?o00000;BC]02dTk@0
7`2dTk@00ol00000]9>d0;BC]00G0;BC]005o`00002dTk@0]9>d0;BC]?l00000?P2dTk@00ol00000
oooo0?ooo`0J0?ooo`00;`3oool00ol00000]9>do`0000080?ooo`03o`00002dTk@0]9>d01l0]9>d
0ol0000G0;BC]004o`00002dTk@0]9>do`0003l0]9>d00?o00000?ooo`3oool06P3oool00300oooo
00?o00000?ooo`3oool01`3oool00ol00000]9>d0;BC]00P0;BC]003o`00003ooooo000000;o0000
502dTk@01?l00000]9>d0;BC]?l000100;BC]003o`00003oool0oooo01T0oooo000j0?ooo`03o`00
002dTk@0]9>d0240]9>d00Co00000?ooo`3oool0oooo0_l0000B0;BC]003o`00002dTkCo00000440
]9>d00?o00000?ooo`3oool06@3oool003X0oooo00?o00000;BC]02dTk@08P2dTk@00ol00000oooo
0?ooo`020?ooo`;o0000402dTk@2o`0004<0]9>d00?o00000?ooo`3oool0603oool003X0oooo9ol0
00050?ooo`?o0000302dTk@3o`0004<0]9>d00?o00000?ooo`3oool0603oool006T0oooo0_l00009
0;BC]0?o0000A@2dTk@00ol00000oooo0?ooo`0G0?ooo`00J`3oool2o`0000D0]9>d0_l000020?oo
o`03o`00002dTk@0]9>d04<0]9>d00?o00000?ooo`3oool05`3oool006d0oooo0ol000000`2dTkCo
00000?ooo`030?ooo`03o`00002dTk@0]9>d04@0]9>d00?o00000?ooo`3oool05P3oool00700oooo
00?o00000?ooo`3oool00`3oool00ol00000]9>d0;BC]0140;BC]003o`00003oool0oooo01H0oooo
001g0?ooo`03o`00002dTk@0]9>d04<0]9>d00?o00000?ooo`3oool05P3oool007L0oooo00?o0000
0;BC]02dTk@0A02dTk@00ol00000oooo0?ooo`0E0?ooo`00M`3oool00ol00000]9>d0;BC]0140;BC
]003o`00003oool0oooo01D0oooo001g0?ooo`03o`00002dTk@0]9>d04D0]9>d00?o00000?ooo`3o
ool0503oool007P0oooo00?o00000;BC]02dTk@0A02dTk@00ol00000oooo0?ooo`0D0?ooo`00N03o
ool00ol00000]9>d0;BC]0150;BC]003o`00003oool0oooo01<0oooo001i0?ooo`03o`00002dTk@0
]9>d04@0]9>d00?o00000?ooo`3oool04`3oool007T0oooo00?o00000;BC]02dTk@0A02dTk@00ol0
0000oooo0?ooo`0C0?ooo`00N@3oool00ol00000]9>d0;BC]0150;BC]003o`00003oool0oooo0180
oooo001j0?ooo`03o`00002dTk@0]9>d04@0]9>d00?o00000?ooo`3oool04P3oool007X0oooo00?o
00000;BC]02dTk@0A02dTk@2o`0001<0oooo001k0?ooo`03o`00002dTk@0]9>d0440]9>d0_l0000E
0?ooo`00N`3oool00ol00000]9>d0;BC]00n0;BC]0?o00005`3oool007`0oooo00?o00000;BC]02d
Tk@0>`2dTk@2o`0001X0oooo001l0?ooo`03o`00002dTk@0]9>d03T0]9>d0_l0000L0?ooo`00O@3o
ool00ol00000]9>d0;BC]00e0;BC]0?o00007P3oool007d0oooo00?o00000;BC]02dTk@0<`2dTk@2
o`000240oooo001m0?ooo`03o`00002dTk@0]9>d0340]9>d0_l0000S0?ooo`00OP3oool00ol00000
]9>d0;BC]00]0;BC]0?o00009@3oool007h0oooo00?o00000;BC]02dTk@0:`2dTk@2o`0002P0oooo
001o0?ooo`03o`00002dTk@0]9>d02P0]9>d0_l0000Z0?ooo`00O`3oool00ol00000]9>d0;BC]00U
0;BC]0?o0000;03oool00800oooo00?o00000;BC]02dTk@08P2dTk@2o`0002l0oooo00200?ooo`03
o`00002dTk@0]9>d0200]9>d0_l0000a0?ooo`00P03oool00ol00000]9>d0;BC]00N0;BC]0;o0000
<`3oool00840oooo00?o00000;BC]02dTk@06P2dTk@3o`0003D0oooo00210?ooo`03o`00002dTk@0
]9>d01P0]9>d0_l0000h0?ooo`00PP3oool00ol00000]9>d0;BC]00E0;BC]0;o0000>P3oool00880
oooo00?o00000;BC]02dTk@04P2dTk@3o`0003`0oooo00230?ooo`03o`00002dTk@0]9>d00l0]9>d
0_l0000o0?ooo`00P`3oool00ol00000]9>d0;BC]00=0;BC]0;o0000@@3oool008@0oooo00?o0000
0;BC]02dTk@02@2dTk@3o`0004<0oooo00240?ooo`03o`00002dTk@0]9>d00L0]9>d0_l000160?oo
o`00Q03oool00ol00000]9>d0;BC]0050;BC]0;o0000B03oool008D0oooo00Co00000;BC]02dTk@0
]9>d0ol0001:0?ooo`00Q@3oool01?l00000]9>do`000?l0001=0?ooo`00QP3oool00ol00000oooo
0?ooo`1=0?ooo`00eP3oool00=H0oooo003F0?ooo`00eP3oool00001\
\>"],
  ImageRangeCache->{{{0, 213.688}, {186.438, 0}} -> {-0.000270149, 0.0635249, \
0.00468226, 0.00468226}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disconnect cddmathlink", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Uninstall[cddml]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("/Users/fukuda/Math/cddmathlink"\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{737, 653},
WindowMargins->{{41, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 133, 4, 204, "Title"],
Cell[1841, 56, 231, 4, 92, "Subtitle"],

Cell[CellGroupData[{
Cell[2097, 64, 110, 2, 56, "Section",
  InitializationCell->True],
Cell[2210, 68, 119, 2, 27, "Input",
  InitializationCell->True],
Cell[2332, 72, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[2447, 76, 534, 13, 68, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3006, 93, 83, 2, 27, "Input",
  InitializationCell->True],
Cell[3092, 97, 959, 16, 187, "Output"]
}, Open  ]],
Cell[4066, 116, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[4181, 120, 418, 10, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4624, 134, 119, 2, 27, "Input",
  InitializationCell->True],
Cell[4746, 138, 88, 1, 27, "Output"]
}, Open  ]],
Cell[4849, 142, 437, 10, 50, "Text",
  InitializationCell->True],
Cell[5289, 154, 99, 2, 27, "Input",
  InitializationCell->True],
Cell[5391, 158, 94, 2, 27, "Input",
  InitializationCell->True],
Cell[5488, 162, 97, 2, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5622, 169, 106, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[5753, 174, 84, 1, 27, "Input"],
Cell[5840, 177, 754, 11, 139, "Output"]
}, Open  ]],
Cell[6609, 191, 176, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[6810, 199, 129, 4, 42, "Input"],
Cell[6942, 205, 261, 4, 23, "Print"]
}, Open  ]],
Cell[7218, 212, 132, 4, 42, "Input"],

Cell[CellGroupData[{
Cell[7375, 220, 75, 1, 27, "Input"],
Cell[7453, 223, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7531, 229, 37, 1, 27, "Input"],
Cell[7571, 232, 356, 5, 110, "Output"]
}, Open  ]],
Cell[7942, 240, 173, 4, 42, "Input"],

Cell[CellGroupData[{
Cell[8140, 248, 98, 1, 27, "Input"],
Cell[8241, 251, 612, 8, 178, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8890, 264, 50, 1, 27, "Input"],
Cell[8943, 267, 820, 12, 107, "Output"]
}, Open  ]],
Cell[9778, 282, 286, 12, 162, "Input"],

Cell[CellGroupData[{
Cell[10089, 298, 98, 1, 27, "Input"],
Cell[10190, 301, 389, 5, 75, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10628, 312, 86, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[10739, 317, 77, 1, 46, "Subsection"],

Cell[CellGroupData[{
Cell[10841, 322, 167, 8, 102, "Input"],
Cell[11011, 332, 170, 6, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11230, 344, 92, 1, 46, "Subsection"],
Cell[11325, 347, 262, 11, 132, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11624, 363, 106, 1, 46, "Subsection"],
Cell[11733, 366, 336, 13, 132, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12118, 385, 74, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[12217, 390, 180, 4, 27, "Input"],
Cell[12400, 396, 138, 3, 21, "Message"],
Cell[12541, 401, 138, 3, 21, "Message"],
Cell[12682, 406, 138, 3, 21, "Message"],
Cell[12823, 411, 164, 3, 21, "Message"],
Cell[12990, 416, 28906, 526, 296, 3962, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[41899, 944, 4099, 219, 296, 3972, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[46001, 1165, 4115, 219, 292, 3988, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[50119, 1386, 4110, 219, 305, 3983, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[54232, 1607, 4136, 219, 311, 4009, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[58371, 1828, 4103, 219, 309, 3976, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[62477, 2049, 31707, 561, 307, 3976, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[94187, 2612, 20330, 421, 217, 3897, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[114520, 3035, 21119, 430, 219, 3954, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[135642, 3467, 23849, 465, 230, 3865, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[159494, 3934, 21499, 435, 231, 3942, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[180996, 4371, 21327, 433, 233, 3905, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[202326, 4806, 21491, 435, 266, 3909, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[223820, 5243, 22162, 444, 255, 3914, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[245985, 5689, 19830, 414, 228, 3997, 214, "GraphicsData", "PostScript", \
"Graphics"],
Cell[265818, 6105, 31864, 563, 337, 4044, 215, "GraphicsData", "PostScript", \
"Graphics"],
Cell[297685, 6670, 32124, 567, 340, 4004, 215, "GraphicsData", "PostScript", \
"Graphics"],
Cell[329812, 7239, 25785, 487, 196, 4007, 214, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[355646, 7732, 74, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[355745, 7737, 66, 1, 27, "Input"],
Cell[355814, 7740, 66, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

