#include<fstream>
#include<iostream>
#include <stdlib.h>
#include <math.h>

using namespace std;

int getU(int **data, int *b, int rows, int cols){
	int max = 0;
	for(int i = 0; i < rows; i++){
		if(abs(b[i]) > max)
			max = abs(b[i]);
		for(int j = 0; j < cols; j++)
			if(abs(data[i][j]) > max)
				max = abs(data[i][j]);
	}
	return (int) ceil(pow(sqrt(rows) * max, rows));
}

// P is RxRxH
// ... actually, it looks like it's h X R x R... above was original comment
void construct_poly(int *** P, int **A, int R, int h, int *r, int n, int m){
	int **T, count = R - 1;  // T is a RxR plane
	T = new int*[R];
	for(int i = 0; i < R; i++){
		T[i] = new int [R];
		for(int j = 0; j < R; j++)
			T[i][j] = 0;
	}

	//initial all to 0
	for(int k = 0; k < h; k++)
		for(int i = 0; i < R; i++)
			for(int j = 0; j < R; j++)
				P[k][i][j] = 0;

        //fill in all variables
	int k = n - 1;
	while(k >= 0){
		int flag = count - r[k];
		for(; count > flag; count--){
			T[count][count] = 1;
			if(flag == count - 1)
				T[count + r[k] - 1][count] = 1;
			else
				T[count - 1][count] = 1;
		}
		k--;
	}

	int lower = 0;
	int upper = r[0] - 1;

	//this probably isn't the best place for this, but we need to set
	//all thevariables on the slack level to 2 if the corresponding
	//r[j] is 1
	int cur = 0;
	for(int i = 0; i < n; i++){
		if(r[i] == 1){
			P[m][cur][cur] = 2;
			T[cur][cur] = 2;
		}
		cur += r[i];
	}

	//pull variables down to right place
	for(int j = 0; j < n; j++){ // for each variable--column
		for(int k = 0; k < m; k++){ // for each equation--row
			/*if r[j] is 1 (lower == upper), need to treat it
			 * differently since there's currently no slack.
		 	 */
			if(lower == upper){
				if(A[k][j] == 1 || A[k][j] == -1){
					P[k][lower][lower] = 1;
					P[m][lower][lower]--;
					T[lower][lower]--;
					//P[m][lower][lower] = 1;
				}
				continue;
			}
			int temp = A[k][j];
			int i = lower;
			if(temp > 0){
				while(T[i][i] == 0) i++;
				for(int l = 0; l < temp; l++){
					T[i + l][i + l] = 0;
					P[k][i + l][i + l] = 1;
				}
			}
			else{
				while(T[(i - lower - 1 + r[j]) % r[j] +
				   lower][i] == 0)
					i++;
				for(int l = 0; l < -temp ; l++){
					T[(i + l - 1 - lower + r[j]) %
					   r[j] + lower][i + l] = 0;
					P[k][(i + l - 1 - lower + r[j]) %
					   r[j] + lower][i + l] = 1;
				}
			}
		}// end inner for

		lower = upper + 1;
		if(j < n - 1)
			upper = upper + r[j + 1];

	}

	for(int i = 0; i < R; i++)
		for(int j = 0; j < R; j++)
			P[h - 1][i][j] = T[i][j];

	for(int i = 0; i < h; i++){
		cout << "Level " << i + 1 << endl;
		for(int j = 0; j < R; j++){
			for(int k = 0; k < R; k++)
				cout << P[i][j][k] << " ";
			cout << endl;
		}
	}
 
	for(int i = 0; i < R; i++)
		delete [] T[i];
	delete [] T;
}

void print_for_pprn(int c, int r, int U, int **sink_demand,
   int **arc_capacities){
	ofstream fout("pprn_output.dat");
	int nodes = c + r;
	int arcs = c * r;
	fout << nodes << " " << arcs << " 2 0 0" << endl;
	fout << "ARC COSTS BY COMMODITIES" << endl;
	for(int i = 0; i < 2; i++){
		for(int j = 0; j < arcs; j++)
			fout << 0.0 << " ";
		fout << endl;
	}
	fout << "ARC CAPACITIES BY COMMODITIES" << endl;
	for(int i = 0; i < 2; i++){
		for(int j = 0; j < r; j++)
			for(int k = 0; k < c; k++)
				fout << arc_capacities[j][k] << " ";
		fout << endl;
	}
	fout << "NODE INJECTIONS BY COMMODITIES" << endl;
	for(int i = 0; i < 2; i++){
		// supply
		for(int j = 0; j < r; j++)
			fout << U << " ";
		// demand
		for(int j = 0; j < c; j++)
			if(i == 0)
				fout << -sink_demand[j][0] << " ";
			else
				fout << -sink_demand[j][2] << " ";
		fout << endl;
	}
	fout << "ARC MUTUAL CAPACITIES" << endl;
	for(int j = 0; j < r; j++)
		for(int k = 0; k < c; k++)
			fout << arc_capacities[j][k] << " ";
	fout << endl;
	fout << "NETWORK TOPOLOGY" << endl;
	for(int i = 1; i <= r; i++)
		for(int j = r + 1; j <= nodes; j++)
			fout << i << " " << j << endl;
}

void phase3_RH(int R, int U, int m, int *w, int ***P){
	/* top is (R^2) x (H + 2R) matrix
	 * left is (R^2) x 3 matrix
	 * right is (H + 2R) x 3 matrix
	 */
	int H = m + 1;
	int **top, **left, **right;
	int RH = R * H;
	int H2R = H + R + R;
	top = new int *[RH];
	left = new int *[RH];
	right = new int *[H2R];
	// create and initialize arrays
	for(int i = 0; i < RH; i++){
		top[i] = new int[H2R];
		for(int j = 0; j < H2R; j++)
			top[i][j] = 0;
		left[i] = new int[3];
		left[i][0] = U;
		left[i][1] = 0;
		left[i][2] = U;
	}
	for(int i = 0; i < H2R; i++){
		right[i] = new int[3];
		right[i][0] = 0;
		right[i][1] = 0;
		right[i][2] = 0;
	}

	// fill in top matrix
	for(int i = 0; i < H; i++){
		for(int j = 0; j < R; j++){
			for(int k = 0; k < R; k++)
				if(P[i][j][k] == 1)
					top[i * R + j][k] = U;
			for(int k = 0; k < H; k++)
				if(i == k)
					top[i * R + j][k + R] = U;
			for(int k = 0; k < R; k++)
				if(j == k)
					top[i * R + j][k + R + H] = U;
		}
	}

	// fill in left matrix
	for(int i = 0; i < RH; i++)
		for(int j = 0; j < R; j++)
			left[i][1] += top[i][j];

	// fill in right matrix
	for(int i = 0; i < R; i++){
		right[i][0] = U;
		for(int j = 0; j < RH; j++)
			right[i][1] += top[j][i];
		right[i][1] -= U;
	}
	for(int i = R; i < H + R; i++){
		right[i][0] = R * U - w[i - R];
		right[i][2] = w[i - R];
	}
	for(int i = H + R; i < H2R; i++){
		right[i][1] = U;
		right[i][2] = U * (H - 1);
	}

	/*print for testing*/
	cout << "***TOP***" << endl;
	for(int i = 0; i < RH; i++){
		for(int j = 0; j < H2R; j++)
			cout << top[i][j] << " ";
		cout << endl;
	}
	cout << "***LEFT***" << endl;
	for(int i = 0; i < RH; i++){
		cout << left[i][0] << " ";
		cout << left[i][1] << " ";
		cout << left[i][2];
		cout << endl;
	}
	cout << "***RIGHT***" << endl;
	for(int i = 0; i < H2R; i++){
		for(int j = 0; j < 3; j++)
		cout << right[i][j] << " ";
		cout << endl;
	}

	print_for_pprn(H2R, RH, U, right, top);

	/* print out new equations for cplex */
	int vars = RH * H2R * 3;
	ofstream fout("final.lp");
	fout << "Maximize" << endl;
	fout << "Obj:" << endl;
	fout << "z0";
	for(int i = 1; i < vars; i++)
		fout << "+" << endl << "z" << i;
	fout << endl << endl;
	fout << "Subject To" << endl;
	//top face ("left") -- RH x 3 equations
	for(int i = 0; i < 3; i++)
		for(int j = 0; j < RH; j++)
			for(int k = 0; k < H2R; k++){
				fout << "z" << k * 3 * RH + j * 3 + i;
				if(k == H2R - 1)
					fout << "=" << left[j][i] << endl;
				else
					fout << "+";
			}
	//left face ("top") -- RH x H2R equations
	for(int i = 0; i < RH; i++)
		for(int j = 0; j < H2R; j++)
			for(int k = 0; k < 3; k++){
				fout << "z" << j * 3 * RH + i * 3 + k;
				if(k == 2)
					fout << "=" << top[i][j] << endl;
				else
					fout << "+";
			}
	//right face ("right")
	for(int i = 0; i < H2R; i++)
		for(int j = 0; j < 3; j++)
			for(int k = 0; k < RH; k++){
				fout << "z" << i * 3 * RH + k * 3 + j;
				if(k == RH - 1)
					fout << "=" << right[i][j] << endl;
				else
					fout << "+";
			}
	fout << endl;
	fout << "Bounds" << endl;
	for(int i = 0; i < vars; i++)
		fout << "0 <= z" << i << endl;
	fout << endl;
	fout << "Integers" << endl;
	for(int i = 0; i < vars; i++)
		fout << "z" << i << endl;
	fout << endl;
	fout << "End" << endl;

	// clean up
	for(int i = 0; i < RH; i++){
		delete [] top[i];
		delete [] left[i];
	}
	delete [] top;
	delete [] left;
	for(int i = 0; i < H2R; i++)
		delete [] right[i];
	delete [] right;
}

void phase3_RR(int R, int U, int m, int *w, int ***P){
	/* top is (R^2) x (H + 2R) matrix
	 * left is (R^2) x 3 matrix
	 * right is (H + 2R) x 3 matrix
	 */
	int H = m + 1;
	int **top, **left, **right;
	int R2 = R * R;
	int H2R = H + R + R;
	top = new int *[R2];
	left = new int *[R2];
	right = new int *[H2R];
	for(int i = 0; i < R2; i++){
		top[i] = new int[H2R];
		for(int j = 0; j < H2R; j++)
			top[i][j] = 0;
		left[i] = new int[3];
		for(int j = 0; j < 3; j++){
			left[i][0] = U;
			left[i][2] = U;
		}
	}
	for(int i = 0; i < H2R; i++){
		right[i] = new int[3];
		for(int j = 0; j < 3; j++)
			right[i][j] = 0;
	}

	/*set array values*/
	/*top*/
	for(int i = 0; i < R2; i++){
		for(int j = 0; j < H; j++){
			//if(P[i / R][i % R][j])
			if(P[j][i / R][i % R]){
				top[i][j] = U; 
			}
			else{
				top[i][j] = 0; 
			}
		}
		for(int j = H; j < H + R; j++){
			if((i / R) + H == j)
				top[i][j] = U;
		}
		for(int j = H + R; j < H + R + R; j++){
			if((i % R) + H + R == j)
				top[i][j] = U;
		}
	}


	/*left*/
	for(int i = 0; i < R2; i++){
		for(int j = 0; j < H; j++)
			left[i][1] += top[i][j];
	}

	/*right*/
	for(int i = 0; i < H; i++){
		right[i][0] = w[i];
		right[i][1] = -w[i];
		for(int j = 0; j < R2; j++)
			right[i][1] += top[j][i];
		right[i][2] = 0;
	}
	for(int i = H; i < H + R; i++){
		right[i][0] = U * (R - 1);
		right[i][1] = 0;
		right[i][2] = U;
	}
	for(int i = H + R; i < H + R + R; i++){
		right[i][0] = 0;
		right[i][1] = U;
		right[i][2] = U * (R - 1);
	}

	/*print for testing*/
	cout << "***TOP***" << endl;
	for(int i = 0; i < R2; i++){
		for(int j = 0; j < H2R; j++)
			cout << top[i][j] << " ";
		cout << endl;
	}
	cout << "***LEFT***" << endl;
	for(int i = 0; i < R2; i++){
		cout << left[i][0] << " ";
		cout << left[i][1] << " ";
		cout << left[i][2];
		cout << endl;
	}
	cout << "***RIGHT***" << endl;
	for(int i = 0; i < H2R; i++){
		for(int j = 0; j < 3; j++)
		cout << right[i][j] << " ";
		cout << endl;
	}

	print_for_pprn(H2R, R2, U, right, top);

	/* print out new equations for cplex */
	int vars = R2 * H2R * 3;
	ofstream fout("final.lp");
	fout << "Maximize" << endl;
	fout << "Obj:" << endl;
	fout << "z0";
	for(int i = 1; i < vars; i++)
		fout << "+" << endl << "z" << i;
	fout << endl << endl;
	fout << "Subject To" << endl;
	//top face ("left") -- R2 x 3 equations
	for(int i = 0; i < 3; i++)
		for(int j = 0; j < R2; j++)
			for(int k = 0; k < H2R; k++){
				fout << "z" << k * 3 * R2 + j * 3 + i;
				if(k == H2R - 1)
					fout << "=" << left[j][i] << endl;
				else
					fout << "+";
			}
	//left face ("top") -- R2 x H2R equations
	for(int i = 0; i < R2; i++)
		for(int j = 0; j < H2R; j++)
			for(int k = 0; k < 3; k++){
				fout << "z" << j * 3 * R2 + i * 3 + k;
				if(k == 2)
					fout << "=" << top[i][j] << endl;
				else
					fout << "+";
			}
	for(int i = 0; i < H2R; i++)
		for(int j = 0; j < 3; j++)
			for(int k = 0; k < R2; k++){
				fout << "z" << i * 3 * R2 + k * 3 + j;
				if(k == R2 - 1)
					fout << "=" << right[i][j] << endl;
				else
					fout << "+";
			}
	//right face ("right")
	fout << endl;
	fout << "Bounds" << endl;
	for(int i = 0; i < vars; i++)
		fout << "0 <= z" << i << endl;
	fout << endl;
	fout << "Integers" << endl;
	for(int i = 0; i < vars; i++)
		fout << "z" << i << endl;
	fout << endl;
	fout << "End" << endl;

	//clean up
	for(int i = 0; i < R * R; i++){
		delete [] top[i];
		delete [] left[i];
	}
	delete [] top;
	delete [] left;
	for(int i = 0; i < H + R + R; i++)
		delete [] right[i];
	delete [] right;
}

int main(int argc, char *argv[])
{
	if(argc != 2){
		cerr << "Usage: " << argv[0] << " input file" << endl;
		exit(1);
	}
	int n, m, **A, *b, **rTemp, *r, R=0, ***P, *w;   //Ax=b

	ifstream inFile;
	inFile.open(argv[1], istream::in);
	inFile >> m >> n;

	/*****allocation*****/
	b=new int[n];
	rTemp=new int * [n];
	r=new int [n];
	A=new int *[m];
	w = new int[m + 1];
	for(int j = 0; j < n; j++){
		rTemp[j] = new int[2];
		rTemp[j][0] = rTemp[j][1] = 0;
	}
	/*********************/

	/******read inFile and compute r[j]******/
	for(int i = 0; i < m; i++){
		A[i] = new int [n];
		for(int j = 0; j < n; j++){
			inFile >> A[i][j];
			if(j == n - 1)
			inFile >> b[i];
			if(A[i][j] >= 0){
				rTemp[j][0] += A[i][j];
//				if(A[i][j]==1)
//					rTemp[j][0]++;
			}
			else{
				rTemp[j][1] += -1 * A[i][j];
//				if(A[i][j]==-1)
//					rTemp[j][1]--;
			}
		}
	}
	inFile.close();


	for(int j = 0; j < n; j++){
		if(rTemp[j][0] > rTemp[j][1])
			r[j] = rTemp[j][0];
		else
			r[j] = rTemp[j][1];
		R += r[j];
	}

	/*calculate U and w[k]'s*/
	cout << "Would you like to [c]alculate U or [g]ive the value?: ";
	char choice;
	cin >> choice;
	while(!(choice == 'c' || choice == 'g')){
		cout << "---Please choose 'c' or 'g': ";
		cin >> choice;
	}
	int U;
	if(choice == 'c')
		U = getU(A, b, m, n);
	else {
		cout << "Please enter U: ";
		cin >> U;
	}
	w[m] = R * U;
	for(int i = 0; i < m; i++){
		int sum = 0;
		for(int j = 0; j < n; j++)
			if(A[i][j] < 0)
				sum += -A[i][j];
			w[i] = b[i] + U * sum;
			w[m] -= w[i];
		cout << "w[" << i << "] = " << w[i] << endl;
	}
	cout << "w[m] = " << w[m] << endl;
	cout << "U = " << U << endl;
	/***************************************/

	/* Construct Plane */
	P=new int** [m+1];
	for(int i=0; i < m + 1; i++){
		P[i] = new int * [R];
		for(int j = 0; j < R; j++)
			P[i][j] = new int [R];
	}
	construct_poly(P, A, R, m+1, r, n, m);

	if(R < m + 1){
		phase3_RR(R, U, m, w, P);
	}
	else {
		phase3_RH(R, U, m, w, P);
	}

	delete [] w;
	delete [] b;
	delete [] r;
	for(int i=0; i<n; i++){
		delete [] rTemp[i];
		//delete [] A[i];
	}

	/*** new added ***/ 
	for(int i=0; i<m; i++)
		delete [] A[i]; 
	
	delete [] rTemp;
	delete [] A;
               
	for(int k=0; k<m+1; k++){ // R--> m+1
		for(int i=0; i<R; i++)
			delete [] P[k][i];
		delete [] P[k];
	}
	delete [] P;

	return 0;
}
