% One dimensional optimal control problem
% zdot=z+u
% l=(z^2+u^2)/2
% x=e^z +1

n=1;
m=1;
d=3;
k=100;

f=[1,1,1/2,1,0,-1/6,0,0,0];
l=zeros(1,12);
l(1,1)=1/2;
l(1,3)=1/2;
l(1,4)=-1/2;
l(1,8)=11/24;

[ka,fk,py,lk]= hjb(f,l,n,m,d);
x=0.01*[0:k];
dpy=2*py(1,1)*x+3*py(1,2)*x.^2+4*py(1,3)*x.^3;
u=ka(1,1)*x+ka(1,2)*x.^2+ka(1,3)*x.^3;
fxu=(x+ones(1,k+1)).*(log(x+ones(1,k+1))+u);
lxu=1/2*(log(x+ones(1,k+1)).^2 +u.^2);
lerr=dpy.*fxu+lxu;
%subplot(3,1,1);
plot(x,lerr)
title('Local error of Albrecht solution')
xlabel('x')
ylabel('local error')
pause
% From graph we take 
x1 =0.24;


tpy=0.5*(1+sqrt(2))*log(x+ones(1,k+1)).^2;
cpy=py(1,1)*x.^2+py(1,2)*x.^3+py(1,3)*x.^4;
%subplot(3,1,2);
plot(x,tpy,'-',x,cpy,'.')
alb=cpy;
% axis([0,1,0,1]);
title('True Solution solid, Albrecht solution dot')
axis([0,1,0,1]);
xlabel('x')
ylabel('cost')
pause


% We solve the lowest order equations

c=[-0.5*(1+x1 )^2, (1+x1 )*log(1+x1), 0.5*log(1+x1 )^2];
r=roots(c)

py1=r(1);
u0=-(1+x1 )*py1;

py2=py1*(log(x1 +1)+u0+1)+log(x1 +1)/(x1 +1);
py2=-py2/((x1 +1)*(log(x1 +1)+u0));
u1=-py2*(x1 +1)-py1;
py3=2*py2*(log(x1 +1)+u0+1)+py1/(x1 +1)+(1-log(x1+1))/(x1+1)^2;
py3=py3+(py2*(x1+1)+py1)*u1;
py3=-py3/((x1 +1)*(log(x1 +1)+u0));
u2=-py3*(x1 +1)-2*py2;

py4=3*py3*(log(x1 +1)+u0+1)+3*py2/(x1 +1)-py1/(x1+1)^2....
     +(2*log(x1+1)-3)/(x1+1)^3;
py4=py4+2*(py3*(x1+1)+2*py2)*u1+(py2*(x1+1)+py1)*u2;
py4=-py4/((x1 +1)*(log(x1 +1)+u0));
u3=-py4*(x1 +1)-3*py3;


c=1+sqrt(2);l=log(x1+1);xx1=x1+1;
tpy1=c*l/xx1;
tpy2=c*(1-l)/xx1^2;
tpy3=c*(2*l-3)/xx1^3;
tpy4=c*(11-6*l)/xx1^4;
tu0=-c*l;
tu1=-c/xx1;
tu2=c/xx1^2;
tu3=-2*c/xx1^3;


cpy(1,100*x1+2:k+1)=cpy(1,100*x1+1)*ones(1,k-100*x1)....
                  +py1*(x(1,100*x1+2:k+1)-x1*ones(1,k-100*x1))....
                  +py2/2*(x(1,100*x1+2:k+1)-x1*ones(1,k-100*x1)).^2....
                  +py3/6*(x(1,100*x1+2:k+1)-x1*ones(1,k-100*x1)).^3....
                  +py4/24*(x(1,100*x1+2:k+1)-x1*ones(1,k-100*x1)).^4;
%subplot(3,1,3);


plot(x,tpy,'-',x,cpy,'-.')
axis([0,1,0,1]);
title('True Solution solid, extended Albrecht solution dashdot')
xlabel('x')
ylabel('cost')
pause

plot(x,tpy-cpy,'-.',x,tpy-alb,'.')
title('Error, Albrecht solution dot, extended Albrecht solution dashdot')
xlabel('x')
ylabel('error in cost')


