/* Copyright 1996 by A. J. Krener and Dean Hickerson */

/******************************************************************************/
/*  This file implements the function c=chuze(n,k).                           */
/*                                                                            */
/*  (written by Dean Hickerson, 8/6/94)                                       */
/******************************************************************************/

#define shortname   "chuze"
#define fullname    "chuze(n,k)"

#include <stdio.h>
#include "mex.h"
#include "mexdefines.h"

/*************/
/* Externals */
/*************/
#ifdef __STDC__
extern int choose(int m, int n);
#else
extern int choose();
#endif

/******************************************************************************/

#ifdef __STDC__
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
#else
mexFunction(nlhs, plhs, nrhs, prhs)
int nlhs, nrhs;
mxArray *plhs[], *prhs[];
#endif
{   double *c;
    int n, k, i;
    char outbuff[200];
    int inputargcounter;

    /**********************************************/
    /* Check that chuze has 2 inputs and 1 output */
    /**********************************************/
    if (nrhs != 2)  err("ERROR: chuze requires 2 inputs.")
    if (nlhs > 1)   err("ERROR: chuze has only 1 output.")
    checktypes
	checkreal

    /*************************************/
    /* Check that the inputs are scalars */
    /*************************************/
    checkscalar(0, "n")
    checkscalar(1, "k")

    n = mxGetPr(prhs[0])[0];
    k = mxGetPr(prhs[1])[0];

    /**************************************/
    /* Allocate (and clear) output matrix */
    /**************************************/
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    c = mxGetPr(plhs[0]);

    /*************************************/
    /* Call choose to do the computation */
    /*************************************/
    c[0] = choose(n,k);
}
