/* Copyright 1996 by A. J. Krener and Dean Hickerson */

/******************************************************************************/
/*  This file implements the function m=crd(n,d).                             */
/*                                                                            */
/*  (written by Dean Hickerson, 8/8/94 - 9/30/94)                             */
/******************************************************************************/

#define shortname   "crd"
#define fullname    "crd(n,d)"

#include <stdio.h>
#include "mex.h"
#include "mexdefines.h"

/*************/
/* Externals */
/*************/
#ifdef __STDC__
extern int crd(int m, int n);
#else
extern int crd();
#endif

/******************************************************************************/

#ifdef __STDC__
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
#else
mexFunction(nlhs, plhs, nrhs, prhs)
int nlhs, nrhs;
mxArray *plhs[], *prhs[];
#endif
{   double *m, *n;
    int ns, d, nr, nc, i;

    initERRCHECK;

    if (ERRCHECK)
      { /********************************************/
        /* Check that crd has 2 inputs and 1 output */
        /********************************************/
        if (nrhs != 2)  err("ERROR: crd requires 2 inputs.")
        if (nlhs > 1)   err("ERROR: crd has only 1 output.")
        checktypes
        checkreal
      }

    /************************************/
    /* Get the size of and pointer to n */
    /************************************/
    nr = mxGetM(prhs[0]);   nc = mxGetN(prhs[0]);   n = mxGetPr(prhs[0]);

    if (ERRCHECK)
      { /************************************************************/
        /* Check that n is a row or column vector and d is a scalar */
        /************************************************************/
        if (nr != 1 && nc != 1)  err(
          "ERROR: In crd(n,d), n must be a vector.")
        checkscalar(1, "d")
      }

    d = mxGetPr(prhs[1])[0];

    /**************************************/
    /* Allocate (and clear) output matrix */
    /**************************************/
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    m = mxGetPr(plhs[0]);

    /*************************************/
    /* Find the sum of the elements of n */
    /*************************************/
    for (i=nr*nc-1, ns=0; i>=0; i--)  ns +=n[i];

    m[0] = crd(ns,d);
}
