/* Copyright 1996 by A. J. Krener and Dean Hickerson */

/******************************************************************************/
/*  This file implements the function m=crdsum(n,d0,d1) or crdsum(n,[d0 d1]). */
/*                                                                            */
/*  (written by Dean Hickerson, 9/22/94)                                      */
/******************************************************************************/

#define shortname   "crdsum"
#define fullname    "crdsum(n,d0,d1)"       /* unused if only 2 arguments. */

#include <stdio.h>
#include "mex.h"
#include "mexdefines.h"

/*************/
/* Externals */
/*************/
#ifdef __STDC__
extern int crdsum(int m, int n0, int n1);
#else
extern int crdsum();
#endif

/******************************************************************************/

#ifdef __STDC__
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
#else
mexFunction(nlhs, plhs, nrhs, prhs)
int nlhs, nrhs;
mxArray *plhs[], *prhs[];
#endif
{   double *m, *n, *d, *dd;
    int ns, d0, d1, nr, nc, i;

    initERRCHECK;

    if (ERRCHECK)
      { /*****************************************************/
        /* Check that crdsum has 2 or 3 inputs and 1 output. */
        /*****************************************************/
        if (nrhs < 2 || nrhs > 3)  err("ERROR: crdsum requires 2 or 3 inputs.")
        if (nlhs > 1)  err("ERROR: crdsum has only 1 output.")
        checktypes
        checkreal
      }

    /*****************************/
    /* Get pointers to n, d, dd. */
    /*****************************/
    n = mxGetPr(prhs[0]);   nr = mxGetM(prhs[0]);   nc = mxGetN(prhs[0]);
    d = mxGetPr(prhs[1]);
    if (nrhs == 3)  dd = mxGetPr(prhs[2]);

    if (ERRCHECK)
      { /******************************************************************/
        /* Check that n is a row or column vector and either d and dd are */
        /* scalars or d is 1x1 or 1x2.                                    */
        /******************************************************************/
        if (nr != 1 && nc != 1)  err(
          "ERROR: In crdsum(n,d) or crdsum(n,d0,d1), n must be a vector.")

        if (nrhs==3)
          { checkscalar(1, "d0")
            checkscalar(2, "d1")
          }
        else
          checkrange(1, "d")
      }

    d0 = d[0];
    d1 = nrhs==3 ? dd[0] : d[mxGetN(prhs[1])-1];

    /***************************************/
    /* Allocate (and clear) output matrix. */
    /***************************************/
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    m = mxGetPr(plhs[0]);

    /**************************************/
    /* Find the sum of the elements of n. */
    /**************************************/
    for (i=nr*nc-1, ns=0; i>=0; i--)  ns += n[i];

    /****************/
    /* Call crdsum. */
    /****************/
    m[0] = crdsum(ns,d0,d1);
}
