% This file describes how to create MEX files on a MAC running OS 10.4
% for the following functions:

%     [h,nh]=cmp(f,nf,df,g,ng,dg,d)
%     [h,nh]=dd(f,nf,df,g,ng,dg,d)
%     [h,nh]=jcbn(f,nf,df,nj,d)
%     [h,nh]=mply(f,nf,df,g,ng,dg,d)
%     c=chuze(n,k)
%     m=crd(n,d)
%     m=crdsum(n,d0,d1) or m=crdsum(n,[d0 d1])
%     z=mon(x,n,d)

% First create a directory for the files that will be needed. 
% You can give this directory any name that you want; in this
% description we'll assume that it's called "ToBeMexed". 
% Start MATLAB 7.04 and make it your working directory.
% Make sure that the following source files are in the directory ToBeMexed. 
%        Makefile        addprod.c       choose.c        chuze.c
%        cmp.c           compose.c       crd.c           crdsum.c
%        dd.c            jacobian.c      jcbn.c          mexdefines.h
%        mply.c          sqz.ext.c       walkmonom.c     walkredmonom.c
%
%  At the MATLAB prompt type the following commands following each with a
%  carriage return
%  >> mex chuze.c choose.c
%  >> mex crd.c choose.c
%  >> mex crdsum.c choose.c
%  >> mex cmp.c sqz.ext.c compose.c choose.c walkmonom.c addprod.c walkredmonom.c addprodcplx.c sqz.ext.cplx.c
%  >> mex dd.c sqz.ext.c addprod.c addprodcplx.c jacobian.c choose.c walkmonom.c walkredmonom.c sqz.ext.cplx.c
%  >> mex jcbn.c jacobian.c choose.c walkmonom.c sqz.ext.c walkredmonom.c sqz.ext.cplx.c
%  >> mex mon.c choose.c walkredmonom.c walkmonom.c
%  >> mex mply.c addprod.c choose.c walkmonom.c walkredmonom.c sqz.ext.c addprodcplx.c sqz.ext.cplx.c

% This causes MATLAB to  compile and link the c programs,
% creating the MEX files.   Afterwards you should find in the directory 
% ToBeMexed in addition to the source files listed above,
% there should be 8 new files, whose names are something like
%
%    chuze.mexmac       cmp.mexmac         crd.mexmac         crdsum.mexmac
%    dd.mexmac          jcbn.mexmac        mply.mexmac		  mon.mexmac

% As a test, try typing "chuze(6,2)".  MATLAB should give the answer 15.


