%  The Nonlinear System Toolbox is a package of .m and .mex files
%  for the analysis and synthesis of nonlinear control systems.
%  The .m files are standard but the .mex files must be compiled
%  from .c files and linked to MATLAB. 



%  This file describes how to create the  MEX files on a unix system
%  running older versions of MATLAB.  Check MATLAB help for more up to 
%  date information on how to mex.
%  There is a file called how2mex_MAC.m that explains how to mex
%  on a MAC.  I do not know how to mex on a PC but I assume that it is 
%  similar to a MAC

%     [h,nh]=cmp(f,nf,df,g,ng,dg,d)
%     [h,nh]=dd(f,nf,df,g,ng,dg,d)
%     [h,nh]=jcbn(f,nf,df,nj,d)
%     [h,nh]=mply(f,nf,df,g,ng,dg,d)
%     c=chuze(n,k)
%     m=crd(n,d)
%     m=crdsum(n,d0,d1) or m=crdsum(n,[d0 d1])
%     z=mon(x,n,d) 

%   The .c files can be found in the directory "ToBeMexed". 
%   They are the following 
%        Makefile        addprod.c       choose.c        chuze.c
%        cmp.c           compose.c       crd.c           crdsum.c
%        dd.c            jacobian.c      jcbn.c          mexdefines.h
%        mon.c			 mply.c          sqz.ext.c       walkmonom.c     
%        walkredmonom.c
%
%  Type "make all".  This causes commands in the file "Makefile" 
%  to be executed, which will compile and link the c programs,
%  creating the MEX files.  A bunch of cryptic messages will 
%  appear on your screen.  After a while, they'll stop and 
%  you will get a unix prompt.  Type "ls" to list the files in
% your directory; in addition to the source files listed above,
% there should be 8 new files, whose names are similar to 
% these (The suffix".mex" may be different on some systems.):

%    chuze.mex       cmp.mex         crd.mex         crdsum.mex
%    dd.mex          jcbn.mex        mon.mex         mply.mex

%  Next you need to tell MATLAB where to find the MEX files
%  that you've created.  How to do this may depend on what
%  version of MATLAB you're using and what unix shell is running. 
%  Typing "man matlab" should give you the manual entry for
%  MATLAB, which may desribe what to do.  On the system that
%  I'm using at the moment, the command is "MATLABPATH=$HOME/ToBeMexed".
%  I've put this command in the file ".profile" in my home 
%  directory, so it's done every time I log on.
%  At this point, you can run MATLAB by typing "matlab".  
%  The functions listed above should be available.  As a test,
%  try typing "chuze(6,2)".  MATLAB should give the answer 15.

