
/* Copyright 1996 by A. J. Krener and Dean Hickerson */

/* Modified 7-10/2001 for complex numbers */

/* Modified 6/30/2005: Changed  mexGetArrayPtr("errorcheckflag","global")    */
/*                          to  mexGetVariablePtr("global","errorcheckflag") */

#define MAXDEGREE   50
#define MAXSUBVECS  50
#define MAXINSIZE   100

#define boolean     char
#define FALSE       0
#define TRUE        1

#define max(a,b)    ((a)>(b) ? (a) : (b))
#define min(a,b)    ((a)<(b) ? (a) : (b))
#define max3(a,b,c) ((a)>(b) ? max(a,c) : max(b,c))

/* The following allow the use of long strings in error messages in */
/* old-style compilers, where string concatenation doesn't work.    */
#define err(a)      mexErrMsgTxt(a);
#define err2(a,b)   { sprintf(outbuff,"%s%s",a,b); mexErrMsgTxt(outbuff); }
#define err3(a,b,c) { sprintf(outbuff,"%s%s%s",a,b,c); mexErrMsgTxt(outbuff); }

/******************************************************************************/

/*  A monom represents a monomial of degree deg, a product of deg not
    necessarily distinct variables.  For  0 <= i < deg,  factor[i] is the
    number of the i'th factor of the current monomial; the factors are kept
    in nondecreasing order.
*/
struct monom
  { int factor[MAXDEGREE];
    int insize;
    int degree;
    int index;      /* Not always maintained */
  };

/******************************************************************************/
/*  initERRCHECK looks at the global variable errorcheckflag in MATLAB and    */
/*  sets the boolean ERRCHECK appropriately.  This should be used in every    */
/*  mexFunction for which error checking is not the default behaviour,        */
/*  between the last declaration and the first statement.                     */
/******************************************************************************/
#define initERRCHECK                                                \
    boolean ERRCHECK;                                               \
    const mxArray *errcheckptr;                                     \
    char outbuff[80];                                               \
    int inputargcounter;                                            \
                                                                    \
    mexEvalString("global errorcheckflag");                         \
    errcheckptr = mexGetVariablePtr("global","errorcheckflag");     \
    ERRCHECK = errcheckptr && mxGetM(errcheckptr)>0 &&              \
                mxGetN(errcheckptr)>0 && mxGetPr(errcheckptr)[0];

/******************************************************************************/
/*  checktypes checks that all of the arguments of mexFunction are full,      */
/*  numeric, and double, printing an error message if not.                    */
/******************************************************************************/
#define checktypes                                                          \
  for (inputargcounter=0; inputargcounter<nrhs; inputargcounter++)          \
    if (mxIsSparse(prhs[inputargcounter]))                                  \
      { sprintf(outbuff, "ERROR: Arguments of %s must not be sparse.",      \
                                                               shortname);  \
        mexErrMsgTxt(outbuff);                                              \
      }                                                                     \
    else if (mxIsChar(prhs[inputargcounter]))                               \
      { sprintf(outbuff, "ERROR: Arguments of %s must be numeric.",         \
                                                               shortname);  \
        mexErrMsgTxt(outbuff);                                              \
      }                                                                     \
    else if (!mxIsDouble(prhs[inputargcounter]))                            \
      { sprintf(outbuff, "ERROR: Arguments of %s must be double.",          \
                                                               shortname);  \
        mexErrMsgTxt(outbuff);                                              \
      }                                                                     \
    else ;

/******************************************************************************/
/*  checkreal checks that all of the arguments of mexFunction are real.       */
/******************************************************************************/
#define checkreal                                                           \
  for (inputargcounter=0; inputargcounter<nrhs; inputargcounter++)          \
    if (mxIsComplex(prhs[inputargcounter]))                                 \
      { sprintf(outbuff, "ERROR: Arguments of %s must be real.",            \
                                                               shortname);  \
        mexErrMsgTxt(outbuff);                                              \
      }                                                                     \
    else ;

/******************************************************************************/
/*  checkscalar(varnum, varname) checks that the varnum'th input variable is  */
/*  a 1x1 matrix, printing an error message if not.                           */
/******************************************************************************/
#define checkscalar(varnum, varname)                                        \
  if (mxGetM(prhs[varnum]) != 1 || mxGetN(prhs[varnum]) != 1)               \
    { sprintf(outbuff,"ERROR: In %s, %s must be a scalar.", fullname,       \
                                                                 varname);  \
      mexErrMsgTxt(outbuff);                                                \
    }                                                                       \
  else ;

/******************************************************************************/
/*  checkrange(varnum, varname) checks that the varnum'th input variable is   */
/*  a 1x1 or 1x2 matrix, printing an error message if not.                    */
/******************************************************************************/
#define checkrange(varnum, varname)                                         \
  if (mxGetM(prhs[varnum]) != 1 || mxGetN(prhs[varnum]) > 2)                \
    { sprintf(outbuff,"ERROR: In %s, %s must be 1x1 or 1x2.", fullname,     \
                                                                 varname);  \
      mexErrMsgTxt(outbuff);                                                \
    }                                                                       \
  else ;

/******************************************************************************/
/*  db prints the line number and source file name, for debugging.            */
/******************************************************************************/
#if THINK_C
#define db  printf("db: line %ld of file %s\r", __LINE__, __FILE__);
#else
#define db  printf("db: line %d of file %s\n", __LINE__, __FILE__);
#endif
