function [h,nh]=cmp(f,nf,df,g,ng,dg,d)
%CMP Composition of polynomial vector fields.
%
%   [H,NH]=CMP(F,NF,DF,G,NG,DG,D)
%   computes the composition of a vector field F, of
%   dimensions NF and polynomial of degrees DF(1,1) to DF(1,2) by a
%   vector field G, of dimensions NG and polynomial of degrees
%   DG(1,1) to DG(1,2). The result is a vector field H, of
%   dimensions NG and polynomial of degrees DF(1,1)*DG(1,1)
%   to DF(1,2)*DG(1,2).
%   Only the terms from degree D(1,1) to degree D(1,2) are computed
%   and returned in H. If these differ from the above then part or
%   all of H may be zero-filled to make H polynomial of degrees 
%   D(1,1) to D(1,2). The dimensions of H are in NH as explained
%   below. The degrees DF, DG and D can 1x2 matrices or scalars. A
%   scalar D is equivalent to [D D].
%   The degrees DF, DG and D can be any nonnegative integers but CMP
%   gets much slower and requires much more memory as they increase.
%   The value of F is a column vector composed of subvectors. The
%   dimensions of these subvectors are in the first column of NF.
%   The argument of F is a column vector composed of subvectors. The 
%   dimensions of these subvectors are in the second column of NF.
%   The dimensions of G and H are in NG and NH and these are the
%   same size as NF. The rest of NF, NG and NH are filled with zeros.
%   CMP assumes that the argument of F and the value of G are the
%   same vector and, in particular, the component subvectors are in
%   the same order. If not, take as the common vector, a
%   supervector of both and modify NF and NG as follows. If a
%   particular subvector is absent in the argument of F, place a
%   zero instead of its dimension in the second column of NF.
%   Do not zero fill F. Similarly, if a particular subvector 
%   is absent in the value of G, place a zero instead of its 
%   dimension in the first column of NG.  The value of H is the
%   same as the value of F while the argument of H is the 
%   argument of G. The dimensions in NH will reflect this.
%   F can also be a matrix or tensor field.
%   CMP.M is implimented by CMP.MEX
%
%   The vector fields F and G can be complex but if one is complex
%   then the other must be too. Otherwise MATLAB will crash.
%   If F and G are complex then the output argument H is complex.

%   Copyright (c) 1996, 2005 by A. J. Krener.
%   All rights reserved.
