function [h,nh,dh]=cmp_inv(f,nf,df,d)
%CMP_INV Computes the inverse under composition of a polynomial vector field 
%
%    [H,NH,DH]=CMPINV(F,NF,DF,D) 
%   computes the inverse map of y=f(x)
%   with respect to composition. The inverse is x=h(y).
%   The value and the argument of F are vectors of subvectors
%   whose dimensions are found in the first and second columns 
%   of the dimension matrix, NF, respectively.  The
%   The vector field F is polynomial of degrees DF(1,1) to DF(1,2).
%   The vector field H is polynomial of degrees D(1,1) to D(1,2).
%   It is necessary that DF(1,1)=D(1,1)=1 and that the linear part 
%   of F is invertible.  Hence the dimensions of the value and 
%   the argument of F must be the same.
%   The result is a vector field H, of dimensions NH and
%   polynomial of degrees DH=D.

if ~(df(1,1) == 1) | ~(d(1,1) == 1)
	error('Lower degree of vector field must be 1');
end;
nfsum=colsum(nf);

if ~(nfsum(1,1) == nfsum(1,2))
	error('Dimensions of the value and the argument of vector field must be the same');
end;

a=f(:,1:nfsum(1,2));
ainv= inv(a);
h=prt(f,nf,df,[2 d(1,2)]);
t=[eye(nfsum(1,2)) zeros(nfsum(1,2),nfsum(1,2))];
nt=[nf(:,2) nf(:,2); zeros(size(nf(:,1))) nf(:,1)];
h=cmp(h,[nf; zeros(size(nf))],[2 d(1,2)],t,nt,1,[2 d(1,2)]);
clear t;
h=[zeros(nfsum(1,2),nfsum(1,2)) ainv -ainv*h];
t=zeros(size(h));
t(:,nfsum(1,1)+1:2*nfsum(1,1))=eye(nfsum(1,1));
h=[h;t];
clear t;
nh=[nf(:,2) nf(:,2); nf(:,1) nf(:,1)];
dh=d;
for j=1:ceil(log(d(1,2))/log(2)),
	[h,nh]=cmp(h,nh,dh,h,nh,dh,d);
end;
t=[zeros(nfsum(1,1),nfsum(1,1)); eye(nfsum(1,2))];
nt=[nf(:,2) zeros(size(nf(:,2))); nf(:,1) nf(:,1)];
h=h(1:nfsum(1,2),:);
nh=[nf(:,2) nf(:,2); zeros(size(nf(:,1))) nf(:,1)];
h=cmp(h,nh,dh,t,nt,1,d);
nh=[nf(:,2) nf(:,1)];

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.

