function m=crdsum(n,d)
%CRDSUM Number of homogeneous monomials up to a given degree.
%
%    M=CRDSUM(N,D) 
%   is the number M of homogeneous monomials
%   of degree D(1) to degree D(2) in N variables.
%   N can be a vector of nonegative integers of any length. 
%   D =[D(1) D(2)] must be a pair of nonegative integers.
%   It is implimented by CRDSUM.MEX


ns= sum(n);
m= chuze(ns+d(2),d(2))-chuze(ns+d(1)-1,d(1)-1);

% Copyright (c) 1996 by A. J. Krener.
% All rights reserved.
