function [f_,h_]=d_ch_crds(f,h,n,m,p,d,ph,al,ga)
%D_CH_CRDS Changes of state and output coordinates and feedback of discrete time system
%
%   [F_,H_]=D_CH_CRDS(F,H,N,M,P,D,PH,AL,GA)
%   computes the effect of changes of state and ouput 
%   coordinates and feedback on the discrete time system
%     X^+= F(X,U)
%     Y  = H(X,U)
%   The transformed system is
%     X_^+= F_(X_,U_)
%     Y_  = H_(X_,U_)
%   The dimensions of X,X_ are N, U,U_ are M and Y,Y_ are P. 
%   The changes of coordintes are
%     X_ = PH(X)
%     Y_ = GA(Y)
%   and the feedback is
%     U_ = AL(X,U)
%   The degrees of the system, the coordinate changes and the
%   feedback are all D=[D1 D2]. Note D1 can be zero.
%   If there is no output map, set H=[], P=0, and GA=[].

nf=[n n;0 m];
nh=[p n;0 m];
nph=[n n;0 0];
phxu=cmp(ph,nph,d,[eye(n),zeros(n,m)],[n n;0 m],1,d);
nphal=[n n;m m];
phalinv= cmp_inv([phxu;al],nphal,d,d);
clear phxu
f_= cmp(ph,nph,d,f,nf,d,d);
f_= cmp(f_,nf,d,phalinv,nphal,d,d);
h_= cmp(h,nh,d,phalinv,nphal,d,d);
clear phalinv
h_= cmp(ga,[p p;0 0],d,h_,nh,d,d);
 
% Copyright (c) 2000, 2005 by A. J. Krener.
% All rights reserved.

