function [ph,ff]=d_inv_mfd2(f,n1,n2,d) 
%D_INV_MFD2 computes, to degree D, an invariant submanifold of an ordinary
% difference equation and the reduced dynamics on the invariant manifold. 
%
%   F is the dynamics,
%     [X1;X2]^+=F(X1,X2), X^+(t)=x(t+1)
%   This is an N=N1+N2 vector field, polynomial of degrees 1 
%   thru D in the vector X=[X1;X2]. The subvectors are 
%   of dimensions N1 and N2, respectively and F is in block reduced form
%   It is assumed that {X2=0} is an invariant subspace of the linear
%   part of the F. 
%
%   The invariant manifold is Z2=0 where
%      Z1 = X1 
%      Z2 = X2 - PH2(X1) -...- PHD(X1)
%   The output parameter PH is 
%     PH = [PH2 ... PHD] 
%   and the output parameter FF is the reduced dynamics on 
%   the invariant submanifold 
%     Z1^+=FF(Z1)

n=n1+n2;
df=[1 d];

ph=[eye(n), zeros(n,crd(n+1,d)-n-1)];
a11= f(1:n1,1:n1);
a22= f(n1+1:n,n1+1:n);
ff=f;

for j=2:d
 n1j= crd(n1,j);
 h= prt(ff(n1+1:n,:),[n2 n],df,j);
 h=cmp(h,[n2,n],j,[eye(n1);zeros(n2,n1)],[n,n1],1,j);
 h=reshape(h,n2*n1j,1);
 mat= cmp(eye(n1j),[n1j n1],j,a11,[n1 n1],1,j);
 mat= kron(mat',eye(n2))- kron(eye(n1j),a22);
 phjcs= pinv(mat)*h;
 res= h- mat*phjcs;
 err=max(max(abs(res)));
 if err>0.000001
  disp(sprintf('Warning! Cannot exactly solve for the invariant manifold at degree %-2.0f',j))
  disp('will use the least squares solution, residue of size...')
  disp(err)
 end %if;
 phj= reshape(phjcs,n2,n1j);
 phj= cmp(phj,[n2 n1],j,[eye(n1), zeros(n1,n2)],[n1 n],1,j);
 ph(n1+1:n,crd(n+1,j-1):crd(n+1,j)-1)= - phj;
 ff=d_ch_crds(f,[],n,0,0,[1,d],ph,[],[]);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ph=-cmp(ph(n1+1:n,:), [n2,n], [1,d], [eye(n1); zeros(n2,n1)],[n,n1],1,[2,d]);
ff=cmp(ff(1:n1,:), [n1,n], df, [eye(n1); zeros(n2,n1)],[n,n1],1,df);


% Copyright (c) 2000, 2005 by A. J. Krener.
% All rights reserved.
