function [h,nh]=dd(f,nf,df,g,ng,dg,d)
%DD Directional derivative of one polynomial vector field by another.
%
%    [H,NH]=DD(F,NF,DF,G,NG,DG,D)
%   computes the directional derivative of a vector field F, of
%   dimensions NF and polynomial of degrees DF(1,1) to DF(1,2) by a
%   vector field G, of dimensions NG and polynomial of degrees
%   DG(1,1) to DG(1,2). The directional derivative is polynomial of
%   degrees MAX(DF(1,1)-1,0)+DG(1,1) to MAX(DF(1,2)-1,0)+DG(1,2).
%   Only the terms from degree D(1,1) to degree D(1,2) are computed
%   and returned in H. If these differ from the above then part or
%   all of H may be zero-filled to make H polynomial of degrees 
%   D(1,1) to D(1,2). The dimensions of H are in NH as explained
%   below. The degrees DF, DG and D can 1x2 matrices or scalars. A
%   scalar D is equivalent to [D D].  There is no restriction on the
%   degrees but DD gets much slower and requires much 
%   more memory as they increase.
%   The value of F is a column vector composed of subvectors. The
%   dimensions of these subvectors are in the first column of NF.
%   The argument of F is a column vector composed of subvectors. The 
%   dimensions of these subvectors are in the second column of NF.
%   The dimensions of G and H are in NG and NH and these are the
%   same size as NF. The rest of NF, NG and NH are filled with zeros.
%   DD assumes that the argument of F, the argument of G and the 
%   value of G are all the same vector and, in particular, the
%   component subvectors are in the same order. If not, take as
%   the common vector, a supervector of all three and modify NF
%   and NG as follows. If a particular subvector is absent in the
%   argument of F, place a zero instead of its dimension in the
%   second column of NF. Do not zero fill F.
%   Similarly, if a particular subvector is absent in the
%   value or argument of G, place a zero instead of its dimension
%   in the first or second column of NG.
%   The value of H is the same as the value of F while the argument
%   of H is the supervector of the argument of F, the argument of G
%   and the value of G. The dimensions in NH will reflect this.
%   F can also be a matrix or tensor field.
%   DD is implimented by DD.MEX
%
%   The vector fields F and G can be complex but if one is complex
%   then the other must be too. Otherwise MATLAB will crash.
%   If F and G are complex then the output argument H is complex.


% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.


