function [ka,de,py,lk]= dsp(f,h,li,lo,n,mu,mw,pz,d)
%DSP Dissipative feedback.
%
%     [KA,DE,PY,LK]=DSP(F,H,LI,LO,N,MU,MW,PZ,D)
%   computes a degree D state feedback 
%     U = KA(x) = KA1(x) + KA2(x) +...+ KAD(x)
%   for the degree d nonlinear system 
%     X' = F(X,U,W) = F1(X,U,W) + F2(X,U,W) +...+ FD(X,U,W)
%     Z  = H(X,U)   = H1(X,U) + H2(X,U) +...+ HD(X,U).
%   The goal is to construct a controller so that the closed loop
%   system is dissipative with respect to the degree D+1 supply
%   rate LI-LO. This is the net rate at which "energy" is being
%   supplied to the system. The noise input W supplies energy at 
%   the rate LI(X,W) and the output Z extracts energy at the
%   rate LO(X,Z) = LO(X,H(X,U)). For fixed X, LI and LO should be 
%   strictly convex in w and u respectively.
%   The closed loop system is said to be dissipative if when
%   started from the initial condition XO = 0,  the total "energy"
%   supplied to the system (the time integral of the supply rate) 
%   is nonnegative over any time interval for any noise W(T).
%   The theory of dissipative systems was developed by J. C. Willems,   .
%   in Dissipative dynamical systems, Part I: General Theory,
%   Arch. Rat. Mech. Anal., 45 (1992), 321-351.
%   The dynamics and output functions are given by the vector fields 
%     F = [F1 F2 ....Fd]
%     H = [H1 H2 ....Hd]
%   The supply rates are given by
%     LI = [LI2 LI3....LId1]
%     LO = [LO2 LO3....LOd1]
%   If LI is a scalar then the input supply rate is asssumed to
%     LI*|W|^2.
%   If LO is a scalar then the output supply rate is asssumed to
%     LO*|H(X,U)|^2.
%   The dimensions of X, U, W and Z are N, MU, MW and PZ.
%   The optimal (most dissipating) feedback is U=KA(X) and the
%   least disspating noise is W=DE(X). These and the storage 
%   function PY(X) satisfy the Hamilton-Jacobi-Issacs PDE 
%   which is solved term by term using Al'brecht's 
%   method by the function HJI.M.

nf= [n 0 0;n mu mw]';
df= [1 d];
g = eye(n+mu+mw);
ng= [n mu mw; n mu+mw 0]';
[f,nf]= cmp(f,nf,df,g,ng,1,df);
g= [eye(n) zeros(n,mu+mw); zeros(mu,n) eye(mu) zeros(mu,mw)];
ng= [n mu; n mu+mw]';
nh= [pz 0;n mu]';
[h,nh]= cmp(h,nh,df,g,ng,1,df);
dl= [2 d+1];
if size(li)==[1,1]
 lii=li;
 li= zeros(1,crd(mw,2));
 k=1;
 for i=1:mw
 	li(1,k)= lii;
	k=k+mw-i+1;
 end %i
 li= [zeros(1,crd(n,2)+n*(mu+mw)+crd(mu,2)+mu*mw) li];
 li= [li zeros(1,crd(1+n+mu+mw,d+1)-crd(1+n+mu+mw,2))];
else
 g = [eye(n) zeros(n,mw); zeros(mu,n+mw); zeros(mw,n) eye(mw)]; 
 ng= [n 0 mw; n mu+mw 0]';
 li= cmp(li,[1 0 0;n 0 mw]',dl,g,ng,1,dl);
end % if

if size(lo)==[1,1]
 loo=lo;
 lo= zeros(1,crd(mw,2));
 k=1;
 for i=1:pz
 	lo(1,k)= loo;
	k=k+pz-i+1;
 end %i
 lo= cmp(lo,[1 0; pz 0]',2,h,nh,df,dl);
else
 lo= cmp(lo,[1 0; pz 0]',dl,h,nh,df,dl);
end % if

[ka,fk,py,lk]= hji(f,li-lo,n,mu+mw,d);
de= ka(mu+1:mu+mw,:);
ka= ka(1:mu,:);

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
