function [th,la,thx_u_,ff,hh]=fbi(f,h,n,m,p,deg,f_,h_,n_,m_,th1,la1) 
%[TH,LA,TH_X_U,FF,HH] Computes the solution of an FBI equation.
%
%     [TH,LA,TH_X_U,FF,HH]=FBI(F,H,N,M,P,DEG,F_,H_,N_,M_,TH1,LA1)
%   computes the term by term solution of the
%   generalized Francis-Byrnes-Isidori (FBI) PDE for nonlinear
%   regulation, model matching. This generalization can be found in
%   Krener, A. J., Optimal model matching controllers for linear
%   and nonlinear systems, Nonlinear Control Systems Design 1992,
%   M. Fliess, Ed., Pergammon Press, Oxford.
%   It is based on earlier work of Francis, Isidori-Byrnes
%   and Huang-Rugh. See above for citations.  This rountine is also
%   used by FL to compute an approximate feedback linearization.
%
%   The input parameters are as follows.
%   F is the plant dynamics,
%     X'=F(X,U,X_,U_).
%   This is an N vector field, polynomial of degrees 1 thru DEG in
%   the vector [X;U;X_;U_] whose subvectors are the plant state X,
%   the plant input U, the model state X_, and the model input U_,
%   which are of dimensions N, M, N_ and M_, respectively.
%   H is the plant output map, 
%     Y=H(X,U,X_,U_) 
%   where Y is P dimensional.
%   H is an P vector field, polynomial of degrees 1
%   thru DEG in the vector [X;U;X_;U_].
%   F_ is the model dynamics, 
%     X_'=F_(X_,U_).
%   This is an N_ vector field, polynomial of degrees 1 thru DEG in
%   the vector [X_;U_].
%   H_ is the model output map,
%     Y_=H_(X_,U_) where Y_ is also P 
%   dimensional. H_ is an P vector field, polynomial of degrees 1
%   thru DEG in the vector [X_;U_].
%   Notice the model dynamics does not depend on X,U.
%   DEG is the degree of the data and the desired solution.
%   TH1, LA1 and MU1 are the linear parts of the solution, which
%   can be prespecified. If they are absent, FBI will compute them.
%   TH1, LA1 are NxN_, Mx(N_+M_) respectively.
%
%   FBI computes, to degree DEG, a submanifold of X,X_ space
%     X = TH(X_)
%   and a feedforward 
%     U = LA(X_,U_)
%   such that the submanifold is invariant under the combined plant
%   and model dynamics and the error E = Y - Y_ is zero on the
%   submanifold. This requires that TH and LA be a solution of the
%   generalized Francis-Byrnes-Isidori (FBI) PDE
%     F(TH(X_),LA(X_,U_),X_,U_) = d/dX_(TH(X_))*F_(X_,U_)
%     H(TH(X_),LA(X_,U_),X_,U_) = H_(X_,U_)
%   Following Huang-Rugh, these equations are solved term by term
%   up to degree DEG
%    X = TH(X_)    = TH1(X_) + TH2(X_) + TH3(X_) 
%    U = LA(X_,U_) = LA1(X_,U_) + LA2(X_,U_) + LA3(X_,U_)
%   At each degree, these reduce to linear equations for next
%   coefficients of TH and LA which depend on the previously found
%   coefficients of lower degrees. Generally, the number of
%   equations and the number of unknowns are not the same.
%   They are the same if M = P and M_ = 0.
%   If the equations are not solvable or if there are several
%   solutions, a least squares solution is found using MATLAB's
%   pseudoinverse function PINV. A warning is displayed and the
%   least squares solution is used in later calculations as if it
%   were the true solution.
%   THX_U_ is TH zero-filled to be a function of [X_;U_].
%   FBI also computes, to degree DEG, the result of the changes of
%   coordinates 
%     Z = X - TH(X_)
%     E = Y - Y_
%   and feedforward 
%     V = U - LA(X_,U_)
%   on F and H and returns them as FF and HH, which are Nx1
%   and Px1 fields in [X;U;X_;U_].

a= f(:,1:n);
b= f(:,n+1:n+m);
aa_= f(:,n+m+1:n+m+n_);
bb_= f(:,n+m+n_+1:n+m+n_+m_);
a_= f_(:,1:n_);
b_= f_(:,n_+1:n_+m_);
if p==0
 c= [];
 d= [];
 cc_= [];
 dd_= [];
 c_= [];
 d_= [];
else
 c= h(:,1:n);
 d= h(:,n+1:n+m);
 cc_= h(:,n+m+1:n+m+n_);
 dd_= h(:,n+m+n_+1:n+m+n_+m_);
 c_= h_(:,1:n_);
 d_= h_(:,n_+1:n_+m_);
end %if
 
if nargin==10 % compute the linear submanifold X = TH1*X_
              % and the linear feedforward U= LA1*[X_;U_]. 
 disp('Solving the FBI equations of degree 1')
 mat= zeros(n*n_+m*n_+m*m_,(n+p)*(n_+m_));
 mat(1:n*n_+m*n_,1:(n+p)*n_)= kron([a b;c d]',eye(n_))....
      - kron([eye(n) zeros(n,m);zeros(p,n+m)]',a_);
 mat(:,(n+p)*n_+1:(n+p)*(n_+m_))=....
            [-kron([eye(n) zeros(n,m);zeros(p,n+m)]',b_);....
             kron([b;d]',eye(m_))];
 z= [reshape([-aa_;c_-cc_]',1,(n+p)*n_)...
       reshape([-bb_;d_-dd_]',1,(n+p)*m_)];
 thla1rs= z*pinv(mat);
 res= z- thla1rs*mat;
 if max(max(abs(res)))>0.000001
  disp('Warning! Cannot exactly solve the FBI eqns at degree 1')
  disp('will use the least squares solution, residue of size...')
  disp(max(max(abs(res))))
 end %if;
 th1= reshape(thla1rs(1,1:n*n_),n_,n)';
 la1= reshape(thla1rs(1,n*n_+1:(n+m)*n_),n_,m)';
 la1= [la1 reshape(thla1rs(1,(n+m)*n_+1:(n+m)*n_+m*m_),m_,m)'];
 clear mat z thla1rs
end

th= th1;
thx_u_= [th1 zeros(n,m_)];
la= la1;
if deg==1 return; end
% We compute the degree 2 parts of F(TH1(X_),LA1(X_,U_),X_,U_)
% and H(TH1(X_),LA1(X_,U_),X_,U_). 
nf= [n 0 0 0;n m n_ m_]';
nh= [p 0 0 0;n m n_ m_]';
df= [1 deg];
ph= [thx_u_; la; eye(n_+m_)];
nph= [n m n_ m_; 0 0 n_ m_]';
dph= [1 1];
ftlj= cmp(f,nf,df,ph,nph,dph,2);
htlj= cmp(h,nh,df,ph,nph,dph,2);
% We multiply TH1 by the degree two part of F_ and extract the 
% degree two part of H_.
nf_= [0 0 n_ 0;0 0 n_ m_]';
nh_= [p 0 0 0;0 0 n_ m_]';
thf_j= th1*prt(f_,nf_,df,2);
h_j = prt(h_,nh_,df,2);

for j=2:deg
 % We compute the degree J terms of the solution to FBI equations.
 disp(sprintf('Solving the FBI equations of degree %-2.0f',j))
 n_j= crd(n_,j);
 n_m_j= crd(n_+m_,j);
 temp= eye(n_j);
 temp1= dd(temp,[n_j n_],j,a_,[n_ n_],1,j);
 mat= kron(a',eye(n_j))-kron(eye(n),temp1);
 mat= [mat zeros(n*n_j,n*(n_m_j-n_j))];
 mat= [mat; kron(b',eye(n_m_j))];
 mat= [mat [kron(c',eye(n_j)) zeros(n*n_j,p*(n_m_j-n_j));...
            kron(d',eye(n_m_j))]];
 temp= thf_j - ftlj;
 temp1= h_j - htlj;
 z= [reshape(temp',1,n*n_m_j) reshape(temp1',1,p*n_m_j)];
 thlajrs= z*pinv(mat);
 res= z- thlajrs*mat;
 if max(max(abs(res)))>0.000001
  disp(sprintf('Warning! Cannot exactly solve the FBI eqns at degree %-2.0f',j))
  disp('will use the least squares solution, residue of size...')
  disp(max(max(abs(res))))
 end %if;
 thj= reshape(thlajrs(1,1:n*n_j),n_j,n)';
 laj= reshape(thlajrs(1,n*n_j+1:n*n_j+m*n_m_j),n_m_j,m)';
 th= [th thj];
 thx_u_= [thx_u_ thj zeros(n,n_m_j - n_j)];
 la= [la laj];
 clear mat z thlajrs temp temp1 thj laj
 if j<deg,
  ph= [thx_u_; la; eye(n_+m_) zeros(n_+m_,crd(n_+m_+1,j)-(n_+m_+1))];
  nph= [n m n_ m_; 0 0 n_ m_]';
  dph= [1 j];
  ftlj= cmp(f,nf,df,ph,nph,dph,j+1);
  htlj= cmp(h,nh,df,ph,nph,dph,j+1);
  nth= [n 0 0 0;0 0 n_ 0]';
  thf_j= dd(th,nth,dph,f_,nf_,df,j+1);
  h_j = prt(h_,nh_,df,j+1);
 end
end

k= crd(n+m+n_+m_+1,deg)-(n+m+n_+m_+1);
ph= [eye(n+m+n_+m_) zeros(n+m+n_+m_,k)];
thall=cmp(thx_u_,[n 0 0 0;0 0 n_ m_]',df,...
      [zeros(n_+m_,n+m) eye(n_+m_)],[0 0 n_ m_;n m n_ m_]',1,df);
ph(1:n,:)= ph(1:n,:)+thall;
laall=cmp(la,[0 m 0 0;0 0 n_ m_]',df,...
      [zeros(n_+m_,n+m) eye(n_+m_)],[0 0 n_ m_;n m n_ m_]',1,df);
ph(n+1:n+m,:)= ph(n+1:n+m,:)+laall; 
nph= [n m n_ m_;n m n_ m_]';
ff= cmp(f,nf,df,ph,nph,df,df);
hh= cmp(h,nh,df,ph,nph,df,df);
temp= dd(th,nth,df,f_,nf_,df,df); 
ff= ff-cmp(temp,[n 0 0 0;0 0 n_ m_]',df,...
      [zeros(n_+m_,n+m) eye(n_+m_)],[0 0 n_ m_;n m n_ m_]',1,df);
hh= hh-cmp(h_,[p 0 0 0;0 0 n_ m_]',df,...
      [zeros(n_+m_,n+m) eye(n_+m_)],[0 0 n_ m_;n m n_ m_]',1,df);

% Copyright (c) 1995, 2005 by A. J. Krener.
% All rights reserved.
