function [ph,al]=fbk_lin(f,h,k,l,n,m,p,d) 
%FBK_LIN Approximate feedback linearization to a given degree.
%
%    [PH,AL]=FBK_LIN(F,H,K,N,M,P,D)
%   computes a change of coordinates
%     X = PH(Z) = Z + PH2(Z) + PH3(Z) +....+ PHD(Z)
%   and a feedback 
%     U = AL(Z,V) = K*Z + L*V + AL2(Z,V) + AL3(Z,V) +...+ ALD(Z,V)
%   which transforms the nonlinear system
%     XDOT = F(X,U) = F1(X,U) + F2(X,U) + F3(X,U) +...+ FD(X,U)
%       Y  = H(X,U) = H1(X,U) + H2(X,U) + H3(X,U) +...+ HD(X,U)

%   where
%      F1(X,U) = A*X + B*U
%      H1(X,U) = C*X + D*U
%   to
%      ZDOT = A*Z + B*V + O(Z,V)^(D+1)
%        Y  = C*Z + D*V + O(Z,V)^(D+1)
%   whenever this is possible. The user specifies the linear
%   part of the feedback, K,L. 
%   When it is not possible or there are several solutions,
%   the least squares solution is computed using PINV.
%   The function FBK_LIN.M converts the feedback linearization
%   problem into a Francis-Byrnes-Isidori PDE which is solved
%   by calling FBI.M.  The inverse change of coordinates and
%   feedback can be computed by CMP_INV.M.



% We convert F and H to functions of [X;U;X_;U_] and call FBI. 
nf= [n 0 0 0;n m 0 0]';
nh= [p 0 0 0;n m 0 0]';
df= [1 d];
ph= [eye(n+m) zeros(n+m,n+m)];
nph= [n m 0 0; n m n m]';
dph= [1 1];
f= cmp(f,nf,df,ph,nph,dph,df);
f_= [f(:,1:n+m) zeros(n,crd(n+m+1,d)-n-m-1)];
if p>0
 h= cmp(h,nh,df,ph,nph,dph,df);
 h_= [h(:,1:n+m) zeros(p,crd(n+m+1,d)-n-m-1)];
else
 h_=[];
end;
[ph,al]=fbi(f,h,n,m,p,d,f_,h_,n,m,eye(n),[k l]); 
 
% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
