function [ph,al]=fh2f_h_(f,h,n,m,p,d,f_,h_)
%FH2F_H_  Find change of coordinates and feedback.
%
%     [PH,AL]=FH2F_H_(F,H,N,M,P,D,F_,H_)
%   computes a change of coordinates and feedback which takes
%   the nonlinear system
%     XDOT = F(X,U) = F1(X,U) + F2(X,U) + F3(X,U) +...+ FD(X,U)
%       Y  = H(X,U) = H1(X,U) + H2(X,U) + H3(X,U) +...+ HD(X,U)
%   where
%      F1(X,U) = A*X + B*U
%      H1(X,U) = C*X + D*U
%   to the nonlinear system
%      ZDOT = F_(Z,V) = F_1(Z,V) + F_2(Z,V) + F_3(Z,V) +...+ F_D(Z,V)
%        Y  = H_(Z,V) = H_1(Z,V) + H_2(Z,V) + H_3(Z,V) +...+ H_D(Z,V)
%   plus errors of degree D+1 where
%       F_1(Z,V) = A_*Z + B_*V
%       H_1(Z,V) = C_*Z + D_*V
%   whenever this is possible. When it is not possible or there
%   are several solutions, the least squares solution is computed
%   using PINV.  The chnge of coordinates is
%       X = PH(Z) = Z + PH2(Z) + PH3(Z) +....+ PHD(Z)
%   and a feedback 
%       U = AL(Z,V) = K*Z + V + AL2(Z,V) + AL3(Z,V) +...+ ALD(Z,V)
%   The function FH2F_H_ converts the problem into a
%   Francis-Byrnes-Isidori PDE which is solved by calling FBI.
%   The inverse change of coordinates 
%      Z =  PHINV(X) = X + PHINV2(X) + PHINV3(X) +...+ PHINVD(X)
%   and inverse feedback
%      V = ALINV(X,U) = -K*X + U + ALINV2(X,U) + ALINV3(X,U) +...
%                        + ALINVD(X,U)
%   can be computed by calling CMP_INV.M. 



% We convert F and H to functions of [X;U;X_;U_] and call FBI. 
nf= [n 0 0 0;n m 0 0]';
nh= [p 0 0 0;n m 0 0]';
df= [1 d];
ph= [eye(n+m) zeros(n+m,n+m)];
nph= [n m 0 0; n m n m]';
dph= [1 1];
f= cmp(f,nf,df,ph,nph,dph,df);
if p>0
 h= cmp(h,nh,df,ph,nph,dph,df);
end;

[ph,al]=fbi(f,h,n,m,p,d,f_,h_,n,m);

% Copyright (c) 1993-4, 2005 by A. J. Krener.
% All rights reserved.
 
