function [ka,fk,py,lk]= hjb(f,l,n,m,d,f_,n_,m_) 
%     [KA,FK,PY,LK]=HJB(F,L,N,M,D,F_,N_,M_)
%   computes the stationary solution of a
%   parametrized nonlinear optimal control problem via the term by
%   term solution of the Hamilton-Jacobi-Bellman (HJB) equation up
%   to feedback terms of degree D.
%   E. G. Al'brekht presented the term by term method for solving
%   the unparametrized Hamilton-Jacobi-Bellman (HJB) equation in
%   PMM-J. Appl. Math. Mech.,25,1961,1254-1266.
%   This generalization is due to A. J. Krener.
%   The input parameters are as follows.
%   F is the state dynamics,
%      X'=F(X,U,X_,U_).
%   This is an N vector field, polynomial of degrees 1 thru D in
%   the vector [X;U;X_;U_] whose subvectors are the state X,
%   the control U, the dynamic parameter X_, and the static parameter
%   U_, which are of dimensions N, M, N_ and M_, respectively.
%   The coeficients of F corresponding to the monomials of degree
%   zero in X and U must be zero, i.e., F(X,U,X_,U_) is O(X,U).
%   L is the Lagrangian (running cost), 
%      L(X,U,X_,U_).
%   This is a scalar field, polynomial of degrees 2 thru D+1 in
%   the vector [X;U;X_;U_]. The coeficients of L corresponding to
%   the monomials of degrees zero and one in X and U must be zero.
%   In other words, L(X,U,X_,U_) is O(X,U)^2.
%   D is the desired degree of the optimal feedback.
%   F_ is the dynamics of the parameters,
%      X_'=F_(X_,U_).
%   This is an N_ vector field, polynomial of degrees 1 thru D in
%   the vector [X_;U_]. 
%   If the system does not depend on parameters, then
%   F_, N_ and M_ can be ommitted in the call of HJB. 
%   Then they are set to the default values F_=[], N_=0, M_=0.
%   The output parameters are as follows. 
%   KA, the optimal feedback,
%      U=KA(X,X_,U_), 
%   degrees 1 thru D 
%   KA(X X_,U_) is O(X).
%   FK, the optimal closed loop system, degrees 1 thru D 
%     X'=FK(X,X_,U_)=F(X,KA(X X_,U_),X_,U_).
%    PY, the optimal cost 
%      PY(X,X_,U_), degrees 2 thru D+1,
%   PY(X X_,U_) is O(X)^2.
%   LK, the optimal running cost, degrees 2 thru D+1,
%      LK(X,X_,U_)=L(X,KA(X X_,U_),X_,U_)
%   LK(X X_,U_) is O(X)^2. 



if nargin==5
 f_= [];
 n_= 0;
 m_= 0;
end
% First we compute the quadratic cost PY2(X) and linear feedback
% U=K*X by using LQR2 from the Control Systems Toolbox.

% disp(sprintf('Computing the HJB feedback of degree %-2.0f',1))
a= f(:,1:n);
b= f(:,n+1:n+m);
ii=0;
q=zeros(n,n);
for i=1:n
 ii=ii+1;
 q(i,i)=2*l(1,ii);
 for j=i+1:n
  ii=ii+1;
  q(i,j)=l(1,ii);
  q(j,i)=l(1,ii);
 end %j
end % i
s= reshape(l(1,crd(n,2)+1:crd(n,2)+n*m),m,n)';
ii=crd(n,2)+n*(m+n_+m_);
r=zeros(m,m);
for i=1:m
 ii=ii+1;
 r(i,i)=2*l(1,ii);
 for j=i+1:m
  ii=ii+1;
  r(i,j)=l(1,ii);
  r(j,i)=l(1,ii);
 end %j
end %i
[k,p] = lqr2(a,b,q,r);
k= -k;
ka= [k zeros(m,n_+m_)];
nka= [0 m 0 0;n 0 n_ m_]';
dka= [1 1];
py=zeros(1,crd(n+n_+m_,2));
ii=0;
for i=1:n
 ii=ii+1;
 py(1,ii)=p(i,i)/2;
 for j=i+1:n
  ii=ii+1;
  py(1,ii)=p(i,j);
 end %j
end %i
npy= [1 0 0 0; n 0 n_ m_]';
dpy= [2 2];
rinv= inv(r);
ak= a+b*k;
ae=[ak zeros(n,n_+m_); zeros(n_,n) f_(:,1:n_+m_);...
       zeros(m_,n+n_+m_)];

% We compute the Jacobians DFDU and DLDU of F and L with respect to U.
nf= [ n 0 0 0; n m n_ m_]';
df= [1 d];
nl= [1 0 0 0; n m n_ m_]';
dl= [2 d+1];
nj=[0 m 0 0]';
[dfdu,ndfdu]= jcbn(f,nf,df,nj,[0 d-1]);
[dldu,ndldu]= jcbn(l,nl,dl,nj,[1 d]);

% We modify the F, L, DFDU and DLDU by the linear feedback
% and obtain functions of [X;X_;U_].

ph= [eye(n) zeros(n,n_+m_);ka; zeros(n_+m_,n) eye(n_+m_)];
nph= [n m n_ m_; n 0 n_ m_]';
dph= [1 1];
dfk= [1 2];
[fk,nfk]= cmp(f,nf,df,ph,nph,dph,dfk);
dlk= [2 3];
[lk,nlk]= cmp(l,nl,dl,ph,nph,dph,dlk);
[dfduk,ndfduk]= cmp(dfdu,ndfdu,[0 d-1],ph,nph,dph,[0 1]);
[dlduk,ndlduk]= cmp(dldu,ndldu,[1 d],ph,nph,dph,[1 2]);
ddfduk= [0 1];
% We convert F_ from a function of [X_;U_] into a function
% of [X;X_;U_] using the standard projection TH.
th= [zeros(n_+m_,n) eye(n_+m_)];
nth= [0 0 n_ m_; n 0 n_ m_]';
[f_,nf_]= cmp(f_,[0 0 n_ 0;0 0 n_ m_]',df,th,nth,1,df);
nfkf_= [n 0 n_ 0; n 0 n_ m_]';
% We compute the degree J+1 cost PYJ1(X,X_,U_) and degree J
% feedback KAJ(X,X_,U_)   
for j=2:d
% disp(sprintf('Computing the HJB feedback of degree %-2.0f',j))
 i2= crd(n_+m_,j+1)+n*crd(n_+m_,j);
 i1= crd(n+n_+m_,j+1)-i2;
 temp= [eye(i1) zeros(i1,i2)];
 mat= dd(temp,[i1 0 0 0;n 0 n_ m_]',j+1,ae,[n 0 n_ m_;n 0 n_ m_]',1,j+1);
 mat= mat(:,1:i1);
 fkf_= [fk; prt(f_,nf_,df,dfk)];
 temp= dd(py,npy,dpy,fkf_,nfkf_,dfk,j+1)....
         +prt(lk,nlk,dlk,j+1);
 temp= temp(:,1:i1);
 pyj1= -temp/mat;
 clear mat
 pyj1= [pyj1 zeros(1,crd(n_+m_,j+1)+n*crd(n_+m_,j))];
 py= [py pyj1];
 dpy= [2 j+1];
 [temp,ntemp]= jcbn(py,npy,dpy,[n 0 0 0]',[1 j]);
 temp= mply(temp,ntemp,[1 j],dfduk,ndfduk,ddfduk,j)....
       +prt(dlduk,ndlduk,dfk,j);
 kaj= -rinv*temp;
 ka= [ka kaj];
% We modify the F, L, DFDU and DLDU by the feedback to degree J
% and obtain functions of [X;X_;U_].
 j1= crd(n+n_+m_,j);
 ph= [ph [zeros(n,j1);kaj;zeros(n_+m_,j1)]];
 dph= [1 j];
 dfk=[1 min(j+1,d)];
 [fk,nfk]= cmp(f,nf,df,ph,nph,dph,dfk);
 dlk= dfk+[1 1];
 [lk,nlk]= cmp(l,nl,dl,ph,nph,dph,dlk);
 if j<d,
  ddfduk= dfk-[1 1];
  [dfduk,ndfduk]= cmp(dfdu,ndfdu,[0 d-1],ph,nph,dph,ddfduk);
  [dlduk,ndlduk]= cmp(dldu,ndldu,[1 d],ph,nph,dph,dfk);
 end
end

% Copyright (c) 1996, 2005, 2007  by A. J. Krener.
% All rights reserved.

% rinv2 error corrected 4/6/07.
