function [th,ff]=inv_mfd(f,n1,n2,d) 
%INV_MFD1 computes, to degree D, an invariant submanifold of an ODE
% and the reduced dynamics on the invariant manifold. 
%
% F is the dynamics, [X1;X2]'=F(X1,X2).
% This is an N=N1+N2 vector field, polynomial of degrees 1 
% thru D in the vector X=[X1;X2]. The subvectors are 
% of dimensions N1 and N2, respectively and F is in block reduced form
% It is assumed that {X1=0} is an invariant subspace of the linear
% part of the F. In other words the linear part of F is block
% lower triangular
%
%
% The invariant manifold is Z2=0 where
%      Z1 = X1 
%      Z2 = X2 - TH1(X1) - TH2(X1) -...- THD(X1)
% The output parameter TH is 
%     TH = [TH1 TH2 ... THD] 
% and the output parameter FF is the reduced dynamics on 
% the invariant submanifold 
%     Z1'=FF(Z1)

n=n1+n2;
df=[1 d];


F11= f(1:n1,1:n1);
F21= f(n1+1:n,1:n1);
F22= f(n1+1:n,n1+1:n);
th=lyap(F22,-F11,F21);



for j=2:d
    nj=crd(n1,j);
    temp=dd(eye(nj),[nj,n1],[j,j],F11,[n1,n1],[1,1],[j,j]);
    fj=prt(f,[n1,n1;n2,n2],[1,d],[2,j]);
    fj=cmp(fj,[n1,n1;n2,n2],[2,j],....
        [eye(n1),zeros(n1,crdsum(n1,[2,j-1]));th],[n1,n1;n2,0],[1,j-1],[2,j]);
    temp1=dd(th,[n2,n1],[1,j-1],....
        fj(1:n1,:),[n1,n1],[2,j],[j,j]);
    temp2=prt(fj(n1+1:n,:),[n2,n1],[2,j],[j,j]);
    th=[th,lyap(F22,-temp,-temp1+temp2)];
end
  

ff=cmp(f(1:n1,:),[n1,n1;0,n2],[1,d],....
    [eye(n1),zeros(n1,crdsum(n1,[2,d]));th],[n1,n1;n2,0],[1,d],[1,d]);
    
    
    
    
    
    
  


% Copyright (c) 2006 by A. J. Krener.
% All rights reserved.
