function [h,nh]= jcbn(f,nf,df,nj,d)
%JCBN(F,NF,DF,NJ,D)
%
%    [H,NH]=JCBN(F,NF,DF,NJ,D)
%   computes the Jacobian of a vector field F, of
%   dimensions NF and polynomial of nonnegative degrees DF(1,1) to
%   DF(1,2) with respect to those subvectors of the argument of F
%   specified by NJ. The result is a matrix field H, of
%   dimensions NH and polynomial of degrees DF(1,1)-1 to DF(1,2)-1.
%   Only the terms from degree D(1,1) to degree D(1,2) are computed
%   and returned in H. If these differ from the above then part or
%   all of H may be zero-filled to make H polynomial of degrees 
%   D(1,1) to D(1,2). The dimensions of H are in NH as explained
%   below. The degrees DF and D can 1x2 matrices or scalars. A
%   scalar D is equivalent to [D D].
%   The value of F is a column vector composed of subvectors. The
%   dimensions of these subvectors are in the first column of NF.
%   The argument of F is a column vector composed of subvectors.
%   The dimensions of these subvectors are in the second column
%   of NF. The rest of NF should be filled with zeros.
%   The column vector NJ should have the same number of rows as NF.
%   If NJ(i)==NF(i,2)~=0 then the Jacobian with respect to
%   the i_th subvector is computed.
%   If NJ(i)~=0 but NF(i,2)==0, then the argument of F is expanded
%   to include the i_th subvector and the appropriate part of the
%   Jacobian is set to zero.
%   If NJ(i)==0 then the Jacobian with respect to
%   the i_th subvector is not computed.
%   The Jacobian of a vector field is a matrix field which is
%   row-stacked and transposed to make a long vector field H.
%   The dimensions of H are returned as NH which has 3 columns.
%   The first, NF(:,1), contains the row dimensions of the matrix
%   value of the Jacobian field, the second contains the column
%   dimensions, NJ, of the matrix value of the Jacobian field
%   and the third contains the dimensions of the argument.
%   F can also be a matrix or tensor field.
%   JCBN.M is implimented by JCBN.MEX
%
%   The vector field F  can be complex 
%   then the output argument H is complex.



% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
