function [ka,th,lk,py]=mdl_mtch(f,h,n,m,p,d,f_,h_,n_,m_,l,flag)
%MDL_MTCH(F,H,N,M,P,D,F_,H_,N_,M_,L,FLAG)
%
%     [KA,TH,LK,PY]=MDL_MTCH(F,H,N,M,P,D,F_,H_,N_,M_,L,FLAG)
%   computes an optimal model matching
%   feedforward and feedback control law of degree D. 
%   The input parameters are as follows.
%   F is the plant dynamics,
%     X'=F(X,U).
%   This is an N vector field, polynomial of degrees 1 thru DEG in
%   the vector [X;U] whose subvectors are the state X and
%   the control U, which are of dimensions N and M, respectively.
%   H is the plant output map,
%     Y=H(X,U) where Y is P
%   dimensional. H is an P vector field, polynomial of degrees 1
%   thru D in the vector [X;U].
%   F_ is the model dynamics, 
%     X'=F_(X_,U_).
%   This is an N_ vector field, polynomial of degrees 1 thru D in
%   the vector [X_;U_].
%   H_ is the model output map, 
%     Y_=H_(X_,U_) 
%   where Y_ is also P 
%   dimensional. H_ is an P vector field, polynomial of degrees 1
%   thru D in the vector [X_;U_]. The output error is E = Y-Y_.
%   After coverting F and H to functions of [X;U;X_;U_], MDL_MTCH
%   calls FBI to compute a degree D submanifold of X,X_ space
%      X = TH(X_)
%   and a feedforward 
%      U = LA(X_,U_)
%   such that the submanifold is invariant under the combined plant
%   and model dynamics and the error E = Y - Y_ is zero on the
%   submanifold. To compute a feedback which drives the system to
%   the submanifold, MDL_MTCH makes the changes of coordinates
%      Z = X - TH(X_)
%   and a feedforward 
%      V = U - LA(X_,U_)
%   and then calls HJB to solve an optimal control problem where
%   L is the Lagrangian (running cost), if flag ==0 or
%   is missing then L = L(Z,V) is a function of the transformed
%   state Z and input V. If flag==1 then L = L(E,V) is a function of
%   the output error E and the transformed input V.
%   L is a scalar field, polynomial of degrees 2 thru D+1 in
%   the vector [Z;V] or [E;V]. 
%   The output parameters are as follows. 
%   KA, the optimal feedforward/feedback,U=KA(X,X_,U_),
%   degrees 1 thru D.   KA(X X_,U_) is O(X).
%   TH, the submanifold on which tracking is exact, X = TH(X_)
%   degrees 1 thru D.
%   PY, the optimal cost
%     PY(X,X_,U_),
%   degrees 2 thru D+1,
%   PY(X X_,U_) is O(X)^2.
%   LK, the optimal running cost, degrees 2 thru D+1,
%     LK(X,X_,U_)=L(X,KA(X X_,U_),X_,U_)
%   LK(X X_,U_) is O(X)^2. 
%
%   The method of constructing the model matching controller 
%   is described in
%   Krener, A. J., Optimal model matching controllers for linear
%   and nonlinear systems, Nonlinear Control Systems Design 1992,
%   M. Fliess, Ed., Pergammon Press, Oxford.
%   It utilizes early work of Al'brecht, Francis, Isidori-Byrnes
%   and Huang-Rugh. See above for citations.


% We convert F and H to functions of [X;U;X_;U_] and call FBI. 
nf= [n 0 0 0;n m 0 0]';
nh= [p 0 0 0;n m 0 0]';
df= [1 d];
ph= [eye(n+m) zeros(n+m,n_+m_)];
nph= [n m 0 0; n m n_ m_]';
dph= [1 1];
f= cmp(f,nf,df,ph,nph,dph,df);
h= cmp(h,nh,df,ph,nph,dph,df);
[th,la,thx_u_,ff,hh]= fbi(f,h,n,m,p,d,f_,h_,n_,m_);
% FF and HH are now functions of [Z;V;X_;U_] and E=HH, see FBI.

if nargin==11, flag=0; end
if flag==0   % we convert L(Z,V) into L(Z,V,X_,U_)
 nl= [1 0 0 0;n m 0 0]';
 dl= [2 d+1];
 l= cmp(l,nl,dl,ph,nph,dph,dl);
else         % we convert L(E,V) into L(Z,V,X_,U_)
 nl= [1 0 0 0 0;p 0 m 0 0]';
 dl= [2 d+1];
 ph= [hh; zeros(m,n) eye(m) zeros(m,n_+m_)...
       zeros(m,crd(n+m+n_+m_+1,d)-crd(n+m+n_+m_+1,1))];
 nph= [p 0 m 0 0;0 n m n_ m_]';
 dph= [1 d];
 l= cmp(l,nl,dl,ph,nph,dph,dl);
end
[ka,fk,py,lk]= hjb(ff,l,n,m,d,f_,n_,m_);

% All returned parameters are functions of [Z;X_;U_], see HJB.
% We convert back to functions of [X;X_;U_].
nthx= [n 0 0 0;0 0 n_ m_]';
nla= [0 m 0 0;0 0 n_ m_]';
ph= [eye(n) -thx_u_(:,1:n_+m_);zeros(n_+m_,n) eye(n_+m_)];
lax= [zeros(m,n) la(:,1:n_+m_)];
dph= [1 d];
for j= 2:d
 ph= [ph [zeros(n,crd(n+n_+m_,j)-crd(n_+m_,j))...
       -prt(thx_u_,nthx,dph,j); zeros(n_+m_,crd(n+n_+m_,j))]];
 lax= [lax zeros(m,crd(n+n_+m_,j)-crd(n_+m_,j))...
       prt(la,nla,dph,j)];
end
nph= [n 0 n_ m_; n 0 n_ m_]';
nfk= [n 0 0 0; n 0 n_ m_]';
nka= [0 m 0 0; n 0 n_ m_]';
nlk= [1 0 0 0;n 0 n_ m_]';
dl= [2 d+1];
ka= cmp(ka,nka,df,ph,nph,dph,df)+lax;
py= cmp(py,nlk,dl,ph,nph,dph,dl);
lk= cmp(lk,nlk,dl,ph,nph,dph,dl); 

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
