function z=mon(x,n,d)
%MON(X,N,D)
%
%   Given the column vector X=[X1;X2;...;XR] where the subvectors
%   are of dimension N=[N1;N2;...;NR],
%     Z=MON(X,N,D)
%   computes the monomials Z of X of degrees D= [DL DU] in block lexographic
%   order. 
%   In the previous version the upper degree DU must be greater than 1 
%   but that is no longer required.

if d(1)> d(2)
	z=[];
	return
end;


n1=n(1);
z1=zeros(crd(n1+1,d(2)),1);
z1(1:n1+1,1)=[1;x(1:n1)];
l=n1+1;
for k=2:d(2)
	l1=crd(n1+1,k-1);
	for i=1:n1
		m=crd(n1-i+1,k-1);
		z1(l+1:l+m,1)=x(i)*z1(l1-m+1:l1);
		l=l+m;
	end
end
nl=length(n);
if nl==1
	z=z1;        
else
	ns=sum(n);
	nrs=ns-n1;
	nr=n(2:nl);
	xr=x(n1+1:ns);
	zr=mon(xr,nr,[0 d(2)]);
	z=[1;x];
	for k=2:d(2)
		for j=0:k
			l1=crd(n1+1,k-j-1);
			l2=crd(n1+1,k-j);
			l3=crd(nrs+1,j-1);
			l4=crd(nrs+1,j);
			z=[z; kron(z1(l1+1:l2,1),zr(l3+1:l4))];
		end %j
	end %k
end % if
z=prt(z',[[1;zeros(nl-1,1)] n],[ 0,d(2)],d)';

% Copyright (c) 1996, 2001, 2005 by A. J. Krener.
% All rights reserved.

