function [h,nh]=mply(f,nf,df,g,ng,dg,d)
%MPLY(F,NF,DF,G,NG,DG,D)
%
%     [H,NH]=MPLY(F,NF,DF,G,NG,DG,D)
%   computes the product of a matrix field F, of
%   dimensions NF and polynomial of degrees DF(1,1) to DF(1,2) by a
%   matrix or vector field G, of dimensions NG and polynomial of
%   degrees DG(1,1) to DG(1,2). The result is a matrix or vector
%   field H, of dimensions NG and polynomial of degrees
%   DF(1,1)*DG(1,1) to DF(1,2)*DG(1,2).
%   Only the terms from degree D(1,1) to degree D(1,2) are computed
%   and returned in H. If these differ from the above then part or
%   all of H may be zero-filled to make H polynomial of degrees 
%   D(1,1) to D(1,2). The dimensions of H are in NH as explained
%   below. The degrees DF, DG and D can 1x2 matrices or scalars. A
%   scalar D is equivalent to [D D].  The degrees DF, DG and D 
%   can be any nonnegative integers but MPLY gets slower 
%   and requires more memory as they increase.
%   The value of F is a matrix composed of submatrices.
%   The row dimensions of the submatrices are in the first column
%   of NF and the column dimensions of the submatices are in the
%   second column of NF.
%   The argument of F is a column vector composed of subvectors. The 
%   dimensions of these subvectors are in the third column of NF.
%   The dimensions of G and H are in NG and NH and these have the
%   same number of rows as NF. If G is a vector field then so is
%   the product H and NG and NH have two columns. If G is a matrix
%   field then so is the product, H, and NG,NH have three columns. 
%   The rest of NF, NG and NH are filled with zeros.
%   Matrix fields are row-stacked and transposed and stored as long
%   column vector fields.
%   Of course F and G must be compatible for multiplication, i.e.,
%   the sum of the second column of NF must equal the sum of the
%   first column of NG.
%   MPLY assumes that the argument of F and the argument of G are
%   the same vector and, in particular, the component subvectors
%   are in the same order. If not, take as the common argument,
%   a supervector of all three and modify NF and NG as follows.
%   If a particular subvector is absent in the argument of F,
%   place a zero instead of its dimension in the third column of NF.
%   Do not zero fill F.
%   Similarly, if a particular subvector is absent in the argument
%   of G, place a zero instead of its dimension in the third column
%   of NG.
%   The value of H is a matrix with row dimensions from F and
%   column dimensions from G. The argument of H is the supervector
%   of the argument of F and the argument of G. The dimensions in
%   NH will reflect this.
%   MPLY.M is implimeted by MPLY.MEX
%
%   The vector fields F and G can be complex but if one is complex
%   then the other must be too. Otherwise MATLAB will crash.
%   If F and G are complex then the output argument H is complex.


% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.


