function [b,nb,db]=mult_inv(a,na,da)
    %  This function computes the polynomial matrix field b  that is the
    %  approximate inverse with respect to matrix multiplication of 
    %  the polynomial matrix field a.
    %  Recall that a polynomial matrix field is converted to a polynomial 
    %  vector field by row stacking and transposing the matrix field to get
    %  a vector field.  The dimensions of a are stored in na.  This is a
    %  matrix that has three columns.  The first column contains the 
    %  dimensions of the row blocks of the matrix field a.  
    %  The second column contains the dimensions of the column blocks
    %  of the matrix field a.  The third column contains the 
    %  dimensions of the vectors that are the arguments of a.
    %  The polynomial matrix field is of degrees 0 through da in
    %  its arguments.  
    %  b is a polynomial matrix of degrees 0 through db =da.  The product
    %  of the polynomial vector fields a and b is the identity field
    %  through terms of degree da.
    %  The matrix field a must be square so  the first two columns
    %  of na must be equal.  Also the constant part of a must be
    %  invertible.
    %  Current restriction:  da<5.
    
    n=colsum(na);
    % add check that n(1)=n(2)
    nb=na;
    db=da;
    
    a0=reshape(a(:,1),n(1),n(1))';
    b0= reshape(inv(a0)',n(1)*n(2),1);
    a0=a(:,1);
    b=b0;
    % add check that a0 is invertible
    
    if da > 0
        a1= a(:,2:n(3)+1);
        b1=-mply(b0,nb,0,a1,na,1,1);
        b1=mply(b1,nb,1,b0,nb,0,1);
        b=[b,b1];
    end
    
    if da > 1
        a2= a(:,n(3)+2:crdsum(n(3),[0,2]));
        b2=mply(a2,na,2,b0,nb,0,2)+mply(a1,na,1,b1,nb,1,2);
        b2=-mply(b0,nb,0,b2,nb,2,2);
        b=[b,b2];
    end 
    
    if da > 2
        a3= a(:,crdsum(n(3),[0,2])+1:crdsum(n(3),[0,3]));
        b3=mply(a3,na,3,b0,nb,0,3)+mply(a2,na,2,b1,nb,1,3)+mply(a1,na,1,b2,nb,2,3);
        b3=-mply(b0,nb,0,b3,nb,3,3);
        b=[b,b3];
    end
    
    
    if da > 3
        a4= a(:,crdsum(n(3),[0,3])+1:crdsum(n(3),[0,4]));
        b4=mply(a4,na,4,b0,nb,0,4)+mply(a3,na,3,b1,nb,1,4)+mply(a2,na,2,b2,nb,2,4)+mply(a1,na,1,b3,nb,3,4);
        b4=-mply(b0,nb,0,b4,nb,4,4);
        b=[b,b4];
    end
    
    if da> 4
        error(' ','damust be between 0 and 4')
    end
% Copyright (c) 2005 by A. J. Krener.
% All rights reserved.

    