function [dth,th,thinv,a,be]=obsKK(f,h,n,p,deg,b)
% This program computes a full order observer to degree DEG for the system
% 	x'=f(x)=f1*x+...
% 	y =h(x)=h1*x+...
% using a modified form of the power series method of Kazantzis and Kravaris as
% found in Systems and Control Letters, 34 (1998), pp 241-247.
% The state x is N dimensional and the output y is P dimensional.
% The matrix B is a design parameter and determines A=F1+B*H1.
% The matrix B is nxp and B should be chosen so that A 
% is Hurwitz with eigenvaues distinct from
% all nonegative integer combinations of those of the linear part F1 of F.
% B should also be chosen so that A,B is controllable.
% It is necessary that the linear part F1,H1 of F,H be observable.  
% The method is to find a change of coordinates, z=th(x)=x+th2(x)+... and
% output injection be(y) that transforms the above system to
%	z'=a*z-be(y) where be(y)=b*y+be2(y)...
% The change of coordinates and the output injection are found term by term.
% The degree d equations are solvable if there is no d-resonance.
% A d-resonace occurs when one of the 
% eigenvalues of A is a sum of d not necessarily distinct eigenvalues of the 
% linear part of F.  It can be shown that for almost all choices of B,
% there is no resonance and the this system is solvable.  In fact, for d>1
% there are an infinite number of solutions becase of the freedom in choosing 
% the degree d part of be.  The program calculates a least squares solution.
% The observer in z coordinates is given by 
%	zhat'=a*zhat-be(y)
%   xhat=th^(-1)(zhat)
% The error dynamics is then
% 	ztilde'=a*ztilde 
% The observer in x coordinates is given by
% 	xhat' = f(xhat) -(dth)^(-1)(xhat)*(be(y)-be(h(xhat)))
% It is best to impliment the observer in z coordinates to ensure stability

be=b;
f1=prt(f,[n,n],[1,deg],1);
h1=prt(h,[p,n],[1,deg],1);
th=eye(n);
a=f1+b*h1;
for j=2:deg
	d=[dd(eye(crd(n,j)),[crd(n,j),n],j,f1,[n,n],1,j);...
		cmp(eye(crd(p,j)),[crd(p,j),p],j,h1,[p,n],1,j)];
	e=dd(th,[n,n],[1,j-1],f,[n,n],[1,deg],j)+...
		cmp(be,[n,p],[1,j-1],h,[p,n],[1,deg],j);
	x=syl(a,[eye(crd(n,j));zeros(crd(p,j),crd(n,j))],eye(n),d,e);
	th=[th x(:,1:crd(n,j))];
	be=[be x(:,crd(n,j)+1:crd(p,j)+crd(n,j))];
end
dth=jcbn(th,[n,n],[1,deg],n,[0, deg-1]);
thinv=cmp_inv(th,[n,n],[1,deg],[1,deg])

% Copyright 2007 by A. J. Krener.
% All rights reserved.
