function h=prt(f,nf,df,d)
%PRT(F,NF,DF,D)
%
%     H=PRT(F,NF,DF,D)
%   returns the degrees D(1,1) to D(1,2) part, H,
%   of the vector field F which is of dimensions NF and polynomial of
%   degrees DF(1,1) to DF(1,2). If DF(1,1)>D(1,1) or D(1,2)>DF(1,2)
%   then H is filled with zeros as needed. The degrees DF and D can
%   1x2 matrices or scalars. A scalar D is equivalent to [D D].
%   The value of F is a column vector composed of subvectors. The
%   dimensions of these subvectors are in the first column of NF.
%   The argument of F is a column vector composed of subvectors.
%   The dimensions of these subvectors are in the second column
%   of NF.  The rest of NF should be filled with zeros.
%   F can also be a matrix or tensor field.

if isempty(f) 
 h=[];
 return
end
[nr,nc]= size(nf);
nh=nf(:,1:nc-1);
if nc>2,
 nsum= sum([nf;zeros(1,nc)]);
 nprod= cumprod(nsum(1,2:nc-1));
 nf= [nf(:,1)*nprod nf(:,nc)];
end

if length(df)==1, df=[df df]; end
if length(d)==1, d=[d d]; end

ms= sum(nf(:,1));
ns= sum(nf(:,2));

h= zeros(ms,crd(ns+1,d(1,2))-crd(ns+1,d(1,1)-1));
dl= max(d(1,1),df(1,1));
du= min(d(1,2),df(1,2));
if dl>du,
 return;
else
 j1= crd(ns+1,dl-1)-crd(ns+1,d(1,1)-1);
 j2= crd(ns+1,du)-crd(ns+1,d(1,1)-1);
 j3= crd(ns+1,dl-1)-crd(ns+1,df(1,1)-1);
 j4= crd(ns+1,du)-crd(ns+1,df(1,1)-1);
 h(:,j1+1:j2)= f(:,j3+1:j4);
end

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
