function [hn,nhn,dhn,hd,dhd]=ratdd(fn,nfn,dfn,fd,dfd,gn,ngn,dgn,gd,dgd)
  
% This function directionally differentiates a rational vector field
% in the direction of another and  
% puts the result over a common denominator.   
% A rational vector field is a polynomial vector field FN
% in the numerator and a polynomial FD in the denominator.  
% The dimensions of the numerator vector field are found in NFN.
% It is assumed that the denominator polynomial has the same arguments
% as the numerator polynomial.
% The lower and upper degrees of the numerator vector field 
% are found in DFN=[DFN(1,1),DFN(1,2)].  If DFN is a scalar then
% it is changed to [DFN,DFN].
% The degrees of the denominator polynomial are found in DFD.
% The same holds for the other rational vector field G and the
% directional derivative H.   

if length(dfn)==1
    dfn=[dfn,dfn];
end

if length(dfd)==1
    dfd=[dfd,dfd];
end

if length(dgn)==1
    dgn=[dgn,dgn];
end

if length(dgd)==1
    dgd=[dgd,dgd];
end


[nf1,nf2]=size(nfn);
nfd=[[1;zeros(nf1-1,1)],nfn(:,2)];


[ng1,ng2]=size(ngn);
ngd=[[1;zeros(ng1-1,1)],ngn(:,1)];


dhn1(1,1)=max(dfn(1,1)-1,0)+dgn(1,1);
dhn1(1,2)=max(dfn(1,2)-1,0)+dgn(1,2);

dhn2(1,1)=max(dfd(1,1)-1,0)+dgn(1,1);
dhn2(1,2)=max(dfd(1,2)-1,0)+dgn(1,2);

dhn(1,1)=min(dhn1(1,1)+dfd(1,1),dhn2(1,1)+dfn(1,1));
dhn(1,2)=max(dhn1(1,2)+dfd(1,2),dhn2(1,2)+dfn(1,2));

[hn1,nhn]=dd(fn,nfn,dfn,gn,ngn,dgn,dhn1);
[r,c]=size(nhn);
nnh1=[nhn(:,1),[1;zeros(r-1,1)],nhn(:,2)];

hn1=mply(hn1,nnh1,dhn1,fd,nfd,dfd,dhn);



[hn2,nhn2]=dd(fd,nfd,dfd,gn,ngn,dgn,dhn2);
[r,c]=size(nfn);
nnfn=[nfn(:,1),[1;zeros(r-1,1)],nfn(:,2)];

hn2=mply(fn,nnfn,dfn,hn2,nhn2,dhn2,dhn);

hn=hn1-hn2;

[r,c]=size(nfd);
nnfd=[nfd(:,1),[1;zeros(r-1,1)],nfd(:,2)];
hd=mply(fd,nnfd,dfd,fd,nfd,dfd,2*dfd);
hd=mply(hd,nnfd,2*dfd,gd,ngd,dgd,2*dfd+dgd);
dhd=2*dfd+dgd;










% Copyright (c) 2007 by A. J. Krener.
% All rights reserved.


