function [hn,nhn,dhn,hd,dhd]=ratjcbn(fn,nfn,dfn,fd,dfd,nj)
  
% This function computes the Jacobian of a rational vector field
% with respect to the arguments specified by NJ.   
% A rational matrix field has a polynomial matrix field FN
% in the numerator and a polynomial FD in the denominator.  
% The dimensions of the numerator matrix field are found in NFN.
% It is assumed that the denominator polynomial has the same 
% arguments as the numerator polynomial vector field.

% The degrees of the numerator matrix field FN are found in DFN.
% The degrees of the denominator polynomial FD are found in DFD.
% The output is a rational matrix field with numerator HN 
% and denominator HD, with numerator dimensions NHN, numertor degree
% DHN and denominator degree DHD.  

if length(dfn)==1
    dfn=[dfn,dfn];
end

if length(dfd)==1
    dfd=[dfd,dfd];
end


if dfn(1,1)>0
    djfn=dfn-[1,1];
else
    djfn=[0,dfn(1,2)-1];
end

[jfn,njfn]=jcbn(fn,nfn,dfn,nj,djfn);

nfnsum=sum(nfn);
njfnsum=sum(njfn);
k=njfnsum(1,1)*njfnsum(1,2);
[n1,n2]=size(nfn);
njfn=[[k,1;zeros(n1-1,2)],nfn(:,2)];
nfd=[[1;zeros(n1-1,1)],nfn(:,2)];
nnfd=[[1,1;zeros(n1-1,2)],nfn(:,2)];

hn1=mply(jfn,njfn,djfn,fd,nfd,dfd,djfn+dfd);

if dfd(1,1)>0
    djfd=dfd-[1,1];
else
    djfd=[0,df2(1,2)-1];
end

[jfd,njfd]=jcbn(fd,nfd,dfd,nj,djfd);

nfn2=[nfn(:,1),[1;zeros(n1-1)],nfn(:,2)];
njfd=[[1,sum(nj');zeros(n1-1,2)],nfn(:,2)];
hn2=mply(fn,nfn2,dfn,jfd,njfd,djfd,djfd+dfn);

if djfn+dfd==djfd+dfn
    dhn=djfd+dfn;
elseif djfn(1,1)+dfd(1,1)>djfd(1,1)+dfn(1,1)
    dhn=djfd+dfn;
    hn1=[zeros(k,crd(nfnsum(1,2),djfd(1,1)+dfn(1,1))),hn1];
else
    dhn=djfn+dfd;
    hn2=[zeros(k,crd(nfnsum(1,2),djfn(1,1)+dfd(1,1))),hn2];
end     
hn=hn1-hn2;
nhn=[nfn(:,1),[nj;zeros(n1-1,1)],nfn(:,2)];

dhd=2*dfd;
hd=mply(fd,nnfd,dfd,fd,nfd,dfd,dhd);


% Copyright (c) 2007 by A. J. Krener.
% All rights reserved.
