function [hn,nhn,dhn,hd,dhd]=ratmply(fn,nfn,dfn,fd,dfd,gn,ngn,dgn,gd,dgd)
  
% This function multiplies two  rational matrix fields 
% puts them over a common denominator.   
% A rational matrix field  is a polynomial matrix field FN
% in the numerator and a polynomial FD in the denominator.  
% The dimensions of the numerator matrix field are found in NFN.
% It is assumed that the denominator polynomial has the same arguments
% as the numerator polynomial.
% The dimensions FN and GN must be compatible for multiplication
% The degrees of the numerator matrix field FN are found in DFN.
% The degrees of the denominator polynomial FD are found in DFD.
% The same holds for the other rational vector field G and their
% sum H.  


if length(dfn)==1
    dfn=[dfn,dfn];
end

if length(dfd)==1
    dfd=[dfd,dfd];
end

if length(dgn)==1
    dgn=[dgn,dgn];
end

if length(dgd)==1
    dgd=[dgd,dgd];
end

[nf1,nf2]=size(nfn);
if nf2 ~= 3 
    error('nf must have three columns')
end

dhn=dfn+dgn;
hn=mply(fn,nfn,dfn,gn,ngn,dgn,dhn);
  
nfd=[[ 1,1; zeros(nf1-1,2)],nfn(:,3)];
[ng1,ng2]=size(ngn);
ngd=[[ ones(1,ng2-1); zeros(ng1-1,ng2-1)],ngn(:,ng2)];
dhd=dfd+dgd;
[hd,nhn]=mply(fd,nfd,dfd,gd,ngd,dgd,dhd);






% Copyright (c) 2007 by A. J. Krener.
% All rights reserved.
