function [hn,nhn,dhn,hd,dhd]=ratsum(fn,nfn,dfn,fd,dfd,gn,dgn,gd,dgd)
  
% This function adds two rational vector fields F and G and 
% puts them over a common denominator.   
% A rational vector field F is a polynomial vector field FN
% in the numerator and a polynomial FD in the denominator.  
% The dimensions of the numerator vector field are found in NFN.
% It is assumed that the denominator polynomial has the same arguments
% as the numerator polynomial.
% The degrees of the numerator vector field are found in DFN.
% The degrees of the denominator polynomial are found in DFD.
% The same holds for the other rational vector field G and their
% sum H.  At presnt we assume that  NFN=NGN. 

if length(dfn)==1
    dfn=[dfn,dfn];
end

if length(dfd)==1
    dfd=[dfd,dfd];
end

if length(dgn)==1
    dgn=[dgn,dgn];
end

if length(dgd)==1
    dgd=[dgd,dgd];
end


nsum=sum(nfn);
[n1,n2]=size(nfn);
nd=[[1; zeros(n1-1,1)],nfn(:,2)];
nnd=[[1; zeros(n1-1,1)],nd];
nn=[nfn(:,1),[1;zeros(n1-1,1)],nfn(:,2)];
nhn=nfn;

dhn1=[dfn(1,1)+dgd(1,1),dfn(1,2)+dgd(1,2)];
dhn2=[dgn(1,1)+dfd(1,1),dgn(1,2)+dfd(1,2)];
dhd=[dfd(1,1)+dgd(1,1),dfd(1,2)+dgd(1,2)];

hn1=mply(fn,nn,dfn,gd,nd,dgd,dhn1);
hn2=mply(gn,nn,dgn,fd,nd,dfd,dhn2);
hd=mply(fd,nnd,dfd,gd,nd,dgd,dhd);

if dhn1(1,1)< dhn2(1,1)
    hn2=[zeros(nsum(1,1), crdsum(nsum(1,2),[dhn1(1,1),dhn2(1,1)-1])),hn2];
    dhn(1,1)=dhn1(1,1);
elseif  dhn2(1,1)< dhn1(1,1)
    hn1=[zeros(nsum(1,1), crdsum(nsum(1,2),[dhn2(1,1),dhn1(1,1)-1])),hn1];
    dhn(1,1)=dhn2(1,1);
end
dhn=dhn1;
if dhn1(1,2)> dhn2(1,2)
    hn2=[hn2,zeros(nsum(1,1), crdsum(nsum(1,2),[dhn2(1,2)+1,dhn1(1,2)]))];
    dhn(1,2)=dhn1(1,2);
elseif  dhn2(1,2)> dhn1(1,2)
    hn1=[hn1,zeros(nsum(1,1), crdsum(nsum(1,2),[dhn1(1,2)+1,dhn2(1,2)]))];
    dhn(1,2)=dhn2(1,2);
end
hn=hn1+hn2;