function [] = showf(f,n,m) 
%SHOWF(F,N,M)
%
%     SHOWF(F,N,M) 
%   displays the cubic controlled dynamics
%      XDOT=F(X,U)= F1(X,U)+F2(X,U)+F3(X,U)
%   in a labeled format. The dimensions of X and U are N and M.

len = 12; % Label parameter.  Should match parameter in PRINTMAT.

xdotlab = []; xlab = [];ulab = [];
xxlab = []; xulab = []; uulab = [];
xxxlab = []; xxulab = []; xuulab = []; uuulab = []; 
for i=1:n,
 xlab = [xlab; sprintf('         x%-2.0f',i)];
 xdotlab = [xdotlab; sprintf('      xdot%-2.0f',i)];
 for j=i:n,
  xxlab = [xxlab; sprintf('     x%-2.0f*x%-2.0f',i,j)];
  for k = j:n,
   xxxlab = [xxxlab; sprintf(' x%-2.0f*x%-2.0f*x%-2.0f',i,j,k)];
  end %k
  for k = 1:m,
   xxulab = [xxulab; sprintf(' x%-2.0f*x%-2.0f*u%-2.0f',i,j,k)];
  end %k  
 end %j
 for j=1:m,
  xulab = [xulab; sprintf('     x%-2.0f*u%-2.0f',i,j)];
  for k = j:m,
   xuulab = [xuulab; sprintf(' x%-2.0f*u%-2.0f*u%-2.0f',i,j,k)];
  end %k
 end %j
end %i
for i=1:m,
 ulab = [ulab; sprintf('         u%-2.0f',i)];
 for j=i:m
  uulab = [uulab; sprintf('     u%-2.0f*u%-2.0f',i,j)];
  for k = j:m,
   uuulab = [uuulab; sprintf(' u%-2.0f*u%-2.0f*u%-2.0f',i,j,k)];
  end %k
 end %j
end %i
dimensions=[n m]

k=0;l=n;
printmat(f(:,k+1:l),'A',xdotlab,xlab);
if m>0
 k=l;l=l+m;
 printmat(f(:,k+1:l),'B',xdotlab,ulab);
end %if
k=l;l=l+crd(n,2);
printmat(f(:,k+1:l),'f2(x,x)',xdotlab,xxlab);
if m>0
 k=l;l=l+n*m;
 printmat(f(:,k+1:l),'f2(x,u)',xdotlab,xulab);
 k=l;l=l+crd(m,2);
 printmat(f(:,k+1:l),'f2(u,u)',xdotlab,uulab);
end %if
k=l;l=l+crd(n,3);
printmat(f(:,k+1:l),'f3(x,x,x)',xdotlab,xxxlab);
if m>0
 k=l;l=l+crd(n,2)*m;
 printmat(f(:,k+1:l),'f3(x,x,u)',xdotlab,xxulab);
 k=l;l=l+n*crd(m,2);
 printmat(f(:,k+1:l),'f3(x,u,u)',xdotlab,xuulab);
 k=l;l=l+crd(m,3);
 printmat(f(:,k+1:l),'f3(u,u,u)',xdotlab,uuulab);
end %if

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
