function [] = showh(h,n,m,p)
%SHOWH(H,N,M,P)
%
%     SHOWH(H,N,M,P)
%   displays the cubic output map
%      Y=H(X,U)= H1(X,U)+H2(X,U)+H3(X,U)
%   in a labeled format. The dimensions of X, U and Y are N, M
%   and P.


len = 12; % Label parameter.  Should match parameter in PRINTMAT.

ylab = []; xlab = [];ulab = [];
xxlab = []; xulab = []; uulab = [];
xxxlab = []; xxulab = []; xuulab = []; uuulab = []; 
for i=1:n,
 xlab = [xlab; sprintf('         x%-2.0f',i)];
 for j=i:n,
  xxlab = [xxlab; sprintf('     x%-2.0f*x%-2.0f',i,j)];
  for k = j:n,
   xxxlab = [xxxlab; sprintf(' x%-2.0f*x%-2.0f*x%-2.0f',i,j,k)];
  end %k
  for k = 1:m,
   xxulab = [xxulab; sprintf(' x%-2.0f*x%-2.0f*u%-2.0f',i,j,k)];
  end %k  
 end %j
 for j=1:m,
  xulab = [xulab; sprintf('     x%-2.0f*u%-2.0f',i,j)];
  for k = j:m,
   xuulab = [xuulab; sprintf(' x%-2.0f*u%-2.0f*u%-2.0f',i,j,k)];
  end %k
 end %j
end %i
for i=1:m,
 ulab = [ulab; sprintf('         u%-2.0f',i)];
 for j=i:m
  uulab = [uulab; sprintf('     u%-2.0f*u%-2.0f',i,j)];
  for k = j:m,
   uuulab = [uuulab; sprintf(' u%-2.0f*u%-2.0f*u%-2.0f',i,j,k)];
  end %k
 end %j
end %i
for i=1:p
 ylab = [ylab; sprintf('         y%-2.0f',i)];
end %i

dimensions=[n m p]


k=0;l=n;
printmat(h(:,k+1:l),'C',ylab,xlab);
if m>0
 k=l;l=l+m;
 printmat(h(:,k+1:l),'D',ylab,ulab);
end %if
k=l;l=l+crd(n,2);
printmat(h(:,k+1:l),'h2(x,x)',ylab,xxlab);
if m>0
 k=l;l=l+n*m;
 printmat(h(:,k+1:l),'h2(x,u)',ylab,xulab);
 k=l;l=l+crd(m,2);
 printmat(h(:,k+1:l),'h2(u,u)',ylab,uulab);
end %if
k=l;l=l+crd(n,3);
printmat(h(:,k+1:l),'h3(x,x,x)',ylab,xxxlab);
if m>0
 k=l;l=l+crd(n,2)*m;
 printmat(h(:,k+1:l),'h3(x,x,u)',ylab,xxulab);
 k=l;l=l+n*crd(m,2);
 printmat(h(:,k+1:l),'h3(x,u,u)',ylab,xuulab);
 k=l;l=l+crd(m,3);
 printmat(h(:,k+1:l),'h3(u,u,u)',ylab,uuulab);
end %if

% Copyright (c) 1996, 2005 by A. J. Krener.
% All rights reserved.
