function py= zbv(f,l,n,d) 
%zbv(f,l,nf,df)
% 
%     py= zbv(f,l,n,d) 
%   computes a Lyapunov function py of degrees
%   [2 d+1] for the dynamics f of degrees [1,d] and Lagrangian l
%   of degrees [2 d+1] by the method of Zubov, i.e. term by term 
%   solution of the partial differential equation,
%
%     d/dx(py(x))*f(x)= -l(x)
%
%   The Lyapunov equation for the linear part of f and the 
%   quadratic part of l  must be solvable, i.e., there is no complex
%   number lambda such that both lambda and -lambda are eigenvaues of 
%   the linear part of f.
%   
%
%   The input parameters are as follows.
%   f is the state dynamics,
%     x'=f(x).
%   This is a vector field, polynomial of degrees 1 
%   thru d in the state x. 
%   l is the Lagrangian (running cost), l(x). 
%   This is a scalar field, polynomial of degrees 2 thru d+1
%   in the vector x. 
%   The output parameter is py, the possible Lyapunov function.
%   py(x) is polynomial in x of degrees 2 thru d+1.


a= f(:,1:n);
nf=[n,n];
df=[1,d];
dl= [2,d+1];
npy= [1,n];
ii=0;
q=zeros(n,n);
for i=1:n
 ii=ii+1;
 q(i,i)=2*l(1,ii);
 for j=i+1:n
  ii=ii+1;
  q(i,j)=l(1,ii);
  q(j,i)=l(1,ii);
 end %j
end % i
p=lyap2(a',q);
dpy= 2;
ii=1;
for i=1:n
 py(1,ii)=p(i,i)/2;
 ii=ii+1;
 for j=i+1:n
  py(1,ii)=p(i,j);
  ii=ii+1;
 end %j
end %i
clear p q 

% We compute pyj1, the degree j+1 part of the Lyapunov function py
for j=2:d
    temp=prt(f,[n,n],[1,d],[2,j]);
    temp=dd(py,[1,n],[2,j],temp,[n,n],[2,j],j+1);
    temp=temp+prt(l,[1,n],[2,d+1],j+1);
    cj1=crd(n,j+1);
    mat=dd(eye(cj1),[cj1,n],j+1,a,[n,n],1,j+1);
    py=[py,-temp/mat];
end

% Copyright (c) 1996, 2005, 2006 by A. J. Krener.
% All rights reserved.
