      program driver
c
c  Sample driver routine for claw2
c  This program solves the 2D isothermal gas equations 
c
c  Derived from:
c
c  Euler solver
c  Author: Randall J. LeVeque
c  Version of November, 1995  --  CLAWPACK Version 2.1
c
c
c
      implicit double precision (a-h,o-z)
      external bc2ex0,rpn2iso,rpt2iso
      parameter (maxmx = 200)
      parameter (maxmy = 200)
c
c  Equation layout:
c  (1) density \rho, (2,3) velocity u, v
c
      parameter (meqn = 3)  
c
c  We have three waves
c
      parameter (mwaves = 3)
      parameter (mbc = 2)
      parameter (mwork = 178092)
c FIXME: Check dimensions
      dimension     q(1-mbc:maxmx+mbc, 1-mbc:maxmy+mbc, meqn)
      dimension mthlim(mwaves),method(7),dtv(5),cflv(4),nv(2)
      dimension x(1-mbc:maxmx+mbc),y(1-mbc:maxmy+mbc)
      dimension work(mwork)

      common /param/ c

      open(10,file='fort.info',status='unknown',form='formatted')
      open(11,file='fort.nplot',status='unknown',form='formatted')
      open(99,file='fort.dump',status='unknown',form='formatted')
c
c     # check to see if we are restarting from a previous run:
c
      write(6,*) 'restarting from previous run?  0=no, 1=yes '
      read(5,*) irstrt
      if (irstrt .eq. 1) then
c         # restart from a previous run
c         # Note: this assumes data is in the file fort.dump
          call rstrt2(maxmx,maxmy,meqn,mwaves,mbc,mx,my,
     &		      q,t,dxold,dyold,dtv,cflv,nv,method,mthlim,info)
c         # dt and method parameters may be reset by new data below.
 	  t0 = t
	else
	  t0 = 0.d0
	endif
c
c     # Input parameters for this run:
c
      write(6,*) 'input dx and dy.  (grid spacing)'
      read(5,*) dx,dy
      if (irstrt.eq.1) then
	 if (dx.ne.dxold .or. dy.ne.dyold) then
	    write(6,*) 'dx or dy set wrong for restart'
	    stop
	    endif
	 endif
c   
      write(6,*) 'input dt and tend.  (time step and final time)'
      read(5,*) dt,tend
      write(6,*) 'input nout.  (number of solution outputs)'
      read(5,*) nout
      write(6,*) 'input method(1:3)'
      read(5,*) method(1), method(2), method(3)
      write(6,*) 'input mthlim(mw), mw=1,mwaves.'
      read(5,*) (mthlim(mw), mw=1,mwaves)
c
c     Sound speed 
c
c     c = 1.3d-2
      write(6,*) 'input constant sound speed'
      read(5,*) c
c
c     Talk to user
c
      write(6,*) 'running...'
      write(6,*) ' '
c
c
c     # time increments between outputing solution:
      dtout = (tend - t0)/dfloat(nout)
c
      cflv(1) = 1.0d0  !# maximum Courant number allowed
      cflv(2) = 0.9d0  !# desired Courant number
      dtv(1) = dt   !# initial time step
      dtv(2) = 1d6   !# maximum allowed time step
      nv(1) = 500   !# maximum number of time steps to allow
      method(4) = 1 !# print dt, cfl in each step
      method(5) = 0 !# no source term
      method(6) = 0 !# no capacity function
      method(7) = 0 !# maux
c
c     # set up grid 
c
c     # domain is unit square:
      ax = 0.d0
      bx = 1.d0
      ay = 0.d0
      by = 1.d0
      mx = (bx-ax + 1d-10)/dx 
      my = (by-ay + 1d-10)/dy 
c
      do 10 i=1,mx
	 x(i) = ax + (i-0.5d0) * dx
   10    continue
      do 15 j=1,my
	 y(j) = ay + (j-0.5d0) * dy
   15    continue
c
c     # set initial conditions, unless we are restarting:
c
      if (irstrt .eq. 0)  then
c        # 2D Riemann problem 
c        # initial conditions are piecewise constant in 4 quadrants
c        # (or other conditions; chosen by linked-to module)
	 call ic2rp(maxmx,maxmy,meqn,mbc,mx,my,x,y,dx,dy,q)
	 endif
c
c     # output initial data to unit 100
      call out2iso(maxmx,maxmy,meqn,mbc,mx,my,x,y,q,tstart,100)
c
c     ----------
c     Main loop:
c     ----------
c
      do 100 n=1,nout
	 tstart = t0 + (n-1) * dtout
	 tend = t0 + n*dtout
c
         call claw2(maxmx,maxmy,meqn,mwaves,mbc,mx,my,
     &		 q,dummy,dx,dy,tstart,tend,dtv,
     &           cflv,nv,method,mthlim,
     &           work,mwork,info,bc2ex0,rpn2iso,rpt2iso,src2xx)
c
         dtv(1) = dtv(5)  !# use final dt as starting value on next call
c
c        # output solution at this time
         call out2iso(maxmx,maxmy,meqn,mbc,mx,my,x,y,q,tend,100+n)
c
c        # write out information about this call to claw:
c
	 write(6,601) nv(2),tend,info
  601    format('CLAW2 returning after ',i3,' steps,  t =',e10.5,
     &	       '  info =',i3,/)
c
	 write(10,1010) tend,info,dtv(3),dtv(4),dtv(5),
     &		 cflv(3),cflv(4),nv(2)
 1010    format('tend =',d15.4,/,
     &       'info =',i5,/,'smallest dt =',d15.4,/,'largest dt =',
     &       d15.4,/,'last dt =',d15.4,/,'largest cfl =',
     &         d15.4,/,'last cfl =',d15.4,/,'steps taken =',i4,/)
c
c        # check to see if an error occured:
	 if (info .ne. 0) go to 200
  100    continue
c
  200 continue
c     # dump information needed for a possible restart:
      call dump2(maxmx,maxmy,meqn,mwaves,mbc,mx,my,
     &           q,tend,dx,dy,dtv,cflv,nv,method,mthlim,info)
      write(11,1101) nout
 1101 format(i5)
      stop 
      end
