
c
c
c     =====================================================
      subroutine rpn2iso(ixy,maxm,meqn,mwaves,mbc,mx,ql,qr,auxl,auxr,
     &                  wave,s,amdq,apdq)
c     =====================================================
c
c     # Roe-solver for isothermal gas flow
c     # solve Riemann problems along one slice of data.
c
c     # On input, ql contains the state vector at the left edge of each cell
c     #           qr contains the state vector at the right edge of each cell
c
c     # This data is along a slice in the x-direction if ixy=1 
c     #                            or the y-direction if ixy=2.
c     # On output, wave contains the waves, s the speeds, 
c     # and amdq, apdq the decomposition of the flux difference
c     #   f(qr(i-1)) - f(ql(i))  
c     # into leftgoing and rightgoing parts respectively.
c     # With the Roe solver we have   
c     #    amdq  =  A^- \Delta q    and    apdq  =  A^+ \Delta q
c     # where A is the Roe matrix.  An entropy fix can also be incorporated
c     # into the flux differences.
c
c     # Note that the i'th Riemann problem has left state qr(i-1,:)
c     #                                    and right state ql(i,:)
c     # From the basic clawpack routines, this routine is called with ql = qr
c
c
      implicit double precision (a-h,o-z)
c
      dimension wave(1-mbc:maxm+mbc, meqn, mwaves)
      dimension    s(1-mbc:maxm+mbc, mwaves)
      dimension   ql(1-mbc:maxm+mbc, meqn)
      dimension   qr(1-mbc:maxm+mbc, meqn)
      dimension  apdq(1-mbc:maxm+mbc, meqn)
      dimension  amdq(1-mbc:maxm+mbc, meqn)
c
c     local arrays -- common block comroe is passed to rpt2iso
c     ------------
      parameter (maxm2 = 202)  !# assumes at most 200x200 grid with mbc=2
      dimension delta(3)
      logical efix
      common /param/  c  !# the constant sound speed
      common /comroe/ u(-1:maxm2),v(-1:maxm2)
c
      data efix /.false./    !# no entropy fix for transonic rarefactions
c
      if (-1.gt.1-mbc .or. maxm2 .lt. maxm+mbc) then
         write(6,*) 'need to increase maxm2 in rpA'
         stop
         endif
c
c     # set mu to point to  the component of the system that corresponds
c     # to velocity in the direction of this slice, mv to the orthogonal
c     # velocity:
c
      if (ixy.eq.1) then
          mu = 2
          mv = 3
        else
          mu = 3
          mv = 2
        endif
c
c     # note that notation for u and v reflects assumption that the 
c     # Riemann problems are in the x-direction with u in the normal
c     # direction and v in the orthogonal direction, but with the above
c     # definitions of mu and mv the routine also works with ixy=2
c     # and returns, for example, f0 as the Godunov flux g0 for the
c     # Riemann problems u_t + g(u)_y = 0 in the y-direction.
c
c
c     # compute the Roe-averaged variables needed in the Roe solver.
c     # These are stored in the common block comroe since they are
c     # later used in routine rpt2iso to do the transverse wave splitting.
c
      do 10 i = 2-mbc, mx+mbc
c     #  \sqrt\rho LEFT/RIGHT
         rhsqrtl = dsqrt(qr(i-1,1))
         rhsqrtr = dsqrt(ql(i,1))
c     #  divisor
         rhsq2 = rhsqrtl + rhsqrtr
c     #  averaged states
         u(i) = (qr(i-1,mu)*rhsqrtl + ql(i,mu)*rhsqrtr) / rhsq2
         v(i) = (qr(i-1,mv)*rhsqrtl + ql(i,mv)*rhsqrtr) / rhsq2
   10    continue
c     
c
c     # now split the jump in q at each interface into waves
c
c     # find a1 thru a3 (\alpha_i^1, \dots, \alpha_i^3, the `wave strengths'), 
c     # the coefficients of the 3 eigenvectors:
c
      do 20 i = 2-mbc, mx+mbc
c     #  jumps
         delta(1) = ql(i,1) - qr(i-1,1)
         delta(2) = ql(i,mu) - qr(i-1,mu)
         delta(3) = ql(i,mv) - qr(i-1,mv)
c     #  wave strengths, \alpha_i^k = R^{-1) delta(k)
c     #  c is the constant sound speed.
         a1 = ((u(i) + c) * delta(1) - delta(2)) / (2.d0 * c)
         a2 = (-2.d0 * c * v(i) * delta(1) + 2.d0 * c * delta(3)) 
     &        / (2.d0 * c)  
         a3 = ((-u(i) + c) * delta(1) + delta(2)) / (2.d0 * c)
c
c     # Compute the waves.
c     # wave 1
c
         wave(i,1,1) = a1
         wave(i,mu,1) = a1*(u(i)-c)
         wave(i,mv,1) = a1*v(i)
         s(i,1) = u(i) - c
c
c     # wave 2
c     
         wave(i,1,2) = 0
         wave(i,mu,2) = 0
         wave(i,mv,2) = a2
         s(i,2) = u(i)
c
c     # wave 3
c
         wave(i,1,3) = a3
         wave(i,mu,3) = a3*(u(i)+c)
         wave(i,mv,3) = a3*v(i)
         s(i,3) = u(i) + c
 20   continue
c
c     # no entropy fix
c     ----------------
c
c     # amdq = SUM s*wave   over left-going waves
c     # apdq = SUM s*wave   over right-going waves
c
      do 100 m=1,3
         do 100 i=2-mbc, mx+mbc
            amdq(i,m) = 0.d0
            apdq(i,m) = 0.d0
            do 90 mw=1,mwaves
               if (s(i,mw) .lt. 0.d0) then
                   amdq(i,m) = amdq(i,m) + s(i,mw)*wave(i,m,mw)
                 else
                   apdq(i,m) = apdq(i,m) + s(i,mw)*wave(i,m,mw)
                 endif
   90          continue
  100       continue
      go to 900     

  900 continue
      return
      end
