#include "rbtree.h"

template <class T>
void TRedBlackTree<T>::Insert(T Content)
{
  TNode *u = new TRedBlackNode<T>(Content, &Nil);
  FindRef(Content, u->Parent) = u;
  TNode *v = u->Parent;
  while (IsRed(v)) {
    TNode *w = v->Parent;
    // 1-Baum-Eigenschaft verletzt
    if (v == Root) {
      // Special case f"ur Kinder der Wurzel
      v->Red = false;
      return;
    }
    else {
      if (IsLeft(v)) {
	// Vater is links
	if (IsRed(SiblingRef(v))) {
	  // Onkel ist rot
	  v->Red = false;
	  SiblingRef(v)->Red = false;
	  w->Red = true;
	  u = w, v = u->Parent;
	  // no return; next iteration
	}
	else {
	  // Onkel ist schwarz
	  if (IsRight(u)) {
	    // u ist rechtes Kind
	    RotateLeft(v);
	    w->Red = true;
	    u->Red = false;
	    RotateRight(w);
	    return;
	  }
	  else {
	    // u ist linkes Kind
	    w->Red = true;
	    v->Red = false;
	    RotateRight(w);
	    return;
	  }
	}
      }
      else {
	// Vater ist rechts
	if (IsRed(SiblingRef(v))) {
	  // Onkel ist rot
	  v->Red = false;
	  SiblingRef(v)->Red = false;
	  w->Red = true;
	  u = w, v = u->Parent;
	  // no return; next iteration
	}
	else {
	  // Onkel ist schwarz
	  if (IsLeft(u)) {
	    // u ist rechtes Kind
	    RotateRight(v);
	    w->Red = true;
	    u->Red = false;
	    RotateLeft(w);
	    return;
	  }
	  else {
	    // u ist linkes Kind
	    w->Red = true;
	    v->Red = false;
	    RotateLeft(w);
	    return;
	  }
	}
      }
    }
  }
}

template <class T>
int TRedBlackTree<T>::Height()
{
  int MaxHeight = 0;
  int CurHeight = 0;
  // Traverse the tree in-order
  TNode *Node = Root;
  TNode *Last = &Nil;
  while (Node != &Nil) {
    if (Node->Left != &Nil && Node->Left != Last && Node->Right != Last)
      Last = Node, Node = Node->Left, CurHeight++;
    else if (Node->Right != &Nil && Node->Right != Last)
      Last = Node, Node = Node->Right, CurHeight++;
    else {
      if (CurHeight > MaxHeight) MaxHeight = CurHeight;
      Last = Node, Node = Node->Parent, CurHeight--;
    }
  }
  return MaxHeight;
}

template <class T>
void TRedBlackTree<T>::DeleteFixup(TRedBlackNode<T> *x)
{
  while (x != Root && IsBlack(x)) {
    TNode *w = SiblingRef(x);
    if (IsLeft(x)) {
      if (IsRed(w)) {
	w->Red = false;
	x->Parent->Red = true;
	RotateLeft(x->Parent);
	w = SiblingRef(x);
      }
      if (IsBlack(w->Left) && IsBlack(w->Right)) {
	w->Red = true;
	x = x->Parent;
      } 
      else {
	if (IsBlack(w->Right)) {
	  w->Left->Red = false;
	  w->Red = true;
	  RotateRight(w);
	  w = SiblingRef(x);
	}
	w->Red = x->Parent->Red;
	x->Parent->Red = false;
	w->Right->Red = false;
	RotateLeft(x->Parent);
	x = Root;
      }
    }
    else {
      if (IsRed(w)) {
	w->Red = false;
	x->Parent->Red = true;
	RotateRight(x->Parent);
	w = SiblingRef(x);
      }
      if (IsBlack(w->Right) && IsBlack(w->Left)) {
	w->Red = true;
	x = x->Parent;
      } 
      else {
	if (IsBlack(w->Left)) {
	  w->Right->Red = false;
	  w->Red = true;
	  RotateLeft(w);
	  w = SiblingRef(x);
	}
	w->Red = x->Parent->Red;
	x->Parent->Red = false;
	w->Left->Red = false;
	RotateRight(x->Parent);
	x = Root;
      }
    }
  }
  x->Red = false;
}

template <class T>
void TRedBlackTree<T>::Delete(T Content)
{
  TNode *z = Find(Content);
  TNode *y = (z->Left == &Nil || z->Right == &Nil) ? z : Successor(z);
  TNode *x;
  if (y->Left != &Nil) x = y->Left; else x = y->Right;
  x->Parent = y->Parent;
  ThisRef(y) = x;
  if (y != z) z->Content = y->Content;
  if (IsBlack(y)) DeleteFixup(x);
}

template <class T>
TRedBlackNode<T> *
TRedBlackTree<T>::Minimum(TRedBlackNode<T> *x)
{
  while (x->Left != &Nil) x = x->Left;
  return x;
}

template <class T>
TRedBlackNode<T> *
TRedBlackTree<T>::Successor(TRedBlackNode<T> *x)
{
  if (x->Right != &Nil) return Minimum(x->Right);
  TNode *y = x->Parent;
  while (y != &Nil && IsRight(x)) {
    x = y;
    y = x->Parent;
  }
  return y;
}
