// This is a -*- C++ -*- header file.

#if !defined(_RBTREE_H_)
#define _RBTREE_H_

template <class T>
class TRedBlackNode {
public:
  T Content;
  bool Red;
  TRedBlackNode *Parent;
  TRedBlackNode *Left, *Right;
  inline TRedBlackNode(T content, TRedBlackNode<T> *nil = 0, bool r = true);
};

template <class T>
class TRedBlackTree {
  friend class TRedBlackNode<T>;
public:
  typedef TRedBlackNode<T> TNode;
  typedef T TElement;
  /*static*/ TNode Nil;
  TRedBlackTree() : Nil(0, &Nil, false), Root(&Nil) {}
  void Insert(T Content);
  void Delete(T Content);
  int Height();
  TNode *Successor(TNode *);
  TNode *Minimum(TNode *);
  TNode *Find(T Content) {
    TNode *Parent;
    return FindRef(Content, Parent);
  }
private:
  TNode *Root;
  bool IsRed(TNode *node) {
    return node->Red;
  }
  bool IsBlack(TNode *node) {
    return !IsRed(node);
  }
  bool IsLeft(TNode *node) {
    return node->Parent->Left == node;
  }
  bool IsRight(TNode *node) {
    return node->Parent->Right == node;
  }
  TNode *&ThisRef(TNode *child) {
    if (child == Root) return Root;
    if (child->Parent->Left == child) return child->Parent->Left;
    return child->Parent->Right;
  }
  TNode *&SiblingRef(TNode *child) {
    //    if (child == Root) return Nil;
    if (child->Parent->Left == child) return child->Parent->Right;
    return child->Parent->Left;
  }    
  void RotateLeft(TNode *Center) {
    TNode *x = Center;
    TNode *y = x->Right;
    TNode *z = x->Parent;
    TNode *B = y->Left;
    ThisRef(x) = y, y->Parent = z;
    y->Left = x, x->Parent = y;
    x->Right = B; if (B) B->Parent = x;
  }
  void RotateRight(TNode *Center) {
    TNode *x = Center->Left;
    TNode *y = Center;
    TNode *z = Center->Parent;
    TNode *B = x->Right;
    ThisRef(y) = x, x->Parent = z;
    y->Left = B; if (B) B->Parent = y;
    x->Right = y, y->Parent = x;
  }
  TNode *&FindRef(T Content, /*return*/ TNode *&Parent) {
    // Returns a reference to the found node;
    // Parent is assigned the parent of that.
    TNode **Node = &Root;
    Parent = &Nil;
    while (*Node != &Nil && (**Node).Content != Content) {
      Parent = *Node;
      if (Content < (**Node).Content) Node = &(*Node)->Left;
      else Node = &(*Node)->Right;
    }
    return *Node;
  }
  void DeleteFixup(TNode *x);
};

template <class T>
inline TRedBlackNode<T>::TRedBlackNode(T content, TRedBlackNode<T> *nil = 0, bool r = true) :
  Content(content),
  Parent(nil), Left(nil), Right(nil),
  Red(r) {}

#endif

