# Integral of a monomial over a simplex,  
# by iterated Laurent expansions. 
# The  integer d is the dimension;
# A vector in Q^d is a list of d rational numbers.
# A vertex is a vector in Q^d;
# The simplex  S is the convex hull of its vertices s_i. 
# Thus S is encoded as a list of vectors
# in Q^d.
# If the simplex is of full dimension, we have (d+1) vertices.  

#  A linear forms is called alpha, it is  represented by  a vector in Q^d.
# A monomial m is a list of d integers.
# 
printlevel:=0;with(LinearAlgebra): 
#  Laurent expansions
# 
# This is the truncated exponential.
trunc_exp:=proc(x,N);
add(x^n/n!,n=0..N);
end:
with(numapprox,laurent):
# INPUT:     P is a polynomial  in variable x.
# OUTPUT: [k,newP] . k is a non negative integer. newP a polynomial  in variable x.
# MATH:     k is the order of vanishing of P at x=0. newP =P/x^k
# -------------------------------------------------------------------------------------------------------
factor_pole_out:=proc(P,x) local k,newP;
k:=0;
newP:=P;
while evalb(subs(x=0,newP)=0)=true do
     k:=k+1;
     newP:=simplify(newP/x);
od;
[k,newP];
end:
# INPUT:     P,Q polynomials  in one variable x with coefficients expressions. 
# OUTPUT:   expression
# MATH:      coefficient of degree j in the Laurent expansion of R=P/Q at x=0
#                    Attention: If 0 is a pole of order k, then laurent (R,x,j) returns  the expansion at order j-k .
#                    Thus we factor out the pole prior to computing the Laurent expansion.
# --------------------------------------------------------------------------------------------------------------------------------------------
Laurent_coeff:=proc(P,Q,x,j) local newQ,R,k,L;
newQ:=factor_pole_out(Q,x)[2];
R:=P/newQ;
k:=factor_pole_out(Q,x)[1];
L:=convert(laurent(R,x,j+k+1),polynom);
coeff(L,x,j+k);
end:
# ------------------------------------------------------------------------------------------------------------------------
# INPUT. vertex :: vector in Q^d
#               U:: list of n vectors in Q^d 
# MATH: 
#             The procedure returns the coefficient of v[1]^m[1] ... v[d]^m[d]
#             in   the meromorphic function e^<v,vertex>/prod(<v,U_j>, expanded using iterated Laurent series. 
# ----------------------------------------------------------------------------------------------------------------------
vertex_expansion:=proc(vertex,U,d,m) local P,Q,n,k,N,R;
n:=nops(U);             
R:=1/product(add(v[k]*U[i][k],k=1..d),i=1..n); 
for k from d to 1 by -1 do           # print("k",k);  
     N:=add(m[i],i=k..d)+n;  
     P:=numer(R)*trunc_exp(v[k]*vertex[k],N);
     Q:=denom(R); 
     R:=Laurent_coeff(P,Q,v[k],m[k]);
od;
R;
end:
# We now will do an iterated expansion depending of the exponent m.
# Here the input is a monomial m: a list of d integers. The output is a permuation of [1,...,d].
# Exemple m:=[2,0,2,0]; the output is [2,4,1,3].
 new_path:=proc(m) local l,out,i,newm,M; 
out:=[];  newm:=m; M:=add(m[i],i=1..nops(m));
l:=sort(m); 
for i from 1 to nops(m) do 
if member(l[i],newm,'k')=true 
then out:=[op(out),k];
newm:=subsop(k=M+1,newm);
fi;
od; 
out;
end:
out:=[]; 
# INPUT. vertex :: vector in R^d
#               U:: list of n vectors in R^d 
# MATH: 
#             The procedure returns the coefficient of v[1]^m[1] ... v[d]^m[d]
#             in   the meromorphic function e^<v,vertex>/prod(<v,U_j>, expanded using iterated Laurent series. We start the expansion by the variable v[i] where m[i] is the smallest. 
reorder_vertex_expansion:=proc(vertex,U,d,m) local P,Q,n,k,N,R,new,M;
n:=nops(U);
M:=add(m[i],i=1..d);
new:=new_path(m);             
R:=1/product(add(v[k]*U[i][k],k=1..d),i=1..n); 
for k from 1 to d  do  
P:=numer(R)*trunc_exp(v[new[k]]*vertex[new[k]],M+d); 
     Q:=denom(R); 
     R:=Laurent_coeff(P,Q,v[new[k]],m[new[k]]);
od;
R;
end:
# Here the input is a simplex S, d the dimension and m a monomial.
# The output is the integral \int_S x_1^(m1)...x_d^(md).
integral_monome_via_iterated:=proc(S,d,m)local A,i,U,DD;
A:=0; 
for i from 1 to d+1 do
    U:=[seq(S[j]-S[i],j=1..i-1),seq(S[j]-S[i],j=i+1..d+1)];     
    A:= A+reorder_vertex_expansion(S[i],U,d,m);  
od; 
DD:=abs(Determinant(Matrix([seq(S[j]-S[1],j=2..d+1)])));      
DD*(-1)^d*product(m[t]!,t=1..d)*A;
end:
cleaned_set:=proc(L) local newL,subL,X,i;
newL:=[]; 
for i from 1 to nops(L) do 
if L[i][1]<>0 then
newL:=[op(newL),L[i]];
fi;
od;
subL:={seq(newL[s][2],s=1..nops(newL))};
X:=add(newL[s][1]*x[newL[s][2]],s=1..nops(newL));
{seq([coeff(X,x[subL[i]],1),subL[i]],i=1..nops(subL))};
end:
# The input is a simplex S, d the dimension, sparse_poly a sparse polynomial. 
# The ouput is a number; the integral over S of the polynomial.
integral_via_iterated:=proc(S,d,sparse_poly)
local n,i,output,new_sparse_poly;
output:=0;
new_sparse_poly:=cleaned_set(sparse_poly);
n:=nops(new_sparse_poly);

for i from 1 to n do 
output:=output+integral_monome_via_iterated(S,d,new_sparse_poly[i][2])*new_sparse_poly[i][1];
   od;
end:

