&  VW:\g82    d                                                                               ԭ  XW:&XW:
3    d  Z                                                           K  x9\g8:%2    d                                                                                              .  TW:\g8:%2    d                                                                   o]W:\g8:%2    d  system
    WinUnlock ();
}



void Window::MoveAbs (Point dP)
// Move the window to an absolute position
{
    MoveRel (dP - OBounds.A);
}



void Window::MoveRel (Point dP)
// The window is moved by the given dX/dY
{
    // Lock the window system
    WinLock ();

    if (IsVisible ()) {

	// Remember old coordinates
	Rect OldOBounds = OBounds;

	// Move window
	OBounds.Move (dP.X, dP.Y);
	IBounds.Move (dP.X, dP.Y);

	// If the window is moved not more than 4 units in combined
	// X and Y direction, redraw the union of both rectangles
	if ( (abs (dP.X) + abs (dP.Y)) > 4) {

	    // Update old area, this resets a possibly set dirty flag
	    Background->UpdateScreen (OldOBounds);

	    // Update new area
	    Background->UpdateScreen (OBounds);

	} else {

	    // Update combined area
	    Background->UpdateScreen (Union (OldOBounds, OBounds));

	}

    } else {
	OBounds.Move (dP.X, dP.Y);
	IBounds.Move (dP.X, dP.Y);
    }

    // Unlock the window system
    WinUnlock ();
}



void Window::SetState (u16 State)
// Set the state of the wfActive and wfVisible flags according to the
// values contained in NewFlags.
{
    switch (State & (wfActive | wfVisible)) {

	case wfActive | wfVisible:
	    // Both flags should be set. To avoid redrawing the area twice,
	    // just set the wfVisible Flag and call Activate. Activate will
	    // call Show if the wfVisible flag is set, after redrawing the
	    // frame, so the area is only output once
	    Flags |= wfVisible;
	    Activate ();
	    break;

	case wfActive:
	    // This one is simple...
	    Activate ();
	    break;

	case wfVisible:
	    // This one is simple...
	    Show ();
	    break;

	case 0:
	    // Hide the window. This will reset the wfActive flag
	    Hide ();
	    break;

    }
}



void Window::NewOptions (u16 NewOps)
{
    u16 OldOps = Options;
    Options    = NewOps;

    // Check if anything has changed
    if ((NewOps & cfCenterAll) != (OldOps & cfCenterAll)) {
	// Re-center the window
	Rect NewBounds (OBounds);
	NewBounds.Center (Background->OuterBounds (), Options);
	MoveAbs (NewBounds.A);
    }
}



void Window::MoveResizeAfterLoad (const Point& OldRes)
// This function is called after a load when most of the window is
// constructed. It is used to move the window to a new position if this is
// needed. OldRes is the old screen resolution that was active, when the
// window was stored.
// The default is to recenter the window if the apropriate flags are set
// and the screen resolution has changed.
{
    // If the screen size has changed and some of the center options
    // are set, recenter the window.
    if (Background->OuterBounds ().Size () != OldRes && (Options & cfCenterAll) != 0) {
	// Screen size has changed
	Rect NewBounds (OBounds);
	NewBounds.Center (Background->OuterBounds (), Options);
	MoveAbs (NewBounds.A);
    }
}



void Window::Hide ()
// Hide the window. The window is no longer visible after calling this
// function but any window output is still allowed.
{
    if (IsVisible ()) {

	// Do not lock the window but reset the wfVisible flag before calling
	// (eventually) Deactivate. If the wfVisible flag is reset, there
	// will be no screen I/O anyway.
	Flags &= ~wfVisible;
	if (IsActive ()) {
	    Deactivate ();
	}
	Background->UpdateScreen (OBounds);
    }
}



void Window::Show ()
// Show a previously hidden window. This does not put the window in front
// of other windows, so the window may still be covered.
{
    if (!IsVisible ()) {
	Flags |= wfVisible;
	Background->UpdateScreen (OBounds);
    }
}

                             
 
 
 
 
 
 
 
 
 	
 

 
 
 

 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
  
 !
 "
 #
 $
 %
 &
 '
 (
 )
 *
 +
 ,
 -
 .
 /
 0
 1
 2
 3
 4
 5
 6
 7
 8
 9
 :
 ;
 <
 =
 >
 ?
 @
 A
 B
 C
 D
 E
 F
 G
 H
 I
 J
 K
 L
 M
 N
 O
 P
 Q
 R
 S
 T
 U
 V
 W
 X
 Y
 Z
 [
 \
 ]
 ^
 _
 `
 a
 b
 c
 d
 e
 f
 g
 h
 i
 j
 k
 l
 m
 n
 o
 p
 q
 r
 s
 t
 u
 v
 w
 x
 y
 z
 {
 |
 }
 ~
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
          
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
                                                                                                                                                                                 