unit Bgi;

{ Metafiling and/or Coordinate Translation for BGI Routines, Version 1.60
  Copr. 1994,95 Matthias Kppe

  This unit redefines all BGI drawing routines and coordinate functions
  for use with Gr and MetaGraph.

  The routines marked with "NO META" are not metafiled, but coordinates
  are modified.
}

{$G+,X+}

interface

uses Graph;

{ Retrieving coordinates 
}
function GetX: Integer;					{ NO META }
function GetY: Integer;					{ NO META }

{ Pixel-oriented routines 
}
procedure PutPixel(X, Y: Integer; Pixel: Word);
function GetPixel(X, Y: Integer): Word;			{ NO META }

{ Line-oriented primitives 
}
procedure SetWriteMode(WriteMode: Integer);
procedure LineTo(X, Y: Integer);
procedure LineRel(Dx, Dy: Integer);
procedure MoveTo(X, Y: Integer);
procedure MoveRel(Dx, Dy: Integer);
procedure Line(x1, y1, x2, y2: Integer);
procedure SetLineStyle(LineStyle: Word; Pattern: Word; Thickness: Word);

{ Linearly bounded primitives 
}
procedure Rectangle(x1, y1, x2, y2: Integer);
procedure Bar(x1, y1, x2, y2: Integer);
procedure Bar3D(x1, y1, x2, y2: Integer; Depth: Word; Top: Boolean);
procedure DrawPoly(NumPoints: Word; var PolyPoints);
procedure FillPoly(NumPoints: Word; var PolyPoints);
procedure SetFillStyle(Pattern: Word; Color: Word);
procedure SetFillPattern(Pattern: FillPatternType; Color: Word);
procedure FloodFill(X, Y: Integer; Border: Word);

{ Nonlinearly bounded primitives 
}
procedure Arc(X, Y: Integer; StAngle, EndAngle, Radius: Word);
procedure GetArcCoords(var ArcCoords: ArcCoordsType);	{ NO META }
procedure Circle(X, Y: Integer; Radius: Word);
procedure Ellipse(X, Y: Integer;
  StAngle, EndAngle: Word; XRadius, YRadius : Word);
procedure FillEllipse(X, Y: Integer; XRadius, YRadius : Word);
procedure SetAspectRatio(Xasp, Yasp: Word);
procedure PieSlice(X, Y: Integer; StAngle, EndAngle, Radius: Word);
procedure Sector(X, Y: Integer;
  StAngle, EndAngle, XRadius, YRadius: Word);

{ Color routines 
}
procedure SetBkColor(ColorNum: Word);
procedure SetColor(Color: Word);

{ Bitmap utilities 
}
procedure GetImage(x1, y1, x2, y2: Integer; var BitMap);	{ NO META }
procedure PutImage(X, Y: Integer; var BitMap; BitBlt: Word);

{ Text routines 
}
procedure OutText(TextString: string);
procedure OutTextXY(X, Y: Integer; TextString: string);
procedure SetTextJustify(Horiz, Vert: Word);
procedure SetTextStyle(Font, Direction: Word; CharSize: Word);
procedure SetUserCharSize(MultX, DivX, MultY, DivY: Word);

{ *BGI Management 
}

{ Gr-Clipping fr andere BGI-Routinen
}
var
  BgiX: Integer;
  BgiY: Integer;

function GrClipBgi: Boolean;

{ Bgi Clipping Mode
}
const
  bcmUpdAlways = 0;
  bcmUpdNever  = 1;
  bcmUpdStop   = 2;
  bcmUpdOnReq  = 3;

  bcsNoUpd     = 0;
  bcsUpdOrigin = 1;
  bcsUpdAll    = 2;
  bcsMeta      = $100;

const
  BgiClipMode: Word = bcmUpdAlways;
  BgiClipState: Word = bcsNoUpd;

{ Exported line routine						User01
}
const
  qLine = 50;

{ Bgi Clipping Notification					User02
}
const
  qNotifyClip = 50;

procedure NotifyClip(Msg: Word);

{ Bgi Init Graphics						User03
}
const
  qInitBgiGraph = 50;

function InitBgiGraph: Boolean;

{ Bgi Close Graphics						User04
}
const
  qCloseBgiGraph = 50;

procedure CloseBgiGraph;

{ Bgi Set Active Page						User05
}
const
  qSetBgiPage = 50;

procedure SetBgiPage;

{ Bgi Change Params						User06
}
const
  qChBgiParams = 50;

function ChBgiParams(Cmd: Word; var Buf): Word;

{ Path to Bgi Driver, determined by initialization code
}
var
  PathToDriver: string[79];

implementation {  }

uses Gr, Misc, BgiRen;

{$ifdef exe}
procedure EgaVgaDriverProc; external;
{$L EGAVGA.OBJ }
{$endif}

const
  NeedToDraw: Boolean = true;

{$L bgimeta.obj (bgimeta.asm) }

function GetX; external;
function GetY; external;
procedure PutPixel; external;
function GetPixel; external;
procedure SetWriteMode; external;
procedure LineTo; external;
procedure LineRel; external;
procedure MoveTo; external;
procedure MoveRel; external;
procedure Line; external;
procedure SetLineStyle; external;
procedure Rectangle; external;
procedure Bar; external;
procedure Bar3D; external;
procedure DrawPoly; external;
procedure FillPoly; external;
procedure SetFillStyle; external;
procedure SetFillPattern; external;
procedure FloodFill; external;
procedure Arc; external;
procedure GetArcCoords; external;
procedure Circle; external;
procedure Ellipse; external;
procedure FillEllipse; external;
procedure SetAspectRatio; external;
procedure PieSlice; external;
procedure Sector; external;
procedure SetBkColor; external;
procedure SetColor; external;
procedure GetImage; external;
procedure PutImage; external;
procedure OutText; external;
procedure OutTextXY; external;
procedure SetTextJustify; external;
procedure SetTextStyle; external;
procedure SetUserCharSize; external;

{ 
}

procedure UpdateOrigin; near;
Begin
  BgiX := DrawOrigin.x - ClipRect.A.x;
  BgiY := DrawOrigin.y - ClipRect.A.y;
  If (Hi(BgiClipState) <> 0) and (MetaState and ms_Record = 0) then Begin
    Inc(BgiX, MetaOrigin.x);
    Inc(BgiY, MetaOrigin.y)
  End;
  BgiClipState := bcsNoUpd;
End;

function ClipChanged: Boolean; near;
var
  ViewPort: ViewPortType;
Begin
  Graph.GetViewSettings(Viewport);
  with ViewPort do
  with ClipRect do
  ClipChanged := (x1 <> A.x) or (y1 <> A.y) or
    (x2 <> B.x - 1) or (y2 <> B.y - 1)
End;

procedure UpdateAll; near;
var
  x, y: Integer;
Begin
  If ClipChanged
  then Begin
    x := Graph.GetX - BgiX;
    y := Graph.GetY - BgiY;
    with ClipRect do Begin
      NeedToDraw := not Empty;
      If NeedToDraw then Begin
	Graph.SetViewPort(A.x, A.y, B.x - 1, B.y - 1, true);
	UpdateOrigin
      End
    End;
    Graph.MoveTo(x + BgiX, y + BgiY)
  End
  else UpdateOrigin
End;

procedure Clip; near; assembler;
{ Out:	AX BgiX
	DX BgiY }
Asm
	CMP	BgiClipMode, bcmUpdAlways
	JNZ	@@1
@@3:	CALL	UpdateAll
	JMP	@@2
@@1:	CMP	BgiClipState.Byte, bcsNoUpd
	JZ	@@2
	TEST	BgiClipState.Byte, bcsUpdAll
	JNZ	@@3
	CALL	UpdateOrigin
@@2:	MOV	AX, BgiX
	MOV	DX, BgiY
	MOV	BgiClipState.1.Byte, 0
End;

function GrClipBgi: Boolean; assembler;
asm
	call    Clip
	mov	al, NeedToDraw
End;

procedure NotifyClip; assembler;
Asm
	TEST	MetaState, ms_Record
	JZ	@@NR
	PUSH	0			{ Locals }
	PUSH	2			{ Params }
	PUSH	0
	MOV	AX, 3			{ pushed }
	CALL	[ExtSave]
	MOV	BgiClipState.1.Byte, 1
@@NR:	MOV	AX, Msg
	CMP	BgiClipMode, bcmUpdAlways
	JZ	@@2
	CMP	BgiClipMode, bcmUpdOnReq
	JNZ	@@4
	CMP	AX, gcnUpdAll
	JNZ	@@5
	CALL	UpdateAll
	JMP	@@0
@@5:	CMP	AX, gcnUpdOrigin
	JNZ	@@2
	CALL	UpdateOrigin
	JMP	@@0
@@4:	CMP	AX, gcnUpdAll
	JNZ	@@1
	OR	BgiClipState, bcsUpdAll
	JMP	@@0
@@1:	CMP	AX, gcnUpdOrigin
	JNZ	@@2
	OR	BgiClipState, bcsUpdOrigin
	JMP	@@0
@@2:    MOV	AH, BYTE PTR BgiClipMode
	CMP	AL, gcnUpdOnReq
	MOV	DX, bcmUpdOnReq
	JZ	@@3
	CMP	AX, gcnStopUpd + 256 * bcmUpdAlways
	MOV	DX, bcmUpdStop
	JZ	@@3
	CMP	AX, gcnContUpd + 256 * bcmUpdStop
	MOV	DX, bcmUpdAlways
	JZ	@@3
	CMP	AL, gcnHaltUpd
	MOV	DX, bcmUpdNever
	JZ	@@3
	CMP	AX, gcnStartUpd + 256 * bcmUpdNever
	MOV	DX, bcmUpdAlways
	JNZ	@@0
@@3:	MOV	BgiClipMode, DX
	CMP	AH, bcmUpdAlways
	JNZ	@@6
	CMP	AL, DL
	JZ	@@0
	CALL	UpdateAll		{ Anpassen }
	JMP	@@0
@@6:	CMP	DL, bcmUpdOnReq
	JNZ	@@0
	CALL	Clip			{ Anforderungen bereinigen }
@@0:	MOV	BgiClipState.1.Byte, 0
End;

function InitBgiGraph: Boolean; assembler;
var
  m, d: Integer;
Asm
	MOV	AX, GrMode
	CMP	AX, grVgaHiStd
	JA	@@2
	CALL	NEAR PTR @@1
	DW	Vga, 	VgaLo
	DW	Vga,	VgaLo
	DW	Vga,	VgaMed
	DW	Vga,	VgaMed
	DW	Vga,	VgaMed
	DW	Vga,	VgaHi
@@1:	SHL	AX, 2
	POP	SI
	CLD
	PUSH	SS
	POP	ES
	ADD	SI, AX
	LEA	DI, d
	PUSH	SS
	PUSH	DI
	SEGCS
	LODSW
	STOSW
	PUSH	SS
	PUSH	DI
	SEGCS
	LODSW
	STOSW
	PUSH	DS
	PUSH	OFFSET PathToDriver
	CALL	Graph.InitGraph
	CALL	GraphResult
	CMP	AX, grOK
	MOV	AL, 1
	JZ	@@3
@@2:	XOR	AL, AL
@@3:	mov	GrActive, AL		{ only for compatibility }
End;

procedure CloseBgiGraph; assembler;
Asm
	CALL	Graph.CloseGraph
End;

procedure SetBgiPage; assembler;
Asm
	PUSH	Gr.ActivePage
	CALL	Graph.SetActivePage
End;

function ChBgiParams;
Begin
  case Lo(Cmd) of
    gcpColor:
    begin
      ChBgiParams := SizeOf(Word);
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  SetColor(Word(Buf));
	Hi(gcpGetParams):
	  Word(Buf) := GetColor;
      end
    end;
    gcpLineStyle:
    begin
      ChBgiParams := SizeOf(LineSettingsType);
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  with LineSettingsType(Buf) do
	  SetLineStyle(LineStyle, Pattern, Thickness);
	Hi(gcpGetParams):
	  GetLineSettings(LineSettingsType(Buf));
      end
    end;
    gcpSolidThLn:
    begin
      ChBgiParams := SizeOf(Word);
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  SetLineStyle(SolidLn, 0, Word(Buf));
      end
    end;
  else ChBgiParams := 0;
  end
End;

Begin
  PathToDriver := GetBgiDir;
{$ifdef exe}
  RegisterBgiDriver(@EgaVgaDriverProc);
{$endif}
  If qLine > qLineProc then Begin
    qLineProc := qLine;
     LineProc :=  Line
  End;
  If qNotifyClip > qClipNotifyProc then Begin
    qClipNotifyProc := qNotifyClip;
     ClipNotifyProc :=  NotifyClip
  End;
  If qInitBgiGraph > qInitGraphProc then Begin
    qInitGraphProc := qInitBgiGraph;
     InitGraphProc :=  InitBgiGraph
  End;
  If qCloseBgiGraph > qCloseGraphProc then Begin
    qCloseGraphProc := qCloseBgiGraph;
     CloseGraphProc :=  CloseBgiGraph
  End;
  If qSetBgiPage > qActivePageProc then Begin
    qActivePageProc := qSetBgiPage;
     ActivePageProc :=  SetBgiPage
  End;
  If qChBgiParams > qChParamsProc then Begin
    qChParamsProc := qChBgiParams;
     ChParamsProc :=  ChBgiParams
  End;
End.

