unit GvCountry;

{ Graphics Vision Country-Specific Information
  Copr. 1995 Matthias Koeppe
}

interface

{ Country information
}
const
  iDate_mmddyy = 0;
  iDate_ddmmyy = 1;
  iDate_yymmdd = 2;

  iCurrency_Follows = 1;
  iCurrency_Spaced = 2;
  iCurrency_ReplacesPoint = 4;

  iTime_12 = 0;
  iTime_24 = 1;

type
  TCountryInfo = record
  { Information provided by DOS
  }
    iDate: Word;
    sCurrency: array[0..4] of Char;
    sThousand: Char;
    _: Char;
    sDecimal: Char;
    __: Char;
    sDate: Char;
    ___: Char;
    sTime: Char;
    ____: Char;
    iCurrency: Byte;
    iCurrDigits: Byte;
    iTime: Byte;
    _____: pointer;
    sList: Char;
    ______: Char;
    _______: array[0..9] of Byte;
    iCountry: Word;
  { Information from WIN.INI
  }
    sLanguage: PChar;
    sCountry: PChar;
    iTLZero: Byte;
    iNegCurr: Byte;
    iLzero: Byte;
    iDigits: Byte;
    iMeasure: Byte;
    s1159: PChar;
    s2359: PChar;
    sShortDate: PChar;
    sLongDate: PChar;
  end;

var
  CountryInfo: TCountryInfo;

implementation

uses Profile;

procedure ReadCountryInfo;
var
  WinIniPath: array[0..79] of Char;
  s: array[0..255] of Char;
  p: PChar;

	function GetIntlInt(KeyName: PChar; Default: Integer): Integer;
	begin
	  GetIntlInt := GetPrivateProfileInt('intl', KeyName,
	    Default, WinIniPath)
	end;

	function GetIntlStr(KeyName: PChar; Default: PChar): PChar;
	var
	  Buffer: array[0..255] of Char;
	begin
	  GetPrivateProfileString('intl', KeyName,
	    Default, Buffer, SizeOf(Buffer), WinIniPath);
	  GetIntlStr := StrNew(Buffer)
	end;

begin
  StrPCopy(WinIniPath, GetWinDir);
  StrCat(WinIniPath, '\win.ini');
  with CountryInfo do
  begin
    iCountry := GetIntIntl('iCountry', 0);
    If iCountry = 0
    then asm
	{ Get info on DOS standard country
	}
	mov	dx, OFFSET CountryInfo
	mov	ax, 3800h
	int	21h
	mov	CountryInfo.iCountry, bx
    end
    else asm
	{ Get info on Windows standard country
	}
	mov	dx, OFFSET CountryInfo
	mov	ax, 38ffh
	mov	bx, CountryInfo.iCountry
	int	21h
	mov	CountryInfo.iCountry, bx
    end;
    sLanguage := GetIntlStr('sLanguage', '');
    Str(iCountry:3, s);
    p := s; while p[0] = ' ' do begin p[0] := '0'; Inc(p) end;
    sCountry := GetIntlStr('sCountry', p);
    iTLZero: Byte;
    iNegCurr: Byte;
    iLzero: Byte;
    iDigits: Byte;
    iMeasure: Byte;
    s1159: PChar;
    s2359: PChar;
    sShortDate: PChar;
    sLongDate: PChar;
  end;
end;

begin
  ReadCountryInfo
end.
