; BGIMETA.ASM
; Copr. 1994 Matthias Kppe

	TITLE	BGI metafiling extensions

	INCLUDE grdef.asm
	INCLUDE	bgiserv.asm

	NOSMART

CODE		SEGMENT BYTE PUBLIC

Entry 	GetX
		call	Graph_GetX
		sub	ax, BgiX
		ret
		ENDP

Entry 	GetY
		call	Graph_GetY
		sub	ax, BgiY
		ret
		ENDP

Entry 	PutPixel
		ARG	Pixel: WORD, atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_PutPixel
Exit

Entry	GetPixel
		ARG	atY: WORD, atX: WORD = ArgSize
		BgiMeta	, <atX>, <atY>
		rCallm	Graph_GetPixel
Exit

Entry	SetWriteMode
		ARG	WriteMode: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetWriteMode
		ENDP

Entry	LineTo
		ARG	atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_LineTo
Exit

Entry	LineRel
		ARG	Deltay: WORD, Deltax: WORD = ArgSize
		BgiMeta	Meta
		rCallm	Graph_LineRel
Exit

Entry	MoveTo
		ARG	atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		jmp	Graph_MoveTo
		ENDP

Entry	MoveRel
		ARG	Deltay: WORD, Deltax: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_MoveRel
		ENDP

Entry	Line
		ARG	y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		BgiMeta	Meta, <x1,x2>, <y1,y2>
		rCallm	Graph_Line
Exit

Entry	SetLineStyle
		ARG	Thickness: WORD, Pattern: WORD, \
			LineStyle: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetLineStyle
		ENDP

Entry	Rectangle
		ARG	y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		BgiMeta	Meta, <x1,x2>, <y1,y2>
		rCallm	Graph_Rectangle
Exit

Entry	Bar
		ARG	y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		BgiMeta	Meta, <x1,x2>, <y1,y2>
		rCallm	Graph_Bar
Exit

Entry	Bar3D
		ARG	Top: BYTE, Depth: WORD, \
			y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		BgiMeta	Meta, <x1,x2>, <y1,y2>
		rCallm	Graph_Bar3D
Exit

Poly		MACRO   ProcName
Entry	ProcName
		ARG	PolyPointsPtr: DWORD, NumPoints: WORD = ArgSize
		push	bp
		mov	bp, sp
		mov	ax, NumPoints
		shl	ax, 1
		mov	cx, ax
		shl	ax, 1
		sub	sp, ax
		mov	dx, ax			; locals
		mov	bx, sp
		les	si, PolyPointsPtr
		cld
@@1:		seges	lodsw			; local copy
		mov	ss:[bx], ax
		add	bx, 2
		loop	@@1
		TEST	MetaState, ms_Record
		JZ	SHORT @@NR
		push	dx			; locals
		push	ArgSize			; args
		push	dx			; locals saved
		MOV	AX, 3
		CALL	[ExtSave]
		MOV	BYTE PTR BgiClipState[1], 1
@@NR:		TEST	MetaState, ms_Draw
		jz	SHORT @@ND
		call	Clip
		cmp	NeedToDraw, 0
		jz	SHORT @@ND
		mov	bx, sp
		mov	cx, NumPoints
		push	cx ss bx
@@2:		add	ss:[bx], ax		; add (BgiX, BgiY)
		add	ss:[bx+2], dx
		add	bx, 4
		loop	@@2

		leave
		rcallm	Graph_&ProcName
		retf	ArgSize

@@ND:		leave
		retf	ArgSize
		ENDP
		ENDM

	Poly	DrawPoly
	Poly	FillPoly

Entry	SetFillStyle
		ARG	Color: WORD, Pattern: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetFillStyle
		ENDP

Entry	SetFillPattern
		ARG	Color: WORD, PatternPtr: DWORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetFillPattern
		ENDP

Entry	FloodFill
		ARG	Border: WORD, atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rcallm	Graph_FloodFill
Exit

Entry	Arc
		ARG	Radius: WORD, EndAngle: WORD, StAngle: WORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_Arc
Exit

Entry	GetArcCoords
		ARG	ArcCoordsPtr: DWORD = ArgSize
		push	bp
		mov	bp, sp
		push	ArcCoordsPtr
		call	Graph_GetArcCoords
		les	di, ArcCoordsPtr
		mov	ax, BgiX
		mov	dx, BgiY
		mov	cx, 3
@@1:		sub	es:[di], ax
		sub	es:[di+2], dx
		add	di, 4
		loop	@@1
		pop	bp
		retf	ArgSize
		ENDP

Entry	Circle
		ARG	Radius: WORD, atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_Circle
Exit

Entry	Ellipse
		ARG	YRadius: WORD, XRadius: WORD, \
			EndAngle: WORD, StAngle: WORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_Ellipse
Exit

Entry	FillEllipse
		ARG	YRadius: WORD, XRadius: WORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_FillEllipse
Exit

Entry	SetAspectRatio
		ARG	YAsp: WORD, XAsp: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetAspectRatio
		ENDP

Entry	PieSlice
		ARG	Radius: WORD, EndAngle: WORD, StAngle: WORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_PieSlice
Exit

Entry	Sector
		ARG	YRadius: WORD, XRadius: WORD, \
			EndAngle: WORD, StAngle: WORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_Sector
Exit

Entry	SetBkColor
		ARG	ColorNum: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetBkColor
		ENDP

Entry	SetColor
		ARG	ColorNum: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetColor
		ENDP

Entry	GetImage
		ARG	BitmapPtr: DWORD, \
			y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		BgiMeta	, <x1,x2>, <y1,y2>
		rCallm	Graph_GetImage
Exit

Entry	PutImage
		ARG	BitBlt: WORD, BitmapPtr: DWORD, \
			atY: WORD, atX: WORD = ArgSize
		BgiMeta	Meta, <atX>, <atY>
		rCallm	Graph_PutImage
Exit

Text		MACRO	ProcName
		test	MetaState, ms_Record
		jnz	@@R
		TEST	MetaState, ms_Draw
		jz	SHORT @@ND
		call	Clip
		cmp	NeedToDraw, 0
		jz	SHORT @@ND
		rCallm	Graph_&ProcName
		ret
@@ND:		retf	ArgSize
@@R:		LOCAL	sofs: WORD, scopy: BYTE: 256 = LocalSize ;; recorded
		enter	LocalSize, 0
		call	NEAR PTR CopyString
		PUSH	LocalSize
		PUSH	ArgSize
		ADD	DX, 3			;; s len + 3
		PUSH	DX			;; Locals to be stored
		MOV	AX, 3			;; pushed
		CALL	[ExtSave]
@@NR:		TEST	MetaState, ms_Draw
		JZ	SHORT @@RND
	IF ArgSize NE 4
		push	atX
		push	atY
	ENDIF
		push	ss sofs
		rcallm	Graph_&ProcName
@@RND:		leave
		retf	ArgSize
		ENDM

Entry	OutText
		ARG	TextStringPtr: DWORD = ArgSize
		Text	OutText
		ENDP

Entry	OutTextXY
		ARG	TextStringPtr: DWORD, atY: WORD, atX: WORD = ArgSize
		Text	OutTextXY
		ENDP

	; CopyString creates a local copy of the string on the stack.

CopyString	PROC NEAR
		MOV	BX, SS
		MOV	ES, BX
		MOV	BX, DS
		LDS	SI, TextStringPtr
		LEA	DI, scopy
		CLD
		LODSB
		MOV	CL, AL
		NOT	CL
		MOV	CH, 0
		ADD	DI, CX
		MOV	sofs, CX
		STOSB
		MOV	CL, AL
		MOV	DX, CX
		REP	MOVSB
		MOV	DS, BX
		retn
CopyString	ENDP

Entry	SetTextJustify
		ARG	Vert: WORD, Horiz: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetTextJustify
		ENDP

Entry	SetTextStyle
		ARG	CharSize: WORD, Direction: WORD, Font: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetTextStyle
		ENDP

Entry	SetUserCharSize
		ARG	DivY: WORD, MultY: WORD, \
			DivX: WORD, MultX: WORD = ArgSize
		BgiMeta	Meta
		jmp	Graph_SetUserCharSize
		ENDP

CODE		ENDS

		END
