unit BgiRen;

{ BgiRen: Renaming BGI routines
  Copr. 1995 Matthias K"oppe

  $Id: bgiren.pas 1.2 1999/02/09 10:44:10 mkoeppe Exp $
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

interface

uses Graph;

{ Retrieving coordinates 
}
function Graph_GetX: Integer;
function Graph_GetY: Integer;

{ Pixel-oriented routines 
}
procedure Graph_PutPixel(X, Y: Integer; Pixel: Word);
function Graph_GetPixel(X, Y: Integer): Word;

{ Line-oriented primitives 
}
procedure Graph_SetWriteMode(WriteMode: Integer);
procedure Graph_LineTo(X, Y: Integer);
procedure Graph_LineRel(Dx, Dy: Integer);
procedure Graph_MoveTo(X, Y: Integer);
procedure Graph_MoveRel(Dx, Dy: Integer);
procedure Graph_Line(x1, y1, x2, y2: Integer);
procedure Graph_SetLineStyle(LineStyle: Word; Pattern: Word; Thickness: Word);

{ Linearly bounded primitives 
}
procedure Graph_Rectangle(x1, y1, x2, y2: Integer);
procedure Graph_Bar(x1, y1, x2, y2: Integer);
procedure Graph_Bar3D(x1, y1, x2, y2: Integer; Depth: Word; Top: Boolean);
procedure Graph_DrawPoly(NumPoints: Word; var PolyPoints);
procedure Graph_FillPoly(NumPoints: Word; var PolyPoints);
procedure Graph_SetFillStyle(Pattern: Word; Color: Word);
procedure Graph_SetFillPattern(Pattern: FillPatternType; Color: Word);
procedure Graph_FloodFill(X, Y: Integer; Border: Word);

{ Nonlinearly bounded primitives 
}
procedure Graph_Arc(X, Y: Integer; StAngle, EndAngle, Radius: Word);
procedure Graph_GetArcCoords(var ArcCoords: ArcCoordsType);
procedure Graph_Circle(X, Y: Integer; Radius: Word);
procedure Graph_Ellipse(X, Y: Integer;
  StAngle, EndAngle: Word; XRadius, YRadius : Word);
procedure Graph_FillEllipse(X, Y: Integer; XRadius, YRadius : Word);
procedure Graph_SetAspectRatio(Xasp, Yasp: Word);
procedure Graph_PieSlice(X, Y: Integer; StAngle, EndAngle, Radius: Word);
procedure Graph_Sector(X, Y: Integer;
  StAngle, EndAngle, XRadius, YRadius: Word);

{ Color routines 
}
procedure Graph_SetBkColor(ColorNum: Word);
procedure Graph_SetColor(Color: Word);

{ Bitmap utilities 
}
procedure Graph_GetImage(x1, y1, x2, y2: Integer; var BitMap);
procedure Graph_PutImage(X, Y: Integer; var BitMap; BitBlt: Word);

{ Text routines 
}
procedure Graph_OutText(TextString: string);
procedure Graph_OutTextXY(X, Y: Integer; TextString: string);
procedure Graph_SetTextJustify(Horiz, Vert: Word);
procedure Graph_SetTextStyle(Font, Direction: Word; CharSize: Word);
procedure Graph_SetUserCharSize(MultX, DivX, MultY, DivY: Word);

implementation

{$L bgiren.obj (bgiren.asm) }

function Graph_GetX; external;
function Graph_GetY; external;
procedure Graph_PutPixel; external;
function Graph_GetPixel; external;
procedure Graph_SetWriteMode; external;
procedure Graph_LineTo; external;
procedure Graph_LineRel; external;
procedure Graph_MoveTo; external;
procedure Graph_MoveRel; external;
procedure Graph_Line; external;
procedure Graph_SetLineStyle; external;
procedure Graph_Rectangle; external;
procedure Graph_Bar; external;
procedure Graph_Bar3D; external;
procedure Graph_DrawPoly; external;
procedure Graph_FillPoly; external;
procedure Graph_SetFillStyle; external;
procedure Graph_SetFillPattern; external;
procedure Graph_FloodFill; external;
procedure Graph_Arc; external;
procedure Graph_GetArcCoords; external;
procedure Graph_Circle; external;
procedure Graph_Ellipse; external;
procedure Graph_FillEllipse; external;
procedure Graph_SetAspectRatio; external;
procedure Graph_PieSlice; external;
procedure Graph_Sector; external;
procedure Graph_SetBkColor; external;
procedure Graph_SetColor; external;
procedure Graph_GetImage; external;
procedure Graph_PutImage; external;
procedure Graph_OutText; external;
procedure Graph_OutTextXY; external;
procedure Graph_SetTextJustify; external;
procedure Graph_SetTextStyle; external;
procedure Graph_SetUserCharSize; external;

end.
